/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.ChangeExecutionService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CloseableUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\r\u001b\u0001\rB\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tq\u0001\u0011\t\u0011)A\u0005i!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003<\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011!\u0003!Q1A\u0005\u0002%C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011)\u0019!C\u0001\u001f\"A1\u000b\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005U\u0001\t\u0015\r\u0011\"\u0001V\u0011!I\u0006A!A!\u0002\u00131\u0006\u0002\u0003.\u0001\u0005\u000b\u0007I\u0011A.\t\u0011\t\u0004!\u0011!Q\u0001\nqC\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005K\")\u0011\u000e\u0001C\u0001U\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA#\u0001\u0011%\u0011q\t\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u0014\u0002!\t\"!&\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \n12\t[1oO\u0016,\u00050Z2vi&|gnU3sm&\u001cWM\u0003\u0002\u001c9\u000591/\u001a:wS\u000e,'BA\u000f\u001f\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002 A\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002C\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tY\u0003'D\u0001-\u0015\tic&A\u0003tY\u001a$$NC\u00010\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0019-\u0005\u001daunZ4j]\u001e\fabY8n[\u0016tGoU3sm&\u001cW-F\u00015!\t)d'D\u0001\u001b\u0013\t9$D\u0001\bD_6lWM\u001c;TKJ4\u0018nY3\u0002\u001f\r|W.\\3oiN+'O^5dK\u0002\n\u0011#\u0019;uC\u000eDW.\u001a8u'\u0016\u0014h/[2f+\u0005Y\u0004CA\u001b=\u0013\ti$DA\tBiR\f7\r[7f]R\u001cVM\u001d<jG\u0016\f!#\u0019;uC\u000eDW.\u001a8u'\u0016\u0014h/[2fA\u0005qA/Y:l%\u0016\u0004xn]5u_JLX#A!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011c\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011ai\u0011\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003=!\u0018m]6SKB|7/\u001b;pef\u0004\u0013\u0001F1ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u00180F\u0001K!\t\u00115*\u0003\u0002M\u0007\n!\u0012\t\u001e;bG\"lWM\u001c;SKB|7/\u001b;pef\fQ#\u0019;uC\u000eDW.\u001a8u%\u0016\u0004xn]5u_JL\b%A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012\u0001\u0015\t\u0003\u0005FK!AU\"\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0013!\u00074bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ,\u0012A\u0016\t\u0003\u0005^K!\u0001W\"\u00033\u0019\u000b7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u0001\u001bM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000fI\u0001\tKZ,g\u000e\u001e\"vgV\tA\f\u0005\u0002^A6\taL\u0003\u0002`9\u00051QM^3oiNL!!\u00190\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u0005AB-\u001a9f]\u0012,gnY=UCJ<W\r\u001e*fg>dg/\u001a:\u0016\u0003\u0015\u0004\"A\u00114\n\u0005\u001d\u001c%\u0001\u0007#fa\u0016tG-\u001a8dsR\u000b'oZ3u%\u0016\u001cx\u000e\u001c<fe\u0006IB-\u001a9f]\u0012,gnY=UCJ<W\r\u001e*fg>dg/\u001a:!\u0003\u0019a\u0014N\\5u}QI1\u000e\\7o_B\f(o\u001d\t\u0003k\u0001AQAM\tA\u0002QBQ!O\tA\u0002mBQaP\tA\u0002\u0005CQ\u0001S\tA\u0002)CQAT\tA\u0002ACQ\u0001V\tA\u0002YCQAW\tA\u0002qCQaY\tA\u0002\u0015D#!E;\u0011\u0007Y\f\u0019!D\u0001x\u0015\tA\u00180\u0001\u0006b]:|G/\u0019;j_:T!A_>\u0002\u000f\u0019\f7\r^8ss*\u0011A0`\u0001\u0006E\u0016\fgn\u001d\u0006\u0003}~\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)a\u001e\u0002\n\u0003V$xn^5sK\u0012\fA\"\u00199qYf\u001c\u0005.\u00198hKN$b!a\u0003\u0002\u0012\u0005\u0005\u0002cA\u0013\u0002\u000e%\u0019\u0011q\u0002\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'\u0011\u0002\u0019AA\u000b\u0003\u001d\u0019\u0007.\u00198hKN\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037a\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002 \u0005e!aB\"iC:<Wm\u001d\u0005\b\u0003G\u0011\u0002\u0019AA\u0013\u0003\u0011)8/\u001a:\u0011\t\u0005\u001d\u00121F\u0007\u0003\u0003SQ1!a\t\u001d\u0013\u0011\ti#!\u000b\u0003\tU\u001bXM\u001d\u0015\u0004%\u0005E\u0002\u0003BA\u001a\u0003\u0003j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\fiJ\fgn]1di&|gN\u0003\u0003\u0002<\u0005u\u0012aA:rY*\u0019\u0011q\b\u000f\u0002\u0005\u0011\u0014\u0017\u0002BA\"\u0003k\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u000eaJ|7-Z:t\r\u0006\u001cW\r^:\u0015\t\u0005-\u0011\u0011\n\u0005\b\u0003'\u0019\u0002\u0019AA\u000b\u0003=\u0001(o\\2fgN\u0014V\r\\3bg\u0016\u001cH\u0003BA\u0006\u0003\u001fBq!a\u0005\u0015\u0001\u0004\t)\"A\bd_2dWm\u0019;D_6lWM\u001c;t)\u0019\t)&!#\u0002\fBA\u0011qKA3\u0003W\n\tH\u0004\u0003\u0002Z\u0005\u0005\u0004cAA.M5\u0011\u0011Q\f\u0006\u0004\u0003?\u0012\u0013A\u0002\u001fs_>$h(C\u0002\u0002d\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA4\u0003S\u00121!T1q\u0015\r\t\u0019G\n\t\u0005\u0003/\ti'\u0003\u0003\u0002p\u0005e!\u0001\u0002+bg.\u0004b!a\u001d\u0002~\u0005\re\u0002BA;\u0003srA!a\u0017\u0002x%\tq%C\u0002\u0002|\u0019\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\u0005\u0005%aA*fc*\u0019\u00111\u0010\u0014\u0011\t\u0005]\u0011QQ\u0005\u0005\u0003\u000f\u000bIBA\u0004D_6lWM\u001c;\t\u000f\u0005MQ\u00031\u0001\u0002\u0016!9\u00111E\u000bA\u0002\u0005\u0015\u0012A\u00059s_\u000e,7o]!ui\u0006\u001c\u0007.\\3oiN$B!a\u0003\u0002\u0012\"9\u00111\u0003\fA\u0002\u0005U\u0011a\u00049s_\u000e,7o]\"p[6,g\u000e^:\u0015\r\u0005-\u0011qSAN\u0011\u001d\tIj\u0006a\u0001\u0003+\nabY8n[\u0016tGo\u001d\"z)\u0006\u001c8\u000eC\u0004\u0002$]\u0001\r!!\n\u0002\u0019A\u0014xnY3tgR\u000b7o[:\u0015\t\u0005-\u0011\u0011\u0015\u0005\b\u0003'A\u0002\u0019AA\u000bQ\r\u0001\u0011Q\u0015\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111V?\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u00020\u0006%&aB*feZL7-\u001a")
public class ChangeExecutionService
implements Logging {
    private final CommentService commentService;
    private final AttachmentService attachmentService;
    private final TaskRepository taskRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseRepository releaseRepository;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChangeExecutionService changeExecutionService = this;
        synchronized (changeExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CommentService commentService() {
        return this.commentService;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public AttachmentRepository attachmentRepository() {
        return this.attachmentRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public DependencyTargetResolver dependencyTargetResolver() {
        return this.dependencyTargetResolver;
    }

    @IsTransactional
    public void applyChanges(Changes changes, User user) {
        this.processFacets(changes);
        this.processAttachments(changes);
        this.processComments(this.collectComments(changes, user), user);
        this.processTasks(changes);
        this.processReleases(changes);
    }

    private void processFacets(Changes changes) {
        Set facets = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processFacets$1(x$1)))).map((Function1 & Serializable)x$2 -> (Facet)x$2)).toSet();
        facets.foreach((Function1 & Serializable)facet -> ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher().liveRepository())).update((Facet)facet));
    }

    private void processReleases(Changes changes) {
        Set releases = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processReleases$1(x$3)))).map((Function1 & Serializable)x$4 -> ((PlanItem)x$4).getRelease())).toSet();
        releases.foreach((Function1 & Serializable)release -> this.releaseRepository().update((Release)release));
    }

    private Map<Task, Seq<Comment>> collectComments(Changes changes, User user) {
        return CollectionConverters$.MODULE$.MapHasAsScala(changes.getCommentsByTask().asMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection commentTexts = (Collection)tuple2._2();
            Seq userComments = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(commentTexts).asScala().map((Function1 & Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                User u = (User)tuple3._1();
                String text = (String)tuple3._2();
                DateTime date = (DateTime)tuple3._3();
                User actualUser = (User)Option$.MODULE$.apply((Object)u).getOrElse((Function0 & Serializable)() -> user);
                Comment comment = this.commentService().buildComment(task, text, actualUser.getName(), date.toDate(), CommentService.COMMENT_PREFIX_MANUAL, CommentService.COMMENT_SUFFIX);
                return comment;
            })).toSeq();
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)userComments);
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void processAttachments(Changes changes) {
        CollectionConverters$.MODULE$.MapHasAsScala(changes.getAttachmentsByTask().asMap()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processAttachments$1(this, changes, x0$1);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(changes.getLinkedAttachments().asMap()).asScala().foreach((Function1 & Serializable)x0$2 -> {
            ChangeExecutionService.$anonfun$processAttachments$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void processComments(Map<Task, Seq<Comment>> commentsByTask, User user) {
        commentsByTask.foreach((Function1 & Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processComments$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void processTasks(Changes changes) {
        Set tasks = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processTasks$1(x$5)))).map((Function1 & Serializable)x$6 -> (Task)x$6)).toSet();
        tasks.collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ChangeExecutionService $outer;

            public final <A1 extends Task, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof GateTask) {
                    GateTask gateTask = (GateTask)A1;
                    CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().foreach((Function1 & Serializable)dependency -> {
                        $anonfun$processTasks$3.$anonfun$applyOrElse$1(this, dependency);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Task x1) {
                Task task = x1;
                boolean bl = task instanceof GateTask;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$processTasks$3 $this, Dependency dependency) {
                $this.$outer.dependencyTargetResolver().populateArchivedTargetId(dependency);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.ChangeExecutionService$$anonfun$processTasks$3 com.xebialabs.xlrelease.domain.Dependency )}, serializedLambda);
            }
        });
        tasks.foreach((Function1 & Serializable)task -> {
            ChangeExecutionService.$anonfun$processTasks$4(this, task);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$processFacets$1(ConfigurationItem x$1) {
        return x$1 instanceof Facet;
    }

    public static final /* synthetic */ boolean $anonfun$processReleases$1(ConfigurationItem x$3) {
        return x$3 instanceof PlanItem;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$3(ChangeExecutionService $this, Task task$2, Attachment attachment$1, Changes changes$1, InputStream is) {
        Boolean bl;
        Attachment attachmentAttached = $this.attachmentService().attachToRelease(task$2.getRelease(), attachment$1.getFile().getName(), attachment$1.getContentType(), is);
        if ($this.attachmentRepository().batchInsert(task$2.getRelease(), (Seq<Attachment>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attachment[]{attachmentAttached}))))) {
            task$2.getAttachments().add(attachmentAttached);
            $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$2.getId(), attachmentAttached));
            bl = BoxedUnit.UNIT;
        } else {
            changes$1.addComment(task$2, User.LOG_OUTPUT, "There was a problem adding the attachment. See xl-release.log");
            bl = BoxesRunTime.boxToBoolean((boolean)task$2.getRelease().getAttachments().remove(attachmentAttached));
        }
        changes$1.update((ConfigurationItem)task$2.getRelease());
    }

    public static final /* synthetic */ void $anonfun$processAttachments$1(ChangeExecutionService $this, Changes changes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Collection attachments = (Collection)tuple2._2();
        CollectionConverters$.MODULE$.CollectionHasAsScala(attachments).asScala().foreach((Function1 & Serializable)attachment -> {
            CloseableUtils$.MODULE$.using(attachment.getFile().getInputStream(), (Function1 & Serializable)is -> {
                ChangeExecutionService.$anonfun$processAttachments$3($this, task$2, attachment, changes$1, is);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$5(ChangeExecutionService $this, Task task$3, Attachment attachment) {
        Attachment loadedAttachment = $this.attachmentRepository().findById(attachment.getId());
        attachment.setFile(loadedAttachment.getFile());
        $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$3.getId(), attachment));
    }

    public static final /* synthetic */ void $anonfun$processAttachments$4(ChangeExecutionService $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Collection attachments = (Collection)tuple2._2();
        CollectionConverters$.MODULE$.CollectionHasAsScala(attachments).asScala().foreach((Function1 & Serializable)attachment -> {
            ChangeExecutionService.$anonfun$processAttachments$5($this, task, attachment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processComments$1(ChangeExecutionService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq comments = (Seq)tuple2._2();
        comments.foreach((Function1 & Serializable)comment -> $this.commentService().create(task, (Comment)comment));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$processTasks$1(ConfigurationItem x$5) {
        return x$5 instanceof Task;
    }

    public static final /* synthetic */ void $anonfun$processTasks$4(ChangeExecutionService $this, Task task) {
        $this.taskRepository().updateTaskProperties(task);
    }

    @Autowired
    public ChangeExecutionService(CommentService commentService, AttachmentService attachmentService, TaskRepository taskRepository, AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.commentService = commentService;
        this.attachmentService = attachmentService;
        this.taskRepository = taskRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        Logging.$init$((Logging)this);
    }
}

