/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plumbing.ExecutionOutputWriter;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.variables.StringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.python.core.PyException;
import org.python.core.PyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class ScriptServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ScriptServiceHelper.class);

    public static Map<String, Object> extractReleaseVariables(ScriptContext context) {
        Object attribute = context.getAttribute("_releaseVariables");
        if (attribute != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> extractGlobalVariables(ScriptContext context) {
        Object attribute = context.getAttribute("_globalVariables");
        if (attribute != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> extractFolderVariables(ScriptContext context) {
        Object attribute = context.getAttribute("_folderVariables");
        if (attribute != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> extractTransitionalAndOutputPropertyValues(CustomScriptTask task, ScriptContext scriptContext, SensitiveValueScrubber scrubber) {
        Collection transitionalAndOutputProperties = task.getPythonScript().getTransitionalAndOutputProperties();
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (PropertyDescriptor propertyDescriptor : transitionalAndOutputProperties) {
            String propertyName = propertyDescriptor.getName();
            Object attr = scriptContext.getAttribute(propertyName);
            if (attr == null) {
                logger.debug("Python script task {} did not return a value for property {}", (Object)task.getId(), (Object)propertyDescriptor.getName());
                continue;
            }
            attr = ScriptServiceHelper.convertOutputPropertyValue(propertyDescriptor, attr, scrubber);
            propertyValues.put(propertyName, attr);
        }
        return propertyValues;
    }

    private static Object convertOutputPropertyValue(PropertyDescriptor propertyDescriptor, Object propertyValue, SensitiveValueScrubber scrubber) {
        Variable variable = Optional.ofNullable((Variable)VariableFactory.createVariableByPropertyDescriptor((PropertyDescriptor)propertyDescriptor).orNull(null)).orElse((Variable)new StringVariable());
        try {
            variable.setUntypedValue(propertyValue);
            Object value = variable.getValue();
            if (value instanceof CharSequence && !propertyDescriptor.isPassword()) {
                value = scrubber.scrubValues(value.toString());
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot store value '%s' of type %s into %s property '%s'", propertyValue, propertyValue.getClass().getSimpleName(), propertyDescriptor.getKind(), propertyDescriptor.getName()));
        }
    }

    public static Option<String> getAttachmentIdFromExecutionLog(Writer executionLog) {
        ScriptServiceHelper.closeWriter(executionLog);
        ThreadLocalWriterDecorator writerDecorator = (ThreadLocalWriterDecorator)executionLog;
        return Option.apply((Object)((ExecutionOutputWriter)writerDecorator.getWriter())).map(executionOutputWriter -> (DefaultScriptService.ScriptTaskOutputWriter)executionOutputWriter.getWriter()).map(DefaultScriptService.ScriptTaskOutputWriter::getAttachmentId);
    }

    public static void addExceptionToExecutionLog(Exception exception, Writer executionLog, String logMessage, String taskId) {
        if (!(exception instanceof ScriptException) || !ScriptServiceHelper.isKeyboardInterrupt((ScriptException)exception)) {
            logger.warn(logMessage, (Object)taskId, (Object)exception);
        }
        String defaultMessage = Objects.toString(ScriptServiceHelper.sanitizeServerPath(exception.toString()), "");
        try {
            executionLog.append("Exception during execution:\n");
            executionLog.append(defaultMessage);
            executionLog.flush();
            ScriptServiceHelper.closeWriter(executionLog);
        }
        catch (Exception e) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)e);
        }
    }

    protected static String sanitizeServerPath(String message) {
        return message == null ? null : message.replace(System.getProperty("user.dir"), "{ServerWorkingDirectory}");
    }

    public static boolean isSystemExit0(ScriptException exception) {
        if (!(exception.getCause() instanceof PyException)) {
            return false;
        }
        PyException pyE = (PyException)exception.getCause();
        String pyEtoString = pyE.toString();
        PyType pyET = (PyType)pyE.type;
        String pyETName = pyET.getName();
        return pyETName.equals("SystemExit") && pyEtoString.contains("SystemExit: 0");
    }

    public static boolean isKeyboardInterrupt(ScriptException exception) {
        if (!(exception.getCause() instanceof PyException)) {
            return false;
        }
        PyException pyE = (PyException)exception.getCause();
        PyType pyET = (PyType)pyE.type;
        String pyETName = pyET.getName();
        return pyETName.equals("KeyboardInterrupt");
    }

    public static void closeWriter(Writer executionLog) {
        try {
            executionLog.close();
        }
        catch (IOException e) {
            logger.warn("Error closing script output logger", (Throwable)e);
        }
    }
}

