/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.annotation.Timed;
import com.typesafe.config.Config;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\b\u0010\u0001aA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tg\u0001\u0011\t\u0011)A\u0005[!)A\u0007\u0001C\u0001k!Aq\t\u0001b\u0001\n\u0003y\u0001\n\u0003\u0004W\u0001\u0001\u0006I!\u0013\u0005\t/\u0002A)\u0019!C\u00051\")A\r\u0001C!K\")Q\u000f\u0001C!m\")\u0011\u0010\u0001C#u\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\tY\u0003\u0001C!\u0003[\u0011q\u0002R3gCVdGOS8c#V,W/\u001a\u0006\u0003!E\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005I\u0019\u0012!\u0003=me\u0016dW-Y:f\u0015\t!R#A\u0005yK\nL\u0017\r\\1cg*\ta#A\u0002d_6\u001c\u0001a\u0005\u0003\u00013}\u0019\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\tq\"\u0003\u0002#\u001f\tA!j\u001c2Rk\u0016,X\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005)1\u000f\u001c45U*\t\u0001&\u0001\u0005he&T(\u0010\\3e\u0013\tQSEA\u0004M_\u001e<\u0017N\\4\u0002\u001b)|'MU3q_NLGo\u001c:z+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0010\u0003)\u0011X\r]8tSR|'/_\u0005\u0003e=\u0012QBS8c%\u0016\u0004xn]5u_JL\u0018A\u00046pEJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Y:\u0004C\u0001\u0011\u0001\u0011\u0015Y3\u00011\u0001.Q\t\u0019\u0011\b\u0005\u0002;\u000b6\t1H\u0003\u0002={\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005yz\u0014a\u00024bGR|'/\u001f\u0006\u0003\u0001\u0006\u000bQAY3b]NT!AQ\"\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$<\u0005%\tU\u000f^8xSJ,G-A\u0005m_\u000e\fGNS8cgV\t\u0011\nE\u0002K#Nk\u0011a\u0013\u0006\u0003\u00196\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqu*\u0001\u0003vi&d'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%.\u0013!\u0002R3mCf\fV/Z;f!\t\u0001C+\u0003\u0002V\u001f\t\u0019!j\u001c2\u0002\u00151|7-\u00197K_\n\u001c\b%\u0001\u0004o_\u0012,\u0017\nZ\u000b\u00023B\u0011!,\u0019\b\u00037~\u0003\"\u0001X\u000e\u000e\u0003uS!AX\f\u0002\rq\u0012xn\u001c;?\u0013\t\u00017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011\u001c\u0003\u0019\u0019XOY7jiR\u0011a-\u001b\t\u00035\u001dL!\u0001[\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u001e\u0001\raU\u0001\u0004U>\u0014\u0007FA\u0004m!\ti7/D\u0001o\u0015\tatN\u0003\u0002qc\u00069Q.\u001a;sS\u000e\u001c(B\u0001:\u0016\u0003!\u0019w\u000eZ1iC2,\u0017B\u0001;o\u0005\u0015!\u0016.\\3e\u0003\u001d\u0011X\r\u001d7bG\u0016$\"AZ<\t\u000b)D\u0001\u0019A*)\u0005!a\u0017aA4fiR\u00111k\u001f\u0005\u0006y&\u0001\r!`\u0001\u000fE\u0006\u001c7\u000e\u001d:fgN,(/\u001a$o!\tqx0D\u0001\u0001\u0013\r\t\t!\t\u0002\u000f\u0005\u0006\u001c7\u000e\u001d:fgN,(/\u001a$oQ\rI\u0011Q\u0001\t\u0005\u0003\u000f\tY!\u0004\u0002\u0002\n)\u0011AhG\u0005\u0005\u0003\u001b\tIAA\u0004uC&d'/Z2\u0002\t1|7m\u001b\u000b\u0004'\u0006M\u0001\"\u00026\u000b\u0001\u0004\u0019\u0016A\u00024j]&\u001c\b\u000eF\u0002g\u00033AQA[\u0006A\u0002MC#a\u00037\u0002#M$x\u000e],pe.,'\u000f\u00165sK\u0006$7\u000fF\u0002g\u0003CAq!a\t\r\u0001\u0004\t)#A\u0003d_VtG\u000fE\u0002\u001b\u0003OI1!!\u000b\u001c\u0005\rIe\u000e^\u0001\tG\u0006t7-\u001a7JMR\u0019a-a\f\t\u000f\u0005ER\u00021\u0001\u00024\u0005I\u0001O]3eS\u000e\fG/\u001a\t\u0006\u0003k\tYdU\u0007\u0003\u0003oQ1!!\u000fN\u0003!1WO\\2uS>t\u0017\u0002BA\u001f\u0003o\u0011\u0011\u0002\u0015:fI&\u001c\u0017\r^3)\u0007\u0001\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9%Q\u0001\u000bgR,'/Z8usB,\u0017\u0002BA&\u0003\u000b\u0012\u0011bQ8na>tWM\u001c;")
public class DefaultJobQueue
implements JobQueue,
Logging {
    private String nodeId;
    private final JobRepository jobRepository;
    private final DelayQueue<Job> localJobs;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public DelayQueue<Job> localJobs() {
        return this.localJobs;
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                String string;
                ClusterMode clusterMode = XlrConfig$.MODULE$.getInstance().clusterMode();
                boolean bl = ClusterMode.Full$.MODULE$.equals(clusterMode) ? true : ClusterMode.HotStandby$.MODULE$.equals(clusterMode);
                if (bl) {
                    Config clusterConfig = XlrConfig$.MODULE$.getInstance().cluster().config().getConfig("node");
                    string = new StringBuilder(1).append(clusterConfig.getString("hostname")).append(":").append(clusterConfig.getInt("clusterPort")).toString();
                } else if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                    string = "default";
                } else {
                    throw new MatchError((Object)clusterMode);
                }
                this.nodeId = string;
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    private String nodeId() {
        return !this.bitmap$0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    @Override
    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("submitted job ").append(job).toString());
        job.id_$eq(this.jobRepository().create(JobRow$.MODULE$.apply(job)).id());
        this.localJobs().add(job);
    }

    @Override
    @Timed
    public void replace(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(13).append("replaced job ").append(job).toString());
        job.id_$eq(this.jobRepository().replace(JobRow$.MODULE$.apply(job)).id());
        this.localJobs().add(job);
    }

    @Override
    public final Job get(Function1<Job, Object> backpressureFn) {
        Job job;
        block6: {
            Job job2;
            while (true) {
                Job job3;
                if ((job3 = (Job)this.localJobs().take()) instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job3;
                    this.logger().debug((Function0 & Serializable)() -> "giving StopWorkerThread");
                    job = stopWorkerThread;
                    break block6;
                }
                if (!BoxesRunTime.unboxToBoolean((Object)backpressureFn.apply((Object)job3))) continue;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.lock(job3));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Job reservedJob = (Job)success.value();
                    this.logger().debug((Function0 & Serializable)() -> new StringBuilder(7).append("giving ").append(reservedJob).toString());
                    job2 = reservedJob;
                    break;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    Throwable throwable = exception;
                    if (throwable instanceof OptimisticLockingFailureException) {
                        this.logger().warn((Function0 & Serializable)() -> new StringBuilder(19).append("Unable to lock job ").append(job3).toString());
                        continue;
                    }
                    if (throwable == null) {
                        throw new MatchError((Object)throwable);
                    }
                    Throwable throwable2 = throwable;
                    this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                    FailJob failJob = new FailJob(job3, throwable2);
                    job2 = failJob;
                    break;
                }
                throw new MatchError((Object)try_);
            }
            job = job2;
        }
        return job;
    }

    private Job lock(Job job) {
        job.version_$eq(job.version() + 1L);
        job.status_$eq(JobStatus.RESERVED);
        job.node_$eq(this.nodeId());
        job.startTime_$eq(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        this.jobRepository().updateWithVersionCheck(JobRow$.MODULE$.apply(job));
        return job;
    }

    @Override
    @Timed
    public void finish(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("finishing job ").append(job).toString());
        this.jobRepository().delete(JobRow$.MODULE$.apply(job));
    }

    @Override
    public void stopWorkerThreads(int count) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("stopping ").append(count).append(" worker threads").toString());
        this.localJobs().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.localJobs().add(new StopWorkerThread()));
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.localJobs().removeIf(predicate);
    }

    @Autowired
    public DefaultJobQueue(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
        Logging.$init$((Logging)this);
        this.localJobs = new DelayQueue();
    }
}

