/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.SequentialGroup;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedOrTypeChangedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskMovedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TasksLockedEvent;
import com.xebialabs.xlrelease.domain.events.TasksUnlockedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdater;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskTypeConversion;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.MovementIndexes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    private TaskRepository taskRepository;
    private ExecutionService executionService;
    private ReleaseService releaseService;
    private CommentService commentService;
    private PermissionChecker permissions;
    private TaskAccessService taskAccessService;
    private TaskTypeConversion taskTypeConversionService;
    private TeamService teamService;
    private InternalMetadataDecoratorService decoratorService;
    private CiIdService ciIdService;
    private ArchivingService archivingService;
    private XLReleaseEventBus eventBus;
    private PhaseService phaseService;
    private ConfigurationRepository configurationRepository;
    private Map<Class<? extends Task>, TaskUpdater> taskUpdatersPerType = new HashMap<Class<? extends Task>, TaskUpdater>();

    @Autowired
    public TaskService(TaskRepository taskRepository, ExecutionService executionService, ReleaseService releaseService, CommentService commentService, PermissionChecker permissions, TaskAccessService taskAccessService, TaskTypeConversion taskTypeConversionService, TeamService teamService, InternalMetadataDecoratorService decoratorService, CiIdService ciIdService, ArchivingService archivingService, XLReleaseEventBus eventBus, PhaseService phaseService, ConfigurationRepository configurationRepository) {
        this.taskRepository = taskRepository;
        this.executionService = executionService;
        this.releaseService = releaseService;
        this.commentService = commentService;
        this.permissions = permissions;
        this.taskAccessService = taskAccessService;
        this.taskTypeConversionService = taskTypeConversionService;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.eventBus = eventBus;
        this.phaseService = phaseService;
        this.configurationRepository = configurationRepository;
    }

    @Autowired
    public void setTaskUpdaters(List<? extends TaskUpdater> taskUpdaters) {
        taskUpdaters.forEach(updater -> {
            Class<? extends Task> taskType = updater.getTaskClass();
            if (this.taskUpdatersPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two updaters are registered for the same task type %s: %s and %s", taskType, this.taskUpdatersPerType.get(taskType), updater));
            }
            this.taskUpdatersPerType.put(taskType, (TaskUpdater)updater);
        });
    }

    @Timed
    public Task getTaskWithoutDecoration(String taskId) {
        return this.taskRepository.findById(taskId);
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        Object task = this.taskRepository.findById(taskId, resolveOptions);
        this.teamService.decorateWithEffectiveTeams(task.getRelease());
        this.decoratorService.decorate((ConfigurationItem)task.getRelease(), Collections.singletonList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES()));
        return task;
    }

    @Timed
    public List<Task> findById(List<String> taskIds) {
        return taskIds.stream().map(this::findById).collect(Collectors.toList());
    }

    @Timed
    public List<Task> findByIdIncludingArchived(List<String> taskIds) {
        return taskIds.stream().map(this::findByIdIncludingArchived).collect(Collectors.toList());
    }

    @Timed
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.taskRepository.findTasksBasicData(taskIds);
    }

    @Timed
    public Task findByIdIncludingArchived(String taskId) {
        return this.findByIdIncludingArchived(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Task findByIdIncludingArchived(String taskId, ResolveOptions resolveOptions) {
        if (this.exists(taskId)) {
            return this.findById(taskId, resolveOptions);
        }
        if (this.archivingService.exists(taskId)) {
            Task task = this.archivingService.getTask(taskId);
            this.decoratorService.decorate((ConfigurationItem)task.getRelease(), Collections.singletonList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES()));
            return task;
        }
        throw new LogFriendlyNotFoundException(String.format("Task [%s] does not exist in the repository or archive", taskId), new Object[0]);
    }

    @Timed
    public String getUniqueId(String parent) {
        return this.ciIdService.getUniqueId(Type.valueOf(Task.class), parent);
    }

    @Timed
    public boolean exists(String taskId) {
        return this.taskRepository.exists(taskId);
    }

    @Timed
    public Task create(String containerId, Task task) {
        return this.create(containerId, task, null);
    }

    @Timed
    public Task create(String containerId, Task task, Integer position) {
        TaskContainer container = this.findContainerById(containerId);
        return this.createTask(container, null, task, position, TaskCreatedEvent::new, true);
    }

    @Timed
    public Task create(TaskContainer taskContainer, @Nullable String generatedTaskId, Task task, Integer position, Function<Task, TaskCreatedOrTypeChangedEvent> eventBuilder) {
        return this.createTask(taskContainer, generatedTaskId, task, position, eventBuilder, false);
    }

    private void checkAreTaskPropertiesUpdatable(Task oldTask, Task newTask) {
        if (newTask.ownerHasBeenReassigned(oldTask)) {
            this.permissions.checkReassignTaskToUser(oldTask, newTask.getOwner());
        }
        if (newTask.teamHasBeenReassigned(oldTask)) {
            this.permissions.checkReassignTaskPermission(oldTask.getRelease());
        }
        if (newTask.delayDuringBlackoutHasChanged(oldTask)) {
            this.permissions.checkEditBlackoutPermission(oldTask.getRelease());
        }
        if (newTask.failureHandlerHasChanged(oldTask)) {
            this.permissions.checkEditFailureHandlerPermission(oldTask.getRelease());
        }
        if (newTask.preconditionHasChanged(oldTask)) {
            this.permissions.checkEditPreconditionPermission(oldTask.getRelease());
        }
        this.checkTaskIsUpdatable(oldTask);
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(oldTask, newTask), (String)"Can't update scheduled start date of task '%s' that is neither planned or pending", (Object)oldTask.getTitle());
    }

    public Task updateTaskWith(String taskId, Task updated) {
        return this.updateTaskWith(taskId, updated, Collections.unmodifiableSet(new HashSet<TaskUpdateDirective>(Arrays.asList(TaskUpdateDirective.UPDATE_RELEASE_TASK, TaskUpdateDirective.UPDATE_TEMPLATE_TASK))), false);
    }

    @Timed
    public Task updateTaskWith(String taskId, Task updated, Set<TaskUpdateDirective> updateDirectives, boolean overrideLock) {
        Preconditions.checkArgument((updated.getFlagStatus() != null ? 1 : 0) != 0, (Object)"Flag status is required.");
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)updated.getTitle()), (Object)"Task title is required.");
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask(updated);
        Object task = this.findById(taskId);
        if (task instanceof CustomScriptTask && ((CustomScriptTask)task).getPythonScript() != null) {
            Preconditions.checkArgument((!((CustomScriptTask)task).isUnknown() ? 1 : 0) != 0, (Object)String.format("You can not update '%s' task", CustomScriptTask.UNKNOWN_TYPE));
        }
        this.checkAreTaskPropertiesUpdatable((Task)task, updated);
        TaskUpdater taskUpdater = this.getTaskUpdater(task.getClass());
        Preconditions.checkArgument((null != taskUpdater ? 1 : 0) != 0, (String)"Cannot update task because there is no updater defined for task type '%s'", (Object)task.getType().toString());
        this.checkIfConfigurationIsInherited(task.getRelease(), CiHelper.getExternalReferences((ConfigurationItem)updated));
        Task original = (Task)CiCloneHelper.cloneCi(task);
        taskUpdater.update((Task)task, updated, updateDirectives);
        VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), task, this.ciIdService);
        Release release = task.getRelease();
        release.updateRealFlagStatus();
        if (!overrideLock) {
            LockedTaskOperationChecks.checkTaskUpdate(original, task);
        }
        this.taskRepository.updateTaskAndReleaseFlagStatus((Task)task, release);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        return this.findById(original.getId());
    }

    @Timed
    public Task changeTaskType(String taskId, Type newTaskType) {
        Object task = this.taskRepository.findById(taskId);
        LockedTaskOperationChecks.checkTaskTypeChange(task);
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        return this.taskTypeConversionService.changeActiveTaskType(taskId, newTaskType);
    }

    @Timed
    public Task completeTask(String taskId, String commentText) {
        Object task = this.findById(taskId);
        Release release = task.getRelease();
        if (task.isPlanned()) {
            this.checkIsStatusCompletableInAdvance((Task)task);
            this.executionService.markTaskAsDone(release, TaskStatus.COMPLETED_IN_ADVANCE, taskId, commentText, User.AUTHENTICATED_USER);
        } else {
            this.checkIsStatusUpdatable((Task)task, "complete");
            this.executionService.markTaskAsDone(release, TaskStatus.COMPLETED, taskId, commentText, User.AUTHENTICATED_USER);
        }
        return this.findById(taskId);
    }

    @Timed
    public List<String> completeTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.completeTask((String)taskId, commentText));
    }

    @Timed
    public Task skipTask(String taskId, String commentText, User user) {
        Object task = this.findById(taskId);
        LockedTaskOperationChecks.checkSkipTask(task);
        Release release = task.getRelease();
        if (task.isPlanned()) {
            this.checkIsTaskSkippableInAdvance((Task)task);
            this.executionService.markTaskAsDone(release, TaskStatus.SKIPPED_IN_ADVANCE, taskId, commentText, user);
        } else {
            this.checkIsTaskSkippable((Task)this.findById(taskId));
            Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when skipping a task.");
            this.executionService.markTaskAsDone(release, TaskStatus.SKIPPED, taskId, commentText, user);
        }
        return this.findById(taskId);
    }

    @Timed
    public List<String> skipTasks(List<String> taskIds, String commentText, User user) {
        return this.executeBulkActionSilently(Lists.reverse(taskIds), taskId -> this.skipTask((String)taskId, commentText, user));
    }

    @Timed
    public Task failTask(String taskId, String commentText) {
        Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when failing a task.");
        Object task = this.findById(taskId);
        Preconditions.checkArgument((!this.isScriptOrCustomScriptTask((Task)task) ? 1 : 0) != 0, (Object)"Script tasks can't be failed, they can be aborted");
        this.checkIsStatusUpdatable((Task)task, "fail");
        this.executionService.fail((Task)task, commentText, User.AUTHENTICATED_USER);
        return task;
    }

    @Timed
    public List<String> failTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.failTask((String)taskId, commentText));
    }

    @Timed
    public Task abortTask(String taskId, String commentText) {
        Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when aborting a task.");
        Object task = this.findById(taskId);
        this.checkCanTaskBeAborted((Task)task);
        this.executionService.abortTask((Task)task, commentText);
        return this.findById(taskId);
    }

    @Timed
    public List<String> abortTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.abortTask((String)taskId, commentText));
    }

    @Timed
    public List<String> reopenTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.reopenTask((String)taskId, commentText));
    }

    @Timed
    public Task reopenTask(String taskId, String commentText) {
        Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when starting a pending task.");
        Object task = this.findById(taskId);
        this.checkCanTaskBeReopen((Task)task);
        this.executionService.reopenTask((Task)task, commentText);
        return this.findById(taskId);
    }

    @Timed
    public Task retryTask(String taskId, String commentText) {
        Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when retrying a task.");
        Object task = this.findById(taskId);
        this.checkCanTaskBeRetried((Task)task);
        this.executionService.retry((Task)task, commentText);
        return task;
    }

    @Timed
    public List<String> retryTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.retryTask((String)taskId, commentText));
    }

    @Timed
    public Task startPendingTask(String taskId, String commentText) {
        Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when starting a pending task.");
        Object task = this.findById(taskId);
        this.executionService.startPendingTask(taskId, task.getRelease(), commentText, User.AUTHENTICATED_USER);
        return this.findById(taskId);
    }

    @Timed
    public Task startWithInput(String taskId, List<Variable> variables) {
        return this.executionService.startWithInput(taskId, variables);
    }

    @Timed
    public List<Comment> getCommentsOfTask(String taskId) {
        if (this.exists(taskId)) {
            return this.commentService.findByTask(taskId);
        }
        if (this.archivingService.exists(taskId)) {
            return this.archivingService.getTask(taskId).getComments();
        }
        throw new LogFriendlyNotFoundException(String.format("Task [%s] does not exist in the repository or archive", taskId), new Object[0]);
    }

    @Timed
    public Comment addComment(Task task, String commentText) {
        Preconditions.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"A commentText is required.");
        return this.commentService.create(task, commentText, User.AUTHENTICATED_USER, true);
    }

    @Timed
    public List<String> addComments(List<Task> tasks, String commentText) {
        return this.executeBulkActionSilently(tasks, task -> this.addComment((Task)task, commentText)).stream().map(BaseConfigurationItem::getId).collect(Collectors.toList());
    }

    @Timed
    public void applyNewTeam(String newTeam, Task task) {
        this.applyNewTeam(newTeam, task, false);
    }

    @Timed
    public void applyNewTeam(String newTeam, Task task, boolean doTaskLockOperationCheck) {
        String previousTeam;
        if (doTaskLockOperationCheck) {
            LockedTaskOperationChecks.checkUpdateTeams(task);
        }
        if (!com.google.common.base.Objects.equal((Object)newTeam, (Object)(previousTeam = task.getTeam()))) {
            this.checkTaskIsUpdatable(task);
            Task original = CiCloneHelper.cloneCi(task.getRelease()).getTask(task.getId());
            task.setTeam(newTeam);
            this.taskRepository.update(task);
            this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        }
    }

    @Timed
    public Task reassignToOwner(String taskId, String newOwner) {
        Object task = this.taskRepository.findById(taskId);
        this.applyNewOwner(newOwner, (Task)task);
        return task;
    }

    @Timed
    public List<String> reassignTasks(List<String> taskIds, String newTeam, String newOwner) {
        return this.executeBulkActionSilently(taskIds, taskId -> {
            this.applyNewTeam(newTeam, (Task)this.taskRepository.findById((String)taskId));
            this.reassignToOwner((String)taskId, newOwner);
            return null;
        });
    }

    @Timed
    public List<String> deleteTasks(List<String> taskIds) {
        return this.executeBulkActionSilently(taskIds, taskId -> {
            this.delete((String)taskId);
            return null;
        });
    }

    @Timed
    public void delete(String taskId) {
        Object task = this.findById(taskId);
        Preconditions.checkArgument((boolean)task.isPlanned(), (String)"Only planned tasks can be deleted. Task '%s' is %s.", (Object)task.getTitle(), (Object)task.getStatus());
        LockedTaskOperationChecks.checkDeleteTask(task);
        Release release = task.getRelease();
        release.deleteTask(task);
        release.updateRealFlagStatus();
        this.clearLinks(task.getContainer(), (Task)task);
        this.taskRepository.delete((Task)task);
        this.eventBus.publish((XLReleaseEvent)new TaskDeletedEvent(task));
    }

    @Timed
    public Task copyTask(String taskToCopyId, String targetContainerId, int targetPosition) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)taskToCopyId), (Object)"Id of task to copy must be provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)targetContainerId), (Object)"Target container id must be provided");
        Object taskToCopy = this.findById(taskToCopyId);
        TaskContainer taskContainer = this.findContainerById(targetContainerId);
        Preconditions.checkArgument((targetPosition <= taskContainer.getTasks().size() ? 1 : 0) != 0, (String)"Target position must be between 0 and %s.", (int)taskContainer.getTasks().size());
        return this.copyTask((Task)taskToCopy, taskContainer, targetPosition);
    }

    @Timed
    public void notifyOverdueTasks(Release release, List<String> taskIds) {
        this.forReleaseTasks(release, taskIds, this::sendOverdue);
    }

    private void sendOverdue(Task task) {
        this.eventBus.publish((XLReleaseEvent)new TaskOverdueEvent(task));
        task.setOverdueNotified(true);
    }

    @Timed
    public void notifyTasksDueSoon(Release release, List<String> taskIds) {
        this.forReleaseTasks(release, taskIds, this::sendDueSoon);
    }

    private void forReleaseTasks(Release release, List<String> taskIds, Consumer<Task> taskOperation) {
        Task[] tasks = (Task[])taskIds.stream().map(taskId -> {
            Task task = release.getTask(taskId);
            taskOperation.accept(task);
            return task;
        }).toArray(Task[]::new);
        this.taskRepository.updateTasks(tasks);
    }

    private void sendDueSoon(Task task) {
        this.eventBus.publish((XLReleaseEvent)new TaskDueSoonEvent(task));
        task.setDueSoonNotified(true);
    }

    @Timed
    public Task duplicateTask(String originTaskId) {
        Object taskToCopy = this.findById(originTaskId);
        TaskContainer container = taskToCopy.getContainer();
        int targetPosition = container.getTasks().indexOf(taskToCopy) + 1;
        return this.copyTask((Task)taskToCopy, container, targetPosition);
    }

    @Timed
    public Task moveTask(MovementIndexes movementIndexes) {
        if (this.isTaskMovedWithinSameContainer(movementIndexes)) {
            return this.moveTaskWithinContainer(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        }
        return this.moveTaskBetweenContainers(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetContainerId(), movementIndexes.getTargetIndex());
    }

    @Timed
    public String getTitle(String id) {
        return this.taskRepository.getTitle(id);
    }

    @Timed
    public Task lockTask(String id) {
        return this.setLock(id, true);
    }

    @Timed
    public Task unlockTask(String id) {
        return this.setLock(id, false);
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return this.taskRepository.getAllTags(limitNumber);
    }

    @Timed
    public TaskStatus getStatus(String taskId) {
        return this.taskRepository.getStatus(taskId);
    }

    @Timed
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskRepository.getTaskStatuses(releaseId);
    }

    private Task setLock(String id, boolean lock) {
        Object task = this.taskRepository.findById(id);
        this.checkTaskIsUpdatable((Task)task);
        ArrayList updatedTasks = new ArrayList();
        task.getAllTasks().stream().filter(candidateTask -> candidateTask.isLocked() != lock).forEach(taskToUpdate -> {
            taskToUpdate.setLocked(lock);
            this.taskRepository.updateTaskProperties((Task)taskToUpdate);
            updatedTasks.add(taskToUpdate);
        });
        this.releaseService.updateReleaseProperties(null, task.getRelease());
        String releaseId = task.getRelease().getId();
        TasksLockedEvent event = lock ? new TasksLockedEvent(releaseId, updatedTasks) : new TasksUnlockedEvent(releaseId, updatedTasks);
        this.eventBus.publish((XLReleaseEvent)event);
        return task;
    }

    private void applyNewOwner(String newOwner, Task task) {
        String previousOwner = task.getOwner();
        if (!StringUtils.equalsIgnoreCase((String)newOwner, (String)previousOwner)) {
            this.checkTaskIsUpdatable(task);
            Task original = CiCloneHelper.cloneCi(task.getRelease()).getTask(task.getId());
            task.setOwner(newOwner);
            task.setOverdueNotified(false);
            task.setDueSoonNotified(false);
            VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
            this.taskRepository.update(task);
            this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        }
    }

    private Task moveTaskWithinContainer(String containerId, Integer originIndex, Integer targetIndex) {
        TaskContainer taskContainer = this.findContainerById(containerId);
        List tasks = taskContainer.getTasks();
        Task taskToMove = (Task)tasks.get(originIndex);
        Task targetTask = this.getTaskFromContainer(taskContainer, targetIndex);
        Preconditions.checkArgument((((PlanItem)taskContainer).isUpdatable() && this.areAllTasksMovable(taskToMove, targetTask) ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        LockedTaskOperationChecks.checkMoveTask(taskToMove, taskContainer, taskContainer);
        tasks.remove(taskToMove);
        tasks.add(targetIndex, taskToMove);
        Task savedTask = this.taskRepository.moveTask(taskToMove, taskToMove, taskContainer, taskContainer);
        this.eventBus.publish((XLReleaseEvent)new TaskMovedEvent(savedTask, originIndex.intValue(), targetIndex.intValue(), taskToMove.getId(), containerId, containerId));
        return savedTask;
    }

    private boolean isTaskMovedWithinSameContainer(MovementIndexes movementIndexes) {
        return movementIndexes.getOriginContainerId().equals(movementIndexes.getTargetContainerId());
    }

    private Task moveTaskBetweenContainers(String originContainerId, Integer originIndex, String targetContainerId, Integer targetIndex) {
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)originContainerId));
        TaskContainer originContainer = this.getTaskContainer(release, originContainerId);
        TaskContainer targetContainer = this.getTaskContainer(release, targetContainerId);
        List originContainerTasks = originContainer.getTasks();
        Task taskToMove = (Task)originContainerTasks.get(originIndex);
        Task targetTask = this.getTaskFromContainer(targetContainer, targetIndex);
        Preconditions.checkArgument((this.areAllTasksMovable(taskToMove, targetTask) && ((PlanItem)originContainer).isUpdatable() && ((PlanItem)targetContainer).isUpdatable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        LockedTaskOperationChecks.checkMoveTask(taskToMove, originContainer, targetContainer);
        String newId = this.getUniqueId(targetContainer.getId());
        this.clearLinks(originContainer, taskToMove);
        Task movedTask = CiCloneHelper.cloneCi(taskToMove);
        CiHelper.rewriteWithNewId((ConfigurationItem)movedTask, (String)newId);
        originContainer.getTasks().remove(taskToMove);
        targetContainer.addTask(movedTask, targetIndex.intValue());
        movedTask.setContainer(targetContainer);
        Task savedTask = this.taskRepository.moveTask(taskToMove, movedTask, originContainer, targetContainer);
        this.eventBus.publish((XLReleaseEvent)new TaskMovedEvent(savedTask, originIndex.intValue(), targetIndex.intValue(), taskToMove.getId(), originContainerId, targetContainerId));
        return savedTask;
    }

    private Task getTaskFromContainer(TaskContainer taskContainer, Integer index) {
        List containerTasks = taskContainer.getTasks();
        if (containerTasks.size() > index) {
            return (Task)containerTasks.get(index);
        }
        return null;
    }

    private boolean areAllTasksMovable(Task ... tasks) {
        return Arrays.stream(tasks).filter(Objects::nonNull).allMatch(Task::isMovable);
    }

    private void clearLinks(TaskContainer originContainer, Task task) {
        if (originContainer instanceof ParallelGroup) {
            Set allLinks = ((ParallelGroup)task.getContainer()).getLinks();
            Set links = allLinks.stream().filter(l -> !((ParallelGroup)task.getContainer()).getLinksOf(task).contains(l)).collect(Collectors.toSet());
            ((ParallelGroup)task.getContainer()).setLinks(links);
        }
    }

    private TaskContainer getTaskContainer(Release release, String containerId) {
        if (Ids.isPhaseId((String)containerId)) {
            return release.getPhase(containerId);
        }
        return (TaskContainer)release.getTask(containerId);
    }

    private Task copyTask(Task taskToCopy, TaskContainer taskContainer, int targetPosition) {
        LockedTaskOperationChecks.checkCopyTask(taskToCopy);
        boolean isInProgressParallelGroup = taskContainer instanceof ParallelGroup && ((ParallelGroup)taskContainer).isInProgress();
        boolean isUpdatableOrDoneInAdvance = taskToCopy.isUpdatable() || taskToCopy.isDoneInAdvance();
        Preconditions.checkArgument((!isInProgressParallelGroup ? 1 : 0) != 0, (Object)"Can't copy task within 'in progress' parallel group.");
        Preconditions.checkArgument((boolean)isUpdatableOrDoneInAdvance, (String)"Can't copy task '%s' because it is %s.", (Object)taskToCopy.getTitle(), (Object)taskToCopy.getStatus());
        Preconditions.checkArgument((targetPosition >= 0 ? 1 : 0) != 0, (Object)"Target position must be greater or equal to 0.");
        String newTaskId = this.getUniqueId(taskContainer.getId());
        Task copiedTaskTemplate = CiCloneHelper.cloneCi(taskToCopy);
        copiedTaskTemplate.setTitle(copiedTaskTemplate.getTitle() + " (copy)");
        copiedTaskTemplate.resetToPlanned();
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedTaskTemplate, (String)newTaskId);
        return this.create(taskContainer, newTaskId, copiedTaskTemplate, targetPosition, TaskCopiedEvent::new);
    }

    private boolean isScriptOrCustomScriptTask(Task task) {
        return task instanceof ScriptTask || task instanceof CustomScriptTask;
    }

    private void checkIsStatusUpdatable(Task task, String action) {
        if (!this.canUpdateInProgressStatus(task)) {
            throw new IllegalArgumentException("You can not " + action + " a task that is : not in progress, automated, or unassigned");
        }
        if (task.isTaskGroup()) {
            throw new IllegalArgumentException("You can not " + action + " a task group");
        }
    }

    private void checkIsReleaseActive(Release release) {
        Preconditions.checkState((boolean)release.isActive(), (String)"The release '%s' must be in progress, failing or failed.", (Object)release.getTitle());
    }

    private void checkIsStatusCompletableInAdvance(Task task) {
        this.checkIsReleaseActive(task.getRelease());
        LockedTaskOperationChecks.checkCompleteTaskInAdvance(task);
        boolean isAutomated = (Boolean)task.getProperty("automated");
        if (!this.canUpdatePlannedStatus(task) || isAutomated) {
            throw new IllegalArgumentException("You can not complete in advance a task that is : not planned or unassigned or automated");
        }
    }

    private void checkIsTaskSkippable(Task task) {
        LockedTaskOperationChecks.checkSkipTask(task);
        if (!this.canUpdateInProgressStatus(task) && !this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not skip a task that is : (in progress and automated or unassigned) or (failed and not automated or unassigned)");
        }
        if (task.isTaskGroup() && !((TaskGroup)task).isSkippableOrRetriable()) {
            throw new IllegalArgumentException("You can not skip this task group");
        }
    }

    private void checkIsTaskSkippableInAdvance(Task task) {
        LockedTaskOperationChecks.checkSkipTask(task);
        if (!this.canUpdatePlannedStatus(task)) {
            throw new IllegalArgumentException("You can not skip in advance a task that is : not planned or unassigned");
        }
        this.checkIsReleaseActive(task.getRelease());
    }

    private void checkCanTaskBeRetried(Task task) {
        if (!this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not retry a task that is : failed and not automated or unassigned");
        }
        if (task instanceof TaskGroup && !((TaskGroup)task).isSkippableOrRetriable()) {
            throw new IllegalArgumentException("You can not retry this task group");
        }
        if (task instanceof CustomScriptTask && ((CustomScriptTask)task).isUnknown()) {
            throw new IllegalArgumentException(String.format("You can not retry '%s' task", CustomScriptTask.UNKNOWN_TYPE));
        }
    }

    private void checkCanTaskBeReopen(Task task) {
        this.checkIsReleaseActive(task.getRelease());
        if (!task.isDoneInAdvance()) {
            throw new IllegalArgumentException("You can not reopen a task that is not done in advance");
        }
    }

    private void checkCanTaskBeAborted(Task task) {
        if (task.isInProgress() || task.isAbortScriptInProgress() || task.isQueued()) {
            Preconditions.checkArgument((boolean)(task instanceof BaseScriptTask), (String)"Unable to abort a task '%s' of type '%s'. When a task is running or queued, only ScriptTask or CustomScriptTask may be cancelled", (Object)task.getId(), (Object)task.getTaskType());
        } else {
            Preconditions.checkArgument((task.isPreconditionInProgress() || task.isFailureHandlerInProgress() || task.isFacetInProgress() ? 1 : 0) != 0, (String)"Only task currently evaluating a precondition, on failure handler state or verifying may be cancelled, but task status is %s", (Object)task.getStatus().name());
        }
    }

    private boolean canUpdateInProgressStatus(Task task) {
        return task.isInProgress() && !task.isAutomated() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdatePlannedStatus(Task task) {
        return task.isPlanned() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdateFailedStatus(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        return !(!task.isFailed() && !task.isFailureHandlerInProgress() || !isAutomated && !task.hasOwner() && !task.hasTeam());
    }

    private <T> List<T> executeBulkActionSilently(List<T> items, Function<T, ?> action) {
        return items.stream().filter(item -> {
            try {
                action.apply(item);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    private void checkTaskIsUpdatable(Task task) {
        Preconditions.checkArgument((boolean)task.isUpdatable(), (String)"Can't update task '%s' because it is in state %s", (Object)task.getTitle(), (Object)task.getStatus());
    }

    private boolean isScheduledStartDateUpdatable(Task original, Task updated) {
        return original.isPlanned() || original.isPending() || com.google.common.base.Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate());
    }

    private TaskUpdater getTaskUpdater(Class<? extends Task> taskType) {
        TaskUpdater updater = this.taskUpdatersPerType.get(taskType);
        return updater != null ? updater : this.taskUpdatersPerType.get(Task.class);
    }

    private TaskContainer findContainerById(String containerId) {
        if (Ids.isPhaseId((String)containerId)) {
            return this.phaseService.findById(containerId);
        }
        Object container = this.findById(containerId);
        if (!(container instanceof TaskGroup)) {
            throw new IllegalArgumentException("Task can only be added to phases or task groups");
        }
        return (TaskGroup)container;
    }

    private boolean isGlobalOrAncestor(String folderId, Release release) {
        return folderId == null || release.getId().startsWith(folderId);
    }

    private void checkIfConfigurationIsInherited(Release release, Set<ConfigurationItem> refs) {
        if (!refs.stream().filter(r -> r instanceof BaseConfiguration).allMatch(r -> this.isGlobalOrAncestor(((BaseConfiguration)r).getFolderId(), release))) {
            throw new IllegalArgumentException("The configuration is not inherited by the release of the updated task");
        }
    }

    private Task createTask(TaskContainer taskContainer, @Nullable String generatedTaskId, Task task, Integer position, Function<Task, TaskCreatedOrTypeChangedEvent> eventBuilder, boolean checkPasswords) {
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask(task);
        this.checkContainerConditionsForAdding(taskContainer, position);
        this.addToContainerAtPosition(taskContainer, task, position);
        if (generatedTaskId == null) {
            String id = this.getUniqueId(task.getContainer().getId());
            task.setId(id);
        }
        task.checkDatesValidity();
        this.checkIfConfigurationIsInherited(task.getRelease(), CiHelper.getExternalReferences((ConfigurationItem)task));
        task.setStatus(TaskStatus.PLANNED);
        if (task instanceof CustomScriptTask) {
            PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
            ResolutionContext resolutionContext = ResolutionContext.apply(Ids.findFolderId((String)task.getId()));
            Preconditions.checkArgument((pythonScript != null ? 1 : 0) != 0, (Object)"Missing pythonScript definition");
            Preconditions.checkArgument((!CustomScriptTask.UNKNOWN_TYPE.equals((Object)pythonScript.getType()) ? 1 : 0) != 0, (Object)String.format("You can not create '%s' task", CustomScriptTask.UNKNOWN_TYPE));
            pythonScript.setId(task.getId() + "/PythonScript");
            pythonScript.setCustomScriptTask((CustomScriptTask)task);
            this.populateCIReference(pythonScript, resolutionContext);
        } else if (task instanceof CreateReleaseTask) {
            List variables = ((CreateReleaseTask)task).getTemplateVariables();
            VariablePersistenceHelper.fixUpVariableIds(task.getId(), variables, this.ciIdService);
        }
        VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
        List aliens = task.getReferencedVariables().stream().filter(variable -> variable.getId() != null && task.getId() != null && !Ids.releaseIdFrom((String)variable.getId()).equals(Ids.releaseIdFrom((String)task.getId()))).map(Variable::getKey).collect(Collectors.toList());
        if (!aliens.isEmpty()) {
            throw new NotFoundException(String.format("Unable to create task with variables [%s] referencing another release.", String.join((CharSequence)", ", aliens)), new Object[0]);
        }
        if (checkPasswords) {
            PasswordVerificationUtils.replacePasswordPropertiesInCiIfNeededJava(Optional.empty(), (ConfigurationItem)task);
        }
        Task createdTask = this.taskRepository.create(task);
        this.eventBus.publish((XLReleaseEvent)eventBuilder.apply(createdTask));
        return createdTask;
    }

    private void populateCIReference(PythonScript pythonScript, ResolutionContext resolutionContext) {
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            Type referencedType;
            if (propertyDescriptor.getKind() != PropertyKind.CI || !propertyDescriptor.isRequired() || propertyDescriptor.get((ConfigurationItem)pythonScript) != null || !(referencedType = propertyDescriptor.getReferencedType()).isSubTypeOf(Type.valueOf(Configuration.class))) continue;
            Configuration configuration = this.configurationRepository.findFirstByType(referencedType, resolutionContext).orElse(null);
            propertyDescriptor.set((ConfigurationItem)pythonScript, (Object)configuration);
        }
    }

    private void checkContainerConditionsForAdding(TaskContainer container, Integer position) {
        LockedTaskOperationChecks.checkCreateTaskInContainer(container);
        String message = "Can't add a task to the %s '%s' because it is in state %s.";
        if (container instanceof Phase) {
            Phase phase = (Phase)container;
            Preconditions.checkArgument((boolean)phase.isUpdatable(), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object)"phase", (Object)phase.getTitle(), (Object)phase.getStatus());
            if (position != null) {
                Preconditions.checkArgument((position >= 0 && position <= phase.getTasks().size() ? 1 : 0) != 0, (Object)"Task index out of bounds");
                if (position < phase.getTasks().size()) {
                    Task taskAfterPosition = (Task)phase.getTasks().get(position);
                    Preconditions.checkArgument((taskAfterPosition.isPlanned() || taskAfterPosition.isDoneInAdvance() ? 1 : 0) != 0, (Object)"Can't add a task before a task that is active or done");
                }
            }
        } else if (container instanceof SequentialGroup) {
            SequentialGroup group = (SequentialGroup)container;
            Preconditions.checkArgument((boolean)group.isUpdatable(), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object)"sequential group", (Object)group.getTitle(), (Object)group.getStatus());
        } else if (container instanceof ParallelGroup) {
            ParallelGroup group = (ParallelGroup)container;
            Preconditions.checkArgument((boolean)group.getStatus().isOneOf(new TaskStatus[]{TaskStatus.PLANNED, TaskStatus.PENDING, TaskStatus.WAITING_FOR_INPUT}), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object)"parallel group", (Object)group.getTitle(), (Object)group.getStatus());
        }
    }

    private void addToContainerAtPosition(TaskContainer container, Task task, Integer position) {
        container.addTask(task, position != null ? position.intValue() : container.getTasks().size());
        task.setContainer(container);
    }
}

