/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.Timer;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.google.common.base.Strings;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;

public class ReleaseJettyServerCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseJettyServerCustomizer.class);

    private ReleaseJettyServerCustomizer() {
    }

    public static JettyServerCustomizer create(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        return jettyServer -> {
            ServerConnector connector;
            if (serverConfiguration.isSsl()) {
                SslContextFactory.Server sslContextFactory = ReleaseJettyServerCustomizer.getSslContextFactory(serverConfiguration);
                connector = new ServerConnector(jettyServer, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{ReleaseJettyServerCustomizer.getHttpConnectionFactory(xlrConfig)});
            } else {
                connector = new ServerConnector(jettyServer, new ConnectionFactory[]{ReleaseJettyServerCustomizer.getHttpConnectionFactory(xlrConfig)});
            }
            connector.setIdleTimeout(30000L);
            connector.setHost(serverConfiguration.getHttpBindAddress());
            connector.setPort(serverConfiguration.getHttpPort());
            jettyServer.setConnectors(new Connector[]{connector});
            logger.info("Connector listen {} on {}:{}", new Object[]{serverConfiguration.isSsl() ? "secure" : "no-secure", connector.getHost(), connector.getPort()});
            jettyServer.setStopTimeout(1000L);
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            jettyServer.addEventListener((Container.Listener)mbContainer);
            jettyServer.addBean((Object)mbContainer);
        };
    }

    private static SslContextFactory.Server getSslContextFactory(ServerConfiguration serverConfiguration) {
        logger.debug("Setting up Jetty to use SSL");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(serverConfiguration.getKeyStorePath());
        sslContextFactory.setKeyStorePassword(serverConfiguration.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(serverConfiguration.getKeyStoreKeyPassword());
        String protocol = serverConfiguration.getSslProtocol();
        if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
            sslContextFactory.setProtocol(protocol);
        }
        if (serverConfiguration.isMutualSsl()) {
            logger.debug("Setting up Jetty to use mutual SSL");
            sslContextFactory.setNeedClientAuth(true);
            sslContextFactory.setTrustStorePath(serverConfiguration.getTrustStorePath());
            sslContextFactory.setTrustStorePassword(serverConfiguration.getTrustStorePassword());
        }
        return sslContextFactory;
    }

    private static ConnectionFactory getHttpConnectionFactory(XlrConfig xlrConfig) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(true, TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS), true));
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConfiguration, HttpCompliance.RFC2616);
        if (xlrConfig.metrics().enabled()) {
            Timer timer = XlrMetricRegistry.metricRegistry().timer("connections");
            connectionFactory = new InstrumentedConnectionFactory((ConnectionFactory)connectionFactory, timer);
        }
        return connectionFactory;
    }
}

