/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.export.UnresolvedReferencesConfigurationItemConverter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateContent;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf!B\n\u0015\u0003\u0003i\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u00111\u0002!\u0011!Q\u0001\n5B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006\u0001\u0002!\t!\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\u0019\u0006\u0001)A\u0005s!)A\u000b\u0001D\u0001+\")1\r\u0001D\tI\")a\u000e\u0001D\t_\"1a\u0010\u0001D\u0001)}Dq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!a&\u0001\t\u0013\tIJ\u0001\u000bCCN,G+Z7qY\u0006$X-S7q_J$XM\u001d\u0006\u0003+Y\ta!\u001a=q_J$(BA\f\u0019\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001a5\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00027\u0005\u00191m\\7\u0004\u0001U\u0011a$R\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017!\u0005;bg.\f5mY3tgN+'O^5dKB\u0011qEK\u0007\u0002Q)\u0011\u0011FF\u0001\bg\u0016\u0014h/[2f\u0013\tY\u0003FA\tUCN\\\u0017iY2fgN\u001cVM\u001d<jG\u0016\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0002(]%\u0011q\u0006\u000b\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003]i\u0017-\u001f2f)\u0016l\u0007\u000f\\1uKB\u0013xnY3tg>\u00148\u000fE\u00023oej\u0011a\r\u0006\u0003iU\nA!\u001e;jY*\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d4\u0005!y\u0005\u000f^5p]\u0006d\u0007c\u0001\u001a;y%\u00111h\r\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002>}5\tA#\u0003\u0002@)\t9B+Z7qY\u0006$X-S7q_J$\bK]8dKN\u001cxN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\tsu\n\u0015\t\u0004{\u0001\u0019\u0005C\u0001#F\u0019\u0001!QA\u0012\u0001C\u0002\u001d\u0013\u0011\u0001V\t\u0003\u0011.\u0003\"\u0001I%\n\u0005)\u000b#a\u0002(pi\"Lgn\u001a\t\u0003{1K!!\u0014\u000b\u0003\u001fQ+W\u000e\u001d7bi\u0016\u001cuN\u001c;f]RDQ!\n\u0003A\u0002\u0019BQ\u0001\f\u0003A\u00025BQ\u0001\r\u0003A\u0002E\n!\u0003^3na2\fG/\u001a)s_\u000e,7o]8sgV\t\u0011(A\nuK6\u0004H.\u0019;f!J|7-Z:t_J\u001c\b%\u0001\u0005tkB\u0004xN\u001d;t+\t1V\f\u0006\u0002X5B\u0011\u0001\u0005W\u0005\u00033\u0006\u0012qAQ8pY\u0016\fg\u000eC\u0003\\\u000f\u0001\u0007A,A\u0007j[B|'\u000f^\"p]R,\u0007\u0010\u001e\t\u0003\tv#QAX\u0004C\u0002}\u0013\u0011!V\t\u0003\u0011\u0002\u0004\"!P1\n\u0005\t$\"!\u0006+f[Bd\u0017\r^3J[B|'\u000f^\"p]R,\u0007\u0010^\u0001\u0016I>\u0014V-\u00193UK6\u0004H.\u0019;f\u0007>tG/\u001a8u)\r\u0019U-\u001c\u0005\u0006M\"\u0001\raZ\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002iW6\t\u0011N\u0003\u0002kk\u0005\u0011\u0011n\\\u0005\u0003Y&\u00141\"\u00138qkR\u001cFO]3b[\")1\f\u0003a\u0001A\u0006ABm\\+qOJ\fG-\u001a+f[Bd\u0017\r^3D_:$XM\u001c;\u0015\u0005Ad\bc\u0001\u001a;cB\u0011!/\u001f\b\u0003g^\u0004\"\u0001^\u0011\u000e\u0003UT!A\u001e\u000f\u0002\rq\u0012xn\u001c;?\u0013\tA\u0018%\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=\"\u0011\u0015i\u0018\u00021\u0001D\u0003=!X-\u001c9mCR,7i\u001c8uK:$\u0018a\u00053p\u0007>tg/\u001a:u)>$V-\u001c9mCR,GCBA\u0001\u0003\u001b\ty\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AF\u0001\u0007I>l\u0017-\u001b8\n\t\u0005-\u0011Q\u0001\u0002\b%\u0016dW-Y:f\u0011\u0015i(\u00021\u0001D\u0011\u0019\t\tB\u0003a\u0001c\u0006\u0019B-Z:uS:\fG/[8o\r>dG-\u001a:JI\u0006q\u0011.\u001c9peR$V-\u001c9mCR,GCBA\f\u0003K\t9\u0003\u0005\u00033u\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}a#A\u0003wS\u0016<8/\u0003\u0003\u0002$\u0005u!\u0001D%na>\u0014HOU3tk2$\b\"\u00024\f\u0001\u00049\u0007\"B.\f\u0001\u0004\u0001\u0017!F5na>\u0014H\u000fV3na2\fG/Z\"p]R,g\u000e\u001e\u000b\t\u0003/\ti#a\f\u00022!)Q\u0010\u0004a\u0001\u0007\"1\u0011\u0011\u0003\u0007A\u0002EDa!a\r\r\u0001\u0004\u0001\u0018\u0001C<be:LgnZ:\u0002\u001bI,7/\u001a;UK6\u0004H.\u0019;f)\u0011\tI$a\u0010\u0011\u0007\u0001\nY$C\u0002\u0002>\u0005\u0012A!\u00168ji\"9\u0011\u0011I\u0007A\u0002\u0005\u0005\u0011a\u0002:fY\u0016\f7/Z\u0001\u001ae\u0016\u001cX\r^+oI\u0016\u001c'/\u001f9uK\u0012\u0004\u0016m]:x_J$7\u000f\u0006\u0004\u0002:\u0005\u001d\u00131\n\u0005\b\u0003\u0013r\u0001\u0019AA\u0001\u0003!!X-\u001c9mCR,\u0007bBA\u001a\u001d\u0001\u0007\u0011Q\n\t\u0005e\u0005=\u0013/C\u0002\u0002RM\u0012!bQ8mY\u0016\u001cG/[8o\u0003a\u0011Xm]3u+:$Wm\u0019:zaR,G\rU1tg^|'\u000f\u001a\u000b\u0006/\u0006]\u00131\u000f\u0005\b\u00033z\u0001\u0019AA.\u0003\t\u0019\u0017\u000e\u0005\u0003\u0002^\u0005=TBAA0\u0015\u0011\t\t'a\u0019\u0002\u0007U$WN\u0003\u0003\u0002f\u0005\u001d\u0014aA1qS*!\u0011\u0011NA6\u0003\u0019\u0001H.^4j]*\u0019\u0011Q\u000e\r\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!\u001d\u0002`\t\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\t\u000f\u0005Ut\u00021\u0001\u0002x\u0005\u0011\u0002O]8qKJ$\u0018\u0010R3tGJL\u0007\u000f^8s!\u0011\tI(a \u000e\u0005\u0005m$\u0002BA?\u0003G\nqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u0002\u0006m$A\u0005)s_B,'\u000f^=EKN\u001c'/\u001b9u_J\fQD]3n_Z,W*[:tS:<w)\u0019;f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0007\u0003s\t9)!#\t\u000f\u0005%\u0003\u00031\u0001\u0002\u0002!9\u00111\u0007\tA\u0002\u00055\u0013a\u0007:f[>4X\r\u0016:jO\u001e,'o\u001d$peJ{w\u000e\u001e$pY\u0012,'\u000f\u0006\u0005\u0002:\u0005=\u00151SAK\u0011\u0019\t\t*\u0005a\u0001c\u0006iA-Z:uS:\fG/[8o\u0013\u0012Dq!!\u0013\u0012\u0001\u0004\t\t\u0001C\u0004\u00024E\u0001\r!!\u0014\u0002/Q,W\u000e\u001d7bi\u0016,\u00050[:ug^KG\u000f\u001b+ji2,G#B,\u0002\u001c\u0006}\u0005BBAO%\u0001\u0007\u0011/\u0001\u0005g_2$WM]%e\u0011\u0019\t\tK\u0005a\u0001c\u0006)A/\u001b;mK\u0002")
public abstract class BaseTemplateImporter<T extends TemplateContent> {
    private final TaskAccessService taskAccessService;
    private final ReleaseService releaseService;
    private final List<TemplateImportProcessor> templateProcessors;

    private List<TemplateImportProcessor> templateProcessors() {
        return this.templateProcessors;
    }

    public abstract <U extends TemplateImportContext> boolean supports(U var1);

    public abstract T doReadTemplateContent(InputStream var1, TemplateImportContext var2);

    public abstract List<String> doUpgradeTemplateContent(T var1);

    public abstract Release doConvertToTemplate(T var1, String var2);

    public List<ImportResult> importTemplate(InputStream inputStream, TemplateImportContext importContext) {
        T templateContent = this.doReadTemplateContent(inputStream, importContext);
        List<String> upgradeWarnings = this.doUpgradeTemplateContent(templateContent);
        return this.importTemplateContent(templateContent, importContext.destinationFolderId(), upgradeWarnings);
    }

    private List<ImportResult> importTemplateContent(T templateContent, String destinationFolderId, List<String> warnings) {
        String destinationId = destinationFolderId == null ? Ids.ROOT_FOLDER_ID : destinationFolderId;
        Release template = this.doConvertToTemplate(templateContent, destinationId);
        template.getAttachments().forEach(attachment -> attachment.setFile((OverthereFile)templateContent.localFiles().get(attachment.getExportFilename())));
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be imported", (Object[])new Object[0]);
        this.taskAccessService.checkIfAuthenticatedUserCanUseTasks(template.getAllTasks());
        this.templateProcessors().forEach(processor -> warnings.addAll(processor.process(template, destinationId)));
        this.removeMissingGateDependencies(template, warnings);
        this.removeTriggersForRootFolder(destinationId, template, warnings);
        this.resetUndecryptedPasswords(template, warnings);
        this.resetTemplate(template);
        while (this.templateExistsWithTitle(destinationId, template.getTitle())) {
            template.setTitle(RetryTitleGenerator.getNextTitle(template.getTitle()));
        }
        if (!template.hasScheduledStartDate()) {
            template.setScheduledStartDate(template.findFirstSetDate());
        }
        this.releaseService.importTemplate(template, destinationId);
        return Arrays.asList((Object[])new ImportResult[]{new ImportResult(template.getId(), template.getTitle(), warnings)});
    }

    private void resetTemplate(Release release) {
        release.setRunningTriggeredReleasesCount(0);
    }

    private void resetUndecryptedPasswords(Release template, Collection<String> warnings) {
        block0: {
            BooleanRef issueWarning = BooleanRef.create((boolean)false);
            List configurationItems = CiHelper.getNestedCis((ConfigurationItem)template);
            configurationItems.forEach(configurationItem -> {
                Collection propertyDescriptors = configurationItem.getType().getDescriptor().getPropertyDescriptors();
                CollectionConverters$.MODULE$.CollectionHasAsScala(propertyDescriptors).asScala().foreach((Function1 & Serializable)propertyDescriptor -> {
                    BaseTemplateImporter.$anonfun$resetUndecryptedPasswords$2(this, configurationItem, issueWarning, propertyDescriptor);
                    return BoxedUnit.UNIT;
                });
            });
            if (!issueWarning.elem) break block0;
            warnings.add("Passwords could not be decrypted and have been reset.");
        }
    }

    private boolean resetUndecryptedPassword(ConfigurationItem ci, PropertyDescriptor propertyDescriptor) {
        PropertyKind propertyKind = propertyDescriptor.getKind();
        PropertyKind propertyKind2 = PropertyKind.STRING;
        if (!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && propertyDescriptor.isPassword()) {
            String passwordValue;
            String string = passwordValue = (String)propertyDescriptor.get(ci);
            String string2 = UnresolvedReferencesConfigurationItemConverter.DECRYPTION_FAILED_VALUE;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                propertyDescriptor.set(ci, (Object)"");
                return true;
            }
        }
        return false;
    }

    private void removeMissingGateDependencies(Release template, Collection<String> warnings) {
        template.getAllGates().forEach(gateTask -> gateTask.getDependencies().removeIf(dependency -> {
            void var3_3;
            boolean shouldBeRemoved = !dependency.hasVariableTarget() && !dependency.hasResolvedTarget() && !dependency.isArchived();
            Object object = shouldBeRemoved ? BoxesRunTime.boxToBoolean((boolean)warnings.add(String.format("Gate Task '%s' has a dependency on an unknown Release/Phase/Task", gateTask.getTitle()))) : BoxedUnit.UNIT;
            return (boolean)var3_3;
        }));
    }

    private void removeTriggersForRootFolder(String destinationId, Release template, Collection<String> warnings) {
        block0: {
            if (!Ids.isRoot((String)destinationId) || template.getReleaseTriggers().isEmpty()) break block0;
            template.setReleaseTriggers(new ArrayList());
            warnings.add("Triggers could not be imported on the root folder.");
        }
    }

    private boolean templateExistsWithTitle(String folderId, String title) {
        return this.releaseService.templateExistsWithTitle(folderId, title);
    }

    public static final /* synthetic */ void $anonfun$resetUndecryptedPasswords$2(BaseTemplateImporter $this, ConfigurationItem configurationItem$1, BooleanRef issueWarning$1, PropertyDescriptor propertyDescriptor) {
        block0: {
            boolean decryptionFailed = $this.resetUndecryptedPassword(configurationItem$1, propertyDescriptor);
            if (!decryptionFailed) break block0;
            issueWarning$1.elem = true;
        }
    }

    public BaseTemplateImporter(TaskAccessService taskAccessService, ReleaseService releaseService, Optional<List<TemplateImportProcessor>> maybeTemplateProcessors) {
        this.taskAccessService = taskAccessService;
        this.releaseService = releaseService;
        this.templateProcessors = maybeTemplateProcessors.orElse(Collections.emptyList());
    }
}

