/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.CommentBuilder;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentServiceHelper;
import com.xebialabs.xlrelease.user.User;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.jdk.javaapi.CollectionConverters;

@Repository
public class CommentService {
    public static final String COMMENT_PREFIX_SCRIPT = String.format("This comment was too long and has been cut off at the end. See the `script_output.log` attachment for the full log.%n%n---%n%n", new Object[0]);
    public static final String COMMENT_PREFIX_MANUAL = String.format("This comment was too long and has been cut off at the end.%n%n---%n%n", new Object[0]);
    public static final String COMMENT_SUFFIX = String.format("%n%n---%n%n[...truncated...]", new Object[0]);
    private static final Logger logger = LoggerFactory.getLogger(CommentService.class);
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private final CommentRepository commentRepository;

    @Autowired
    public CommentService(CiIdService ciIdService, XLReleaseEventBus eventBus, CommentRepository commentRepository) {
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.commentRepository = commentRepository;
    }

    @Timed
    public Comment create(Task task, Comment comment) {
        return this.createComment(task, comment.getText(), comment.getAuthor(), false, COMMENT_PREFIX_MANUAL);
    }

    @Timed
    public Comment create(Task task, String text, User author, boolean notify) {
        return this.createComment(task, text, author, notify, COMMENT_PREFIX_MANUAL);
    }

    @Timed
    public Comment update(Task task, String commentId, String text) {
        Comment comment = this.commentRepository.findById(commentId);
        Comment original = CiCloneHelper.cloneCi(comment);
        int maxCommentSize = task.getMaxCommentSize();
        if (!text.equals(comment.getText())) {
            CommentServiceHelper.updateCommentText((Comment)comment, (String)text, (int)maxCommentSize, (String)COMMENT_PREFIX_MANUAL, (String)COMMENT_SUFFIX);
            task.updateComment(original, comment);
            this.commentRepository.update(comment.getId(), comment.getText());
            this.eventBus.publish((XLReleaseEvent)new CommentUpdatedEvent(task, original, comment));
        }
        return comment;
    }

    @Timed
    public String appendComment(Task task, String commentId, String commentText) {
        String updatedCommentId = commentId;
        try {
            int maxCommentSize = task.getMaxCommentSize();
            if (Strings.isBlank((String)updatedCommentId)) {
                Comment comment = this.createComment(task, commentText, User.LOG_OUTPUT, false, COMMENT_PREFIX_SCRIPT);
                updatedCommentId = comment.getId();
            } else {
                Comment comment = this.commentRepository.findById(updatedCommentId);
                Comment original = CiCloneHelper.cloneCi(comment);
                CommentServiceHelper.appendCommentText((Comment)comment, (String)commentText, (int)maxCommentSize, (String)COMMENT_PREFIX_SCRIPT, (String)COMMENT_SUFFIX);
                task.updateComment(original, comment);
                this.commentRepository.update(comment.getId(), comment.getText());
                this.eventBus.publish((XLReleaseEvent)new CommentUpdatedEvent(task, original, comment));
            }
        }
        catch (Exception exception) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)task.getId(), (Object)exception);
        }
        return updatedCommentId;
    }

    private Comment createComment(Task task, String commentText, User author, boolean notify, String prefix) {
        String commentAuthor = author == User.SYSTEM ? null : author.getName();
        return this.createComment(task, commentText, commentAuthor, notify, prefix);
    }

    private Comment createComment(Task task, String commentText, String commentAuthor, boolean notify, String prefix) {
        Comment comment = this.buildComment(task, commentText, commentAuthor, new Date(), prefix, COMMENT_SUFFIX);
        task.getComments().add(comment);
        logger.debug("Creating comment: {}", (Object)comment);
        this.commentRepository.create(comment);
        this.eventBus.publish((XLReleaseEvent)new CommentCreatedEvent(task, comment, commentAuthor, notify));
        return comment;
    }

    public Comment buildComment(Task task, String commentText, String author, Date creationDate, String prefix, String suffix) {
        int maxCommentSize = task.getMaxCommentSize();
        Comment comment = CommentBuilder.newComment().withId(this.ciIdService.getUniqueId(Type.valueOf(Comment.class), task.getId())).withCreationDate(creationDate).withLimit(maxCommentSize).withAuthor(author).build();
        CommentServiceHelper.appendCommentText((Comment)comment, (String)commentText, (int)maxCommentSize, (String)prefix, (String)suffix);
        return comment;
    }

    public void decorate(Task task) {
        this.commentRepository.decorate(task);
    }

    public void decorate(Release release) {
        this.commentRepository.decorate(release);
    }

    public List<Comment> findByTask(String taskId) {
        return CollectionConverters.asJava(this.commentRepository.findByTask(taskId));
    }

    @Timed
    public void delete(Task task, String commentId) {
        Comment comment = this.commentRepository.findById(commentId);
        this.commentRepository.delete(comment);
        this.eventBus.publish((XLReleaseEvent)new CommentDeletedEvent(task, comment));
    }
}

