/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.xlrelease.ReleaseServer;
import com.xebialabs.xlrelease.XLReleaseBootstrapper;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.util.ResourceUtils;
import scala.runtime.BoxesRunTime;

public final class XLReleaseBootstrapper$ {
    public static final XLReleaseBootstrapper$ MODULE$ = new XLReleaseBootstrapper$();
    private static final String PRODUCT_DIGITALAI = "Digital.ai Release";
    private static final String LOGBACK_CONFIG_FILE = "logback.configurationFile";
    private static ReleaseServer releaseServer;

    public String PRODUCT_DIGITALAI() {
        return PRODUCT_DIGITALAI;
    }

    public String LOGBACK_CONFIG_FILE() {
        return LOGBACK_CONFIG_FILE;
    }

    public ReleaseServer releaseServer() {
        return releaseServer;
    }

    public void releaseServer_$eq(ReleaseServer x$1) {
        releaseServer = x$1;
    }

    public void boot(String[] args) {
        ReleaseServer.outputReleaseInfo();
        XLReleaseServerLaunchOptions launchOptions = XLReleaseServerLaunchOptions.parseCommandLine(args);
        if (launchOptions == null) {
            System.exit(0);
        }
        File serverConfFile = ResourceUtils.getFile((String)XlrConfig$.MODULE$.bootConfig().confFile_location());
        ServerConfigFile confFile = new ServerConfigFile(serverConfFile);
        LocalBooter.boot();
        Security.addProvider((Provider)new BouncyCastleProvider());
        XLReleasePermissions.init();
        this.releaseServer_$eq(new ReleaseServer(launchOptions, confFile));
        this.releaseServer().prepareConfigs();
    }

    public void main(String[] args) {
        this.boot(args);
        System.setProperty("liquibase.hub.mode", "off");
        SpringApplication app = new SpringApplication(new Class[]{XLReleaseBootstrapper.class});
        app.setAllowBeanDefinitionOverriding(true);
        app.setBannerMode(Banner.Mode.OFF);
        app.setDefaultProperties(this.defaultProperties());
        app.addInitializers(new ApplicationContextInitializer[]{new XlrWebApplicationInitializer()});
        app.run(args);
    }

    /*
     * WARNING - void declaration
     */
    private Properties defaultProperties() {
        void var1_1;
        Object object;
        Properties properties = new Properties();
        properties.put("spring.liquibase.enabled", "false");
        properties.put("spring.backgroundpreinitializer.ignore", "true");
        properties.put("server.shutdown", "immediate");
        properties.put("xl.server.session.storage.enabled", BoxesRunTime.boxToBoolean((boolean)XlrConfig$.MODULE$.getInstance().server_session_storage_enabled()));
        properties.put("xl.release.config", XlrConfig$.MODULE$.defaultConfigName());
        if (Strings.isNullOrEmpty((String)System.getProperty(this.LOGBACK_CONFIG_FILE()))) {
            object = properties.put("logging.config", "conf/logback.xml");
        } else {
            properties.put("logging.config", System.getProperty(this.LOGBACK_CONFIG_FILE()));
            object = System.setProperty(this.LOGBACK_CONFIG_FILE(), "");
        }
        return var1_1;
    }

    private XLReleaseBootstrapper$() {
    }
}

