/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.configuration.SystemMessageSettings;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExternalVariableService;
import com.xebialabs.xlrelease.service.SharedConfigurationService;
import com.xebialabs.xlrelease.service.SharedConfigurationStatusService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.ConfigurationView;
import com.xebialabs.xlrelease.views.SharedConfigurationStatusResponse;
import com.xebialabs.xlrelease.views.converters.ConfigurationItemViewConverter;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
@AllCILevels
public class ConfigurationApiImpl
implements ConfigurationApi {
    private SharedConfigurationService sharedConfigurationService;
    private PermissionChecker permissions;
    private VariableService variableService;
    private ConfigurationRepository configurationRepository;
    private ConfigurationItemViewConverter configurationViewConverter;
    private SharedConfigurationStatusService sharedConfigurationStatusService;
    private ExternalVariableService externalVariableService;

    @Autowired
    public ConfigurationApiImpl(PermissionChecker permissions, VariableService variableService, SharedConfigurationService sharedConfigurationService, ConfigurationRepository configurationRepository, ConfigurationItemViewConverter configurationViewConverter, SharedConfigurationStatusService sharedConfigurationStatusService, ExternalVariableService externalVariableService) {
        this.permissions = permissions;
        this.variableService = variableService;
        this.sharedConfigurationService = sharedConfigurationService;
        this.configurationRepository = configurationRepository;
        this.configurationViewConverter = configurationViewConverter;
        this.sharedConfigurationStatusService = sharedConfigurationStatusService;
        this.externalVariableService = externalVariableService;
    }

    public ConfigurationApiImpl() {
    }

    @GET
    @Path(value="/Configuration/variables/global")
    @PublicApiMember
    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getGlobalVariables() {
        return this.variableService.findGlobalVariablesOrEmpty().getVariables();
    }

    @GET
    @Path(value="/Configuration/variableValues/global")
    @PublicApiMember
    @Timed
    public Map<String, String> getGlobalVariableValues() {
        return VariableHelper.getVariableValuesAsStrings((List)this.variableService.findGlobalVariablesOrEmpty().getVariables());
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getGlobalVariable(@PathParam(value="variableId") String variableId) {
        return this.variableService.findById(variableId);
    }

    @POST
    @Path(value="/Configuration/variables/global")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable addGlobalVariable(Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]);
        this.externalVariableService.checkExistsAndCorrectType(variable.getExternalVariableValue());
        if (this.variableService.findGlobalVariablesOrEmpty().getVariablesByKeys().containsKey(variable.getKey())) {
            throw new ItemConflictException("A global variable already exists by key [%s]", new Object[]{variable.getKey()});
        }
        return this.variableService.addGlobalVariable(variable.toReleaseVariable());
    }

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(@PathParam(value="variableId") String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        variable.setId(variableId);
        if (!VariableHelper.isGlobalVariableId((String)variable.getId())) {
            throw new ItemConflictException("Variable id [%s] doesn't belong to the global variable", new Object[]{variable.getId()});
        }
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        return this.variableService.updateGlobalVariable(variable);
    }

    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.updateGlobalVariable(variable.getId(), variable);
    }

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteGlobalVariable(@PathParam(value="variableId") String variableId) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        this.variableService.findById(variableId);
        this.variableService.deleteGlobalVariable(variableId);
    }

    public List<? extends ConfigurationItem> searchByTypeAndTitle(String configurationType, String title) {
        return this.searchByTypeAndTitle(configurationType, title, null, false);
    }

    public List<? extends ConfigurationItem> searchByTypeAndTitle(String configurationType, String title, String folderId) {
        return this.searchByTypeAndTitle(configurationType, title, folderId, false);
    }

    @GET
    @Path(value="byTypeAndTitle")
    @PublicApiMember
    @Timed
    public List<Configuration> searchByTypeAndTitle(@QueryParam(value="configurationType") String configurationType, @QueryParam(value="title") String title, @QueryParam(value="folderId") String folderId, @QueryParam(value="folderOnly") boolean folderOnly) {
        List<Configuration> items = this.sharedConfigurationService.searchByTypeAndTitle(Type.valueOf((String)configurationType), title, folderId, folderOnly);
        items.forEach(item -> CiHelper.forFields((ConfigurationItem)item, PropertyDescriptor::isPassword, (ci, pd) -> pd.set(ci, null)));
        return items;
    }

    @GET
    @Path(value="/{configurationId:.*/Configuration[^/]*}")
    @PublicApiMember
    @Timed
    public Configuration getConfiguration(@PathParam(value="configurationId") String configurationId) {
        return this.sharedConfigurationService.findById(configurationId);
    }

    @POST
    @PublicApiMember
    @Timed
    public Configuration addConfiguration(Configuration configuration) {
        this.checkEditConfigurationPermissions(configuration);
        return this.sharedConfigurationService.create(configuration);
    }

    @PUT
    @Path(value="{configurationId:.*/Configuration[^/]*}")
    @Timed
    public Configuration updateConfiguration(@PathParam(value="configurationId") String configurationId, Configuration configuration) {
        this.checkEditConfigurationPermissions(configurationId);
        return this.sharedConfigurationService.update(configurationId, configuration);
    }

    @PublicApiMember
    @Timed
    public Configuration updateConfiguration(Configuration configuration) {
        return this.updateConfiguration(configuration.getId(), configuration);
    }

    @DELETE
    @Path(value="{configurationId:.*/Configuration[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteConfiguration(@PathParam(value="configurationId") String configurationId) {
        this.checkEditConfigurationPermissions(configurationId);
        this.sharedConfigurationService.delete(configurationId);
    }

    private void checkEditConfigurationPermissions(String configurationId) {
        Configuration configuration = this.sharedConfigurationService.findById(configurationId);
        this.checkEditConfigurationPermissions(configuration);
    }

    private void checkEditConfigurationPermissions(Configuration configuration) {
        if (configuration.getFolderId() == null) {
            this.permissions.check(PlatformPermissions.ADMIN);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_CONFIGURATION, configuration.getFolderId());
        }
    }

    @GET
    @Path(value="system-message")
    @PublicApiMember
    @Timed
    public SystemMessageSettings getSystemMessage() {
        return (SystemMessageSettings)((Object)this.configurationRepository.read("Configuration/settings/SystemMessageSettings"));
    }

    @PUT
    @Path(value="system-message")
    @PublicApiMember
    @Timed
    public SystemMessageSettings updateSystemMessage(SystemMessageSettings systemMessageSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurationRepository.update(systemMessageSettings);
    }

    @POST
    @Path(value="status")
    @PublicApiMember
    @Timed
    public SharedConfigurationStatusResponse checkStatus(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        this.checkEditConfigurationPermissions(configuration);
        return this.sharedConfigurationStatusService.checkStatus(configuration);
    }

    @POST
    @Path(value="{configurationId:.*/Configuration[^/]*}/status")
    @PublicApiMember
    @Timed
    public SharedConfigurationStatusResponse checkStatus(@PathParam(value="configurationId") String configurationId) {
        Configuration configuration = this.sharedConfigurationService.findById(configurationId);
        this.checkEditConfigurationPermissions(configuration);
        return this.sharedConfigurationStatusService.checkStatus(configuration);
    }
}

