/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import akka.actor.Actor;
import akka.actor.ActorRef;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\teb\u0001B\n\u0015\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005q!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003D\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bE\u0003A\u0011\u0001*\t\u000b\u001d\u0004A\u0011\u00015\t\u000bQ\u0004A\u0011\u00015\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\tY\u000e\u0001C\u0005\u0003;Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0011\u0003\b\tA\"\t\\1dW>,H\u000fV1tW\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005U1\u0012\u0001\u00032mC\u000e\\w.\u001e;\u000b\u0005]A\u0012aB:feZL7-\u001a\u0006\u00033i\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011\u0003\u0002\u0001!M9\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003%)\u0007\u0010^3og&|gN\u0003\u0002,1\u00051\u0011m\u0019;peNL!!\f\u0015\u00039\u0005\u001bGo\u001c:FqR,gn]5p]\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0006g24GG\u001b\u0006\u0002g\u0005AqM]5{u2,G-\u0003\u00026a\t9Aj\\4hS:<\u0017\u0001C3wK:$()^:\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\r\u00154XM\u001c;t\u0015\ti\u0004$\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u007fi\u0012\u0001\"\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016,\u0012a\u0011\t\u0003\t\u0016k\u0011AK\u0005\u0003\r*\u00121CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fAC]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0004;bg.\u0014V\r]8tSR|'/_\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\u0011Q\nG\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA(M\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM+fk\u0016\t\u0003)\u0002i\u0011\u0001\u0006\u0005\u0006m\u001d\u0001\r\u0001\u000f\u0005\u0006\u0003\u001e\u0001\ra\u0011\u0005\u0006\u0011\u001e\u0001\rA\u0013\u0015\u0003\u000fe\u0003\"AW3\u000e\u0003mS!\u0001X/\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002_?\u00069a-Y2u_JL(B\u00011b\u0003\u0015\u0011W-\u00198t\u0015\t\u00117-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0017aA8sO&\u0011am\u0017\u0002\n\u0003V$xn^5sK\u0012\f\u0001B]3hSN$XM\u001d\u000b\u0002SB\u0011\u0011E[\u0005\u0003W\n\u0012A!\u00168ji\"\u0012\u0001\"\u001c\t\u0003]Jl\u0011a\u001c\u0006\u00039BT\u0011!]\u0001\u0006U\u00064\u0018\r_\u0005\u0003g>\u0014Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\u0018AC;oe\u0016<\u0017n\u001d;fe\"\u0012\u0011B\u001e\t\u0003]^L!\u0001_8\u0003\u0015A\u0013X\rR3tiJ|\u00170A\tp]\nc\u0017mY6pkR,\u0006\u000fZ1uK\u0012$\"![>\t\u000bqT\u0001\u0019A?\u0002\u000b\u00154XM\u001c;\u0011\u0005er\u0018BA@;\u0005Q\u0011E.Y2l_V$X\u000b\u001d3bi\u0016$WI^3oi\"\u001a!\"a\u0001\u0011\t\u0005\u0015\u0011\u0011C\u0007\u0003\u0003\u000fQ1\u0001XA\u0005\u0015\u0011\tY!!\u0004\u0002\u000f5,GO]5dg*\u0019\u0011q\u0002\u000f\u0002\u0011\r|G-\u00195bY\u0016LA!a\u0005\u0002\b\t)A+[7fI\"\u001a!\"a\u0006\u0011\t\u0005e\u0011QD\u0007\u0003\u00037Q!a\u000f\r\n\t\u0005}\u00111\u0004\u0002\n'V\u00147o\u0019:jE\u0016\f\u0011c\u001c8CY\u0006\u001c7n\\;u\t\u0016dW\r^3e)\rI\u0017Q\u0005\u0005\u0007y.\u0001\r!a\n\u0011\u0007e\nI#C\u0002\u0002,i\u0012AC\u00117bG.|W\u000f\u001e#fY\u0016$X\rZ#wK:$\bfA\u0006\u0002\u0004!\u001a1\"a\u0006\u0002!%\u001c\u0018I\u001a4fGRLgn\u001a+bg.\u001cHCBA\u001b\u0003w\ti\u0004E\u0002\"\u0003oI1!!\u000f#\u0005\u001d\u0011un\u001c7fC:DQ\u0001 \u0007A\u0002uDq!a\u0010\r\u0001\u0004\t\t%A\u0002o_^\u0004B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003vi&d'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013Q\t\u0002\u0005\t\u0006$X-\u0001\ntG\",G-\u001e7f)\u0006\u001c8.\u00169eCR,G#B5\u0002V\u0005=\u0004bBA,\u001b\u0001\u0007\u0011\u0011L\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005m\u0013\u0011\u000e\b\u0005\u0003;\n)\u0007E\u0002\u0002`\tj!!!\u0019\u000b\u0007\u0005\rd$\u0001\u0004=e>|GOP\u0005\u0004\u0003O\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002l\u00055$AB*ue&twMC\u0002\u0002h\tBq!!\u001d\u000e\u0001\u0004\t\u0019(A\u0004d_6l\u0017M\u001c3\u0011\t\u0005U\u00141\u0012\b\u0005\u0003o\n9I\u0004\u0003\u0002z\u0005\u0015e\u0002BA>\u0003\u0007sA!! \u0002\u0002:!\u0011qLA@\u0013\u0005i\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002,1%\u0019\u0011\u0011\u0012\u0016\u0002;I+G.Z1tK\u0016CXmY;uS>t\u0017i\u0019;pe6+7o]1hKNLA!!$\u0002\u0010\n\u0001R\t\u001f;f]NLwN\\\"p[6\fg\u000e\u001a\u0006\u0004\u0003\u0013S\u0013AC4fi\"\u000bg\u000e\u001a7feRA\u0011QSAZ\u0003\u007f\u000bI\r\u0005\u0003\u0002\u0018\u00065f\u0002BAM\u0003OsA!a'\u0002\":!\u0011qLAO\u0013\t\ty*\u0001\u0003bW.\f\u0017\u0002BAR\u0003K\u000bQ!Y2u_JT!!a(\n\t\u0005%\u00161V\u0001\u0006\u0003\u000e$xN\u001d\u0006\u0005\u0003G\u000b)+\u0003\u0003\u00020\u0006E&a\u0002*fG\u0016Lg/\u001a\u0006\u0005\u0003S\u000bY\u000bC\u0004\u00026:\u0001\r!a.\u0002\tM,GN\u001a\t\u0005\u0003s\u000bY,\u0004\u0002\u0002,&!\u0011QXAV\u0005!\t5\r^8s%\u00164\u0007bBAa\u001d\u0001\u0007\u00111Y\u0001\u0007g\u0016tG-\u001a:\u0011\u000b\u0005\n)-a.\n\u0007\u0005\u001d'EA\u0005Gk:\u001cG/[8oa!A\u00111\u001a\b\u0005\u0002\u0004\ti-A\u0004sK2,\u0017m]3\u0011\u000b\u0005\ny-a5\n\u0007\u0005E'E\u0001\u0005=Eft\u0017-\\3?!\u0011\t).a6\u000e\u0003qJ1!!7=\u0005\u001d\u0011V\r\\3bg\u0016\fa\"\u001e9eCR,G+Y:l/&$\b\u000e\u0006\u0003\u0002`\u0006EHcA5\u0002b\"9\u00111]\bA\u0002\u0005\u0015\u0018aB;qI\u0006$XM\u001d\t\u0007C\u0005\u001d\u00181^5\n\u0007\u0005%(EA\u0005Gk:\u001cG/[8ocA!\u0011Q[Aw\u0013\r\ty\u000f\u0010\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0002X=\u0001\r!!\u0017\u00021U\u0004H-\u0019;f'\u000eDW\rZ;mK\u0012\u001cF/\u0019:u\t\u0006$X\rF\u0003j\u0003o\fY\u0010C\u0004\u0002zB\u0001\r!a;\u0002\tQ\f7o\u001b\u0005\b\u0003{\u0004\u0002\u0019AA!\u0003UqWm^*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016\fqC]3tKR\u001c6\r[3ek2,Gm\u0015;beR$\u0015\r^3\u0015\u0007%\u0014\u0019\u0001C\u0004\u0002zF\u0001\r!a;\u0002\u0011M,\b\u000f]8siN$B!!\u000e\u0003\n!9!1\u0002\nA\u0002\t5\u0011!B2mCjT\b\u0007\u0002B\b\u00053\u0001b!a\u0017\u0003\u0012\tU\u0011\u0002\u0002B\n\u0003[\u0012Qa\u00117bgN\u0004BAa\u0006\u0003\u001a1\u0001A\u0001\u0004B\u000e\u0005\u0013\t\t\u0011!A\u0003\u0002\tu!aA0%cE!!q\u0004B\u0013!\r\t#\u0011E\u0005\u0004\u0005G\u0011#a\u0002(pi\"Lgn\u001a\t\u0005\u0003s\u00139#\u0003\u0003\u0003*\u0005-&!B!di>\u0014\bf\u0001\u0001\u0003.A!!q\u0006B\u001b\u001b\t\u0011\tDC\u0002\u00034\u0005\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119D!\r\u0003\u000fM+'O^5dK\u0002")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        block0: {
            Date now = new Date();
            if (!this.isAffectingTasks(event, now)) break block0;
            Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(46).append(taskIds.length()).append(" taskIds to be updated after blackout ").append(event.original().getLabel()).append(" update.").toString());
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlackoutPeriod[]{new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate())})));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
        }
    }

    @Subscribe
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append(taskIds.length()).append(" taskIds to be started after blackout ").append(event.blackout().getLabel()).append(" removal.").toString());
        taskIds.foreach((Function1 & Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, Function0<Release> release) {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate ? true : object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(69).append("Updating task '").append(task.getId()).append("' scheduled start date due to new blackout end date '").append(newScheduledStartDate).append("'").toString());
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(84).append("Resetting task '").append(task.getId()).append("' scheduled start date due to blackout not being applicable anymore.").toString());
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    @Autowired
    public BlackoutTaskEventHandler(EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

