/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.exception.PortAlreadyInUseException;
import com.xebialabs.xlrelease.server.jetty.ReleaseJettyServerCustomizer;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Marker;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y4AAC\u0006\u0001-!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\u0001(\t\u000bM\u0003A\u0011\t+\t\u000bu\u0003A\u0011\u00020\t\u000b)\u0004A\u0011B6\t\u000b1\u0004A\u0011B7\u0003\u0017)+G\u000f^=TKJ4XM\u001d\u0006\u0003\u00195\tQA[3uifT!AD\b\u0002\rM,'O^3s\u0015\t\u0001\u0012#A\u0005yYJ,G.Z1tK*\u0011!cE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0005\u0001]y2\u0007\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\r\u0001#\u0006L\u0007\u0002C)\u0011aB\t\u0006\u0003G\u0011\n1a^3c\u0015\t)c%\u0001\u0003c_>$(BA\u0014)\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u0015\u0002\u0007=\u0014x-\u0003\u0002,C\tQr+\u001a2TKJ4XM\u001d$bGR|'/_\"vgR|W.\u001b>feB\u0011Q&M\u0007\u0002])\u0011Ab\f\u0006\u0003a\t\n\u0001\"Z7cK\u0012$W\rZ\u0005\u0003e9\u0012ADS3uif\u001cVM\u001d<mKR<VMY*feZ,'OR1di>\u0014\u0018\u0010\u0005\u00025s5\tQG\u0003\u00027o\u0005)1\u000f\u001c45U*\t\u0001(\u0001\u0005he&T(\u0010\\3e\u0013\tQTGA\u0004M_\u001e<\u0017N\\4\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001Q\t\u0002\u0011\u0011,\u0007\u000f\\8zSRL!AQ \u0003'M+'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u0003%AHN]\"p]\u001aLw-F\u0001G!\t9%*D\u0001I\u0015\tIu\"\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0017\"\u0013\u0011\u0002\u00177s\u0007>tg-[4\u0002\u0015ad'oQ8oM&<\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u001fF\u0013\u0006C\u0001)\u0001\u001b\u0005Y\u0001\"B\u001e\u0006\u0001\u0004i\u0004\"\u0002#\u0006\u0001\u00041\u0015!C2vgR|W.\u001b>f)\t)6\f\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0003V]&$\b\"\u0002/\u0007\u0001\u0004a\u0013a\u00024bGR|'/_\u0001\u0010EVLG\u000e\u001a+ie\u0016\fG\rU8pYV\tq\f\u0005\u0002aQ6\t\u0011M\u0003\u0002cG\u00061A\u000f\u001b:fC\u0012T!\u0001Z3\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0019\u0019T!a\u001a\u0015\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011\u0011.\u0019\u0002\u0011#V,W/\u001a3UQJ,\u0017\r\u001a)p_2\f!c\u00195fG.\u0004vN\u001d;Bm\u0006LG.\u00192mKR\tQ+A\bjgB{'\u000f^!wC&d\u0017M\u00197f)\rq\u0017O\u001e\t\u0003->L!\u0001],\u0003\u000f\t{w\u000e\\3b]\")!/\u0003a\u0001g\u0006!\u0001o\u001c:u!\t1F/\u0003\u0002v/\n\u0019\u0011J\u001c;\t\u000b]L\u0001\u0019\u0001=\u0002\u000f\u0005$GM]3tgB\u0011\u0011\u0010`\u0007\u0002u*\u00111pG\u0001\u0004]\u0016$\u0018BA?{\u0005-Ie.\u001a;BI\u0012\u0014Xm]:")
public class JettyServer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Logging {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JettyServer jettyServer = this;
        synchronized (jettyServer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public void customize(JettyServletWebServerFactory factory) {
        int port = this.serverConfiguration().getHttpPort();
        String webContextRoot = this.serverConfiguration().getWebContextRoot();
        this.checkPortAvailable();
        if (!"/".equals(webContextRoot)) {
            factory.setContextPath(webContextRoot);
        }
        factory.setPort(port);
        factory.setThreadPool((ThreadPool)this.buildThreadPool());
        factory.addServerCustomizers(new JettyServerCustomizer[]{ReleaseJettyServerCustomizer.create(this.serverConfiguration(), this.xlrConfig())});
    }

    private QueuedThreadPool buildThreadPool() {
        int maxThreads = this.serverConfiguration().getMaxThreads();
        int minThreads = this.serverConfiguration().getMinThreads();
        return new QueuedThreadPool(maxThreads, minThreads);
    }

    private void checkPortAvailable() {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(this.serverConfiguration().getHttpBindAddress());
        }
        catch (UnknownHostException ex) {
            String message = new StringBuilder(47).append("Cannot start ").append("XL Release").append("; invalid bind address: ").append(this.serverConfiguration().getHttpBindAddress()).toString();
            this.logger().error((Function0 & Serializable)() -> message);
            throw ex;
        }
        if (!this.isPortAvailable(this.serverConfiguration().getHttpPort(), address)) {
            String message = new StringBuilder(46).append("Cannot start ").append("XL Release").append("; port ").append(this.serverConfiguration().getHttpPort()).append(" already in use.").toString();
            this.logger().error((Function0 & Serializable)() -> message);
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(50).append("Perhaps another instance of ").append("XL Release").append(" is running.").toString());
            throw new PortAlreadyInUseException(message);
        }
    }

    private boolean isPortAvailable(int port, InetAddress address) {
        try {
            ServerSocket socket = new ServerSocket(port, 1, address);
            socket.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public JettyServer(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        Logging.$init$((Logging)this);
    }
}

