/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.scheduler;

import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.script.CustomScriptTaskResult;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.FacetCheckResult;
import com.xebialabs.xlrelease.script.FailureHandlerResult;
import com.xebialabs.xlrelease.script.PreconditionResult;
import com.xebialabs.xlrelease.script.ScriptTaskResult;
import com.xebialabs.xlrelease.user.User;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class FutureTaskAdapter<U>
implements Callable<U> {
    public static final Logger logger = LoggerFactory.getLogger(FutureTaskAdapter.class);
    private Callable<U> command;
    private Scheduler scheduler;
    private CompletableFuture<U> completableFuture = new CompletableFuture();
    private AtomicBoolean cancelledExternallyOrStarted = new AtomicBoolean(false);
    private volatile ScheduledFuture<U> scheduledFuture;

    protected FutureTaskAdapter(Callable<U> command) {
        this.command = command;
    }

    @Override
    public U call() throws Exception {
        this.backpressureWait();
        if (!this.cancelledExternallyOrStarted.compareAndExchange(false, true)) {
            logger.debug("Starting {}", (Object)this);
            try {
                U result = this.command.call();
                logger.debug("Successfully completed {}", (Object)this);
                this.completableFuture.complete(result);
                U u = result;
                return u;
            }
            catch (RejectedExecutionException e) {
                logger.debug("{} rejected", (Object)this, (Object)e);
                this.scheduler.handleFailureFuture(this.onReject(), this);
                this.completableFuture.completeExceptionally(e);
                throw e;
            }
            catch (InterruptedException e) {
                logger.debug("{} interrupted", (Object)this, (Object)e);
                this.scheduler.handleFailureFuture(this.onInterrupt(), this);
                Thread.currentThread().interrupt();
                this.completableFuture.completeExceptionally(e);
                throw e;
            }
            catch (Exception e) {
                logger.debug("{} caused exception", (Object)this, (Object)e);
                this.scheduler.handleFailureFuture(this.onExecutionException(), this);
                this.completableFuture.completeExceptionally(e);
                throw e;
            }
            finally {
                this.scheduler.onTaskCompleted(this);
            }
        }
        logger.info("Task {} did not run because it was cancelled due to shutdown", (Object)this);
        throw new IllegalStateException(String.format("Task %s was cancelled", this.toString()));
    }

    protected abstract void backpressureWait();

    public FutureTaskAdapter<U> setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public CompletableFuture<U> getCompletableFuture() {
        return this.completableFuture;
    }

    public void cancelExternally() {
        if (!this.cancelledExternallyOrStarted.compareAndExchange(false, true)) {
            logger.info("Successfully cancelled task {} that has not been started yet", (Object)this);
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduler.handleFailureFuture(this.onCancel(), this);
        } else {
            logger.info("Unable to cancel task {} because it has already been started", (Object)this);
        }
    }

    public ScheduledFuture<U> bind(ScheduledFuture<U> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
        return scheduledFuture;
    }

    protected abstract Future<Object> onCancel();

    protected abstract Future<Object> onReject();

    protected abstract Future<Object> onInterrupt();

    protected abstract Future<Object> onExecutionException();

    public static FutureTaskAdapter<ScriptTaskResult> ofScriptTask(String taskId, ReleaseActorService releaseActorService, String executionId, Callable<ScriptTaskResult> command) {
        return new DefaultFutureTaskAdapter<ScriptTaskResult>("ofScriptTask: " + taskId, command, taskId, releaseActorService, "Script task", TaskStatus.QUEUED, executionId);
    }

    public static FutureTaskAdapter<Void> ofCreateReleaseTask(String taskId, ReleaseActorService releaseActorService, String executionId, Callable<Void> command) {
        return new DefaultFutureTaskAdapter<Void>("ofCreateReleaseTask: " + taskId, command, taskId, releaseActorService, "Create Release task", TaskStatus.QUEUED, executionId);
    }

    public static FutureTaskAdapter<Void> ofNotificationTask(String taskId, ReleaseActorService releaseActorService, String executionId, Callable<Void> command) {
        return new DefaultFutureTaskAdapter<Void>("ofNotificationTask: " + taskId, command, taskId, releaseActorService, "Notification task", TaskStatus.QUEUED, executionId);
    }

    public static FutureTaskAdapter<CustomScriptTaskResult> ofCustomScriptTask(String taskId, boolean isAbortScriptInProgress, ReleaseActorService releaseActorService, String executionId, Callable<CustomScriptTaskResult> command) {
        TaskStatus statusIfCancelled = isAbortScriptInProgress ? TaskStatus.ABORT_SCRIPT_QUEUED : TaskStatus.QUEUED;
        return new DefaultFutureTaskAdapter<CustomScriptTaskResult>("ofCustomScriptTask: " + taskId, command, taskId, releaseActorService, "Custom Script task", statusIfCancelled, executionId);
    }

    public static FutureTaskAdapter<PreconditionResult> ofPrecondition(String taskId, ReleaseActorService releaseActorService, String executionId, Callable<PreconditionResult> command) {
        return new DefaultFutureTaskAdapter<PreconditionResult>("ofPrecondition: " + taskId, command, taskId, releaseActorService, "Precondition", TaskStatus.QUEUED, executionId);
    }

    public static FutureTaskAdapter<FacetCheckResult> ofFacetCheck(String taskId, ReleaseActorService releaseActorService, String executionId, Callable<FacetCheckResult> command) {
        return new DefaultFutureTaskAdapter<FacetCheckResult>("ofFacetCheck: " + taskId, command, taskId, releaseActorService, "Check", TaskStatus.QUEUED, executionId);
    }

    public static FutureTaskAdapter<FailureHandlerResult> ofFailureHandler(String taskId, ReleaseActorService releaseActorService, String executionId, Callable<FailureHandlerResult> command) {
        return new DefaultFutureTaskAdapter<FailureHandlerResult>("ofFailureHandler: " + taskId, command, taskId, releaseActorService, "Failure handler", TaskStatus.FAILURE_HANDLER_QUEUED, executionId);
    }

    public static FutureTaskAdapter<Void> ofResumeQueuedTaskOperation(String taskId, TaskStatus queuedStatus, ReleaseActorService releaseActorService, String executionId) {
        return new DefaultFutureTaskAdapter<Void>("ofResumeQueuedTaskOperation: " + taskId, () -> {
            releaseActorService.resumeQueuedTask(taskId, executionId);
            return null;
        }, taskId, releaseActorService, "ResumeQueuedTask operation", queuedStatus, executionId);
    }

    public static class DefaultFutureTaskAdapter<U>
    extends FutureTaskAdapter<U> {
        private final String description;
        private final String taskId;
        private final ReleaseActorService releaseActorService;
        private final String displayName;
        private final TaskStatus statusIfCancelled;
        private final String executionId;

        protected DefaultFutureTaskAdapter(String description, Callable<U> command, String taskId, ReleaseActorService releaseActorService, String displayName, TaskStatus statusIfCancelled, String executionId) {
            super(command);
            this.description = description;
            this.taskId = taskId;
            this.releaseActorService = releaseActorService;
            this.displayName = displayName;
            this.statusIfCancelled = statusIfCancelled;
            this.executionId = executionId;
        }

        @Override
        protected Future<Object> onCancel() {
            return this.releaseActorService.queueTaskFutureWithRetry(this.taskId, this.statusIfCancelled, this.executionId);
        }

        @Override
        protected Future<Object> onReject() {
            return this.releaseActorService.queueTaskFutureWithRetry(this.taskId, this.statusIfCancelled, this.executionId);
        }

        @Override
        protected Future<Object> onInterrupt() {
            return this.releaseActorService.failTaskFuture(this.taskId, String.format("%s interrupted", this.displayName), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.apply(null));
        }

        @Override
        protected Future<Object> onExecutionException() {
            return this.releaseActorService.failTaskFuture(this.taskId, String.format("%s failed", this.displayName), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.apply(null));
        }

        @Override
        protected void backpressureWait() {
            logger.debug("Backpressure wait {}", (Object)this);
            this.releaseActorService.backpressureWait(this.taskId);
        }

        public String toString() {
            return this.description;
        }
    }
}

