/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.xebialabs.xlrelease.actors.package$;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.utils.ReleaseSoftReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;

public final class ReleaseActorCache$
implements Logging {
    public static ReleaseActorCache$ MODULE$;
    private boolean cacheEnabled;
    private Cache<String, ReleaseSoftReference> cache;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    static {
        new ReleaseActorCache$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseActorCache$ releaseActorCache$ = this;
        synchronized (releaseActorCache$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean cacheEnabled$lzycompute() {
        ReleaseActorCache$ releaseActorCache$ = this;
        synchronized (releaseActorCache$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.cacheEnabled = XlrConfig$.MODULE$.getInstance().features().releaseActors().releaseCacheEnabled();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.cacheEnabled;
    }

    private boolean cacheEnabled() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.cacheEnabled$lzycompute() : this.cacheEnabled;
    }

    private Cache<String, ReleaseSoftReference> cache$lzycompute() {
        ReleaseActorCache$ releaseActorCache$ = this;
        synchronized (releaseActorCache$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cache = Caffeine.newBuilder().initialCapacity(2000).maximumSize(3000L).expireAfterAccess(5L, TimeUnit.MINUTES).recordStats().build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cache;
    }

    private Cache<String, ReleaseSoftReference> cache() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cache$lzycompute() : this.cache;
    }

    public Release get(String id, Supplier<Release> supplier) {
        Object object;
        if (this.cacheEnabled()) {
            String shortId = package$.MODULE$.releaseId2ActorName(id);
            ReleaseSoftReference ref = (ReleaseSoftReference)this.cache().get((Object)shortId, x$1 -> {
                Release release = (Release)supplier.get();
                MODULE$.logger().debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(5).append("miss ").append(id).toString());
                return release == null ? null : new ReleaseSoftReference(release, supplier);
            });
            object = ref == null ? null : ref.get();
        } else {
            object = supplier.get();
        }
        return object;
    }

    public Option<Release> getIfPresent(String id) {
        return Option$.MODULE$.apply(this.cache().getIfPresent((Object)id)).flatMap((Function1 & java.io.Serializable & Serializable)ref -> Option$.MODULE$.apply((Object)ref.getIfPresent()));
    }

    public Option<Release> remove(String id) {
        None$ none$;
        if (id != null && this.cacheEnabled()) {
            String shortId = package$.MODULE$.releaseId2ActorName(id);
            Option cachedReleaseRef = Option$.MODULE$.apply(this.cache().getIfPresent((Object)shortId));
            this.cache().invalidate((Object)shortId);
            none$ = cachedReleaseRef.flatMap((Function1 & java.io.Serializable & Serializable)ref -> Option$.MODULE$.apply((Object)ref.get()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private ReleaseActorCache$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

