/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.google.common.base.Strings;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.script.VariablesHolderForScriptContext;
import com.xebialabs.xlrelease.security.UsernamePassword;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationService {
    private AuthenticationManager authenticationManager;
    private UserLastActiveActorService userLastActiveActorService;
    private ThreadLocal<Authentication> authenticationThreadLocal = new ThreadLocal();
    private ThreadLocal<Task> currentScriptTask = new ThreadLocal();
    private ThreadLocal<Release> currentScriptRelease = new ThreadLocal();
    private ThreadLocal<VariablesHolderForScriptContext> currentVariables = new ThreadLocal();

    @Autowired
    public AuthenticationService(AuthenticationManager authenticationManager, UserLastActiveActorService userLastActiveActorService) {
        this.authenticationManager = authenticationManager;
        this.userLastActiveActorService = userLastActiveActorService;
    }

    public UsernamePassword loginScriptUser(Task task) {
        Release release = task.getRelease();
        this.currentScriptTask.set(task);
        return this.loginScriptUser(release);
    }

    public UsernamePassword loginScriptUser(Task task, VariablesHolderForScriptContext variablesHolderForScriptContext) {
        UsernamePassword usernamePass = this.loginScriptUser(task);
        this.currentVariables.set(variablesHolderForScriptContext);
        return usernamePass;
    }

    public UsernamePassword loginScriptUser(Release release) {
        this.currentScriptRelease.set(release);
        String scriptUser = (String)VariableHelper.replaceAll((Object)release.getScriptUsername(), (Map)release.getAllStringVariableValues(), new HashSet(), (boolean)false);
        String scriptUserPassword = this.resolveUserScriptPassword(release);
        this.authenticationThreadLocal.set(SecurityContextHolder.getContext().getAuthentication());
        if (!Strings.isNullOrEmpty((String)scriptUser)) {
            if (Strings.isNullOrEmpty((String)scriptUserPassword)) {
                throw new IllegalArgumentException(String.format("'Password' property has to be set to run automated tasks as '%s'", scriptUser));
            }
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)scriptUser, (Object)scriptUserPassword);
            Authentication authentication = this.authenticationManager.authenticate((Authentication)usernamePasswordAuthenticationToken);
            this.userLastActiveActorService.updateLastActive(scriptUser);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        this.currentVariables.remove();
        return UsernamePassword.apply(scriptUser, scriptUserPassword);
    }

    public void logoutScriptUser() {
        SecurityContextHolder.getContext().setAuthentication(this.authenticationThreadLocal.get());
        this.authenticationThreadLocal.remove();
        this.currentScriptRelease.remove();
        this.currentScriptTask.remove();
        this.currentVariables.remove();
    }

    public boolean isInScriptTask() {
        return this.currentScriptRelease.get() != null;
    }

    public boolean hasScriptTask() {
        return this.currentScriptTask.get() != null;
    }

    @NonNull
    public Task getCurrentScriptTask() {
        if (!this.isInScriptTask()) {
            throw new IllegalStateException("Current authentication context is not a script task");
        }
        if (this.currentScriptTask.get() == null) {
            throw new IllegalStateException("Script task not available in this context");
        }
        return this.currentScriptTask.get();
    }

    @NonNull
    public Release getCurrentScriptRelease() {
        if (!this.isInScriptTask()) {
            throw new IllegalStateException("Current authentication context is not a script task");
        }
        return this.currentScriptRelease.get();
    }

    public boolean hasVariablesHolderForScriptContext() {
        return this.currentVariables.get() != null;
    }

    @NonNull
    public VariablesHolderForScriptContext getCurrentVariablesHolderForScriptContext() {
        if (!this.hasVariablesHolderForScriptContext()) {
            throw new IllegalStateException("Current VariablesHolderForScriptContext is null");
        }
        return this.currentVariables.get();
    }

    private String resolveUserScriptPassword(Release release) {
        Map passwordVariables = release.getPasswordVariableValues();
        passwordVariables.forEach((key, value) -> {
            String decryptedValue = PasswordEncrypter.getInstance().ensureDecrypted(value);
            passwordVariables.put(key, decryptedValue);
        });
        if (release.getVariableMapping() != null && release.getVariableMapping().containsKey(Release.SCRIPT_USER_PASSWORD_VARIABLE_MAPPING_KEY)) {
            return (String)VariableHelper.replaceAll(release.getVariableMapping().get(Release.SCRIPT_USER_PASSWORD_VARIABLE_MAPPING_KEY), (Map)passwordVariables, new HashSet(), (boolean)false);
        }
        return PasswordEncrypter.getInstance().ensureDecrypted(release.getScriptUserPassword());
    }
}

