/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.FutureTaskAdapter;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator;
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ExecuteRecoverAction;
import com.xebialabs.xlrelease.script.ExecuteRecoverCallback;
import com.xebialabs.xlrelease.script.FailureHandlerResult;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.service.ChangeExecutionService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.ExecutionServiceVisitor;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.PostActionVisitor;
import com.xebialabs.xlrelease.service.ScriptResultsService;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.OptionallyDecoratedReleaseSupplier;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Option;

@Service
public class ExecutionService
implements ExecutionServiceVisitor,
ExecuteRecoverCallback {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionService.class);
    private ReleaseRepository releaseRepository;
    private TaskRepository taskRepository;
    private DependencyService dependencyService;
    private ScriptLifeCycle scriptLifeCycle;
    private TaskBackup taskBackup;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private TeamService teamService;
    private ChangeExecutionService changeExecutionService;
    private ScriptResultsService scriptResultsService;
    private Scheduler scheduler;
    private PhaseService phaseService;
    private Map<String, ScriptService> scriptServices = new HashMap<String, ScriptService>();
    private Map<Class<? extends Task>, TaskExecutor<? extends Task>> taskExecutorsPerType = new HashMap<Class<? extends Task>, TaskExecutor<? extends Task>>();
    private InternalMetadataDecoratorService decoratorService;
    private ServerConfiguration serverConfiguration;
    private volatile boolean preparingForShutdown = false;

    @Autowired
    public ExecutionService(ReleaseRepository releaseRepository, TaskRepository taskRepository, DependencyService dependencyService, ScriptLifeCycle scriptLifeCycle, TaskBackup taskBackup, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, List<? extends TaskExecutor<? extends Task>> taskExecutors, Collection<? extends ScriptService> scriptServices, InternalMetadataDecoratorService decoratorService, TeamService teamService, ChangeExecutionService changeExecutionService, ServerConfiguration serverConfiguration, ScriptResultsService scriptResultsService, Scheduler scheduler, PhaseService phaseService) {
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.dependencyService = dependencyService;
        this.scriptLifeCycle = scriptLifeCycle;
        this.taskBackup = taskBackup;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.decoratorService = decoratorService;
        this.teamService = teamService;
        this.changeExecutionService = changeExecutionService;
        this.serverConfiguration = serverConfiguration;
        this.scriptResultsService = scriptResultsService;
        this.scheduler = scheduler;
        this.phaseService = phaseService;
        this.setTaskExecutors(taskExecutors);
        scriptServices.forEach(scriptService -> this.scriptServices.put(scriptService.engine(), (ScriptService)scriptService));
    }

    private void setTaskExecutors(List<? extends TaskExecutor<? extends Task>> taskExecutors) {
        taskExecutors.forEach(executor -> {
            Class taskType = executor.getTaskClass();
            if (this.taskExecutorsPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two executors are registered for the same task type %s: %s and %s", taskType, this.taskExecutorsPerType.get(taskType), executor));
            }
            this.taskExecutorsPerType.put(taskType, (TaskExecutor<? extends Task>)executor);
        });
    }

    @Timed
    public Release start(Release release, User user) {
        this.decorateWithMetadata(release);
        Changes changes = release.start();
        this.processChangesAndPublishOperations(changes, user);
        return release;
    }

    @Timed
    public Release start(Release release, User user, boolean releaseStartedImmediatelyAfterBeingCreated, boolean isPartOfBulkOperation) {
        if (release.hasBeenStarted()) {
            logger.info("Will not start release, because it is already started, probably due to duplicate message delivery {}", (Object)release.getId());
            return release;
        }
        this.decorateWithMetadata(release);
        Changes changes = isPartOfBulkOperation ? release.startAsPartOfBulkOperation() : release.start(releaseStartedImmediatelyAfterBeingCreated);
        this.processChangesAndPublishOperations(changes, user);
        return release;
    }

    @Timed
    public Release abort(String releaseId, String abortComment, boolean isPartOfBulkOperation) {
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkState((boolean)release.hasNoAutomatedTaskRunning(), (String)"The release %s could not be aborted because it has automated tasks that are in progress.", (Object)release.getTitle());
        Preconditions.checkState((release.getStatus() != ReleaseStatus.COMPLETED ? 1 : 0) != 0, (String)"You can not abort completed release.", (Object)release.getTitle());
        this.teamService.decorateWithStoredTeams(release);
        this.decorateWithMetadata(release);
        Changes changes = isPartOfBulkOperation ? release.abortAsPartOfBulkOperation(abortComment) : release.abort(abortComment);
        this.publishBeforeEvents(changes);
        this.applyChanges(changes, User.AUTHENTICATED_USER);
        this.publishAfterEvents(changes);
        this.failDependentGates(changes, release.getTitle());
        return release;
    }

    @Timed
    public Release resume(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkState((boolean)release.isPaused(), (String)"Only paused releases may be restarted. Release '%s' is %s.", (Object)release.getTitle(), (Object)release.getStatus());
        this.decorateWithMetadata(release);
        Changes changes = release.resume();
        this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
        return release;
    }

    @Timed
    public void startPendingTask(String taskId, Release release, String comment, User user) {
        boolean shouldConsiderBlackoutPeriods = User.SYSTEM.equals((Object)user);
        if (shouldConsiderBlackoutPeriods) {
            this.decorateWithMetadata(release);
        }
        Changes changes = release.startPendingTask(taskId);
        changes.addComment(release.getTask(taskId), comment);
        this.processChangesAndPublishOperations(changes, user);
    }

    @VisibleForTesting
    void executePostActions(Changes changes) {
        changes.getPostActions().forEach(action -> action.accept((PostActionVisitor)this));
    }

    private void publishBeforeEvents(Changes changes) {
        XLReleaseOperations.runActionInterceptors(changes.getOperations(), this.eventBus);
    }

    private void publishAfterEvents(Changes changes) {
        XLReleaseOperations.publishEvents(changes.getOperations(), this.eventBus);
    }

    @Timed
    public void finishCustomScriptTask(Release release, String taskId, String comment, String executionId, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults) {
        CustomScriptTask task = (CustomScriptTask)release.getTask(taskId);
        Changes changes = new Changes();
        if (task.isStillExecutingScript(executionId)) {
            scriptResults.ifPresent(s -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults((Task)task, (DefaultScriptService.BaseScriptTaskResults)s)));
            if (task.isWaitingForSignal()) {
                logger.info("Will not complete task: '{}', staying in progress until task condition is met.", (Object)taskId);
            } else if (task.isAbortScriptInProgress()) {
                this.fail(changes, (Task)task, "Abort script finished.", logArtifactId, Optional.empty(), User.SYSTEM, false);
            } else {
                this.markTaskAsDone(changes, release, TaskStatus.COMPLETED, taskId, comment, logArtifactId, Optional.empty(), User.LOG_OUTPUT);
            }
        } else {
            logger.debug("Will not complete task: '{}', it has been aborted.", (Object)taskId);
        }
    }

    @Timed
    public void finishScriptTask(Release release, String taskId, String comment, String executionId, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults) {
        Task task = release.getTask(taskId);
        Changes changes = new Changes();
        if (task.isStillExecutingScript(executionId)) {
            scriptResults.ifPresent(sr -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults(task, (DefaultScriptService.BaseScriptTaskResults)sr)));
            this.markTaskAsDone(changes, release, TaskStatus.COMPLETED, taskId, comment, logArtifactId, Optional.empty(), User.LOG_OUTPUT);
        } else {
            logger.debug("Will not complete task: '{}', executionId does not match, it has been aborted.", (Object)taskId);
        }
    }

    private void markTaskAsDone(Changes changes, Release release, TaskStatus targetStatus, String taskId, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user) {
        this.decorateWithMetadata(release);
        Task task = release.getTask(taskId);
        scriptResults.ifPresent(baseScriptTaskResults -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults(task, (DefaultScriptService.BaseScriptTaskResults)baseScriptTaskResults)));
        if (User.LOG_OUTPUT.equals((Object)user)) {
            this.attachScriptOutput(changes, task, addedComment, logArtifactId);
        } else {
            changes.addComment(task, addedComment);
        }
        if (targetStatus.isDoneInAdvance()) {
            changes.addAll(task.markAsDone(taskId, targetStatus));
        } else {
            changes.addAll(release.markTaskAsDone(taskId, targetStatus));
        }
        this.processChangesAndPublishOperations(changes, user);
    }

    @Timed
    public boolean markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user, String executionId) {
        Task task = release.getTask(taskId);
        if (task.isStillExecutingScript(executionId)) {
            this.markTaskAsDone(release, targetStatus, taskId, addedComment, logArtifactId, scriptResults, user);
        } else {
            logger.info("Skipping duplicate message MarkTaskAsDone for {}", (Object)taskId);
        }
        return true;
    }

    @Timed
    public void markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user) {
        this.markTaskAsDone(new Changes(), release, targetStatus, taskId, addedComment, logArtifactId, scriptResults, user);
    }

    @Timed
    public void skipTaskDueToPreconditionCheck(Release release, String taskId, String executionId, String executionLog) {
        Task task = release.getTask(taskId);
        if (task.isStillExecutingScript(executionId)) {
            this.markTaskAsDone(release, TaskStatus.SKIPPED, taskId, executionLog, User.LOG_OUTPUT);
        } else {
            logger.info("Will not skip task due to precondition check because executionId does not match: {}", (Object)taskId);
        }
    }

    @Timed
    public void markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, User user) {
        this.markTaskAsDone(release, targetStatus, taskId, addedComment, Optional.empty(), Optional.empty(), user);
    }

    @Timed
    public void scriptFailed(String taskId, String scriptFailMessage, String scriptExecutionId, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user) {
        Object task = this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
        Changes changes = new Changes();
        if (task.isStillExecutingScript(scriptExecutionId)) {
            scriptResults.ifPresent(s -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults((Task)task, (DefaultScriptService.BaseScriptTaskResults)s)));
            this.fail(changes, (Task)task, FailureReasons.SCRIPT_TASK_FAILED.format(new Object[]{scriptFailMessage}), logArtifactId, Optional.empty(), user, false);
        } else {
            logger.debug("Will not fail task: '{}', it has been aborted, task status is {} and task executionId is {} and expected executionId is {}", new Object[]{task.getId(), task.getStatus(), task.getExecutionId(), scriptExecutionId});
            this.attachScriptOutput(changes, (Task)task, scriptFailMessage, logArtifactId);
            this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
        }
    }

    @Timed
    public void fail(Task task, String addedComment, Optional<DefaultScriptService.BaseScriptTaskResults> baseScriptTaskResults, User user, Optional<String> executionId) {
        if (executionId.isPresent() && !task.isStillExecutingScript(executionId.get())) {
            logger.info("Skipping duplicate FailTask message");
            return;
        }
        this.fail(new Changes(), task, addedComment, Optional.empty(), baseScriptTaskResults, user, false);
    }

    @Timed
    public void fail(Task task, String addedComment, User user) {
        this.fail(new Changes(), task, addedComment, Optional.empty(), Optional.empty(), user, false);
    }

    private void fail(Changes changes, Task task, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> baseScriptTaskResults, User user, boolean fromAbort) {
        Release release = task.getRelease();
        baseScriptTaskResults.ifPresent(s -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults(task, (DefaultScriptService.BaseScriptTaskResults)s)));
        if (User.LOG_OUTPUT.equals((Object)user)) {
            changes.addAll(release.failTask(task.getId(), "", fromAbort));
            this.attachScriptOutput(changes, task, addedComment, logArtifactId);
        } else {
            changes.addAll(release.failTask(task.getId(), addedComment, user, fromAbort));
        }
        this.publishBeforeEvents(changes);
        this.processChanges(changes, user);
        this.publishAfterEvents(changes);
        if (release.isAbortOnFailure() && release.isAborted()) {
            this.failDependentGates(changes, release.getTitle());
        }
    }

    @Timed
    public void retry(Task task, String addedComment) {
        Release release = task.getRelease();
        this.decorateWithMetadata(release);
        Changes changes = release.retryTask(task.getId());
        changes.addComment(task, addedComment);
        this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
    }

    @Timed
    public Task startWithInput(String taskId, List<Variable> variables) {
        Object task = this.taskRepository.findById(taskId);
        Task updated = this.updateVariables(variables, (Task)task);
        Release release = updated.getRelease();
        this.decorateWithMetadata(release);
        this.processChangesAndPublishOperations(release.startWithInput(taskId), User.AUTHENTICATED_USER);
        return task;
    }

    @Timed
    public void queueTask(OptionallyDecoratedReleaseSupplier releaseSupplier, String taskId, TaskStatus targetStatus, String executionId) {
        if (this.preparingForShutdown) {
            Release nonDecoratedRelease = releaseSupplier.getNonDecorated();
            Task task = nonDecoratedRelease.getTask(taskId);
            if (task.isStillExecutingScript(executionId)) {
                Changes changes = nonDecoratedRelease.queueTask(taskId, targetStatus);
                this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
            } else {
                logger.info("Skipping duplicate QueueTask message {}", (Object)taskId);
            }
        } else {
            Release decoratedRelease = releaseSupplier.getDecorated();
            Task task = decoratedRelease.getTask(taskId);
            if (task.isStillExecutingScript(executionId)) {
                logger.info("Ignoring QueueTask because we are not shutting down {}", (Object)taskId);
                this.resumeQueuedTask(taskId, decoratedRelease, executionId);
            } else {
                logger.info("Skipping duplicate QueueTask message {}", (Object)taskId);
            }
        }
    }

    private Task updateVariables(List<Variable> variables, Task task) {
        Map inputVariablesByKey = VariableHelper.indexByKey(variables);
        task.getInputVariables().stream().filter(variable -> inputVariablesByKey.containsKey(variable.getKey())).forEach(variable -> variable.setUntypedValue(((Variable)inputVariablesByKey.get(variable.getKey())).getValue()));
        return this.taskRepository.update(task);
    }

    @Timed
    public void abortTask(Task task, String addedComment) {
        this.scriptLifeCycle.tryAborting(task.getExecutionId());
        String comment = FailureReasons.SCRIPT_TASK_ABORTED.format(new Object[]{addedComment});
        if (task.isAbortScriptInProgress()) {
            comment = FailureReasons.ABORT_SCRIPT_TASK_ABORTED.format(new Object[]{addedComment});
        }
        this.fail(new Changes(), task, comment, Optional.empty(), Optional.empty(), User.AUTHENTICATED_USER, true);
    }

    @Timed
    public void reopenTask(Task task, String addedComment) {
        Changes changes = task.reopen();
        changes.addComment(task, addedComment);
        this.publishBeforeEvents(changes);
        this.applyChanges(changes, User.AUTHENTICATED_USER);
        this.publishAfterEvents(changes);
    }

    private void completeDependentGates(Changes changes) {
        Collection<String> completableGateIds = this.dependencyService.getCompletableGateIds(this.toPlanItems(changes.getUpdatedItems()));
        for (String gateId : completableGateIds) {
            this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, gateId, null, User.SYSTEM);
        }
    }

    private void failDependentGates(Changes changes, String releaseTitle) {
        Collection<String> failableGateIds = this.dependencyService.getFailableGateIds(this.toPlanItems(changes.getUpdatedItems()));
        for (String gateId : failableGateIds) {
            this.releaseActorService.failTaskAsync(gateId, FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(new Object[]{releaseTitle}), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    private void attachScriptOutput(Changes changes, Task task, String addedComment, Optional<String> logArtifactId) {
        if (logArtifactId.isPresent()) {
            changes.linkScriptOutputLog(task, logArtifactId.get());
        } else {
            changes.addAttachment(task, addedComment.getBytes(StandardCharsets.UTF_8), new SimpleDateFormat("'script_output_'yyyyMMddHHmmss'.log'").format(new Date()), "text/plain");
        }
    }

    private Set<PlanItem> toPlanItems(Set<ConfigurationItem> updatedItems) {
        return updatedItems.stream().filter(PlanItem.class::isInstance).map(PlanItem.class::cast).collect(Collectors.toSet());
    }

    private void applyChanges(Changes changes, User user) {
        this.changeExecutionService.applyChanges(changes, user);
    }

    @Timed
    public void resumeTask(String taskId) {
        this.executeTask((Task)this.taskRepository.findById(taskId));
    }

    @Timed
    public void resumeQueuedTask(String taskId, Release release, String executionId) {
        if (release.getTask(taskId).isStillExecutingScript(executionId)) {
            Changes changes = release.resumeQueuedTask(taskId);
            this.processChangesAndPublishOperations(changes, User.SYSTEM);
        }
    }

    @Timed
    public void executeTask(Task task) {
        try {
            this.doExecuteTask(task);
        }
        catch (RejectedExecutionException exception) {
            this.queueTask(OptionallyDecoratedReleaseSupplier.ofDecoratedRelease((Release)task.getRelease()), task.getId(), task.isAbortScriptInProgress() ? TaskStatus.ABORT_SCRIPT_QUEUED : TaskStatus.QUEUED, task.getExecutionId());
        }
        catch (Exception exception) {
            String msg = String.format("Unable to schedule task execution. Reason: %s", exception.getMessage());
            this.releaseActorService.failTaskAsync(task.getId(), msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    private <U extends Task> Supplier<U> makeTaskSupplier(String taskId) {
        return () -> this.taskRepository.findById(taskId);
    }

    private void doExecuteTask(Task task) {
        SensitiveValueScrubber scrubber;
        TaskExecutor<? extends Task> taskExecutor = this.taskExecutorsPerType.get(task.getClass());
        Preconditions.checkArgument((taskExecutor != null ? 1 : 0) != 0, (String)"Cannot execute task because there is no executor defined for task type '%s'", (Object)task.getType().toString());
        Release release = task.getRelease();
        if (release == null || !release.isAllowPasswordsInAllFields()) {
            scrubber = SensitiveValueScrubber.disabled();
        } else {
            Map passwordVariables = release.getPasswordVariableValues();
            passwordVariables.forEach((key, value) -> {
                String decryptedValue = PasswordEncrypter.getInstance().ensureDecrypted(value);
                passwordVariables.put(key, decryptedValue);
            });
            Changes changes = new Changes();
            if (task instanceof BaseScriptTask) {
                task.freezeVariablesInCustomFields(passwordVariables, passwordVariables, changes, true);
            }
            scrubber = new SensitiveValueScrubber(changes.getVariablesUsed(), passwordVariables);
        }
        taskExecutor.executeWithSoftReference((TaskSoftReference<? extends Task>)new TaskSoftReference(task, this.makeTaskSupplier(task.getId())), scrubber);
    }

    @Timed
    public void executePrecondition(Task task) {
        try {
            this.scriptServices.get("jython").executePrecondition((TaskSoftReference<Task>)new TaskSoftReference(task, this.makeTaskSupplier(task.getId()))).thenAccept(r -> r.save(this.releaseActorService, this.phaseService));
        }
        catch (RejectedExecutionException exception) {
            this.queueTask(OptionallyDecoratedReleaseSupplier.ofDecoratedRelease((Release)task.getRelease()), task.getId(), TaskStatus.QUEUED, task.getExecutionId());
        }
        catch (Exception exception) {
            String msg = String.format("Unable to schedule precondition check. Reason: %s", exception.getMessage());
            this.releaseActorService.failTaskAsync(task.getId(), msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    @Timed
    public void executeFacetCheck(Task task) {
        try {
            this.scriptServices.get("jython").executeFacetCheck((TaskSoftReference<Task>)new TaskSoftReference(task, this.makeTaskSupplier(task.getId()))).thenAccept(r -> r.save(this.releaseActorService, this.phaseService));
        }
        catch (RejectedExecutionException exception) {
            this.queueTask(OptionallyDecoratedReleaseSupplier.ofDecoratedRelease((Release)task.getRelease()), task.getId(), TaskStatus.QUEUED, task.getExecutionId());
        }
        catch (Exception exception) {
            String msg = String.format("Unable to schedule facet check. Reason: %s", exception.getMessage());
            this.releaseActorService.failTaskAsync(task.getId(), msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    @Timed
    void executeFailureHandler(Task task) {
        long timeout = XlrConfig.getInstance().timeoutSettings().failureHandlerTimeout().toSeconds();
        try {
            this.scriptServices.get("jython").executeFailureHandler((TaskSoftReference<Task>)new TaskSoftReference(task, this.makeTaskSupplier(task.getId())), timeout, TimeUnit.SECONDS).whenComplete((taskResult, error) -> {
                if (error instanceof RejectedExecutionException) {
                    logger.debug("Got RejectedExecutionException when trying to schedule failure handler of task {}, ignoring", (Object)task.getId());
                } else if (error != null && error.getCause() instanceof TimeoutException) {
                    this.scriptLifeCycle.tryAborting(task.getExecutionId());
                    this.releaseActorService.failTaskAsync(task.getId(), String.format("Failure handler of task [%s] with script execution [%s] was terminated due to timeout of [%s] seconds. Consider increasing 'xl.timeouts.failureHandlerTimeout' property", task.getId(), task.getExecutionId(), timeout), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
                } else if (error != null) {
                    String message = String.format("Failure handler of task [%s] with script execution [%s] was terminated due to: [%s]", task.getId(), task.getExecutionId(), error.toString());
                    this.releaseActorService.failTaskAsync(task.getId(), message, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
                } else {
                    Optional.of(taskResult).ifPresent(result -> {
                        FailureHandlerResult failureHandlerResult = (FailureHandlerResult)result;
                        failureHandlerResult.executeCallback(this.releaseActorService, this.recoverCallback(task), (Function1<Throwable, ExecuteRecoverAction>)this.fallbackCallback(task));
                    });
                }
            });
        }
        catch (RejectedExecutionException exception) {
            this.queueTask(OptionallyDecoratedReleaseSupplier.ofDecoratedRelease((Release)task.getRelease()), task.getId(), TaskStatus.FAILURE_HANDLER_QUEUED, task.getExecutionId());
        }
        catch (Exception exception) {
            String msg = String.format("Unable to schedule failure handler. Reason: %s", exception.getMessage());
            this.releaseActorService.failTaskAsync(task.getId(), msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    @Timed
    void executeAbortScript(Task task) {
        Preconditions.checkArgument((boolean)(task instanceof CustomScriptTask), (String)"Cannot execute abort script because task is not an instance of CustomScriptTask", (Object)task.getType().toString());
        ((CustomScriptTask)task).resetSchedule();
        this.executeTask(task);
    }

    @Timed
    public void taskPreconditionValidated(String taskId, Release release, String executionId) {
        this.decorateWithMetadata(release);
        Task task = release.getTask(taskId);
        Changes changes = new Changes();
        if (task.isStillExecutingScript(executionId)) {
            changes.addAll(release.taskPreconditionValidated(taskId));
        } else {
            logger.debug("Will not accept precondition validation results becaue executionId does not match.");
        }
        this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
    }

    @Timed
    public void postponeUntilEnvironmentsAreReserved(String taskId, Date postponeUntil, String comment, String executionId) {
        Object task = this.taskRepository.findById(taskId);
        if (task.isStillExecutingScript(executionId)) {
            Changes changes = task.postponeUntilEnvironmentsAreReserved(postponeUntil);
            this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
        } else {
            logger.info("Will not postpone task until environments are reserved, because execution id does not match: {}", (Object)taskId);
        }
    }

    @Override
    public ReleaseActorService exec() {
        return this.releaseActorService;
    }

    @Override
    public TaskRepository taskRepo() {
        return this.taskRepository;
    }

    @Override
    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    private void processChangesAndPublishOperations(Changes changes, User user) {
        this.publishBeforeEvents(changes);
        this.processChanges(changes, user);
        this.publishAfterEvents(changes);
        this.completeDependentGates(changes);
    }

    private void processChanges(Changes changes, User user) {
        this.taskBackup.backupTasks(changes.getTasksToBackup());
        this.applyChanges(changes, user);
        this.executePostActions(changes);
    }

    private void decorateWithMetadata(Release release) {
        this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(BlackoutMetadata.BLACKOUT(), ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), ReleaseServerUrlDecorator.SERVER_URL()));
    }

    public void prepareForShutdown() {
        this.preparingForShutdown = true;
    }

    public void saveCustomScriptResults(Release release, String taskId, DefaultScriptService.CustomScriptTaskResults results, String executionId) {
        Task task = release.getTask(taskId);
        if (task instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task;
            if (customScriptTask.isStillExecutingScript(executionId) && !this.scriptLifeCycle.isRegistered(executionId)) {
                Changes changes = this.scriptResultsService.resolveScriptTaskResults((Task)customScriptTask, results);
                this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
            } else {
                logger.info("Discarding duplicate SaveCustomScriptResults message because either executionId does not match or executionId is already registered {}", (Object)customScriptTask.getId());
            }
        } else {
            logger.info("Discarding SaveCustomScriptResults message because task appeared to be not CustomScriptTask any more {}", (Object)task.getId());
        }
    }

    @Timed
    public void executeNextCustomScriptPath(CustomScriptTask task) {
        String lastExecutionId = task.getExecutionId();
        long delay = task.getInterval() != null ? (long)(task.getInterval() * 1000) : XlrConfig.getInstance().durations_customScriptTaskScheduleInterval().toMillis();
        logger.trace("Scheduling next script path: {}", (Object)task.getNextScriptPath());
        try {
            this.scriptLifeCycle.preregister(lastExecutionId);
            this.scheduleNextCustomScriptTaskExecution((TaskSoftReference<CustomScriptTask>)new TaskSoftReference((Task)task, this.makeTaskSupplier(task.getId())), delay);
        }
        catch (RejectedExecutionException ex) {
            this.queueTask(OptionallyDecoratedReleaseSupplier.ofDecoratedRelease((Release)task.getRelease()), task.getId(), task.isAbortScriptInProgress() ? TaskStatus.ABORT_SCRIPT_QUEUED : TaskStatus.QUEUED, task.getExecutionId());
        }
    }

    private void scheduleNextCustomScriptTaskExecution(TaskSoftReference<CustomScriptTask> taskRef, long delay) {
        this.scheduler.scheduleOnce(FutureTaskAdapter.ofCustomScriptTask(taskRef.getTaskId(), taskRef.isAbortScriptInProgress(), this.releaseActorService, taskRef.getExecutionId(), () -> {
            CustomScriptTask currentTask;
            CustomScriptTask task = (CustomScriptTask)taskRef.get();
            String lastExecutionId = taskRef.getExecutionId();
            logger.trace("Going to execute scheduled polling task {}", (Object)task.getId());
            try {
                currentTask = (CustomScriptTask)this.taskRepository.findById(task.getId());
            }
            catch (ClassCastException e) {
                logger.warn("Task {} expected to be CustomScriptTask but appeared to be of another type, ignoring", (Object)task.getId(), (Object)e);
                return null;
            }
            try {
                if (lastExecutionId != null && !currentTask.isStillExecutingScript(lastExecutionId)) {
                    logger.info("Not executing script of task {} as the execution ID has changed from the last polling from {} to {}. Probably the task was aborted and immediately retried.", new Object[]{currentTask, lastExecutionId, currentTask.getExecutionId()});
                    return null;
                }
                this.doExecuteTask((Task)currentTask);
            }
            catch (RejectedExecutionException e) {
                this.releaseActorService.queueTask(task.getId(), task.isAbortScriptInProgress() ? TaskStatus.ABORT_SCRIPT_QUEUED : TaskStatus.QUEUED, task.getExecutionId());
            }
            catch (Exception e) {
                logger.warn("Exception happen when running scheduled polling task {}", (Object)task.getId(), (Object)e);
                this.releaseActorService.failTaskAsync(task.getId(), String.format("Exception happen when running scheduled polling task: %s", e.getMessage()), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
            }
            return null;
        }), delay, TimeUnit.MILLISECONDS);
    }
}

