/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.gate;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Component
public class GateTaskExecutor
implements TaskExecutor<GateTask> {
    private DependencyRepository dependencyRepository;
    private ReleaseActorService releaseActorService;
    private DependencyTargetResolver dependencyTargetResolver;

    @Autowired
    public GateTaskExecutor(DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, DependencyTargetResolver dependencyTargetResolver) {
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.dependencyTargetResolver = dependencyTargetResolver;
    }

    @Override
    public Class<GateTask> getTaskClass() {
        return GateTask.class;
    }

    @Override
    public void execute(GateTask task, SensitiveValueScrubber scrubber) {
        try {
            this.tryResolveTargetIdOfDependencies(task);
            this.completeOrFailIfNeeded(task);
        }
        catch (TargetIdResolutionFailedException e) {
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.GATE_TASK_FAILED.format(new Object[]{e.getMessage()}), User.AUTHENTICATED_USER, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    private void tryResolveTargetIdOfDependencies(GateTask gateTask) throws TargetIdResolutionFailedException {
        ArrayList<Dependency> updatedDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : gateTask.getDependencies()) {
            String targetId = dependency.getTargetId();
            if (Strings.isEmpty((String)targetId)) {
                if (dependency.hasResolvedTarget() || dependency.isArchived()) continue;
                throw new TargetIdResolutionFailedException(String.format("Missing target on dependency %s. Was it defined as a variable with an empty value?", dependency.getId()));
            }
            this.dependencyTargetResolver.resolveTarget(dependency);
            updatedDependencies.add(dependency);
        }
        this.dependencyRepository.update(gateTask.getRelease(), (Seq<Dependency>)JavaConverters.asScalaBuffer(updatedDependencies));
    }

    private void completeOrFailIfNeeded(GateTask task) {
        if (task.isCompletable()) {
            this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, task.getId(), null, User.AUTHENTICATED_USER);
        } else if (task.hasAbortedDependencies()) {
            String titles = task.getAbortedDependencyTitles();
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(new Object[]{titles}), User.AUTHENTICATED_USER, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }
}

