/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.CalendarEntry;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.events.BlackoutCreatedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b%\u0003A\u0011\u0001&\t\u000by\u0003A\u0011A0\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u0016\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011q\u000f\u0001\u0005\u0002\u0005\u0005\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0005=\u0019\u0015\r\\3oI\u0006\u00148+\u001a:wS\u000e,'BA\f\u0019\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0007\u000e\u0002\u0013ad'/\u001a7fCN,'BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013!B:mMRR'\"A\u0016\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\f\u0015\u0003\u000f1{wmZ5oO\u000692-\u00197f]\u0012\f'/\u00128uef\u0014V\r]8tSR|'/_\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007G\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001b3\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\rdC2,g\u000eZ1s\u000b:$(/\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n1bY5JIN+'O^5dKV\t\u0011\b\u0005\u0002;w5\ta#\u0003\u0002=-\tY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003!)g/\u001a8u\u0005V\u001cX#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015AB3wK:$8O\u0003\u0002F1\u00051Am\\7bS:L!a\u0012\"\u0003\u0011\u00153XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u0005i\u0002\u0001\"\u0002\u0018\b\u0001\u0004\u0001\u0004\"B\u001c\b\u0001\u0004I\u0004\"\u0002 \b\u0001\u0004\u0001\u0005FA\u0004Q!\t\tF,D\u0001S\u0015\t\u0019F+\u0001\u0006b]:|G/\u0019;j_:T!!\u0016,\u0002\u000f\u0019\f7\r^8ss*\u0011q\u000bW\u0001\u0006E\u0016\fgn\u001d\u0006\u00033j\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u00027\u0006\u0019qN]4\n\u0005u\u0013&!C!vi><\u0018N]3e\u000359W\r^*qK\u000eL\u0017\r\u001c#bsR\u0011\u0001M\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0012\u000b\u0001bY1mK:$\u0017M]\u0005\u0003K\n\u0014!b\u00159fG&\fG\u000eR1z\u0011\u00159\u0007\u00021\u0001i\u00031\u0019\b/Z2jC2$\u0015-_%e!\tI\u0007O\u0004\u0002k]B\u00111NI\u0007\u0002Y*\u0011QNH\u0001\u0007yI|w\u000e\u001e \n\u0005=\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c\u0012)\u0005!!\bCA;|\u001b\u00051(BA*x\u0015\tA\u00180A\u0004nKR\u0014\u0018nY:\u000b\u0005id\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005q4(!\u0002+j[\u0016$\u0017!D:fiN\u0003XmY5bY\u0012\u000b\u0017\u0010\u0006\u0003a\u007f\u0006\u0005\u0001\"B4\n\u0001\u0004A\u0007BBA\u0002\u0013\u0001\u0007\u0001-\u0001\u0006ta\u0016\u001c\u0017.\u00197ECfD#!\u0003;\u0002\u001d\u001d,Go\u00159fG&\fG\u000eR1zgR1\u00111BA\u000e\u0003K\u0001R!!\u0004\u0002\u0018\u0001l!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005kRLGN\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\t1K7\u000f\u001e\u0005\b\u0003;Q\u0001\u0019AA\u0010\u0003\u00111'o\\7\u0011\t\u00055\u0011\u0011E\u0005\u0005\u0003G\tyA\u0001\u0003ECR,\u0007bBA\u0014\u0015\u0001\u0007\u0011qD\u0001\u0003i>D#A\u0003;\u0002\u0017\u0005$GM\u00117bG.|W\u000f\u001e\u000b\u0005\u0003_\t)\u0004E\u0002b\u0003cI1!a\rc\u0005!\u0011E.Y2l_V$\bbBA\u001c\u0017\u0001\u0007\u0011qF\u0001\tE2\f7m[8vi\"\u00121\u0002\u001e\u000b\u0007\u0003_\ti$!\u0011\t\r\u0005}B\u00021\u0001i\u0003!\u0001\u0018M]3oi&#\u0007bBA\u001c\u0019\u0001\u0007\u0011q\u0006\u0015\u0003\u0019Q\fa\"\u001e9eCR,'\t\\1dW>,H\u000f\u0006\u0003\u00020\u0005%\u0003bBA&\u001b\u0001\u0007\u0011qF\u0001\bkB$\u0017\r^3eQ\tiA/\u0001\beK2,G/\u001a\"mC\u000e\\w.\u001e;\u0015\t\u0005M\u0013\u0011\f\t\u0004C\u0005U\u0013bAA,E\t!QK\\5u\u0011\u0019\tYF\u0004a\u0001Q\u0006Q!\r\\1dW>,H/\u00133)\u00059!\u0018aC4fi\nc\u0017mY6pkR$B!a\f\u0002d!1\u00111L\bA\u0002!D#a\u0004;\u0002\u0019%\u001c\u0018J\u001c\"mC\u000e\\w.\u001e;\u0015\t\u0005-\u0014\u0011\u000f\t\u0004C\u00055\u0014bAA8E\t9!i\\8mK\u0006t\u0007bBA:!\u0001\u0007\u0011qD\u0001\u0004]><\bF\u0001\tu\u000319W\r\u001e\"mC\u000e\\w.\u001e;t)\u0011\tY(! \u0011\r\u00055\u0011qCA\u0018\u0011\u001d\t\u0019(\u0005a\u0001\u0003?A#!\u0005;\u0015\r\u0005m\u00141QAC\u0011\u001d\tiB\u0005a\u0001\u0003?Aq!a\n\u0013\u0001\u0004\ty\u0002\u000b\u0002\u0013i\u0006A1/\u001a;ECR,7\u000f\u0006\u0004\u0002T\u00055\u0015\u0011\u0013\u0005\u0007\u0003\u001f\u001b\u0002\u0019\u00015\u0002\u0005%$\u0007BBA\u0002'\u0001\u0007\u0001-\u0001\u0005wC2LG-\u0019;f)\u0011\t\u0019&a&\t\u000f\u0005]B\u00031\u0001\u00020!\u001a\u0001!a'\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S1!!)Y\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003K\u000byJA\u0004TKJ4\u0018nY3")
public class CalendarService
implements Logging {
    private final CalendarEntryRepository calendarEntryRepository;
    private final CiIdService ciIdService;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CalendarService calendarService = this;
        synchronized (calendarService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CalendarEntryRepository calendarEntryRepository() {
        return this.calendarEntryRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public SpecialDay getSpecialDay(String specialDayId) {
        SpecialDay specialDay;
        if (!this.calendarEntryRepository().exists(specialDayId)) {
            void var2_2;
            SpecialDay result = new SpecialDay();
            result.setId(specialDayId);
            this.setDates(specialDayId, result);
            specialDay = var2_2;
        } else {
            specialDay = (SpecialDay)this.calendarEntryRepository().findById(specialDayId);
        }
        return specialDay;
    }

    @Timed
    public SpecialDay setSpecialDay(String specialDayId, SpecialDay specialDay) {
        if (specialDay.isBlank()) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Removing special day [").append(specialDayId).append("]").toString());
            if (this.calendarEntryRepository().exists(specialDayId)) {
                this.calendarEntryRepository().delete(specialDayId);
            }
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Saving special day [").append(specialDayId).append("] with label [").append(specialDay.getLabel()).append("] and color [").append(specialDay.getColor()).append("]").toString());
            specialDay.setId(specialDayId);
            this.setDates(specialDayId, specialDay);
            this.calendarEntryRepository().createOrUpdate((CalendarEntry)specialDay);
        }
        return specialDay;
    }

    @Timed
    public List<SpecialDay> getSpecialDays(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(SpecialDay.class), from, to);
    }

    @Timed
    public Blackout addBlackout(Blackout blackout) {
        return this.addBlackout(Ids.CALENDAR_ROOT, blackout);
    }

    @Timed
    public Blackout addBlackout(String parentId, Blackout blackout) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Adding new blackout [").append(blackout.getLabel()).append(" for period [").append(blackout.getStartDate()).append("] - [").append(blackout.getEndDate()).append("] to parent [").append(parentId).append("]").toString());
        this.validate(blackout);
        blackout.setId(this.ciIdService().getUniqueId(Type.valueOf(Blackout.class), parentId));
        this.calendarEntryRepository().create((CalendarEntry)blackout);
        this.eventBus().publish((XLReleaseEvent)new BlackoutCreatedEvent(blackout));
        return blackout;
    }

    @Timed
    public Blackout updateBlackout(Blackout updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updating blackout [").append(updated.getId()).append("]").toString());
        this.validate(updated);
        Blackout original = (Blackout)this.calendarEntryRepository().findById(updated.getId());
        this.calendarEntryRepository().update((CalendarEntry)updated);
        this.eventBus().publish((XLReleaseEvent)new BlackoutUpdatedEvent(original, updated));
        return updated;
    }

    @Timed
    public void deleteBlackout(String blackoutId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Deleting blackout [").append(blackoutId).append("]").toString());
        Blackout blackout = (Blackout)this.calendarEntryRepository().findById(blackoutId);
        this.calendarEntryRepository().delete(blackoutId);
        this.eventBus().publish((XLReleaseEvent)new BlackoutDeletedEvent(blackout));
    }

    @Timed
    public Blackout getBlackout(String blackoutId) {
        return (Blackout)this.calendarEntryRepository().findById(blackoutId);
    }

    @Timed
    public boolean isInBlackout(Date now) {
        return this.calendarEntryRepository().existsByTypeInRange(Type.valueOf(Blackout.class), now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date now) {
        return this.getBlackouts(now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(Blackout.class), from, to);
    }

    private void setDates(String id, SpecialDay specialDay) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            dateFormat.setLenient(false);
            DateTime specialDayDate = new DateTime((Object)dateFormat.parse(Ids.getName((String)id)));
            specialDay.setStartDate(specialDayDate.withTimeAtStartOfDay().toDate());
            specialDay.setEndDate(specialDayDate.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Special day ID [").append(id).append("] does not have a valid format - Configuration/Calendar/").append("yyyyMMdd").append(".").toString(), e);
        }
    }

    private void validate(Blackout blackout) {
        int blackoutLabelCharLength = 1024;
        Checks.checkNotNull((Object)blackout.getLabel(), (String)"Blackout label");
        Checks.checkArgument((blackout.getLabel().length() <= blackoutLabelCharLength ? 1 : 0) != 0, (String)"Blackout Label must be less than 1024 characters", (Object[])new Object[0]);
        Checks.checkNotNull((Object)blackout.getStartDate(), (String)"Blackout start date");
        Checks.checkNotNull((Object)blackout.getEndDate(), (String)"Blackout end date");
        Checks.checkArgument((boolean)blackout.getStartDate().before(blackout.getEndDate()), (String)"Blackout end date must be after start date.", (Object[])new Object[0]);
    }

    @Autowired
    public CalendarService(CalendarEntryRepository calendarEntryRepository, CiIdService ciIdService, EventBus eventBus) {
        this.calendarEntryRepository = calendarEntryRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

