/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.actors.utils.TriggerActorLifecycleUtils;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.GateConditionRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.UserProfileRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.rules.LoginRule;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.PreArchiveService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import com.xebialabs.xlrelease.utils.Eventually;
import java.lang.annotation.AnnotationFormatError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=JUnit4.class)
@ContextConfiguration(locations={"/spring/xlrelease-context-test.xml", "classpath:springmvc-resteasy.xml"}, initializers={XlrWebApplicationInitializer.class})
@WebAppConfiguration(value="src/test/resources")
@ActiveProfiles(profiles={"integrationTest"})
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest
implements ApplicationContextAware {
    public static final String PROFILE_INTEGRATION_TEST = "integrationTest";
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseIntegrationTest.class);
    protected ApplicationContext applicationContext;
    @ClassRule
    public static final SpringClassRule SPRING_CLASS_RULE = new SpringClassRule();
    @Rule
    public final SpringMethodRule springMethodRule = new SpringMethodRule();
    protected List<String> cisForDeletion = new ArrayList<String>();
    private List<Team> teamsForDeletion = new ArrayList<Team>();
    private List<String> cisToUnmark = new ArrayList<String>();
    private List<AutoCloseable> closeablesToClose = new ArrayList<AutoCloseable>();
    @Autowired
    public FolderService folderService;
    @Autowired
    public GateConditionRepository gateConditionRepository;
    @Autowired
    public CommentRepository commentRepository;
    @Autowired
    public ConfigurationService configurationService;
    @Autowired
    public ReleaseService releaseService;
    @Autowired
    public ReleaseRepository releaseRepository;
    @Autowired
    public TriggerRepository triggerRepository;
    @Autowired
    public PhaseRepository phaseRepository;
    @Autowired
    public PlanItemRepository planItemRepository;
    @Autowired
    public UserProfileRepository userProfileRepository;
    @Autowired
    public Eventually eventually;
    @Autowired
    public TeamService teamService;
    @Autowired
    public FacetService facetService;
    @Autowired
    public FolderPersistence folderPersistence;
    @Autowired
    public PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Autowired
    protected ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    @Autowired
    protected TriggerActorLifecycleUtils triggerActorLifecycleUtils;
    @Autowired
    private VariableService variableService;
    @Autowired
    protected ArchivedReleases archivedReleases;
    @Autowired
    protected ArchivingService archivingService;
    @Autowired
    public StorageFacade storageFacade;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    protected ConfigurationRepository configurationRepository;
    @Autowired(required=false)
    protected List<FeatureService> featureServices = new ArrayList<FeatureService>();
    @Qualifier(value="xlrRepositoryTransactionManager")
    @Autowired
    protected PlatformTransactionManager txManager;
    @Qualifier(value="reportingJdbcTemplate")
    @Autowired
    protected JdbcTemplate reportingJdbcTemplate;
    @Autowired
    private ArchivingSettingsManager archivingSettings;
    @Autowired
    private ReleaseActorService releaseActorService;
    @Autowired
    private XLReleaseEventBus xlrEventBus;
    @Autowired
    private PreArchiveService preArchiveService;
    @Rule
    public TestName testName = new TestName();

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected boolean featureServicesEnabled() {
        return true;
    }

    protected boolean isRelaxedTest() {
        return true;
    }

    @Before
    public void before() {
        this.withAdmin(() -> {
            logger.debug("XLReleaseIntegrationTest 'before' started");
            if (StringUtils.hasText((String)this.testName.getMethodName())) {
                MDC.put((String)"testName", (String)this.testName.getMethodName());
            }
            XLReleasePermissions.init();
            if (this.featureServicesEnabled()) {
                this.featureServices.forEach(this.safeRun(FeatureService::enable));
            } else {
                this.featureServices.forEach(this.safeRun(FeatureService::disable));
            }
            this.archivingSettings.setEnabled(Boolean.valueOf(true));
            this.enablePrearchive();
            LoginRule.grantAdminPermissionTo((String)"admin", (PermissionEditor)this.permissionEditor, (RoleService)this.roleService);
            this.variableService.findGlobalVariablesOrEmpty().getVariables().forEach(ci -> this.variableService.deleteGlobalVariable(ci.getId()));
            this.terminateReleaseActors(FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.storageFacade.verifyRepositoryClean();
            logger.debug("XLReleaseIntegrationTest 'before' finished");
            return null;
        });
    }

    private Consumer<? super FeatureService> safeRun(Consumer<? super FeatureService> action) {
        return featureService -> {
            try {
                action.accept((FeatureService)featureService);
            }
            catch (Exception ex) {
                logger.error("Unable to run feature action on {}", (Object)featureService.name(), (Object)ex);
            }
        };
    }

    private void disablePrearchive() {
        this.xlrEventBus.deregister((Object)this.preArchiveService);
        this.preArchiveService.disable();
    }

    private void enablePrearchive() {
        this.preArchiveService.enable();
        this.xlrEventBus.register((Object)this.preArchiveService);
    }

    @After
    public void tearDown() throws Exception {
        this.withAdmin(() -> {
            this.featureServices.forEach(this.safeRun(FeatureService::disable));
            this.disablePrearchive();
            this.archivingSettings.setEnabled(Boolean.valueOf(false));
            this.waitForEventBusToBecomeEmpty();
            for (AutoCloseable closeable : this.closeablesToClose) {
                closeable.close();
            }
            int abortAttempts = 5;
            long abortBackoff = 1000L;
            Seq releasesToAbort = this.releaseRepository.findIdsByStatus(ReleaseStatus.ACTIVE_STATUSES);
            for (int attempt = 0; attempt < abortAttempts && !releasesToAbort.isEmpty(); ++attempt) {
                if (attempt > 0) {
                    try {
                        Thread.sleep(abortBackoff);
                        abortBackoff *= 2L;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                releasesToAbort = ((Traversable)releasesToAbort.filter(releaseId -> {
                    try {
                        this.releaseActorService.abortRelease(releaseId, "aborted by test tearDown");
                        return false;
                    }
                    catch (Exception ex) {
                        logger.warn("Unable to abort release '{}'", releaseId, (Object)ex);
                        this.releaseService.findById(releaseId).getAllTasks().stream().filter(Task::isInProgress).forEach(t -> {
                            try {
                                this.releaseActorService.abortTask(t.getId(), "aborted by tearDown");
                            }
                            catch (Exception ex2) {
                                logger.warn("Unable to abort task '{}'", (Object)t.getId(), (Object)ex2);
                            }
                        });
                        return true;
                    }
                })).toSeq();
            }
            if (!releasesToAbort.isEmpty()) {
                throw new AnnotationFormatError("Unable to abort releases, this can cause odd effects in next test, thus crashing here");
            }
            DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
            txDef.setName("tearDownTx");
            TransactionStatus transactionStatus = this.txManager.getTransaction((TransactionDefinition)txDef);
            if (transactionStatus.isRollbackOnly()) {
                throw new IllegalStateException("Test left transaction in rollbackOnly state");
            }
            if (!transactionStatus.isNewTransaction()) {
                throw new IllegalStateException("Test left uncommitted transaction");
            }
            try {
                logger.debug("XLReleaseIntegrationTest 'after' started");
                this.terminateReleaseActors(FiniteDuration.apply((long)15L, (TimeUnit)TimeUnit.SECONDS));
                int attempts = 5;
                long backoff = 1000L;
                for (int attempt = 0; attempt < attempts; ++attempt) {
                    logger.debug(String.format("XLReleaseIntegrationTest 'after' started attempt %s", attempt));
                    try {
                        this.deleteCis();
                        if (this.isRelaxedTest()) {
                            this.storageFacade.cleanup();
                        }
                        this.storageFacade.verifyRepositoryClean();
                        this.deleteArchivedReleases();
                        if (transactionStatus.isRollbackOnly()) {
                            logger.debug(String.format("XLReleaseIntegrationTest 'after' attempt %s got isRollbackOnly", attempt));
                            this.txManager.rollback(transactionStatus);
                            transactionStatus = this.txManager.getTransaction((TransactionDefinition)txDef);
                            if (attempt != attempts - 1) continue;
                            throw new IllegalStateException("\"XLReleaseIntegrationTest 'after' attempt %s got isRollbackOnly\" on all attempts");
                        }
                        this.txManager.commit(transactionStatus);
                    }
                    catch (DataIntegrityViolationException | DeadlockLoserDataAccessException | UncategorizedSQLException e) {
                        logger.debug(String.format("XLReleaseIntegrationTest 'after' attempt %s got DataIntegrityViolationException", attempt), e);
                        this.txManager.rollback(transactionStatus);
                        transactionStatus = this.txManager.getTransaction((TransactionDefinition)txDef);
                        if (attempt == attempts - 1) {
                            throw e;
                        }
                        Thread.sleep(backoff);
                        backoff += 1000L;
                        continue;
                    }
                    logger.debug(String.format("XLReleaseIntegrationTest 'after' finished attempt %s", attempt));
                    break;
                }
                logger.debug("XLReleaseIntegrationTest 'after' finished");
            }
            catch (Throwable t) {
                if (!transactionStatus.isCompleted()) {
                    this.txManager.rollback(transactionStatus);
                }
                logger.error("Test '{}' tearDown failed.", (Object)MDC.get((String)"testName"), (Object)t);
                throw new AnnotationFormatError(t);
            }
            finally {
                this.cisForDeletion.clear();
                this.teamsForDeletion.clear();
                if (StringUtils.hasText((String)this.testName.getMethodName())) {
                    MDC.remove((String)"testName");
                }
            }
            return null;
        });
    }

    private void waitForEventBusToBecomeEmpty() {
        long backoff = 50L;
        for (int tries = 15; tries >= 0; --tries) {
            if (!this.xlrEventBus.hasPendingMessages()) {
                return;
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            backoff += 50L;
        }
    }

    private void terminateReleaseActors(FiniteDuration apply) {
        try {
            this.releaseActorLifecycleUtils.terminateAllReleaseActorsAndAwait(apply);
        }
        catch (Exception ex) {
            logger.error("Timed out while terminating actors, try increasing the timeout", (Throwable)ex);
        }
    }

    private void deleteArchivedReleases() {
        this.reportingJdbcTemplate.execute("DELETE FROM RELEASES");
    }

    protected void verifyRepositoryClean() {
        this.storageFacade.verifyRepositoryClean();
    }

    private void deleteCis() {
        this.teamsForDeletion.stream().distinct().collect(Collectors.toList()).removeIf(t -> this.storageFacade.delete((Team)t));
        this.cisForDeletion = this.cisForDeletion.stream().distinct().collect(Collectors.toList());
        this.cisForDeletion.removeAll(this.cisToUnmark);
        this.cisForDeletion.removeIf(id -> Ids.isDependencyId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> this.isPhaseOrTask((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isTeamId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isReleaseId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isTriggerId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isConfigurationId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> !Ids.isReleaseId((String)id) && !Ids.isConfigurationId((String)id) && !Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
    }

    private boolean isPhaseOrTask(String id) {
        return Ids.isPlanItemId((String)id) && !Ids.isReleaseId((String)id);
    }

    protected void deleteOnTearDown(ConfigurationItem ... items) {
        for (ConfigurationItem item : items) {
            this.deleteOnTearDown(item.getId());
        }
    }

    protected void deleteOnTearDown(String ... ids) {
        Collections.addAll(this.cisForDeletion, ids);
    }

    public void markForDeletion(ConfigurationItem item) {
        this.markForDeletion(item.getId());
    }

    public void markForDeletion(String ciId) {
        this.cisForDeletion.add(ciId);
    }

    public void markForDeletion(Team team) {
        this.teamsForDeletion.add(team);
    }

    public void unmarkForDeletion(String id) {
        this.cisToUnmark.add(id);
        this.teamsForDeletion.removeIf(team -> id.equals(team.getId()));
    }

    public void deleteOrder(ConfigurationItem ... items) {
        this.cisForDeletion = Stream.concat(Arrays.stream(items).map(ConfigurationItem::getId), this.cisForDeletion.stream()).collect(Collectors.toList());
    }

    public void deleteRelease(List<String> releaseIds) {
        releaseIds.forEach(this::deleteRelease);
    }

    public void deleteRelease(String ... releaseIds) {
        this.deleteRelease(Arrays.asList(releaseIds));
    }

    public void deleteRelease(String releaseId) {
        this.releaseRepository.delete(releaseId);
    }

    public void storeRelease(Release ... releases) {
        this.storeRelease(Arrays.asList(releases));
    }

    public void storeRelease(List<Release> releases) {
        releases.forEach(this::storeRelease);
    }

    public Release insertArchivedRelease(Release release, String releaseJson, String activityLogs) {
        this.archivedReleases.insert(release, releaseJson, activityLogs, false);
        return release;
    }

    public Release archiveRelease(Release release) {
        this.storeRelease(release);
        this.preArchiveAndArchiveRelease(release);
        return release;
    }

    public Release preArchiveAndArchiveRelease(Release release) {
        this.archivingService.preArchiveRelease(release);
        this.archivingService.archiveRelease(release.getId());
        return release;
    }

    public int deleteFromArchive(String releaseId) {
        return this.storageFacade.deleteFromArchive(releaseId);
    }

    public void storeChanges(Changes changes) {
        changes.getUpdatedItems().stream().filter(ci -> ci.getType().equals((Object)Type.valueOf(Release.class))).map(Release.class::cast).forEach(r -> this.releaseRepository.update(r));
    }

    public <T extends Task> T getTask(String taskId) {
        return (T)this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    public void createTask(Task task) {
        this.taskRepository.create(task);
    }

    public void updateTask(Task task) {
        this.taskRepository.update(task);
    }

    public void updateTaskProperty(Task task) {
        this.updateTask(task);
    }

    public Phase getPhase(String phaseId) {
        return this.phaseRepository.findById(phaseId);
    }

    public void updatePhase(Phase phase) {
        this.phaseRepository.update(phase.getRelease(), phase, phase);
    }

    public void updateRelease(Release release) {
        this.releaseRepository.update(release);
    }

    public Release storeRelease(Release release) {
        return this.storeRelease(release, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Trigger storeTrigger(Trigger trigger) {
        Trigger storedTrigger = this.triggerRepository.create(trigger);
        this.markForDeletion((ConfigurationItem)storedTrigger);
        return storedTrigger;
    }

    public ReleaseTrigger storeTrigger(ReleaseTrigger trigger) {
        return (ReleaseTrigger)this.storeTrigger((Trigger)trigger);
    }

    public Release storeRelease(Release release, DeleteOption ... deleteOptions) {
        Release stored = this.releaseRepository.create(release, (ReleaseCreationSource)new CreatedWithoutTemplate());
        logger.info("Stored release {}({})", (Object)stored.getTitle(), (Object)stored.getCiUid());
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_RELEASE)) {
            this.markForDeletion((ConfigurationItem)stored);
        }
        this.storeTeams(stored, deleteOptions);
        for (int tries = 10; tries > 0; --tries) {
            try {
                Thread.sleep(100L);
                this.releaseRepository.findById(release.getId(), ResolveOptions.MINIMAL());
                for (Task task : release.getAllTasks()) {
                    this.taskRepository.findById(task.getId());
                }
                return stored;
            }
            catch (Exception e) {
                logger.warn("storeRelease check failed: ", (Throwable)e);
                continue;
            }
        }
        throw new RuntimeException("storeRelease unable to check that release is saved");
    }

    public Release storeTemplate(Release releaseData) {
        return this.storeTemplate(releaseData, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Release storeTemplate(Release releaseData, DeleteOption ... deleteOptions) {
        return this.storeTemplate(Folder.ROOT_FOLDER_ID, releaseData, deleteOptions);
    }

    public Release storeTemplate(Folder parentFolder, Release releaseData) {
        return this.storeTemplate(parentFolder.getId(), releaseData, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Release storeTemplate(Folder parentFolder, Release releaseData, DeleteOption ... deleteOptions) {
        return this.storeTemplate(parentFolder.getId(), releaseData, deleteOptions);
    }

    private Release storeTemplate(String parentFolderId, Release releaseData, DeleteOption ... deleteOptions) {
        Release stored = this.releaseService.createTemplate(releaseData, parentFolderId);
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_RELEASE)) {
            this.markForDeletion((ConfigurationItem)stored);
        }
        if (Ids.ROOT_FOLDER_ID.equals(parentFolderId)) {
            this.storeTeams(stored, deleteOptions);
        }
        return stored;
    }

    public <T extends BaseConfiguration> T storeConfiguration(T configurationItem) {
        BaseConfiguration storedItem = this.configurationRepository.create(configurationItem);
        this.markForDeletion((ConfigurationItem)storedItem);
        return (T)storedItem;
    }

    private void storeTeams(Release stored, DeleteOption[] deleteOptions) {
        logger.warn("Saving teams: {}", (Object)stored.getTeams().stream().map(BaseConfigurationItem::getId).collect(Collectors.joining(",")));
        List savedTeams = this.teamService.saveTeamsToPlatform(stored);
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_TEAMS)) {
            savedTeams.forEach(this::markForDeletion);
        }
    }

    private boolean optionHas(DeleteOption[] deleteOptions, DeleteOption option) {
        return Arrays.asList(deleteOptions).contains((Object)option);
    }

    public Variable getVariable(String variableId) {
        return this.variableService.findById(variableId);
    }

    public Release getRelease(String releaseId) {
        return this.releaseRepository.findById(releaseId);
    }

    public GateCondition getGateCondition(String conditionId) {
        return this.gateConditionRepository.findById(conditionId);
    }

    public PlanItem getPlanItem(String planItemId) {
        return this.planItemRepository.findById(planItemId);
    }

    public String createRole(String roleName) {
        Role role = new Role(roleName);
        List allRoles = this.roleService.readRoleAssignments();
        allRoles.add(role);
        this.roleService.writeRoleAssignments(allRoles);
        return roleName;
    }

    public Folder createFolder(Folder folder, boolean createDefaultTeamsIfTopLevel) {
        return this.createFolder(Ids.getParentId((String)folder.getId()), folder, createDefaultTeamsIfTopLevel);
    }

    public Folder createFolder(String parentId, Folder folder) {
        return this.createFolder(parentId, folder, true);
    }

    public Folder createFolder(String parentId, Folder folder, boolean createDefaultTeamsIfTopLevel) {
        Folder createdFolder = this.folderService.create(parentId, folder, createDefaultTeamsIfTopLevel);
        this.markForDeletion((ConfigurationItem)createdFolder);
        return createdFolder;
    }

    public String encrypt(String password) {
        if (null != password && !XlrConfig.getInstance().repository_decryptPasswords()) {
            return PasswordEncrypter.getInstance().ensureEncrypted(password);
        }
        return password;
    }

    public <T extends AutoCloseable> T registerCloseable(T closeable) {
        this.closeablesToClose.add(closeable);
        return closeable;
    }

    private void withAdmin(Callable<Void> callable) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication oldAuth = context.getAuthentication();
        TestingAuthenticationToken adminAuth = new TestingAuthenticationToken((Object)"itusername", (Object)"itpassword", new String[]{"ROLE_ADMIN"});
        context.setAuthentication((Authentication)adminAuth);
        SecurityContextHolder.setContext((SecurityContext)context);
        try {
            callable.call();
        }
        catch (Exception ex) {
            throw new AnnotationFormatError(ex);
        }
        finally {
            context.setAuthentication(oldAuth);
        }
    }

    public static enum DeleteOption {
        DELETE_NONE,
        DELETE_RELEASE,
        DELETE_TEAMS;

    }
}

