/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class BaseConditionAwaiter
implements AutoCloseable {
    protected static final long DEFAULT_TIMEOUT = 3000L;
    protected boolean failed = false;
    private XLReleaseEventBus eventBus;
    protected CountDownLatch latch;
    protected long timeout;

    public BaseConditionAwaiter(XLReleaseEventBus eventBus, long timeout) {
        this(eventBus, timeout, 1);
    }

    public BaseConditionAwaiter(XLReleaseEventBus eventBus, long timeout, int latchCount) {
        this.eventBus = eventBus;
        this.timeout = timeout;
        this.latch = new CountDownLatch(latchCount);
        eventBus.register((Object)this);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void await() throws InterruptedException, TimeoutException {
        if (!this.latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
            this.failed = true;
            throw new TimeoutException(this.getErrorMessage());
        }
        if (this.failed) {
            if (this.getErrorCause() != null) {
                throw new IllegalStateException(this.getErrorMessage(), this.getErrorCause());
            }
            throw new IllegalStateException(this.getErrorMessage());
        }
    }

    @Override
    public void close() {
        this.eventBus.deregister((Object)this);
    }

    protected abstract String getErrorMessage();

    protected Throwable getErrorCause() {
        return null;
    }
}

