/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.utils.BaseConditionAwaiter;
import com.xebialabs.xlrelease.utils.EventsAwaiter;
import com.xebialabs.xlrelease.utils.MatchingAwaiter;
import com.xebialabs.xlrelease.utils.PlanItemStatusAwaiter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import scala.PartialFunction;

public class ConditionBuilder<R> {
    private final XLReleaseEventBus eventBus;
    private final Supplier<R> runnable;
    private static final long DEFAULT_TIMEOUT = 45000L;

    private ConditionBuilder(XLReleaseEventBus eventBus, Supplier<R> runnable) {
        this.eventBus = eventBus;
        this.runnable = runnable;
    }

    public static <R> ConditionBuilder<R> execute(XLReleaseEventBus eventBus, Supplier<R> runnable) {
        return new ConditionBuilder<R>(eventBus, runnable);
    }

    public <S> R until(String planItemId, List<S> statuses) throws InterruptedException, TimeoutException {
        return this.until(planItemId, statuses, 45000L);
    }

    public <S> R until(String planItemId, List<S> statuses, long timeout) throws InterruptedException, TimeoutException {
        return this.until(() -> new PlanItemStatusAwaiter(this.eventBus, planItemId, statuses, timeout));
    }

    public <S> R until(String planItemId, S ... statuses) throws InterruptedException, TimeoutException {
        return this.until(planItemId, 45000L, statuses);
    }

    public R until(long timeout, XLReleaseEvent ... eventsInOccurrenceOrder) throws InterruptedException, TimeoutException {
        return this.until(() -> new EventsAwaiter(this.eventBus, Arrays.asList(eventsInOccurrenceOrder), timeout, EventsAwaiter.VerificationMode.EVENTS_IN_ORDER));
    }

    public <S> R until(String planItemId, long timeout, S ... statuses) throws InterruptedException, TimeoutException {
        return this.until(planItemId, Arrays.asList(statuses), timeout);
    }

    public R until(XLReleaseEvent ... eventsInOccurrenceOrder) throws InterruptedException, TimeoutException {
        return this.until(() -> new EventsAwaiter(this.eventBus, Arrays.asList(eventsInOccurrenceOrder), 45000L, EventsAwaiter.VerificationMode.EVENTS_IN_ORDER));
    }

    public R untilInAnyOrder(XLReleaseEvent ... events) throws InterruptedException, TimeoutException {
        return this.until(() -> new EventsAwaiter(this.eventBus, Arrays.asList(events), 45000L, EventsAwaiter.VerificationMode.EVENTS_IN_ANY_ORDER));
    }

    public R untilAnyOf(XLReleaseEvent ... events) throws InterruptedException, TimeoutException {
        return this.until(() -> new EventsAwaiter(this.eventBus, Arrays.asList(events), 45000L, EventsAwaiter.VerificationMode.ANY_OF_EVENTS));
    }

    public R until(long timeout, PartialFunction<XLReleaseEvent, MatchingAwaiter.MatcherEvent> ... matchers) throws TimeoutException, InterruptedException {
        return this.until(() -> MatchingAwaiter.apply(this.eventBus, timeout, matchers));
    }

    public R until(PartialFunction<XLReleaseEvent, MatchingAwaiter.MatcherEvent> ... matchers) throws TimeoutException, InterruptedException {
        return this.until(() -> MatchingAwaiter.apply(this.eventBus, 45000L, matchers));
    }

    private R until(Supplier<BaseConditionAwaiter> conditionSupplier) throws InterruptedException, TimeoutException {
        try (BaseConditionAwaiter condition = conditionSupplier.get();){
            R result = this.runnable.get();
            condition.await();
            R r = result;
            return r;
        }
    }
}

