/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u000f\u001e\u0001\u0011B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"A1\u0010\u0001B\u0001B\u0003%\u0011\rC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011q\u000b\u0001\u0005\u0012\u0005e\u0003bBA\u001a\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\ti\b\u0001C!\u0003KAq!a \u0001\t\u0013\t\t\tC\u0004\u0002*\u0002!I!a+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011\u0011\u0017\u0001\u0005\n\u0005=\u0006bBAZ\u0001\u0011%\u00111\u0016\u0005\b\u0003k\u0003A\u0011AA\u0013\u000f\u001d\t).\bE\u0001\u0003/4a\u0001H\u000f\t\u0002\u0005e\u0007B\u0002@\u001a\t\u0003\t\t\u000fC\u0004\u0002pe!\t!a9\u0003!M\u000bHn\u0015;pe\u0006<WMR1dC\u0012,'B\u0001\u0010 \u0003%AHN]3mK\u0006\u001cXM\u0003\u0002!C\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M!\u0001!J\u00172!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aa\u00142kK\u000e$\bC\u0001\u00180\u001b\u0005i\u0012B\u0001\u0019\u001e\u00055\u0019Fo\u001c:bO\u00164\u0015mY1eKB\u0011aFM\u0005\u0003gu\u0011!\u0003V3ti\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0006iam\u001c7eKJ\u001cVM\u001d<jG\u0016\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u000f\u0002\u000fM,'O^5dK&\u0011!h\u000e\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0004gFd'BA!\u001e\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0007z\u0012\u0011cU9m)\u0016\fWNU3q_NLGo\u001c:z\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\r\u001ek\u0011\u0001Q\u0005\u0003\u0011\u0002\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB\u0011agS\u0005\u0003\u0019^\u0012ACU3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0017!\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#z\n1\u0002]3sg&\u001cH/\u001a8dK&\u00111\u000b\u0015\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002G-&\u0011q\u000b\u0011\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\fqcY1mK:$\u0017M]#oiJL(+\u001a9pg&$xN]=\u0011\u0005\u0019S\u0016BA.A\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0011aGX\u0005\u0003?^\u0012\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0011\u0005\t\\W\"A2\u000b\u0005\u0011,\u0017\u0001B2pe\u0016T!AZ4\u0002\t)$'m\u0019\u0006\u0003Q&\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002U\u0006\u0019qN]4\n\u00051\u001c'\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0006B\u0005oqf\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002ti\u00069a-Y2u_JL(BA;h\u0003\u0015\u0011W-\u00198t\u0013\t9\bOA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\n!0A\ryYJ\u0014V\r]8tSR|'/\u001f&eE\u000e$V-\u001c9mCR,\u0017!\u0006:fa>\u0014H/\u001b8h\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\u0005\u00159DX0I\u0001|\u0003\u0019a\u0014N\\5u}Q1\u0012\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\t9\u0002\u0005\u0002/\u0001!)Ag\u0003a\u0001k!)1h\u0003a\u0001y!)Ai\u0003a\u0001\u000b\")\u0011j\u0003a\u0001\u0015\")Qj\u0003a\u0001\u001d\")Ak\u0003a\u0001+\")\u0001l\u0003a\u00013\")Al\u0003a\u0001;\")\u0001m\u0003a\u0001C\"*\u00111\u00038ys\")1p\u0003a\u0001C\"*\u0011q\u00038y{\"\u001a1\"!\b\u0011\u0007=\fy\"C\u0002\u0002\"A\u0014\u0011\"Q;u_^L'/\u001a3\u0002\u000f\rdW-\u00198vaR\u0011\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0011\u0011QF\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003c\tYC\u0001\u0003V]&$\u0018A\u00023fY\u0016$X\r\u0006\u0003\u00028\u0005u\u0002\u0003BA\u0015\u0003sIA!a\u000f\u0002,\t9!i\\8mK\u0006t\u0007bBA \u001b\u0001\u0007\u0011\u0011I\u0001\u0003S\u0012\u0004B!a\u0011\u0002R9!\u0011QIA'!\u0011\t9%a\u000b\u000e\u0005\u0005%#bAA&G\u00051AH]8pizJA!a\u0014\u0002,\u00051\u0001K]3eK\u001aLA!a\u0015\u0002V\t11\u000b\u001e:j]\u001eTA!a\u0014\u0002,\u0005iA-\u001a7fi\u0016\u0014V\r\\3bg\u0016$B!a\n\u0002\\!9\u0011q\b\bA\u0002\u0005\u0005C\u0003BA\u001c\u0003?Bq!!\u0019\u0010\u0001\u0004\t\u0019'\u0001\u0003uK\u0006l\u0007\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%T$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003[\n9G\u0001\u0003UK\u0006l\u0017!\u00053fY\u0016$XM\u0012:p[\u0006\u00138\r[5wKR!\u00111OA=!\u0011\tI#!\u001e\n\t\u0005]\u00141\u0006\u0002\u0004\u0013:$\bbBA>!\u0001\u0007\u0011\u0011I\u0001\ne\u0016dW-Y:f\u0013\u0012\fQC^3sS\u001aL(+\u001a9pg&$xN]=DY\u0016\fg.\u0001\u000euKN$H)\u001b3O_R\u001cE.Z1o\u0003\u001a$XM]%ug\u0016dg\r\u0006\u0004\u0002\u0004\u0006%\u0015Q\u0015\t\u0004M\u0005\u0015\u0015bAADO\t\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0005\b\u0003\u0017\u0013\u0002\u0019AAG\u0003\u0019\t7\r^5wKB1\u0011qRAM\u0003?sA!!%\u0002\u0016:!\u0011qIAJ\u0013\t\ti#\u0003\u0003\u0002\u0018\u0006-\u0012a\u00029bG.\fw-Z\u0005\u0005\u00037\u000biJA\u0002TKFTA!a&\u0002,AA\u0011\u0011FAQ\u0003\u0003\n\t%\u0003\u0003\u0002$\u0006-\"A\u0002+va2,'\u0007C\u0004\u0002(J\u0001\r!!$\u0002\u0011\u0005\u00148\r[5wK\u0012\fQbY8v]R\u0014V\r\\3bg\u0016\u001cHCAA:\u0003m9W\r\u001e*f[\u0006Lg.\u001b8h%\u0016dW-Y:fg\u0012+G/Y5mgR\u0011\u0011QR\u0001$O\u0016$(+Z7bS:LgnZ!sG\"Lg/\u001a3SK2,\u0017m]3t\t\u0016$\u0018-\u001b7t\u0003U\u0019w.\u001e8u\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\fab\u00197fC:DFNV3sg&|g\u000eK\u0002\u0018\u0003s\u0003B!a/\u0002D6\u0011\u0011Q\u0018\u0006\u0004c\u0006}&BAAa\u0003\u0015Q\u0017M^1y\u0013\u0011\t)-!0\u0003\u0015A\u0013X\rR3tiJ|\u0017\u0010K\u0002\u0001\u0003\u0013\u0004B!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f<\u0017AC:uKJ,w\u000e^=qK&!\u00111[Ag\u0005%\u0019u.\u001c9p]\u0016tG/\u0001\tTc2\u001cFo\u001c:bO\u00164\u0015mY1eKB\u0011a&G\n\u00043\u0005m\u0007\u0003BA\u0015\u0003;LA!a8\u0002,\t1\u0011I\\=SK\u001a$\"!a6\u0015\t\u0005\u0015\u0018\u0011\u001e\u000b\u0005\u0003g\n9\u000fC\u0003a7\u0001\u0007\u0011\rC\u0004\u0002|m\u0001\r!!\u0011")
public class SqlStorageFacade
implements StorageFacade,
TestAuthentication {
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    @Override
    public void cleanup() {
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.DEPENDENCIES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.CONFIGURATION_REFS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.COMMENTS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.TASKS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute("DELETE FROM XLR_ACTIVITY_LOGS");
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.RELEASES_EXT$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute("DELETE FROM XLR_RISK_ASSESSMENTS");
        this.jdbcTemplate.execute("DELETE FROM XLR_RISKS");
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.ARTIFACTS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
        this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(MetadataSchema.METADATA$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        this.reportingJdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE()).toString());
        this.reportingJdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE()).toString());
        this.reportingJdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE()).toString());
        this.reportingJdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME()).toString());
        this.reportingJdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME()).toString());
        this.reportingJdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString());
    }

    @Override
    public boolean delete(String id) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public void deleteRelease(String id) {
        block3: {
            block2: {
                if (!this.releaseRepository.exists(id)) break block2;
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                break block3;
            }
            if (!this.archivingService.exists(id)) break block3;
            this.deleteFromArchive(id);
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
    }

    private RuntimeException testDidNotCleanAfterItself(Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new RuntimeException(new StringBuilder(62).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$2) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$3) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$4) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlVersion() {
        this.jdbcTemplate.execute("DELETE FROM XL_VERSION");
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((TraversableOnce)((TraversableLike)active$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)archived$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        TestAuthentication.$init$((TestAuthentication)this);
    }
}

