/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class BaseConditionAwaiter
implements AutoCloseable {
    protected static final long DEFAULT_TIMEOUT = 3000L;
    private XLReleaseEventBus eventBus;
    protected CountDownLatch latch;
    protected long timeout;

    public BaseConditionAwaiter(XLReleaseEventBus eventBus, long timeout) {
        this.eventBus = eventBus;
        this.timeout = timeout;
        this.latch = new CountDownLatch(1);
        eventBus.register((Object)this);
    }

    public void await() throws InterruptedException, TimeoutException {
        if (!this.latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException(this.getErrorMessage());
        }
    }

    @Override
    public void close() {
        this.eventBus.deregister((Object)this);
    }

    protected abstract String getErrorMessage();
}

