/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.GateConditionRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.UserProfileRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.rules.LoginRule;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import com.xebialabs.xlrelease.utils.Eventually;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=JUnit4.class)
@ContextConfiguration(locations={"/spring/xlrelease-context-test.xml", "classpath:springmvc-resteasy.xml"}, initializers={XlrWebApplicationInitializer.class})
@WebAppConfiguration(value="src/test/resources")
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseIntegrationTest.class);
    @ClassRule
    public static final SpringClassRule SPRING_CLASS_RULE = new SpringClassRule();
    @Rule
    public final SpringMethodRule springMethodRule = new SpringMethodRule();
    private List<String> cisForDeletion = new ArrayList<String>();
    private List<Team> teamsForDeletion = new ArrayList<Team>();
    private List<String> cisToUnmark = new ArrayList<String>();
    @Autowired
    public FolderService folderService;
    @Autowired
    public GateConditionRepository gateConditionRepository;
    @Autowired
    public CommentRepository commentRepository;
    @Autowired
    public ReleaseService releaseService;
    @Autowired
    public ReleaseRepository releaseRepository;
    @Autowired
    public PhaseRepository phaseRepository;
    @Autowired
    public PlanItemRepository planItemRepository;
    @Autowired
    public UserProfileRepository userProfileRepository;
    @Autowired
    public Eventually eventually;
    @Autowired
    public TeamService teamService;
    @Autowired
    public FacetService facetService;
    @Autowired
    public FolderPersistence folderPersistence;
    @Autowired
    public PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    @Autowired
    private VariableService variableService;
    @Autowired
    public StorageFacade storageFacade;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    protected ConfigurationRepository configurationRepository;
    @Qualifier(value="xlrRepositoryTransactionManager")
    @Autowired
    protected PlatformTransactionManager txManager;
    @Qualifier(value="reportingJdbcTemplate")
    @Autowired
    private JdbcTemplate reportingJdbcTemplate;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void before() {
        logger.debug("XLReleaseIntegrationTest 'before' started");
        if (StringUtils.hasText((String)this.testName.getMethodName())) {
            MDC.put((String)"testName", (String)this.testName.getMethodName());
        }
        XLReleasePermissions.init();
        LoginRule.grantAdminPermissionTo((String)"admin", (PermissionEditor)this.permissionEditor, (RoleService)this.roleService);
        this.variableService.findGlobalVariablesOrEmpty().getVariables().forEach(ci -> this.variableService.deleteGlobalVariable(ci.getId()));
        this.terminateReleaseActors(FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
        this.storageFacade.verifyRepositoryClean();
        logger.debug("XLReleaseIntegrationTest 'before' finished");
    }

    @After
    public void tearDown() throws Exception {
        DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
        txDef.setName("tearDownTx");
        txDef.setPropagationBehavior(0);
        TransactionStatus transactionStatus = this.txManager.getTransaction((TransactionDefinition)txDef);
        try {
            logger.debug("XLReleaseIntegrationTest 'after' started");
            this.terminateReleaseActors(FiniteDuration.apply((long)15L, (TimeUnit)TimeUnit.SECONDS));
            this.deleteCis();
            this.storageFacade.cleanup();
            this.storageFacade.verifyRepositoryClean();
            this.deleteArchivedReleases();
            logger.debug("XLReleaseIntegrationTest 'after' finished");
            this.txManager.commit(transactionStatus);
        }
        catch (Throwable t) {
            if (!transactionStatus.isCompleted()) {
                this.txManager.rollback(transactionStatus);
            }
            logger.error("Test '{}' tearDown failed.", (Object)MDC.get((String)"testName"), (Object)t);
            throw t;
        }
        finally {
            this.cisForDeletion.clear();
            this.teamsForDeletion.clear();
            if (StringUtils.hasText((String)this.testName.getMethodName())) {
                MDC.remove((String)"testName");
            }
        }
    }

    private void terminateReleaseActors(FiniteDuration apply) {
        try {
            this.releaseActorLifecycleUtils.terminateAllReleaseActorsAndAwait(apply);
        }
        catch (Exception ex) {
            logger.error("Timed out while terminating actors, try increasing the timeout", (Throwable)ex);
        }
    }

    private void deleteArchivedReleases() {
        this.reportingJdbcTemplate.execute("DELETE FROM RELEASES");
    }

    protected void verifyRepositoryClean() {
        this.storageFacade.verifyRepositoryClean();
    }

    private void deleteCis() {
        this.teamsForDeletion.stream().distinct().collect(Collectors.toList()).removeIf(t -> this.storageFacade.delete((Team)t));
        this.cisForDeletion = this.cisForDeletion.stream().distinct().collect(Collectors.toList());
        this.cisForDeletion.removeAll(this.cisToUnmark);
        this.cisForDeletion.removeIf(id -> Ids.isDependencyId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> this.isPhaseOrTask((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isTeamId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isReleaseId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isConfigurationId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> !Ids.isReleaseId((String)id) && !Ids.isConfigurationId((String)id) && !Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
    }

    private boolean isPhaseOrTask(String id) {
        return Ids.isPlanItemId((String)id) && !Ids.isReleaseId((String)id);
    }

    protected void deleteOnTearDown(ConfigurationItem ... items) {
        for (ConfigurationItem item : items) {
            this.deleteOnTearDown(item.getId());
        }
    }

    protected void deleteOnTearDown(String ... ids) {
        Collections.addAll(this.cisForDeletion, ids);
    }

    public void markForDeletion(ConfigurationItem item) {
        this.markForDeletion(item.getId());
    }

    public void markForDeletion(String ciId) {
        this.cisForDeletion.add(ciId);
    }

    public void markForDeletion(Team team) {
        this.teamsForDeletion.add(team);
    }

    public void unmarkForDeletion(String id) {
        this.cisToUnmark.add(id);
        this.teamsForDeletion.removeIf(team -> id.equals(team.getId()));
    }

    public void deleteOrder(ConfigurationItem ... items) {
        this.cisForDeletion = Stream.concat(Arrays.stream(items).map(ConfigurationItem::getId), this.cisForDeletion.stream()).collect(Collectors.toList());
    }

    public void deleteRelease(List<String> releaseIds) {
        releaseIds.forEach(this::deleteRelease);
    }

    public void deleteRelease(String ... releaseIds) {
        this.deleteRelease(Arrays.asList(releaseIds));
    }

    public void deleteRelease(String releaseId) {
        this.releaseRepository.delete(releaseId);
    }

    public void storeRelease(Release ... releases) {
        this.storeRelease(Arrays.asList(releases));
    }

    public void storeRelease(List<Release> releases) {
        releases.forEach(this::storeRelease);
    }

    public void storeChanges(Changes changes) {
        changes.getUpdatedItems().stream().filter(ci -> ci.getType().equals((Object)Type.valueOf(Release.class))).map(Release.class::cast).forEach(r -> this.releaseRepository.update(r));
    }

    public <T extends Task> T getTask(String taskId) {
        return (T)this.taskRepository.findById(taskId);
    }

    public void createTask(Task task) {
        this.taskRepository.create(task);
    }

    public void updateTask(Task task) {
        this.taskRepository.update(task);
    }

    public void updateTaskProperty(Task task) {
        this.updateTask(task);
    }

    public Phase getPhase(String phaseId) {
        return this.phaseRepository.findById(phaseId);
    }

    public void updatePhase(Phase phase) {
        this.phaseRepository.update(phase.getRelease(), phase, phase);
    }

    public void updateRelease(Release release) {
        this.releaseRepository.update(release);
    }

    public Release storeRelease(Release release) {
        return this.storeRelease(release, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Release storeRelease(Release release, DeleteOption ... deleteOptions) {
        Release stored = this.releaseRepository.create(release, (ReleaseCreationSource)new CreatedWithoutTemplate());
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_RELEASE)) {
            this.markForDeletion((ConfigurationItem)stored);
        }
        logger.warn("Saving teams: {}", (Object)stored.getTeams().stream().map(BaseConfigurationItem::getId).collect(Collectors.joining(",")));
        List savedTeams = this.teamService.saveTeamsToPlatform(stored);
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_TEAMS)) {
            savedTeams.forEach(this::markForDeletion);
        }
        return stored;
    }

    private boolean optionHas(DeleteOption[] deleteOptions, DeleteOption option) {
        return Arrays.asList(deleteOptions).contains((Object)option);
    }

    public Variable getVariable(String variableId) {
        return this.variableService.findById(variableId);
    }

    public Release getRelease(String releaseId) {
        return this.releaseRepository.findById(releaseId);
    }

    public Release getRelease(String releaseId, WorkDir workDir) {
        return this.releaseRepository.findById(releaseId, workDir);
    }

    public GateCondition getGateCondition(String conditionId) {
        return this.gateConditionRepository.findById(conditionId);
    }

    public PlanItem getPlanItem(String planItemId) {
        return this.planItemRepository.findById(planItemId);
    }

    public String createRole(String roleName) {
        Role role = new Role(roleName);
        List allRoles = this.roleService.readRoleAssignments();
        allRoles.add(role);
        this.roleService.writeRoleAssignments(allRoles);
        return roleName;
    }

    public Folder createFolder(Folder folder, boolean createDefaultTeamsIfTopLevel) {
        return this.createFolder(Ids.getParentId((String)folder.getId()), folder, createDefaultTeamsIfTopLevel);
    }

    public Folder createFolder(String parentId, Folder folder) {
        return this.createFolder(parentId, folder, true);
    }

    public Folder createFolder(String parentId, Folder folder, boolean createDefaultTeamsIfTopLevel) {
        Folder createdFolder = this.folderService.create(parentId, folder, createDefaultTeamsIfTopLevel);
        this.markForDeletion((ConfigurationItem)createdFolder);
        return createdFolder;
    }

    public String encrypt(String password) {
        if (null != password && !XlrConfig.getInstance().repository_decryptPasswords()) {
            return PasswordEncrypter.getInstance().ensureEncrypted(password);
        }
        return password;
    }

    public static enum DeleteOption {
        DELETE_NONE,
        DELETE_RELEASE,
        DELETE_TEAMS;

    }
}

