/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001%\u0011\u0001cU9m'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u000b\u0005\r!\u0011!\u0003=me\u0016dW-Y:f\u0015\t)a!A\u0005yK\nL\u0017\r\\1cg*\tq!A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u0015I1\u0002CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!D*u_J\fw-\u001a$bG\u0006$W\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0013)\u0016\u001cH/Q;uQ\u0016tG/[2bi&|g\u000e\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u000351w\u000e\u001c3feN+'O^5dKB\u0011AdH\u0007\u0002;)\u0011aDA\u0001\bg\u0016\u0014h/[2f\u0013\t\u0001SDA\u0007G_2$WM]*feZL7-\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005qA/Z1n%\u0016\u0004xn]5u_JL\bC\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q\t\t!B]3q_NLGo\u001c:z\u0013\tQSEA\tTc2$V-Y7SKB|7/\u001b;pefD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bC\u0001\u00180\u001b\u00059\u0013B\u0001\u0019(\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0005\te\u0001\u0011\t\u0011)A\u0005g\u0005!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"\u0001\b\u001b\n\u0005Uj\"\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW\r\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\"!\u000f\u001f\u000e\u0003iR!aO\u0013\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003{i\u0012Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002/\u0003&\u0011!i\n\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pefD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0018G\u0006dWM\u001c3be\u0016sGO]=SKB|7/\u001b;pef\u0004\"A\f$\n\u0005\u001d;#aF\"bY\u0016tG-\u0019:F]R\u0014\u0018PU3q_NLGo\u001c:z\u0011!I\u0005A!A!\u0002\u0013Q\u0015\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\ta2*\u0003\u0002M;\t\u0001\u0012I]2iSZLgnZ*feZL7-\u001a\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKB\u0011\u0001+W\u0007\u0002#*\u0011!kU\u0001\u0005G>\u0014XM\u0003\u0002U+\u0006!!\u000e\u001a2d\u0015\t1v+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0016aA8sO&\u0011!,\u0015\u0002\r\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\u0005\u001br3w\r\u0005\u0002^I6\taL\u0003\u0002`A\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0014\u0017a\u00024bGR|'/\u001f\u0006\u0003GV\u000bQAY3b]NL!!\u001a0\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%\u00015\u00023ad'OU3q_NLGo\u001c:z\u0015\u0012\u00147\rV3na2\fG/\u001a\u0005\u0006U\u0002!\ta[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00151lgn\u001c9reN$X\u000f\u0005\u0002\u0014\u0001!)!$\u001ba\u00017!)!%\u001ba\u0001G!)A&\u001ba\u0001[!)!'\u001ba\u0001g!)q'\u001ba\u0001q!)q(\u001ba\u0001\u0001\")A)\u001ba\u0001\u000b\")\u0011*\u001ba\u0001\u0015\")a*\u001ba\u0001\u001f\"\"Q\u000f\u00184hQ\tI\u0007\u0010\u0005\u0002^s&\u0011!P\u0018\u0002\n\u0003V$xn^5sK\u0012DQ\u0001 \u0001\u0005Bu\fqa\u00197fC:,\b\u000fF\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q!!a\u0001\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0005+:LG\u000fC\u0004\u0002\f\u0001!\t%!\u0004\u0002\r\u0011,G.\u001a;f)\u0011\ty!!\u0006\u0011\u0007}\f\t\"\u0003\u0003\u0002\u0014\u0005\u0005!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003/\tI\u00011\u0001\u0002\u001a\u0005\u0011\u0011\u000e\u001a\t\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u0015\u0002\u0003BA\u0010\u0003\u0003i!!!\t\u000b\u0007\u0005\r\u0002\"\u0001\u0004=e>|GOP\u0005\u0005\u0003O\t\t!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003O\t\t\u0001C\u0004\u0002\f\u0001!\t%!\r\u0015\t\u0005=\u00111\u0007\u0005\t\u0003k\ty\u00031\u0001\u00028\u0005!A/Z1n!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f\u0005\u00051Am\\7bS:LA!!\u0011\u0002<\t!A+Z1n\u0011\u0019\t)\u0005\u0001C!{\u0006)b/\u001a:jMf\u0014V\r]8tSR|'/_\"mK\u0006t\u0007bBA%\u0001\u0011%\u00111J\u0001\u0010M&tG-\u00117m%\u0016dW-Y:fgV\u0011\u0011Q\n\t\u0007\u0003\u001f\n)&!\u0017\u000e\u0005\u0005E#bAA*\u001d\u0005!Q\u000f^5m\u0013\u0011\t9&!\u0015\u0003\t1K7\u000f\u001e\t\u0005\u0003s\tY&\u0003\u0003\u0002^\u0005m\"a\u0002*fY\u0016\f7/\u001a\u0005\u0007\u0003C\u0002A\u0011A?\u0002\u001d\rdW-\u00198YYZ+'o]5p]\"\"\u0011qLA3!\u0011\t9'a\u001c\u000e\u0005\u0005%$bA0\u0002l)\u0011\u0011QN\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003c\nIG\u0001\u0006Qe\u0016$Um\u001d;s_fD3\u0001AA;!\u0011\t9(! \u000e\u0005\u0005e$bAA>+\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005}\u0014\u0011\u0010\u0002\n\u0007>l\u0007o\u001c8f]RDc\u0001AABM\u0006E\u0005\u0003BAC\u0003\u001bk!!a\"\u000b\u0007}\u000bIIC\u0002\u0002\fV\u000bqaY8oi\u0016DH/\u0003\u0003\u0002\u0010\u0006\u001d%a\u0002)s_\u001aLG.\u001a\u0017\u0003\u0003'\u000b\u0013A\n")
public class SqlStorageFacade
implements StorageFacade,
TestAuthentication {
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    @Override
    public void cleanup() {
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.DEPENDENCIES$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecuritySchema.ROLES$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.CONFIGURATION_REFS$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.COMMENTS$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.TASKS$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM XLR_ACTIVITY_LOGS"})).s((Seq)Nil$.MODULE$));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.RELEASES_EXT$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM XLR_RISK_ASSESSMENTS"})).s((Seq)Nil$.MODULE$));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM XLR_RISKS"})).s((Seq)Nil$.MODULE$));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.RELEASES$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.ARTIFACTS$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE ", " <> ", " OR ", " <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.PATHS$.MODULE$.TABLE(), Schema.PATHS$.MODULE$.ANCESTOR_UID(), FolderRow.Root$.MODULE$.uid(), Schema.PATHS$.MODULE$.DESCENDANT_UID(), FolderRow.Root$.MODULE$.uid()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", " SET ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.FOLDERS$.MODULE$.TABLE(), Schema.FOLDERS$.MODULE$.SECURITY_UID(), FolderRow.Root$.MODULE$.uid()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE ", " <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.FOLDERS$.MODULE$.TABLE(), Schema.FOLDERS$.MODULE$.CI_UID(), FolderRow.Root$.MODULE$.uid()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MetadataSchema.METADATA$.MODULE$.TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE ", " <> 'admin'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema.USER_PROFILE$.MODULE$.TABLE(), Schema.USER_PROFILE$.MODULE$.USERNAME()})));
    }

    @Override
    public boolean delete(String id) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object;
            this.logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
            if (Ids.isReleaseId((String)id)) {
                if ($this.releaseRepository.exists(id)) {
                    try {
                        $this.teamRepository.deleteTeamsFromPlatform(id);
                    }
                    catch (NotFoundException e) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete teams of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), (Throwable)e);
                    }
                    $this.releaseRepository.delete(id);
                } else if ($this.archivingService.exists(id)) {
                    $this.archivingService.delete(id);
                }
                object = BoxedUnit.UNIT;
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
                object = BoxedUnit.UNIT;
            } else if (Ids.isPlanItemId((String)id)) {
                object = BoxedUnit.UNIT;
            } else if (Ids.isFolderId((String)id)) {
                if ($this.folderService.exists(id)) {
                    $this.folderService.delete(id);
                }
                object = BoxedUnit.UNIT;
            } else if (Ids.isCustomConfigurationId((String)id)) {
                object = BoxesRunTime.boxToBoolean((boolean)$this.configurationRepository.delete(id));
            } else if (Ids.isCalendarId((String)id)) {
                $this.calendarEntryRepository.delete(id);
                object = BoxedUnit.UNIT;
            } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                object = BoxesRunTime.boxToBoolean((boolean)$this.configurationRepository.delete(id));
            } else {
                if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Variable '", "' will be deleted once the parent release is deleted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                }
                object = BoxedUnit.UNIT;
            }
            return true;
        });
        if (try_ instanceof Success) {
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete CI with Id: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), e);
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting team ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{team.getId()})));
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void verifyRepositoryClean() {
        List<Release> releases = this.findAllReleases();
        if (releases.size() > 0) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " releases after test has finished: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releases.size()), ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).mkString(",")})));
        }
    }

    private List<Release> findAllReleases() {
        ReleasesFilters filters = new ReleasesFilters();
        filters.withPlanned();
        filters.withActive();
        filters.withInactive();
        return (List)this.withAuthentication((Authentication)new TestingAuthenticationToken((Object)"admin", (Object)""), (Function0 & Serializable & scala.Serializable)() -> {
            ReleaseSearchResult searchResults = $this.releaseSearchService.search(filters, 0L, Integer.MAX_VALUE);
            return searchResults.getReleases();
        });
    }

    @PreDestroy
    public void cleanXlVersion() {
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM XL_VERSION"})).s((Seq)Nil$.MODULE$));
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.jdbcTemplate = jdbcTemplate;
        TestAuthentication.$init$((TestAuthentication)this);
    }
}

