/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.utils.BaseConditionAwaiter;
import java.util.Set;
import nl.javadude.t2bus.Subscribe;

public class TaskCommentsAwaiter
extends BaseConditionAwaiter {
    private String taskId;
    private int expectedNumComments;
    private Set<Comment> comments = Sets.newHashSet();

    public TaskCommentsAwaiter(XLReleaseEventBus eventBus, String taskId, int expectedNumComments) {
        this(eventBus, taskId, expectedNumComments, 3000L);
    }

    public TaskCommentsAwaiter(XLReleaseEventBus eventBus, String taskId, int expectedNumComments, long timeout) {
        super(eventBus, timeout);
        this.expectedNumComments = expectedNumComments;
        this.taskId = taskId;
    }

    @Override
    protected String getErrorMessage() {
        return String.format("task %s did not have %s comments within timeout", this.taskId, this.expectedNumComments);
    }

    @Subscribe
    public void onCommentCreatedEvent(CisCreatedEvent event) {
        event.getCis().stream().filter(ci -> ci instanceof Comment).map(ci -> (Comment)ci).filter(comment -> comment.getId().contains(this.taskId)).forEach(comment -> {
            this.comments.add((Comment)comment);
            if (this.comments.size() >= this.expectedNumComments) {
                this.latch.countDown();
            }
        });
    }

    @Subscribe
    public void onCommentCreatedXlrEvent(CommentCreatedEvent commentCreatedEvent) {
        Comment comment = commentCreatedEvent.comment();
        if (commentCreatedEvent.task().getId().equals(this.taskId)) {
            this.comments.add(comment);
        }
        if (this.comments.size() >= this.expectedNumComments) {
            this.latch.countDown();
        }
    }
}

