/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eventually {
    private static final int TIMEOUT_MS = 45000;
    private final XlrRepository xlrRepository;
    private final long timeoutMs;
    private static final Logger log = LoggerFactory.getLogger(Eventually.class);

    public Eventually(XlrRepository xlrRepository) {
        this.xlrRepository = xlrRepository;
        this.timeoutMs = 45000L;
    }

    public <T extends Task> EventuallyTask<T> task(String taskId) {
        return new EventuallyTask(taskId);
    }

    public EventuallyRelease release(String releaseId) {
        return new EventuallyRelease(releaseId);
    }

    public <R> R eventually(XlrRepositoryCommand<R> command, Predicate<R> predicate) {
        return (R)this.eventually(() -> this.xlrRepository.handle(command), predicate);
    }

    public <R> R eventually(Supplier<R> supplier, Predicate<R> predicate) {
        try {
            return (R)CompletableFuture.supplyAsync(() -> {
                long start = System.currentTimeMillis();
                Exception lastException = null;
                while (true) {
                    try {
                        while (true) {
                            Object handle;
                            if (predicate.test(handle = supplier.get())) {
                                return handle;
                            }
                            long duration = System.currentTimeMillis() - start;
                            if (duration > this.timeoutMs) {
                                throw new AssertionError("Could not complete within " + this.timeoutMs + " millis", lastException);
                            }
                            Thread.sleep(250L);
                        }
                    }
                    catch (Exception store) {
                        lastException = store;
                        continue;
                    }
                    break;
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class EventuallyRelease {
        private String releaseId;

        public EventuallyRelease(String releaseId) {
            this.releaseId = releaseId;
        }

        public Release hasStatus(ReleaseStatus status) {
            return Eventually.this.eventually(new ReleaseGetCommand(this.releaseId, Integer.valueOf(Integer.MAX_VALUE), false, null), release -> release.getStatus() == status);
        }

        public Release hasOneOfStatus(List<ReleaseStatus> statuses) {
            return Eventually.this.eventually(new ReleaseGetCommand(this.releaseId, Integer.valueOf(Integer.MAX_VALUE), false, null), release -> statuses.contains(release.getStatus()));
        }
    }

    public class EventuallyTask<T extends Task> {
        private String taskId;

        public EventuallyTask(String taskId) {
            this.taskId = taskId;
        }

        public T hasStatus(TaskStatus status) {
            return (T)Eventually.this.eventually(new TaskGetCommand(this.taskId), task -> task.getStatus() == status);
        }

        public T hasOneOfStatus(List<TaskStatus> statuses) {
            return (T)Eventually.this.eventually(new TaskGetCommand(this.taskId), task -> statuses.contains(task.getStatus()));
        }

        public T hasComments(int numberOfComments) {
            return (T)Eventually.this.eventually(new TaskGetCommand(this.taskId), task -> task.getComments().size() == numberOfComments);
        }
    }
}

