/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.xebialabs.xlrelease.builder.FolderBuilder;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.initialize.RootInitializer;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.rules.XlrExternalResource;
import com.xebialabs.xlrelease.service.FolderService;

public class SqlTestInDirectoryRule
extends XlrExternalResource {
    private String directoryId;
    private FolderService folderService;
    private RootInitializer rootInitializer;

    public SqlTestInDirectoryRule(String directoryId, FolderService folderService, RootInitializer rootInitializer) {
        this.directoryId = directoryId;
        this.folderService = folderService;
        this.rootInitializer = rootInitializer;
    }

    @Override
    public void before() {
        this.rootInitializer.createRootDirectories();
        if (!this.directoryId.equals(Ids.ROOT_FOLDER_ID)) {
            if (this.folderService.exists(this.directoryId)) {
                this.folderService.delete(this.directoryId);
            }
            Folder folder = FolderBuilder.newFolder().withId(this.directoryId).withTitle(Ids.getName((String)this.directoryId)).build();
            if (!Ids.ROOT_FOLDER_ID.equals(Ids.getParentId((String)this.directoryId))) {
                throw new IllegalArgumentException(String.format("We did not expect to create a folder '%s' which is not a child of root '%s'. If it's really needed implement it.", this.directoryId, Ids.ROOT_FOLDER_ID));
            }
            this.folderService.create(Ids.getParentId((String)this.directoryId), folder);
        }
    }

    @Override
    public void after() {
        if (!this.directoryId.equals(Ids.ROOT_FOLDER_ID)) {
            this.folderService.delete(this.directoryId);
        }
    }
}

