/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.initialize.RootInitializer;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.rules.XlrExternalResource;

public class JcrTestInDirectoryRule
extends XlrExternalResource {
    private String directoryId;
    private RepositoryService repositoryService;
    private boolean useCache;

    public JcrTestInDirectoryRule(String directoryId, RepositoryService repositoryService, boolean useCache) {
        this.directoryId = directoryId;
        this.repositoryService = repositoryService;
        this.useCache = useCache;
    }

    public static JcrTestInDirectoryRule newDirectory(String directoryId, RepositoryService repositoryService) {
        return JcrTestInDirectoryRule.newDirectory(directoryId, repositoryService, true);
    }

    public static JcrTestInDirectoryRule newDirectory(String directoryId, RepositoryService repositoryService, boolean useCache) {
        return new JcrTestInDirectoryRule(directoryId, repositoryService, useCache);
    }

    @Override
    public void before() throws Exception {
        this.createAllDirectories();
        if (this.useCache) {
            NodeReaderContext.get().hold();
        }
    }

    @Override
    public void after() {
        if (this.useCache) {
            NodeReaderContext.get().release();
        }
        this.removeDirectory();
    }

    private void createAllDirectories() {
        this.createCurrentDirectory();
        new RootInitializer(this.repositoryService).createRootDirectories();
    }

    private void createCurrentDirectory() {
        if (!this.directoryId.equals(Ids.ROOT_FOLDER_ID)) {
            if (this.repositoryService.exists(this.directoryId)) {
                this.removeDirectory();
            }
            Directory directory = (Directory)Type.valueOf(Directory.class).getDescriptor().newInstance(this.directoryId);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }

    private void removeDirectory() {
        if (!this.directoryId.equals(Ids.ROOT_FOLDER_ID)) {
            this.repositoryService.delete(new String[]{this.directoryId});
        }
    }
}

