/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.GateConditionGetCommand;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseGetCommand;
import com.xebialabs.xlrelease.repository.PhaseUpdateCommand;
import com.xebialabs.xlrelease.repository.PlanItemByIdQuery;
import com.xebialabs.xlrelease.repository.ReleaseCreateCommand;
import com.xebialabs.xlrelease.repository.ReleaseDeleteCommand;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseUpdateCommand;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.TaskCreateCommand;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.TaskPropertyUpdateCommand;
import com.xebialabs.xlrelease.repository.TaskUpdateCommand;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.VariableGetCommand;
import com.xebialabs.xlrelease.repository.Variables;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import com.xebialabs.xlrelease.repository.XlrRepositoryQuery;
import com.xebialabs.xlrelease.rules.LoginRule;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ChangesUpdatesConverter;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import com.xebialabs.xlrelease.utils.Eventually;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.util.StringUtils;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=JUnit4.class)
@ContextConfiguration(locations={"/spring/xlrelease-context-test.xml", "classpath:springmvc-resteasy.xml"}, initializers={XlrWebApplicationInitializer.class})
@WebAppConfiguration(value="src/test/resources")
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseIntegrationTest.class);
    @ClassRule
    public static final SpringClassRule SPRING_CLASS_RULE = new SpringClassRule();
    @Rule
    public final SpringMethodRule springMethodRule = new SpringMethodRule();
    private List<String> cisForDeletion = new ArrayList<String>();
    private List<Team> teamsForDeletion = new ArrayList<Team>();
    @Autowired
    public RepositoryService repositoryService;
    @Autowired
    public FolderService folderService;
    @Autowired
    public XlrRepository xlrRepository;
    @Autowired
    public XlrQueries xlrQueries;
    @Autowired
    public Releases releases;
    @Autowired
    public Eventually eventually;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Autowired
    private Teams teams;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    @Autowired
    private Variables variablesRepository;
    @Autowired
    private StorageFacade storageFacade;
    @Qualifier(value="reportingJdbcTemplate")
    @Autowired
    private JdbcTemplate reportingJdbcTemplate;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void before() {
        logger.debug("XLReleaseIntegrationTest 'before' started");
        if (StringUtils.hasText((String)this.testName.getMethodName())) {
            MDC.put((String)"testName", (String)this.testName.getMethodName());
        }
        XLReleasePermissions.init();
        LoginRule.grantAdminPermissionTo((String)"admin", (PermissionEditor)this.permissionEditor, (RoleService)this.roleService);
        this.variablesRepository.findGlobalVariablesOrEmpty().getVariables().forEach(ci -> this.variablesRepository.deleteGlobalVariable(ci.getId()));
        this.terminateReleaseActors(FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
        this.storageFacade.verifyRepositoryClean();
        logger.debug("XLReleaseIntegrationTest 'before' finished");
    }

    @After
    public void tearDown() throws Exception {
        try {
            logger.debug("XLReleaseIntegrationTest 'after' started");
            this.terminateReleaseActors(FiniteDuration.apply((long)15L, (TimeUnit)TimeUnit.SECONDS));
            this.deleteCis();
            this.storageFacade.cleanup();
            this.storageFacade.cleanActivityLogs();
            this.storageFacade.verifyRepositoryClean();
            this.deleteArchivedReleases();
            logger.debug("XLReleaseIntegrationTest 'after' finished");
        }
        catch (Throwable t) {
            logger.error("Test '{}' tearDown failed.", (Object)MDC.get((String)"testName"), (Object)t);
            throw t;
        }
        finally {
            this.cisForDeletion.clear();
            this.teamsForDeletion.clear();
            if (StringUtils.hasText((String)this.testName.getMethodName())) {
                MDC.remove((String)"testName");
            }
        }
    }

    private void terminateReleaseActors(FiniteDuration apply) {
        try {
            this.releaseActorLifecycleUtils.terminateAllReleaseActorsAndAwait(apply);
        }
        catch (Exception ex) {
            logger.error("Timed out while terminating actors, try increasing the timeout", (Throwable)ex);
        }
    }

    private void deleteArchivedReleases() {
        this.reportingJdbcTemplate.execute("DELETE FROM RELEASES");
    }

    protected void verifyRepositoryClean() {
        this.storageFacade.verifyRepositoryClean();
    }

    private void deleteCis() {
        this.teamsForDeletion.stream().distinct().collect(Collectors.toList()).removeIf(t -> this.storageFacade.delete((Team)t));
        this.cisForDeletion = this.cisForDeletion.stream().distinct().collect(Collectors.toList());
        this.cisForDeletion.removeIf(id -> Ids.isDependencyId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> this.isPhaseOrTask((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isReleaseId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isConfigurationId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
        this.cisForDeletion.removeIf(id -> !Ids.isReleaseId((String)id) && !Ids.isConfigurationId((String)id) && !Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
    }

    private boolean isPhaseOrTask(String id) {
        return Ids.isPlanItemId((String)id) && !Ids.isReleaseId((String)id);
    }

    protected void deleteOnTearDown(ConfigurationItem ... items) {
        for (ConfigurationItem item : items) {
            this.deleteOnTearDown(item.getId());
        }
    }

    protected void deleteOnTearDown(String ... ids) {
        Collections.addAll(this.cisForDeletion, ids);
    }

    public void markForDeletion(ConfigurationItem item) {
        this.markForDeletion(item.getId());
    }

    public void markForDeletion(String ciId) {
        this.cisForDeletion.add(ciId);
    }

    public void markForDeletion(Team team) {
        this.teamsForDeletion.add(team);
    }

    public void deleteOrder(ConfigurationItem ... items) {
        this.cisForDeletion = Stream.concat(Arrays.asList(items).stream().map(ConfigurationItem::getId), this.cisForDeletion.stream()).collect(Collectors.toList());
    }

    public void createCisAndSaveTeams(ConfigurationItem ... cis) {
        this.createCisAndSaveTeams(Arrays.asList(cis));
    }

    public void deleteReleaseXlrRepo(List<String> releaseIds) {
        releaseIds.forEach(this::deleteReleaseXlrRepo);
    }

    public void deleteReleaseXlrRepo(String ... releaseIds) {
        this.deleteReleaseXlrRepo(Arrays.asList(releaseIds));
    }

    public void deleteReleaseXlrRepo(String releaseId) {
        this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseDeleteCommand(releaseId));
    }

    public void storeReleaseXlrRepo(Release ... releases) {
        this.storeReleaseXlrRepo(Arrays.asList(releases));
    }

    public void storeReleaseXlrRepo(List<Release> releases) {
        releases.forEach(this::storeReleaseXlrRepo);
    }

    public void storeChangesXlrRepo(Changes changes) {
        this.xlrRepository.handle((XlrRepositoryCommand)ChangesUpdatesConverter.toCommands((Changes)changes));
    }

    public <T extends Task> T getTaskXlrRepo(String taskId) {
        return (T)((Task)this.xlrRepository.handle((XlrRepositoryCommand)new TaskGetCommand(taskId)));
    }

    public void createTaskXlrRepo(Task task) {
        this.xlrRepository.handle((XlrRepositoryCommand)new TaskCreateCommand(task, Collections.emptyList()));
    }

    public void updateTaskXlrRepo(Task task) {
        this.xlrRepository.handle((XlrRepositoryCommand)new TaskUpdateCommand(task, task, Collections.emptyList(), Collections.emptyList(), task.getRelease(), Collections.emptyList()));
    }

    public void updateTaskPropertyXlrRepo(Task task) {
        this.xlrRepository.handle((XlrRepositoryCommand)new TaskPropertyUpdateCommand(task, task, Collections.emptyList()));
    }

    public Phase getPhaseXlrRepo(String phaseId) {
        return (Phase)this.xlrRepository.handle((XlrRepositoryCommand)new PhaseGetCommand(phaseId));
    }

    public void updatePhaseXlrRepo(Phase phase) {
        this.xlrRepository.handle((XlrRepositoryCommand)new PhaseUpdateCommand(phase, phase, Collections.emptyList()));
    }

    public void updateReleaseXlRepo(Release release) {
        this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseUpdateCommand(release, release, Collections.emptyList()));
    }

    public Release storeReleaseXlrRepo(Release release) {
        return this.storeReleaseXlrRepo(release, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Release storeReleaseXlrRepo(Release release, DeleteOption ... deleteOptions) {
        Release stored = (Release)this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseCreateCommand(release, (ReleaseCreationSource)new CreatedWithoutTemplate()));
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_RELEASE)) {
            this.markForDeletion((ConfigurationItem)stored);
        }
        logger.warn("Saving teams: {}", (Object)stored.getTeams().stream().map(BaseConfigurationItem::getId).collect(Collectors.joining(",")));
        List savedTeams = this.teams.saveTeamsToPlatform(stored);
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_TEAMS)) {
            savedTeams.forEach(this::markForDeletion);
        }
        return stored;
    }

    private boolean optionHas(DeleteOption[] deleteOptions, DeleteOption option) {
        return Arrays.asList(deleteOptions).contains((Object)option);
    }

    public Variable getVariableXlrRepo(String variableId) {
        return (Variable)this.xlrRepository.handle((XlrRepositoryCommand)new VariableGetCommand(variableId));
    }

    public Release getReleaseXlrRepo(String releaseId) {
        return (Release)this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseGetCommand(releaseId, Integer.valueOf(Integer.MAX_VALUE), false, null));
    }

    public Release getReleaseXlrRepo(String releaseId, WorkDir workDir) {
        return (Release)this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseGetCommand(releaseId, Integer.valueOf(Integer.MAX_VALUE), false, workDir));
    }

    public GateCondition getGateConditionXlrRepo(String conditionId) {
        return (GateCondition)this.xlrRepository.handle((XlrRepositoryCommand)new GateConditionGetCommand(conditionId));
    }

    public PlanItem getPlanItem(String planItemId) {
        return (PlanItem)this.xlrQueries.query((XlrRepositoryQuery)new PlanItemByIdQuery(planItemId, Integer.valueOf(Integer.MAX_VALUE)));
    }

    public void createCisAndSaveTeams(Collection<ConfigurationItem> cis) {
        this.storageFacade.createCisAndSaveTeams(this.teams, cis);
    }

    public String createRole(String roleName) {
        Role role = new Role(roleName);
        List allRoles = this.roleService.readRoleAssignments();
        allRoles.add(role);
        this.roleService.writeRoleAssignments(allRoles);
        return roleName;
    }

    public String encrypt(String password) {
        if (null != password && !XlrConfig.getInstance().repository_decryptPasswords()) {
            return PasswordEncrypter.getInstance().ensureEncrypted(password);
        }
        return password;
    }

    protected void assumeJNotSql() {
        Assume.assumeFalse((String)"this test doesn't make sense on SQL", (boolean)XlrConfig.getInstance().isSqlRepositoryEnabled());
    }

    private void tryDeleteRelease(Release ci) {
        try {
            this.storageFacade.delete(ci.getId());
        }
        catch (Throwable t) {
            logger.warn("Unable to delete release '{}'", (Object)ci.getId(), (Object)t);
        }
    }

    public static enum DeleteOption {
        DELETE_NONE,
        DELETE_RELEASE,
        DELETE_TEAMS;

    }
}

