/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.DependenciesSqlRepository;
import com.xebialabs.xlrelease.repository.DependenciesSqlRepository$;
import com.xebialabs.xlrelease.repository.FolderSchema;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseDeleteCommand;
import com.xebialabs.xlrelease.repository.ReleaseExistsQuery;
import com.xebialabs.xlrelease.repository.ReleasesDeleteUnderFolderCommand;
import com.xebialabs.xlrelease.repository.ReleasesSqlRepository$;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import com.xebialabs.xlrelease.repository.XlrRepositoryQuery;
import com.xebialabs.xlrelease.repository.data.FolderData;
import com.xebialabs.xlrelease.repository.sql.SqlTeams;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Profile(value={"sql"})
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001%\u0011\u0001cU9m'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u000b\u0005\r!\u0011!\u0003=me\u0016dW-Y:f\u0015\t)a!A\u0005yK\nL\u0017\r\\1cg*\tq!A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u0015I1\u0002CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!D*u_J\fw-\u001a$bG\u0006$W\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0013)\u0016\u001cH/Q;uQ\u0016tG/[2bi&|g\u000e\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u000351w\u000e\u001c3feN+'O^5dKB\u0011AdH\u0007\u0002;)\u0011aDA\u0001\bg\u0016\u0014h/[2f\u0013\t\u0001SDA\u0007G_2$WM]*feZL7-\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005)A/Z1ngB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0004gFd'B\u0001\u0015\u0003\u0003)\u0011X\r]8tSR|'/_\u0005\u0003U\u0015\u0012\u0001bU9m)\u0016\fWn\u001d\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005i\u0001\u0010\u001c:SKB|7/\u001b;pef\u0004\"AL\u0018\u000e\u0003\u001dJ!\u0001M\u0014\u0003\u001bac'OU3q_NLGo\u001c:z\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014A\u0003=meF+XM]5fgB\u0011a\u0006N\u0005\u0003k\u001d\u0012!\u0002\u00177s#V,'/[3t\u0011!9\u0004A!A!\u0002\u0013A\u0014\u0001\u0006:fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW\r\u0005\u0002\u001ds%\u0011!(\b\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\t\u0011q\u0002!\u0011!Q\u0001\nu\n\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f!\tq$)D\u0001@\u0015\tA\u0003I\u0003\u0002B\t\u0005AA-\u001a9m_fLG/\u0003\u0002D\u007f\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019\u000b\u0011\u0004Z3qK:$WM\\2jKN\u001c\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ssB\u0011afR\u0005\u0003\u0011\u001e\u0012\u0011\u0004R3qK:$WM\\2jKN\u001c\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\"A!\n\u0001B\u0001B\u0003%1*\u0001\u0007kI\n\u001cG+Z7qY\u0006$X\r\u0005\u0002M+6\tQJ\u0003\u0002O\u001f\u0006!1m\u001c:f\u0015\t\u0001\u0016+\u0001\u0003kI\n\u001c'B\u0001*T\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W\u001b\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\"\u0011\n\u00172d!\tI\u0006-D\u0001[\u0015\tYF,\u0001\u0006b]:|G/\u0019;j_:T!!\u00180\u0002\u000f\u0019\f7\r^8ss*\u0011q,U\u0001\u0006E\u0016\fgn]\u0005\u0003Cj\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003\u0011\f\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\")a\r\u0001C\u0001O\u00061A(\u001b8jiz\"\u0012\u0002[5kW2lgn\u001c9\u0011\u0005M\u0001\u0001\"\u0002\u000ef\u0001\u0004Y\u0002\"\u0002\u0012f\u0001\u0004\u0019\u0003\"\u0002\u0017f\u0001\u0004i\u0003\"\u0002\u001af\u0001\u0004\u0019\u0004\"B\u001cf\u0001\u0004A\u0004\"\u0002\u001ff\u0001\u0004i\u0004\"B#f\u0001\u00041\u0005\"\u0002&f\u0001\u0004Y\u0005\u0006\u00029YE\u000eD#!Z:\u0011\u0005e#\u0018BA;[\u0005%\tU\u000f^8xSJ,G\rC\u0003x\u0001\u0011\u0005\u00030A\u0004dY\u0016\fg.\u001e9\u0015\u0003e\u0004\"A_?\u000e\u0003mT\u0011\u0001`\u0001\u0006g\u000e\fG.Y\u0005\u0003}n\u0014A!\u00168ji\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011A\u00023fY\u0016$X\r\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001>\u0002\b%\u0019\u0011\u0011B>\u0003\u000f\t{w\u000e\\3b]\"9\u0011QB@A\u0002\u0005=\u0011AA5e!\u0011\t\t\"a\b\u000f\t\u0005M\u00111\u0004\t\u0004\u0003+YXBAA\f\u0015\r\tI\u0002C\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u10\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\t\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;Y\bbBA\u0001\u0001\u0011\u0005\u0013q\u0005\u000b\u0005\u0003\u000b\tI\u0003\u0003\u0005\u0002,\u0005\u0015\u0002\u0019AA\u0017\u0003\u0011!X-Y7\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r\u0003\u0003\u0019!w.\\1j]&!\u0011qGA\u0019\u0005\u0011!V-Y7\t\r\u0005m\u0002\u0001\"\u0011y\u0003E\u0019G.Z1o\u0003\u000e$\u0018N^5us2{wm\u001d\u0005\b\u0003\u007f\u0001A\u0011IA!\u0003U\u0019'/Z1uK\u000eK7/\u00118e'\u00064X\rV3b[N$R!_A\"\u0003\u0017BqAIA\u001f\u0001\u0004\t)\u0005E\u0002/\u0003\u000fJ1!!\u0013(\u0005\u0015!V-Y7t\u0011!\ti%!\u0010A\u0002\u0005=\u0013aA2jgB1\u0011\u0011KA,\u00037j!!a\u0015\u000b\u0007\u0005Uc\"\u0001\u0003vi&d\u0017\u0002BA-\u0003'\u0012!bQ8mY\u0016\u001cG/[8o!\u0011\ti&a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\n1!\u001e3n\u0015\u0011\t)'a\u001a\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002j\u0001\u000ba\u0001\u001d7vO&t\u0017\u0002BA7\u0003?\u0012\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u0019\t\t\b\u0001C!q\u0006)b/\u001a:jMf\u0014V\r]8tSR|'/_\"mK\u0006t\u0007bBA;\u0001\u0011%\u0011qO\u0001\u0010M&tG-\u00117m%\u0016dW-Y:fgV\u0011\u0011\u0011\u0010\t\u0007\u0003#\nY(a \n\t\u0005u\u00141\u000b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00020\u0005\u0005\u0015\u0002BAB\u0003c\u0011qAU3mK\u0006\u001cX\rK\u0002\u0001\u0003\u000f\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u000b\u0016AC:uKJ,w\u000e^=qK&!\u0011\u0011SAF\u0005%\u0019u.\u001c9p]\u0016tG\u000f\u000b\u0004\u0001\u0003+\u0013\u00171\u0015\t\u0005\u0003/\u000by*\u0004\u0002\u0002\u001a*\u00191,a'\u000b\u0007\u0005u\u0015+A\u0004d_:$X\r\u001f;\n\t\u0005\u0005\u0016\u0011\u0014\u0002\b!J|g-\u001b7fY\t\t)+I\u0001'\u0001")
public class SqlStorageFacade
implements StorageFacade,
TestAuthentication {
    private final FolderService folderService;
    private final SqlTeams teams;
    private final XlrRepository xlrRepository;
    private final XlrQueries xlrQueries;
    private final ReleaseSearchService releaseSearchService;
    private final RepositoryService repositoryService;
    private final DependenciesSqlRepository dependenciesSqlRepository;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    @Override
    public void cleanup() {
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM SEC_ROLES"})).s((Seq)Nil$.MODULE$));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM SEC_ROLE_ROLES"})).s((Seq)Nil$.MODULE$));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM SEC_ROLE_PRINCIPALS"})).s((Seq)Nil$.MODULE$));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReleasesSqlRepository$.MODULE$.ARTIFACTS_TABLE()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE ", " <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FolderSchema.FOLDERS$.MODULE$.TABLE(), FolderSchema.FOLDERS$.MODULE$.ciUid(), FolderData.Root$.MODULE$.uid()})));
        this.jdbcTemplate.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE ", " <> ", " AND ", " <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FolderSchema.PATHS$.MODULE$.TABLE(), FolderSchema.PATHS$.MODULE$.ancestorUid(), FolderData.Root$.MODULE$.uid(), FolderSchema.PATHS$.MODULE$.descendantUid(), FolderData.Root$.MODULE$.uid()})));
    }

    @Override
    public boolean delete(String id) {
        Object object;
        this.logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
        if (Ids.isReleaseId((String)id)) {
            if (Predef$.MODULE$.Boolean2boolean((Boolean)this.xlrQueries.query((XlrRepositoryQuery)new ReleaseExistsQuery(id)))) {
                try {
                    this.teams.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete teams of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), (Throwable)e);
                }
                object = this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseDeleteCommand(id));
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            if (Ids.isDependencyId((String)id)) {
                this.dependenciesSqlRepository.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if (this.folderService.exists(id)) {
                        this.xlrRepository.handle((XlrRepositoryCommand)new ReleasesDeleteUnderFolderCommand(id));
                        this.teams.deleteTeamsFromPlatform(id);
                        this.folderService.delete(id);
                    }
                } else if (Ids.isConfigurationId((String)id)) {
                    this.repositoryService.delete(new String[]{id});
                } else {
                    this.repositoryService.delete(new String[]{id});
                }
            }
            object = BoxedUnit.UNIT;
        }
        return true;
    }

    @Override
    public boolean delete(Team team) {
        this.logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting team ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{team.getId()})));
        this.teams.delete(team.getId());
        return true;
    }

    @Override
    public void cleanActivityLogs() {
    }

    @Override
    public void createCisAndSaveTeams(Teams teams, Collection<ConfigurationItem> cis) {
        throw new IllegalStateException("method createCisAndSaveTeams should not be called from SQL profile tests");
    }

    @Override
    public void verifyRepositoryClean() {
        List<Release> releases = this.findAllReleases();
        if (releases.size() > 0) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " releases after test has finished: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releases.size()), ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).mkString(",")})));
        }
    }

    private List<Release> findAllReleases() {
        ReleasesFilters filters = new ReleasesFilters();
        filters.withPlanned();
        filters.withActive();
        filters.withInactive();
        return (List)this.withAuthentication((Authentication)new TestingAuthenticationToken((Object)"admin", (Object)""), (Function0 & Serializable & scala.Serializable)() -> {
            ReleaseSearchResult searchResults = $this.releaseSearchService.search(filters, 0L, Integer.MAX_VALUE);
            return searchResults.getReleases();
        });
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeams teams, XlrRepository xlrRepository, XlrQueries xlrQueries, ReleaseSearchService releaseSearchService, RepositoryService repositoryService, DependenciesSqlRepository dependenciesSqlRepository, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate) {
        this.folderService = folderService;
        this.teams = teams;
        this.xlrRepository = xlrRepository;
        this.xlrQueries = xlrQueries;
        this.releaseSearchService = releaseSearchService;
        this.repositoryService = repositoryService;
        this.dependenciesSqlRepository = dependenciesSqlRepository;
        this.jdbcTemplate = jdbcTemplate;
        TestAuthentication.$init$((TestAuthentication)this);
    }
}

