/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.initialize.RootInitializer;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Teams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"!sql"})
@Component
public class JcrStorageFacade
implements StorageFacade {
    private RepositoryService repositoryService;
    private Teams teams;

    @Autowired
    public JcrStorageFacade(RepositoryService repositoryService, Teams teams) {
        this.repositoryService = repositoryService;
        this.teams = teams;
    }

    private void deleteAllByType(Class<? extends ConfigurationItem> clazz) {
        List allItems = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(clazz)));
        allItems.forEach(f -> this.repositoryService.delete(new String[]{f.getId()}));
    }

    @Override
    public void cleanup() {
        this.deleteAllByType(Team.class);
        this.deleteAllByType(Dependency.class);
        this.deleteAllByType(Release.class);
        this.deleteAllByType(Folder.class);
    }

    @Override
    public boolean delete(String id) {
        this.repositoryService.delete(new String[]{id});
        return true;
    }

    @Override
    public boolean delete(Team team) {
        this.teams.delete(team.getId());
        return true;
    }

    @Override
    public void cleanActivityLogs() {
        if (this.repositoryService.exists(RootInitializer.ACTIVITY_LOGS_DIR())) {
            this.repositoryService.delete(new String[]{RootInitializer.ACTIVITY_LOGS_DIR()});
        }
    }

    @Override
    public void createCisAndSaveTeams(Teams teams, Collection<ConfigurationItem> cis) {
        List cisWithoutTeams = cis.stream().filter(ci -> !ci.getType().instanceOf(Type.valueOf(Team.class))).collect(Collectors.toList());
        this.repositoryService.createCollection(cisWithoutTeams);
        this.saveTeams(cis, teams);
    }

    @Override
    public void verifyRepositoryClean() {
        List<Team> teams = this.findAllTeams();
        teams.forEach(this::delete);
        List<Release> cis = this.findAllReleases();
        cis.forEach(this::tryDeleteRelease);
        if (teams.size() > 0) {
            throw new RuntimeException(String.format("Found %s teams after test has finished: %s", teams.size(), this.idList(teams)));
        }
        if (cis.size() > 0) {
            throw new RuntimeException(String.format("Found %s releases after the test has finished: %s", cis.size(), this.idList(cis)));
        }
    }

    private String idList(List<? extends BaseConfigurationItem> cis) {
        return cis.stream().map(BaseConfigurationItem::getId).collect(Collectors.joining(","));
    }

    private void tryDeleteRelease(Release ci) {
        try {
            this.delete(ci.getId());
        }
        catch (Throwable t) {
            this.logger().warn("Unable to delete release '{}'", (Object)ci.getId(), (Object)t);
        }
    }

    private List<Release> findAllReleases() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setAncestor("Applications");
        searchParameters.setType(Type.valueOf(Release.class));
        List releasesAndTemplates = this.repositoryService.listEntities(searchParameters);
        searchParameters.addProperty("status", ReleaseStatus.TEMPLATE.name());
        List templates = this.repositoryService.listEntities(searchParameters);
        return releasesAndTemplates.stream().filter(r -> !templates.contains(r)).collect(Collectors.toList());
    }

    private List<Team> findAllTeams() {
        return this.repositoryService.listEntities(new SearchParameters().setType(Type.valueOf(Team.class)));
    }

    private void saveTeams(Collection<ConfigurationItem> entities, Teams teams) {
        HashMap<String, List> containersToTeams = new HashMap<String, List>();
        entities.stream().filter(entity -> Type.valueOf(Team.class).equals((Object)entity.getType())).forEach(team -> {
            String containerId = Ids.getParentId((String)team.getId());
            containersToTeams.computeIfAbsent(containerId, s -> new ArrayList()).add((Team)team);
        });
        containersToTeams.forEach((arg_0, arg_1) -> ((Teams)teams).saveTeamsToPlatform(arg_0, arg_1));
    }
}

