package com.xebialabs.xlrelease.utils

import com.xebialabs.xlrelease.XLReleaseScalaTestTrait
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord
import com.xebialabs.xlrelease.repository.FacetRepository
import com.xebialabs.xlrelease.repository.FacetRepository.SpecializedFacetRepository

import java.util.Date

trait DateIntegrationUtils { self: XLReleaseScalaTestTrait =>

  def relaxedTimeComparison(date1: Date, date2: Date, toleranceInMs: Long): Unit = {
    val diff = Math.abs(date1.getTime - date2.getTime)
    diff < toleranceInMs shouldBe true
  }

  def setCreationDate[R <: TaskReportingRecord](repository: SpecializedFacetRepository, record: R): Unit = {
    repository match {
      case _: FacetRepository.ForArchive =>
        record.setCreationDate(new Date)
      case _ => ()
    }
  }

}
