package com.xebialabs.xlrelease.rules;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.junit.rules.ExternalResource;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;

public class HttpProxyRule extends ExternalResource {

    private static HttpProxyServer proxyServer;

    @Override
    protected void before() throws Throwable {
        ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getLocalHost());
        int port = serverSocket.getLocalPort();
        serverSocket.close();
        proxyServer = DefaultHttpProxyServer.bootstrap()
                .withAllowLocalOnly(true)
                .withPort(port)
                .withProxyAuthenticator(proxyAuthenticator())
                .start();
    }

    @Override
    protected void after() {
        if (null != proxyServer) {
            proxyServer.stop();
        }
    }

    public String getHost() {
        return proxyServer.getListenAddress().getHostName();
    }

    public int getPort() {
        return proxyServer.getListenAddress().getPort();
    }


    private static ProxyAuthenticator proxyAuthenticator() {
        return new ProxyAuthenticator() {
            @Override
            public boolean authenticate(final String userName, final String password) {
                if ("admin".equals(userName) && "validPassword".equals(password)) {
                    return true;
                }
                return false;
            }

            @Override
            public String getRealm() {
                return "default";
            }
        };
    }

}
