/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.events.PhaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.TaskExecutionEvent;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.utils.BaseConditionAwaiter;
import java.util.List;

class PlanItemStatusAwaiter<S>
extends BaseConditionAwaiter {
    private String planItemId;
    private List<S> expectedStatuses;

    PlanItemStatusAwaiter(XLReleaseEventBus eventBus, String planItemId, List<S> statuses, long timeout) {
        super(eventBus, timeout);
        this.planItemId = planItemId;
        this.expectedStatuses = statuses;
    }

    @Override
    protected String getErrorMessage() {
        return String.format("%s did not reach expected status %s within %d milliseconds", this.planItemId, this.expectedStatuses, this.timeout);
    }

    @SynchronizedSubscribe
    public void onEvent(CiBaseEvent event) {
        List cis = event.getCis();
        cis.forEach(this::doneIfExpectedPlanItemAndStatus);
    }

    @SynchronizedSubscribe
    public void onReleaseExecutionEvent(ReleaseExecutionEvent event) {
        this.doneIfExpectedPlanItemAndStatus((ConfigurationItem)event.release());
    }

    @SynchronizedSubscribe
    public void onPhaseExecutionEvent(PhaseExecutionEvent event) {
        this.doneIfExpectedPlanItemAndStatus((ConfigurationItem)event.phase());
    }

    @SynchronizedSubscribe
    public void onTaskExecutionEvent(TaskExecutionEvent event) {
        this.doneIfExpectedPlanItemAndStatus((ConfigurationItem)event.task());
    }

    private void doneIfExpectedPlanItemAndStatus(ConfigurationItem planItem) {
        if (this.planItemId.equals(planItem.getId()) && this.expectedStatuses.contains(planItem.getProperty("status"))) {
            this.latch.countDown();
        }
    }
}

