/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Tenant;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TenantLimitRepository;
import com.xebialabs.xlrelease.repository.TenantRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\r=f\u0001B!C\u0001%C\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0003\u000b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\n\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005%\u0002A!A!\u0002\u0013\tY\u0003\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0005\u0003gA!\"!\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u001e\u0011)\t9\u0005\u0001B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003\u001f\u0002!\u0011!Q\u0001\n\u0005E\u0003BCA,\u0001\t\u0005\t\u0015!\u0003\u0002Z!Q\u0011q\f\u0001\u0003\u0002\u0003\u0006I!!\u0019\t\u0015\u0005\u001d\u0004A!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002p\u0001\u0011\t\u0011)A\u0005\u0003cB!\"!(\u0001\u0005\u0003\u0005\u000b\u0011BA9\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!5\u0001\t\u0003\n\u0019\u000e\u0003\u0004\\\u0001\u0011\u0005\u00131\u001e\u0005\b\u0003s\u0004A\u0011IA~\u0011\u001d\u0011Y\u0001\u0001C!\u0003WDqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0004\u00032\u0001!IAa\r\t\u000f\tU\u0002\u0001\"\u0003\u00034!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B!\u0001\u0011%!\u0011\b\u0005\u000b\u0005\u0007\u0002\u0001R1A\u0005\u0002\t\u0015\u0003\"\u0003B+\u0001\t\u0007I\u0011\u0002B,\u0011!\u0011i\u0006\u0001Q\u0001\n\te\u0003b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011\u0019\b\u0001C!\u0003WDqA!\u001e\u0001\t\u0003\nY\u000fC\u0004\u0003x\u0001!\tE!\u001f\t\u000f\t}\u0004\u0001\"\u0005\u0003\u0002\"9!Q\u0011\u0001\u0005\u0012\t\u001d\u0005b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005#\u0003A\u0011\u0003BJ\u0011\u001d\u00119\b\u0001C!\u0005/CqAa\u001e\u0001\t\u0003\u0012I\u000bC\u0004\u00036\u0002!\tEa.\t\u000f\t\r\u0007\u0001\"\u0011\u0002l\"9!Q\u0019\u0001\u0005\n\t\u001d\u0007b\u0002Be\u0001\u0011%!q\u0019\u0005\b\u0005\u0017\u0004A\u0011\u0002Bd\u0011\u001d\u0011i\r\u0001C\u0005\u0005\u001fDqAa6\u0001\t\u0013\u0011I\u000eC\u0004\u0003~\u0002!IAa@\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012!91Q\u0005\u0001\u0005\n\t\u001d\u0007bBB\u0014\u0001\u0011%!q\u0019\u0005\b\u0007S\u0001A\u0011BB\u0016\u0011\u001d\u0019y\u0003\u0001C\u0005\u0007cAqaa\r\u0001\t\u0013\u0019\t\u0004C\u0004\u00046\u0001!Ia!\r\t\u000f\r]\u0002\u0001\"\u0003\u0003H\"91\u0011\b\u0001\u0005\u0002\u0005-\bbCB&\u0001\u0001\u0007\t\u0019!C\u0001\u0007\u001bB1b!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0004X!Y1Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BB(\u0011\u001d\u0019Y\u0007\u0001C\u0001\u0007[Bqa!\u001d\u0001\t\u0003\u0019\u0019hB\u0004\u0004\u001a\nC\taa'\u0007\r\u0005\u0013\u0005\u0012ABO\u0011\u001d\t\u0019K\u0010C\u0001\u0007KCqA!.?\t\u0003\u00199K\u0001\tTc2\u001cFo\u001c:bO\u00164\u0015mY1eK*\u00111\tR\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0012$\u0002\u0013a,'-[1mC\n\u001c(\"A$\u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001Q%K\u00160bOF\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\t\tFJ\u0001\u0004PE*,7\r\u001e\t\u0003'Rk\u0011AQ\u0005\u0003+\n\u0013Qb\u0015;pe\u0006<WMR1dC\u0012,\u0007CA,]\u001b\u0005A&BA-[\u0003%a\u0017.];jE\u0006\u001cXM\u0003\u0002\\\u0005\u00069Q\u000f]4sC\u0012,\u0017BA/Y\u00055\u0011UMZ8sKV\u0003xM]1eKB\u00111kX\u0005\u0003A\n\u0013!\u0003V3ti\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0011!-Z\u0007\u0002G*\u0011AMQ\u0001\u0003I\nL!AZ2\u0003!1K\u0017/^5cCN,7+\u001e9q_J$\bC\u00015p\u001b\u0005I'B\u00016l\u0003\u0019\u0019\bO]5oO*\u0011A.\\\u0001\u0006a\u0016\\7n\u001c\u0006\u0003]\n\u000bqa];qa>\u0014H/\u0003\u0002qS\n\u00112kY1mCN\u0003(/\u001b8h'V\u0004\bo\u001c:u!\t\u0011\u00180D\u0001t\u0015\t!X/A\u0004d_:$X\r\u001f;\u000b\u0005Y<\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\f1a\u001c:h\u0013\tQ8OA\fBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018i^1sK\u0006iam\u001c7eKJ\u001cVM\u001d<jG\u0016\u00042!`A\u0001\u001b\u0005q(BA@C\u0003\u001d\u0019XM\u001d<jG\u0016L1!a\u0001\u007f\u000551u\u000e\u001c3feN+'O^5dK\u0006ya-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAQ\u0001\u000be\u0016\u0004xn]5u_JL\u0018\u0002BA\t\u0003\u0017\u0011qBR1dKR\u0014V\r]8tSR|'/_\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z!\u0011\t9\"!\b\u000e\u0005\u0005e!\u0002BA\u000e\u0003\u0017\t1a]9m\u0013\u0011\ty\"!\u0007\u0003#M\u000bH\u000eV3b[J+\u0007o\\:ji>\u0014\u00180\u0001\tuK:\fg\u000e\u001e*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011BA\u0013\u0013\u0011\t9#a\u0003\u0003!Q+g.\u00198u%\u0016\u0004xn]5u_JL\u0018!\u0006;f]\u0006tG\u000fT5nSR\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u0013\ti#\u0003\u0003\u00020\u0005-!!\u0006+f]\u0006tG\u000fT5nSR\u0014V\r]8tSR|'/_\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b\u0003BA\u0005\u0003kIA!a\u000e\u0002\f\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKB!\u0011QHA\"\u001b\t\tyD\u0003\u0003\u0002B\u0005e\u0011a\u00039feNL7\u000f^3oG\u0016LA!!\u0012\u0002@\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\u0011\tI!a\u0013\n\t\u00055\u00131\u0002\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\fqcY1mK:$\u0017M]#oiJL(+\u001a9pg&$xN]=\u0011\t\u0005%\u00111K\u0005\u0005\u0003+\nYAA\fDC2,g\u000eZ1s\u000b:$(/\u001f*fa>\u001c\u0018\u000e^8ss\u0006\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0004{\u0006m\u0013bAA/}\n\u0001\u0012I]2iSZLgnZ*feZL7-Z\u0001\u0012iJLwmZ3s%\u0016\u0004xn]5u_JL\b\u0003BA\u0005\u0003GJA!!\u001a\u0002\f\t\tBK]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016\u0004B!!\u0010\u0002l%!\u0011QNA \u0005=!\u0016m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u00046eE\u000e$V-\u001c9mCR,\u0007\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0005G>\u0014XMC\u0002\u0002|U\fAA\u001b3cG&!\u0011qPA;\u00051QEMY2UK6\u0004H.\u0019;fQ\u001di\u00111QAL\u00033\u0003B!!\"\u0002\u00146\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0006b]:|G/\u0019;j_:TA!!$\u0002\u0010\u00069a-Y2u_JL(bAAIk\u0006)!-Z1og&!\u0011QSAD\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-\t\u0002\u0002\u001c\u0006I\u0002\u0010\u001c:SKB|7/\u001b;pefTEMY2UK6\u0004H.\u0019;f\u0003U\u0011X\r]8si&twM\u00133cGR+W\u000e\u001d7bi\u0016DsADAB\u0003/\u000b\t+\t\u0002\u0002\u001e\u00061A(\u001b8jiz\"b$a*\u0002*\u0006-\u0016QVAX\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-!2\u0011\u0005M\u0003\u0001\"B>\u0010\u0001\u0004a\bbBA\u0003\u001f\u0001\u0007\u0011q\u0001\u0005\b\u0003'y\u0001\u0019AA\u000b\u0011\u001d\t\tc\u0004a\u0001\u0003GAq!!\u000b\u0010\u0001\u0004\tY\u0003C\u0004\u00022=\u0001\r!a\r\t\u000f\u0005er\u00021\u0001\u0002<!9\u0011qI\bA\u0002\u0005%\u0003bBA(\u001f\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003/z\u0001\u0019AA-\u0011\u001d\tyf\u0004a\u0001\u0003CBq!a\u001a\u0010\u0001\u0004\tI\u0007C\u0004\u0002p=\u0001\r!!\u001d)\u0011\u0005\u0005\u00171QAL\u00033Cq!!(\u0010\u0001\u0004\t\t\b\u000b\u0005\u0002F\u0006\r\u0015qSAQQ\ry\u00111\u001a\t\u0005\u0003\u000b\u000bi-\u0003\u0003\u0002P\u0006\u001d%!C!vi><\u0018N]3e\u0003AAHNU3mK\u0006\u001cXMV3sg&|g\u000e\u0006\u0002\u0002VB!\u0011q[At\u001b\t\tINC\u0002\\\u00037TA!!8\u0002`\u0006\u0019\u0011\r]5\u000b\t\u0005\u0005\u00181]\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007\u0005\u0015H)\u0001\u0005eKBdw._5u\u0013\u0011\tI/!7\u0003\u000fY+'o]5p]R\u0011\u0011Q\u001e\t\u0005\u0003_\f)0\u0004\u0002\u0002r*\u0011\u00111_\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003o\f\tP\u0001\u0003V]&$\u0018\u0001\u0007:fa>\u001c\u0018\u000e^8ssZ+'o]5p]N+'O^5dKV\u0011\u0011Q \t\u0005\u0003\u007f\u00149!\u0004\u0002\u0003\u0002)\u00191La\u0001\u000b\u0007\t\u0015A)\u0001\u0006yYBd\u0017\r\u001e4pe6LAA!\u0003\u0003\u0002\tA\"+\u001a9pg&$xN]=WKJ\u001c\u0018n\u001c8TKJ4\u0018nY3\u0002\u0013\u0011|W\u000b]4sC\u0012,\u0017aE2pk:$(+Z2pe\u0012\u001c\u0018J\u001c+bE2,G\u0003\u0002B\t\u0005/\u0001B!a<\u0003\u0014%!!QCAy\u0005\u0011auN\\4\t\u000f\teA\u00031\u0001\u0003\u001c\u0005IA/\u00192mK:\u000bW.\u001a\t\u0005\u0005;\u0011YC\u0004\u0003\u0003 \t\u001d\u0002\u0003\u0002B\u0011\u0003cl!Aa\t\u000b\u0007\t\u0015\u0002*\u0001\u0004=e>|GOP\u0005\u0005\u0005S\t\t0\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0011yC\u0001\u0004TiJLgn\u001a\u0006\u0005\u0005S\t\t0\u0001\fxSB,w*\u001e;Be\u000eD\u0017N^3ECR\f'-Y:f+\t\ti/A\bxSB,w*\u001e;ECR\f'-Y:f\u0003II7\u000f\u00122DY\u0016\fg.\u001e9F]\u0006\u0014G.\u001a3\u0016\u0005\tm\u0002\u0003BAx\u0005{IAAa\u0010\u0002r\n9!i\\8mK\u0006t\u0017AH5t\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0013xNZ5mK\u0006\u001bG/\u001b<f\u0003)!\u0017\r^1T_V\u00148-Z\u000b\u0003\u0005\u000f\u0002BA!\u0013\u0003R5\u0011!1\n\u0006\u0005\u00037\u0011iE\u0003\u0002\u0003P\u0005)!.\u0019<bq&!!1\u000bB&\u0005)!\u0015\r^1T_V\u00148-Z\u0001\u0003\u001d2+\"A!\u0017\u0011\u0007-\u0013Y&C\u0002\u0003.1\u000b1A\u0014'!\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\t\t\r$q\r\u000b\u0005\u0005w\u0011)\u0007C\u0004\u0002pq\u0001\u001d!!\u001d\t\u000f\teA\u00041\u0001\u0003\u001c\u0005\u0011B-\u001a7fi\u0016$\u0016M\u00197f\u0007>tG/\u001a8u)\u0011\u0011iG!\u001d\u0015\t\u00055(q\u000e\u0005\b\u0003_j\u00029AA9\u0011\u001d\u0011I\"\ba\u0001\u00057\t\u0011\u0004Z3mKR,\u0007+\u001a:nSN\u001c\u0018n\u001c8T]\u0006\u00048\u000f[8ug\u000691\r\\3b]V\u0004\u0018A\u00023fY\u0016$X\r\u0006\u0003\u0003<\tm\u0004b\u0002B?A\u0001\u0007!1D\u0001\u0003S\u0012\fa\u0002Z3mKR,G)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0003\u0002n\n\r\u0005b\u0002B?C\u0001\u0007!1D\u0001\u0010I\u0016dW\r^3ECND'm\\1sIR!\u0011Q\u001eBE\u0011\u001d\u0011iH\ta\u0001\u00057\t!#[:HY>\u0014\u0017\r\\*fiRLgnZ:JIR!!1\bBH\u0011\u001d\u0011ih\ta\u0001\u00057\tQ\u0002Z3mKR,'+\u001a7fCN,G\u0003BAw\u0005+CqA! %\u0001\u0004\u0011Y\u0002\u0006\u0003\u0003<\te\u0005b\u0002BNK\u0001\u0007!QT\u0001\u0005i\u0016\fW\u000e\u0005\u0003\u0003 \n\u0015VB\u0001BQ\u0015\r\u0011\u0019KQ\u0001\u0007I>l\u0017-\u001b8\n\t\t\u001d&\u0011\u0015\u0002\u0005)\u0016\fW\u000e\u0006\u0003\u0003<\t-\u0006b\u0002BWM\u0001\u0007!qV\u0001\u0002iB!!q\u0014BY\u0013\u0011\u0011\u0019L!)\u0003\rQ+g.\u00198u\u0003E!W\r\\3uK\u001a\u0013x.\\!sG\"Lg/\u001a\u000b\u0005\u0005s\u0013y\f\u0005\u0003\u0002p\nm\u0016\u0002\u0002B_\u0003c\u00141!\u00138u\u0011\u001d\u0011\tm\na\u0001\u00057\t\u0011B]3mK\u0006\u001cX-\u00133\u0002+Y,'/\u001b4z%\u0016\u0004xn]5u_JL8\t\\3b]\u0006I1m\\;oi*{'m\u001d\u000b\u0003\u0005s\u000bAbY8v]R4u\u000e\u001c3feN\f\u0011cY8v]R\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t\u0003%\u0019w.\u001e8u%><8\u000f\u0006\u0004\u0003:\nE'1\u001b\u0005\b\u00053a\u0003\u0019\u0001B\u000e\u0011\u001d\u0011)\u000e\fa\u0001\u00057\t!bY8mk6tg*Y7f\u0003M9W\r\u001e*f[\u0006Lg.\u001b8h\t\u0016$\u0018-\u001b7t)!\u0011YNa=\u0003v\ne\bC\u0002Bo\u0005O\u0014iO\u0004\u0003\u0003`\n\rh\u0002\u0002B\u0011\u0005CL!!a=\n\t\t\u0015\u0018\u0011_\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IOa;\u0003\u0007M+\u0017O\u0003\u0003\u0003f\u0006E\b\u0003CAx\u0005_\u0014YBa\u0007\n\t\tE\u0018\u0011\u001f\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\teQ\u00061\u0001\u0003\u001c!9!q_\u0017A\u0002\tm\u0011\u0001D5e\u0007>dW/\u001c8OC6,\u0007b\u0002B~[\u0001\u0007!1D\u0001\u0010i&$H.Z\"pYVlgNT1nK\u0006ya/\u001a:jMfdUM\u001a;pm\u0016\u00148\u000f\u0006\u0007\u0002n\u000e\u00051QAB\u0004\u0007\u0017\u0019i\u0001C\u0004\u0004\u00049\u0002\rAa\u0007\u0002\u000f5,7o]1hK\"9!\u0011\u0004\u0018A\u0002\tm\u0001bBB\u0005]\u0001\u0007!1D\u0001\u0010G>,h\u000e^\"pYVlgNT1nK\"9!q\u001f\u0018A\u0002\tm\u0001b\u0002B~]\u0001\u0007!1D\u0001\u001bi\u0016\u001cH\u000fR5e\u001d>$8\t\\3b]\u00063G/\u001a:JiN,GN\u001a\u000b\t\u0007'\u0019Ib!\b\u0004\"A\u00191k!\u0006\n\u0007\r]!I\u0001\u000bUKN$8\t\\3b]V\u0004X\t_2faRLwN\u001c\u0005\b\u00077y\u0003\u0019\u0001B\u000e\u0003!!Xm\u001d;OC6,\u0007bBB\u0010_\u0001\u0007!1\\\u0001\u0007C\u000e$\u0018N^3\t\u000f\r\rr\u00061\u0001\u0003\\\u0006A\u0011M]2iSZ,G-A\u0007d_VtGOU3mK\u0006\u001cXm]\u0001\u000eG>,h\u000e\u001e+sS\u001e<WM]:\u00027\u001d,GOU3nC&t\u0017N\\4Ue&<w-\u001a:t\t\u0016$\u0018-\u001b7t)\t\u0019i\u0003\u0005\u0004\u0003^\n\u001d(1D\u0001\u001aO\u0016$(+Z7bS:Lgn\u001a$pY\u0012,'\u000fR3uC&d7\u000f\u0006\u0002\u0003\\\u0006Yr-\u001a;SK6\f\u0017N\\5oOJ+G.Z1tKN$U\r^1jYN\f1eZ3u%\u0016l\u0017-\u001b8j]\u001e\f%o\u00195jm\u0016$'+\u001a7fCN,7\u000fR3uC&d7/A\u000bd_VtG/\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002\u0013\rdW-\u00198YY\u0012\u0013\u0007fA\u001c\u0004>A!1qHB$\u001b\t\u0019\tE\u0003\u0003\u0002\n\u000e\r#BAB#\u0003\u001dQ\u0017m[1si\u0006LAa!\u0013\u0004B\tQ\u0001K]3EKN$(o\\=\u0002%\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^\u000b\u0003\u0007\u001f\u00022A]B)\u0013\r\u0019\u0019f\u001d\u0002\u0013\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH/\u0001\fbaBd\u0017nY1uS>t7i\u001c8uKb$x\fJ3r)\u0011\tio!\u0017\t\u0013\rm\u0013(!AA\u0002\r=\u0013a\u0001=%c\u0005\u0019\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=uA!\u001a!h!\u0019\u0011\t\r\r4qM\u0007\u0003\u0007KRA!!%\u0002r&!1\u0011NB3\u00051\u0011U-\u00198Qe>\u0004XM\u001d;z\u0003U9W\r^!qa2L7-\u0019;j_:\u001cuN\u001c;fqR$\"aa\u0014)\u0007m\u001a\t'A\u000btKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0015\t\u000558Q\u000f\u0005\n\u00077b\u0014\u0011!a\u0001\u0007\u001fB3\u0001PB1Q\r\u000111\u0010\t\u0005\u0007{\u001a\u0019)\u0004\u0002\u0004\u0000)\u00191\u0011Q;\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0004\u0006\u000e}$!C\"p[B|g.\u001a8uQ\u001d\u00011\u0011RAL\u0007'\u0003Baa#\u0004\u00106\u00111Q\u0012\u0006\u0004\u0003\u0013\u001b\u0018\u0002BBI\u0007\u001b\u0013q\u0001\u0015:pM&dW\r\f\u0002\u0004\u0016\u0006\u00121qS\u0001\u0010S:$Xm\u001a:bi&|g\u000eV3ti\u0006\u00012+\u001d7Ti>\u0014\u0018mZ3GC\u000e\fG-\u001a\t\u0003'z\u001a2APBP!\u0011\tyo!)\n\t\r\r\u0016\u0011\u001f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\rmE\u0003BBU\u0007[#BA!/\u0004,\"9\u0011q\u000e!A\u0002\u0005E\u0004b\u0002Ba\u0001\u0002\u0007!1\u0004")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final FacetRepository facetRepository;
    private final SqlTeamRepository teamRepository;
    private final TenantRepository tenantRepository;
    private final TenantLimitRepository tenantLimitRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    private final TaskPersistence taskPersistence;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    public <T> T asAdmin(Function0<T> block) {
        return (T)TestAuthentication.asAdmin$((TestAuthentication)this, block);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject("SELECT count(*) FROM " + tableName, Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        if (this.isDbCleanupEnabled()) {
            DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
            LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
                private final DataSource reportingDataSource$1;

                public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                    return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
                }

                public DataSource dataSource() {
                    return this.reportingDataSource$1;
                }
                {
                    this.reportingDataSource$1 = reportingDataSource$1;
                    LiquibaseSupport.$init$((LiquibaseSupport)this);
                }
            };
            reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void wipeOutDatabase() {
        if (this.isDbCleanupEnabled() && this.isIntegrationTestProfileActive()) {
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean isDbCleanupEnabled() {
        String nodbcleanup = System.getProperty("nodbcleanup", "false");
        boolean isCleanupEnabled = !Boolean.parseBoolean(nodbcleanup);
        this.logger().info("Cleanup enabled: " + isCleanupEnabled);
        return isCleanupEnabled;
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        if (!this.bitmap$0) {
            return this.dataSource$lzycompute();
        }
        return this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject("SELECT count(*) FROM " + tableName, Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        if (this.tableExists(tableName, jdbcTemplate)) {
            this.logger().info("DELETING " + tableName);
            jdbcTemplate.execute("DELETE FROM " + tableName);
            return;
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_JOBS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_EXECUTIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.CATEGORIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute("DELETE FROM " + Schema.PATHS$.MODULE$.TABLE() + " WHERE " + Schema.PATHS$.MODULE$.ANCESTOR_UID() + " <> " + FolderRow.Root$.MODULE$.uid() + " OR " + Schema.PATHS$.MODULE$.DESCENDANT_UID() + " <> " + FolderRow.Root$.MODULE$.uid());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute("UPDATE " + Schema.FOLDERS$.MODULE$.TABLE() + " SET " + Schema.FOLDERS$.MODULE$.SECURITY_UID() + " = " + FolderRow.Root$.MODULE$.uid());
            this.jdbcTemplate.execute("DELETE FROM " + Schema.FOLDERS$.MODULE$.TABLE() + " WHERE " + Schema.FOLDERS$.MODULE$.CI_UID() + " <> " + FolderRow.Root$.MODULE$.uid());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute("DELETE FROM " + Schema.USER_PROFILE$.MODULE$.TABLE() + " WHERE " + Schema.USER_PROFILE$.MODULE$.USERNAME() + " <> 'admin'");
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace("Deleting id " + id);
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id, (Long)$this.taskPersistence.taskUidById(Ids.getParentId((String)id)).get());
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn("Variable '" + id + "' will be deleted once the parent release is deleted.");
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isFacetId((String)id)) {
                        $this.facetRepository.delete(id, $this.facetRepository.delete$default$2());
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn("Id '" + id + "' will be deleted once the parent release or template is deleted.");
                    } else if (Ids.isDeliveryId((String)id)) {
                        this.deleteDelivery(id);
                    } else if (Ids.isDashboardId((String)id)) {
                        this.deleteDashboard(id);
                    } else if (!this.isGlobalSettingsId(id)) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn("Deleted " + id);
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error("Unable to delete CI with Id: `" + id + "` as it was not found");
                return true;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().error("Unable to delete CI with Id: `" + id + "`", e);
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public void deleteDelivery(String id) {
        this.jdbcTemplate.execute("DELETE FROM XLR_DELIVERIES WHERE ID = '" + Ids.getName((String)id) + "'");
    }

    public void deleteDashboard(String id) {
        this.jdbcTemplate.execute("DELETE FROM XLR_DASHBOARDS WHERE ID = '" + Ids.getName((String)id) + "'");
    }

    private boolean isGlobalSettingsId(String id) {
        String shortId = Ids.getName((String)id);
        return shortId.startsWith("EmailNotificationSettings");
    }

    public void deleteRelease(String id) {
        this.logger().info("Deleting release {}", (Object)id);
        boolean found = false;
        if (this.releaseRepository.exists(id)) {
            this.logger().info("Release {} found in repository", (Object)id);
            try {
                this.teamRepository.deleteTeamsFromPlatform(id);
            }
            catch (NotFoundException e) {
                this.logger().warn("Could not delete teams of " + id, (Throwable)e);
            }
            this.releaseRepository.delete(id, false);
            found = true;
        }
        if (this.archivingService.exists(id)) {
            this.logger().info("Release {} found in archive", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (this.archivingService.existsPreArchived(id)) {
            this.logger().info("Release {} found as pre-archived", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (!found) {
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
            return;
        }
    }

    @Override
    public boolean delete(Team team) {
        this.logger().trace("Deleting team " + team.getId());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(Tenant t) {
        boolean bl;
        try {
            this.tenantLimitRepository.delete(t.tenantId());
            this.tenantRepository.delete(t.tenantId());
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? MDC.get((String)"testName") + ": " : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(testName + "Found " + triggerCount + " remaining triggers in database:" + this.NL() + this.getRemainingTriggersDetails().mkString(this.NL()));
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        return (B1)(id + " -> " + path);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    return tuple2 != null;
                }
            });
            throw new TestCleanupException(testName + "There are leftover folders: " + folders);
        }
        int jobsCount = this.countJobs();
        if (jobsCount > 0) {
            Seq jobs = (Seq)this.getRemainingDetails(Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID()).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                    A1 A1 = x$1;
                    return (B1)x$1._2();
                }

                public final boolean isDefinedAt(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    return true;
                }
            });
            throw new TestCleanupException(testName + "There are leftover jobs: " + jobs);
        }
        this.verifyLeftovers(testName + "There are leftover applications", "XLR_APPLICATIONS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(testName + "There are leftover environments", "XLR_ENVIRONMENTS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(testName + "There are leftover jobs", Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID());
    }

    private int countJobs() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(1) FROM " + Schema.TASK_JOBS$.MODULE$.TABLE(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + Schema.FOLDERS$.MODULE$.CI_UID() + ") FROM " + Schema.FOLDERS$.MODULE$.TABLE(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countApplications() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(CI_UID) FROM XLR_APPLICATIONS", (rs, x$4) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countRows(String tableName, String columnName) {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + columnName + ") FROM " + tableName, (rs, x$5) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingDetails(String tableName, String idColumnName, String titleColumnName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + idColumnName + ", " + titleColumnName + " FROM " + tableName, (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private void verifyLeftovers(String message, String tableName, String countColumnName, String idColumnName, String titleColumnName) {
        int count = this.countRows(tableName, countColumnName);
        if (count > 1) {
            Seq<Tuple2<String, String>> leftOvers = this.getRemainingDetails(tableName, idColumnName, titleColumnName);
            throw new TestCleanupException(message + ": " + leftOvers);
        }
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(testName + "Found " + numTotal + " remaining releases (" + numActive + " from database and " + numArchived + " from archive):\n" + SqlStorageFacade.all$1(active, archived));
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + Schema.RELEASES$.MODULE$.CI_UID() + ") FROM " + Schema.RELEASES$.MODULE$.TABLE(), (rs, x$7) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + Schema.TRIGGERS$.MODULE$.CI_UID() + ") FROM " + Schema.TRIGGERS$.MODULE$.TABLE(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ", " + Schema.TRIGGERS$.MODULE$.ID() + " FROM " + Schema.TRIGGERS$.MODULE$.TABLE(), (rs, x$9) -> "Trigger: " + rs.getString(1) + " with id: " + rs.getString(2))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + Schema.FOLDERS$.MODULE$.FOLDER_ID() + ", " + Schema.FOLDERS$.MODULE$.FOLDER_PATH() + " FROM " + Schema.FOLDERS$.MODULE$.TABLE(), (rs, x$10) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + Schema.RELEASES$.MODULE$.RELEASE_ID() + ", " + Schema.RELEASES$.MODULE$.RELEASE_TITLE() + " FROM " + Schema.RELEASES$.MODULE$.TABLE(), (rs, x$11) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query("SELECT " + ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN() + ", " + ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN() + " FROM " + ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), (rs, x$12) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject("SELECT COUNT(" + ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN() + ") FROM " + ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), (rs, x$13) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 != null) {
            String id = (String)tuple2._1();
            String title = (String)tuple2._2();
            return id + " -> '" + title + "' (" + tag + ")";
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, FacetRepository facetRepository, SqlTeamRepository teamRepository, TenantRepository tenantRepository, TenantLimitRepository tenantLimitRepository, ReleaseRepository releaseRepository, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, TaskPersistence taskPersistence, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.facetRepository = facetRepository;
        this.teamRepository = teamRepository;
        this.tenantRepository = tenantRepository;
        this.tenantLimitRepository = tenantLimitRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.taskPersistence = taskPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

