package com.xebialabs.xlrelease.utils

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.utils.MatchingAwaiter.MATCHER

import scala.annotation.varargs

/**
 * Collects all events that were matched instead of terminating after first one
 */
class CollectingMatchingAwaiter(eventBus: XLReleaseEventBus, timeout: Long, matchers: Seq[MATCHER]) extends MatchingAwaiter(eventBus, timeout, matchers) {
  override protected def matched(event: XLReleaseEvent): Unit = {
    logger.info(s"Matched event ${event}")
    events += "matched" -> event
  }
}

object CollectingMatchingAwaiter {
  @varargs
  def apply(eventBus: XLReleaseEventBus, timeout: Long, matchers: MATCHER*) = new CollectingMatchingAwaiter(eventBus, timeout, matchers)
}