/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.utils.BaseConditionAwaiter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventsAwaiter
extends BaseConditionAwaiter {
    private static final Logger logger = LoggerFactory.getLogger(EventsAwaiter.class);
    private static final String LOCK = "";
    private volatile List<XLReleaseEvent> expectedEvents;
    private volatile Queue<XLReleaseEvent> pendingEvents;
    private volatile List<XLReleaseEvent> actualEvents = new ArrayList<XLReleaseEvent>();
    private VerificationMode mode;

    private EventsAwaiter(XLReleaseEventBus eventBus, List<XLReleaseEvent> eventsInOccurrenceOrder, long timeout) {
        this(eventBus, eventsInOccurrenceOrder, timeout, VerificationMode.EVENTS_IN_ORDER);
    }

    private EventsAwaiter(XLReleaseEventBus eventBus, List<XLReleaseEvent> events, long timeout, VerificationMode mode) {
        super(eventBus, timeout);
        this.expectedEvents = events;
        this.pendingEvents = new ArrayDeque<XLReleaseEvent>(events);
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventsAwaiter create(XLReleaseEventBus eventBus, List<XLReleaseEvent> eventsInOccurrenceOrder, long timeout) {
        String string = LOCK;
        synchronized (LOCK) {
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return new EventsAwaiter(eventBus, eventsInOccurrenceOrder, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventsAwaiter create(XLReleaseEventBus eventBus, List<XLReleaseEvent> events, long timeout, VerificationMode mode) {
        String string = LOCK;
        synchronized (LOCK) {
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return new EventsAwaiter(eventBus, events, timeout, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SynchronizedSubscribe
    public void onEvent(XLReleaseEvent event) {
        String string = LOCK;
        synchronized (LOCK) {
            logger.trace("Received event: {}", (Object)event);
            this.actualEvents.add(event);
            switch (this.mode.ordinal()) {
                case 0: {
                    if (!Objects.equals(this.pendingEvents.peek(), event)) break;
                    this.pendingEvents.poll();
                    break;
                }
                case 1: {
                    this.pendingEvents.remove(event);
                    break;
                }
                case 2: {
                    if (!this.pendingEvents.contains(event)) break;
                    this.pendingEvents.clear();
                }
            }
            if (this.pendingEvents.isEmpty()) {
                this.latch.countDown();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected String getErrorMessage() {
        return String.format("Did not encounter events %s out of requested ordered list %s within %d milliseconds, events encountered: %s", this.pendingEvents, this.expectedEvents, this.timeout, this.actualEvents);
    }

    static enum VerificationMode {
        EVENTS_IN_ORDER,
        EVENTS_IN_ANY_ORDER,
        ANY_OF_EVENTS;

    }
}

