package com.xebialabs.xlrelease.service;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.platform.script.jython.EngineInstance;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.events.EventListenerRegister;
import com.xebialabs.xlrelease.script.bindings.SecurityApiBinding;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeLiquibaseUpgrade;

public class TestServiceStarter extends ServiceStarter {

    private static final Logger logger = LoggerFactory.getLogger(TestServiceStarter.class);

    @Autowired
    public TestServiceStarter(Upgrader upgrader,
                              RepositoryInitializer repositoryInitializer,
                              XlrServiceManager serviceManager,
                              XlrConfig xlrConfig,
                              MissingTypesChecker missingTypesChecker,
                              BeforeLiquibaseUpgrade beforeLiquibaseUpgrade,
                              @Qualifier("xlrMigrationsDbInitializer") XLReleaseDbInitializer xlrMigrationsDbInitializer,
                              @Qualifier("xlrRepositoryDbInitializer") XLReleaseDbInitializer xlrRepositoryDbInitializer,
                              @Qualifier("reportingDbInitializer") XLReleaseDbInitializer reportingDbInitializer,
                              EventListenerRegister eventListenerRegister,
                              SecurityApiBinding securityApiBinding,
                              DatacenterService datacenterService) {
        super(upgrader, repositoryInitializer, serviceManager, xlrConfig, missingTypesChecker, beforeLiquibaseUpgrade,
                xlrMigrationsDbInitializer,
                xlrRepositoryDbInitializer,
                reportingDbInitializer,
                eventListenerRegister,
                securityApiBinding,
                datacenterService);
    }

    public void startServices() {
        super.startServices();
        initializeJython();
        initializeGroovy();
    }

    private void initializeJython() {
        try {
            logger.info("Starting up Jython engine (might take a while)...");
            long start = System.currentTimeMillis();
            EngineInstance.jython().eval("True");
            logger.info(String.format("Jython engine loaded in %d ms", System.currentTimeMillis() - start));
        } catch (Exception e) {
            logger.warn("Exception while initializing Jython engine", e);
        }
    }

    private void initializeGroovy() {
        try {
            logger.info("Starting up Groovy engine (might take a while)...");
            long start = System.currentTimeMillis();
            ScriptEngine groovy = new ScriptEngineManager().getEngineByName("groovy");
            if (groovy == null) {
                logger.info("No Groovy engine found");
            } else {
                groovy.eval("true");
                logger.info(String.format("Groovy engine loaded in %d ms", System.currentTimeMillis() - start));
            }
        } catch (Exception e) {
            logger.warn("Exception while initializing Groovy engine", e);
        }
    }

}
