/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.XLReleaseIntegrationTestConfig;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import java.util.ArrayList;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.session.SessionRegistry;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class XLReleaseIntegrationTestConfig$ {
    public static final XLReleaseIntegrationTestConfig$ MODULE$ = new XLReleaseIntegrationTestConfig$();
    private static final XLReleaseIntegrationTestConfig instance = new XLReleaseIntegrationTestConfig();
    private static final Map<String, String> testUserAccounts = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scriptUser1"), (Object)"scriptUserSecret1")}));
    private static final Map<String, String> testUserTokenAccount = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"run-as-admin-token"), (Object)"admin")}));

    public XLReleaseIntegrationTestConfig instance() {
        return instance;
    }

    public Map<String, String> testUserAccounts() {
        return testUserAccounts;
    }

    public Map<String, String> testUserTokenAccount() {
        return testUserTokenAccount;
    }

    public XLReleaseIntegrationTestConfig getInstance() {
        this.init();
        return this.instance();
    }

    public void init() {
        this.instance().licenseService_$eq((LicenseService)Mockito.mock(LicenseService.class));
        this.instance().sessionRegistry_$eq((SessionRegistry)Mockito.mock(SessionRegistry.class));
        this.instance().serverConfiguration_$eq(new ServerConfiguration());
        this.instance().authenticationManager_$eq((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        this.instance().runnerAuthenticationManager_$eq((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        this.instance().workManager_$eq((WorkManager)Mockito.mock(WorkManager.class));
        Mockito.when((Object)this.instance().authenticationManager().authenticate((Authentication)ArgumentMatchers.any(Authentication.class))).thenAnswer(invocation -> {
            Object object;
            Object object2;
            Authentication auth = (Authentication)invocation.getArguments()[0];
            Object authUsername = auth.getPrincipal();
            Object authCredentials = auth.getCredentials();
            if (authUsername != null && MODULE$.testUserAccounts().contains((Object)authUsername.toString())) {
                String string = (String)auth.getCredentials();
                Object object3 = MODULE$.testUserAccounts().apply((Object)authUsername.toString());
                if (string == null ? object3 != null : !string.equals(object3)) {
                    throw new BadCredentialsException("Invalid Credentials for " + auth.getPrincipal());
                }
            }
            if (auth instanceof PersonalAuthenticationToken && authCredentials != null) {
                Option option = MODULE$.testUserTokenAccount().get((Object)authCredentials.toString());
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    throw new BadCredentialsException("Cannot authenticate with supplied personal access token");
                }
                Some some = (Some)option;
                String user = (String)some.value();
                object2 = user;
            } else {
                object2 = authUsername;
            }
            Object principal = object2;
            ArrayList authorities = new ArrayList(auth.getAuthorities());
            if ("admin".equals(authUsername) && authorities.isEmpty()) {
                object = BoxesRunTime.boxToBoolean((boolean)authorities.addAll(AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ADMIN"})));
                return new TestingAuthenticationToken(principal, authCredentials, authorities);
            }
            object = BoxedUnit.UNIT;
            return new TestingAuthenticationToken(principal, authCredentials, authorities);
        });
    }

    private XLReleaseIntegrationTestConfig$() {
    }
}

