package com.xebialabs.xlrelease.email

import com.icegreen.greenmail.util.{GreenMail, ServerSetup}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport
import org.springframework.context.ApplicationContextAware
import org.springframework.test.util.TestSocketUtils

trait GreenMailSupport extends ScalaSpringSupport {
  self: ApplicationContextAware =>

  private val SMTP_SERVER_ID = "Configuration/mail/SmtpServer"

  protected val server = "localhost"
  protected val smtpPort = TestSocketUtils.findAvailableTcpPort()
  protected val imapPort = TestSocketUtils.findAvailableTcpPort()
  protected val smtpMailConfig = new ServerSetup(smtpPort, server, ServerSetup.PROTOCOL_SMTP)
  protected val imapMailConfig = new ServerSetup(imapPort, server, ServerSetup.PROTOCOL_IMAP)
  protected lazy val greenMail = new GreenMail(Array(smtpMailConfig, imapMailConfig))
  private lazy val configurationRepository = springBean[ConfigurationRepository]

  protected val smtpServer = {
    val smtpAuthentication: BaseConfigurationItem = Type.valueOf("xlrelease", "BasicSmtpAuthentication").getDescriptor.newInstance("Configuration/mail/SmtpServer")
    smtpAuthentication.setProperty("username", "itchy")
    smtpAuthentication.setProperty("password", "itchy")

    val smtpServer: BaseConfiguration = Type.valueOf("xlrelease", "SmtpServer").getDescriptor.newInstance(SMTP_SERVER_ID)
    smtpServer.setProperty("host", server)
    smtpServer.setProperty("port", smtpPort)
    smtpServer.setProperty("fromAddress", "xl-release@example.com")
    smtpServer.setProperty("testAddress", "john.doe@example.com")
    smtpServer.setProperty("tls", false)
    smtpServer.setProperty("authentication", smtpAuthentication)
    smtpServer
  }

  def startGreenMail(): Unit = {
    greenMail.setUser("itchy@xebialabs.com", "itchy", "itchy")
    greenMail.start()
    configurationRepository.delete(SMTP_SERVER_ID)
    configurationRepository.create(smtpServer)
  }

  def stopGreenMail(): Unit = {
    greenMail.stop()
    configurationRepository.delete(SMTP_SERVER_ID)
  }


}
