package com.xebialabs.xlrelease.service;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

import com.xebialabs.xlrelease.script.bindings.SecurityApiBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.platform.script.jython.EngineInstance;
import com.xebialabs.xlrelease.actors.cluster.XlrActorSystem;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.events.EventListenerRegister;
import com.xebialabs.xlrelease.scheduler.JobQueueServices;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeLiquibaseUpgrade;

public class TestServiceStarter extends ServiceStarter {

    private static final Logger logger = LoggerFactory.getLogger(TestServiceStarter.class);

    @Autowired
    public TestServiceStarter(Upgrader upgrader,
                              RepositoryInitializer repositoryInitializer,
                              XlrActorSystem xlrActorSystem,
                              XlrConfig xlrConfig,
                              MissingTypesChecker missingTypesChecker,
                              BeforeLiquibaseUpgrade beforeLiquibaseUpgrade,
                              List<? extends FeatureService> featureServices,
                              PreArchiveService preArchiveService,
                              @Qualifier("xlrMigrationsDbInitializer") XLReleaseDbInitializer xlrMigrationsDbInitializer,
                              @Qualifier("xlrRepositoryDbInitializer") XLReleaseDbInitializer xlrRepositoryDbInitializer,
                              @Qualifier("reportingDbInitializer") XLReleaseDbInitializer reportingDbInitializer,
                              EventListenerRegister eventListenerRegister,
                              JobQueueServices jobQueueServices,
                              SecurityApiBinding securityApiBinding) {
        super(upgrader, repositoryInitializer, xlrActorSystem, xlrConfig, missingTypesChecker, beforeLiquibaseUpgrade,
                featureServices,
                preArchiveService,
                xlrMigrationsDbInitializer,
                xlrRepositoryDbInitializer,
                reportingDbInitializer,
                eventListenerRegister,
                jobQueueServices,
                securityApiBinding);
    }

    public void startServices() {
        super.startServices();
        initializeJython();
        initializeGroovy();
    }

    private void initializeJython() {
        try {
            logger.info("Starting up Jython engine (might take a while)...");
            long start = System.currentTimeMillis();
            EngineInstance.jython().eval("True");
            logger.info(String.format("Jython engine loaded in %d ms", System.currentTimeMillis() - start));
        } catch (Exception e) {
            logger.warn("Exception while initializing Jython engine", e);
        }
    }

    private void initializeGroovy() {
        try {
            logger.info("Starting up Groovy engine (might take a while)...");
            long start = System.currentTimeMillis();
            ScriptEngine groovy = new ScriptEngineManager().getEngineByName("groovy");
            if (groovy == null) {
                logger.info("No Groovy engine found");
            } else {
                groovy.eval("true");
                logger.info(String.format("Groovy engine loaded in %d ms", System.currentTimeMillis() - start));
            }
        } catch (Exception e) {
            logger.warn("Exception while initializing Groovy engine", e);
        }
    }

}
