package com.xebialabs.xlrelease.utils

import com.xebialabs.deployit.security.PermissionDeniedException
import com.xebialabs.xlrelease.views.BulkActionResultView
import com.xebialabs.xlrelease.{Login, XLReleaseIntegrationScalaTest}
import org.scalatest.exceptions.TestFailedException

import java.util
import javax.ws.rs.core.Response

abstract class ApiMethodChecker extends XLReleaseIntegrationScalaTest with Login {
  def check(method: () => Any, shouldSuccess: Boolean): Unit = {
    try {
      val response = method()
      response match {
        case v: BulkActionResultView =>
          withClue("for BulkActionResultView Updated/Created Ids") {
            if (shouldSuccess) {
              v.getUpdatedIds should not be empty
            }
            else {
              v.getUpdatedIds should be(empty)
            }
          }
        case v: Response =>
          withClue("checking whether the response is 200") {
            v.getStatus should be(200)
          }
        case v: util.List[_] =>
          withClue("checking whether the list is empty") {
            v.isEmpty shouldNot be(shouldSuccess)
          }
        case _ =>
          withClue("should not have been successful") {
            shouldSuccess should be(true)
          }
      }
    } catch {
      case e: TestFailedException => throw e
      case _: PermissionDeniedException =>
        withClue("should have been successful") {
          shouldSuccess should be(false)
        }
    }
  }
}
