package com.xebialabs.xlrelease

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.util.PasswordEncrypter

import scala.jdk.CollectionConverters._

package object utils {

  // TODO: surely somewhere there is already such a thing?
  def ci[T <: BaseConfigurationItem](ciType: String)(props: (String, Any)*): T = {
    val item = Type.valueOf(ciType).getDescriptor.newInstance[T](null)
    val desc = item.getType.getDescriptor
    val descs = desc.getPropertyDescriptors.asScala.map(pd => pd.getName -> pd).toMap
    props foreach {
      case (key, value: String) if descs.contains(key) && descs(key).isPassword =>
        item.setProperty(key, PasswordEncrypter.getInstance().encrypt(value))
      case (key, value) =>
        item.setProperty(key, value)
    }
    item
  }

}
