package com.xebialabs.xlrelease.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import com.xebialabs.xlrelease.events.XLReleaseEventBus;

public abstract class BaseConditionAwaiter implements AutoCloseable {

    protected static final long DEFAULT_TIMEOUT = 3000;

    protected boolean failed = false;
    private XLReleaseEventBus eventBus;
    protected CountDownLatch latch;
    protected long timeout;

    public BaseConditionAwaiter(XLReleaseEventBus eventBus, long timeout) {
        this(eventBus, timeout, 1);
    }

    public BaseConditionAwaiter(XLReleaseEventBus eventBus, long timeout, int latchCount) {
        this.eventBus = eventBus;
        this.timeout = timeout;
        latch = new CountDownLatch(latchCount);
    }

    public void startListening() {
        eventBus.register(this);
    }

    public void await() throws InterruptedException, TimeoutException {
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            failed = true;
            throw new TimeoutException(getErrorMessage());
        }
        if (failed) {
            if (getErrorCause() != null) {
                throw new IllegalStateException(getErrorMessage(), getErrorCause());
            } else {
                throw new IllegalStateException(getErrorMessage());
            }
        }
    }

    @Override
    public void close() {
        eventBus.deregister(this);
    }

    protected abstract String getErrorMessage();

    protected Throwable getErrorCause() {
        return null;
    }
}
