/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\r=e\u0001B A\u0001\u001dC\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u0015\u0005e\u0001A!A!\u0002\u0013\tY\u0002\u0003\u0006\u0002\"\u0001\u0011\t\u0011)A\u0005\u0003GA!\"!\u000b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0016\u0011)\t9\u0004\u0001B\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0003\u007f\u0001!\u0011!Q\u0001\n\u0005\u0005\u0003BCA$\u0001\t\u0005\t\u0015!\u0003\u0002J!Q\u0011q\n\u0001\u0003\u0002\u0003\u0006I!!\u0015\t\u0015\u0005]\u0003A!A!\u0002\u0013\tI\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003CB!\"!$\u0001\u0005\u0003\u0005\u000b\u0011BA1\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a0\u0001\t\u0003\n\t\r\u0003\u0004Z\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\tI\u0010\u0001C!\u00033Dq!a?\u0001\t\u0003\ni\u0010C\u0004\u0003 \u0001!IA!\t\t\u000f\t\r\u0002\u0001\"\u0003\u0003\"!9!Q\u0005\u0001\u0005\n\t\u001d\u0002b\u0002B\u0018\u0001\u0011%!q\u0005\u0005\u000b\u0005c\u0001\u0001R1A\u0005\u0002\tM\u0002\"\u0003B\"\u0001\t\u0007I\u0011\u0002B#\u0011!\u0011Y\u0005\u0001Q\u0001\n\t\u001d\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011\t\u0007\u0001C!\u00033DqAa\u0019\u0001\t\u0003\nI\u000eC\u0004\u0003f\u0001!\tEa\u001a\t\u000f\t5\u0004\u0001\"\u0005\u0003p!9!1\u000f\u0001\u0005\u0012\tU\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005\u007f\u0002A\u0011\u0003BA\u0011\u001d\u0011)\u0007\u0001C!\u0005\u000bCqAa&\u0001\t\u0003\u0012I\nC\u0004\u0003&\u0002!\t%!7\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"9!1\u0016\u0001\u0005\n\t%\u0006b\u0002BW\u0001\u0011%!\u0011\u0016\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011I\f\u0001C\u0005\u0005wCqAa8\u0001\t\u0013\u0011\t\u000fC\u0004\u0003r\u0002!IAa=\t\u000f\r\u001d\u0001\u0001\"\u0003\u0003*\"91\u0011\u0002\u0001\u0005\n\t%\u0006bBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u0007#\u0001A\u0011BB\n\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007'Aqaa\u0006\u0001\t\u0013\u0019\u0019\u0002C\u0004\u0004\u001a\u0001!IA!+\t\u000f\rm\u0001\u0001\"\u0001\u0002Z\"Y1\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011AB\u0016\u0011-\u0019\u0019\u0004\u0001a\u0001\u0002\u0004%\ta!\u000e\t\u0017\rm\u0002\u00011A\u0001B\u0003&1Q\u0006\u0005\b\u0007\u0013\u0002A\u0011AB&\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007':qa!\u001fA\u0011\u0003\u0019YH\u0002\u0004@\u0001\"\u00051Q\u0010\u0005\b\u0003'cD\u0011ABC\u0011\u001d\u00119\n\u0010C\u0001\u0007\u000f\u0013\u0001cU9m'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u000b\u0005\u0005\u0013\u0015!\u0003=me\u0016dW-Y:f\u0015\t\u0019E)A\u0005yK\nL\u0017\r\\1cg*\tQ)A\u0002d_6\u001c\u0001a\u0005\u0005\u0001\u0011B#FlX3n!\tIe*D\u0001K\u0015\tYE*\u0001\u0003mC:<'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013aa\u00142kK\u000e$\bCA)S\u001b\u0005\u0001\u0015BA*A\u00055\u0019Fo\u001c:bO\u00164\u0015mY1eKB\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\nY&\fX/\u001b2bg\u0016T!!\u0017!\u0002\u000fU\u0004xM]1eK&\u00111L\u0016\u0002\u000e\u0005\u00164wN]3Va\u001e\u0014\u0018\rZ3\u0011\u0005Ek\u0016B\u00010A\u0005I!Vm\u001d;BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\u0004\u0015A\u00013c\u0013\t!\u0017M\u0001\tMSF,\u0018NY1tKN+\b\u000f]8siB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0006kRLGn\u001d\u0006\u0003U\u0002\u000ba!Y2u_J\u001c\u0018B\u00017h\u0005I\u00196-\u00197b'B\u0014\u0018N\\4TkB\u0004xN\u001d;\u0011\u00059,X\"A8\u000b\u0005A\f\u0018aB2p]R,\u0007\u0010\u001e\u0006\u0003eN\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002i\u0006\u0019qN]4\n\u0005Y|'aF!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\fu/\u0019:f\u000351w\u000e\u001c3feN+'O^5dKB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010Q\u0001\bg\u0016\u0014h/[2f\u0013\ti(PA\u0007G_2$WM]*feZL7-Z\u0001\u0010M\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0001\u000b!B]3q_NLGo\u001c:z\u0013\u0011\tI!a\u0001\u0003\u001f\u0019\u000b7-\u001a;SKB|7/\u001b;pef\fa\u0002^3b[J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\u0011\t\u0019\"a\u0001\u0002\u0007M\fH.\u0003\u0003\u0002\u0018\u0005E!!E*rYR+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\t\u0005\u0005\u0011QD\u0005\u0005\u0003?\t\u0019AA\tSK2,\u0017m]3SKB|7/\u001b;pef\fAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007cA=\u0002&%\u0019\u0011q\u0005>\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0005\u0003c\t\t\"A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0002BA\u001b\u0003_\u0011Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011AA\u001e\u0013\u0011\ti$a\u0001\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018aF2bY\u0016tG-\u0019:F]R\u0014\u0018PU3q_NLGo\u001c:z!\u0011\t\t!a\u0011\n\t\u0005\u0015\u00131\u0001\u0002\u0018\u0007\u0006dWM\u001c3be\u0016sGO]=SKB|7/\u001b;pef\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u0007e\fY%C\u0002\u0002Ni\u0014\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u0002\u0005M\u0013\u0002BA+\u0003\u0007\u0011\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0003BA\u0017\u00037JA!!\u0018\u00020\tyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X\r\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\t\r|'/\u001a\u0006\u0004\u0003W\n\u0018\u0001\u00026eE\u000eLA!a\u001c\u0002f\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\":A\"a\u001d\u0002\b\u0006%\u0005\u0003BA;\u0003\u0007k!!a\u001e\u000b\t\u0005e\u00141P\u0001\u000bC:tw\u000e^1uS>t'\u0002BA?\u0003\u007f\nqAZ1di>\u0014\u0018PC\u0002\u0002\u0002F\fQAY3b]NLA!!\"\u0002x\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0017\u000b\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006)\"/\u001a9peRLgn\u001a&eE\u000e$V-\u001c9mCR,\u0007fB\u0007\u0002t\u0005\u001d\u0015\u0011S\u0011\u0003\u0003\u001b\u000ba\u0001P5oSRtD\u0003HAL\u00033\u000bY*!(\u0002 \u0006\u0005\u00161UAS\u0003O\u000bI+a+\u0002.\u0006=\u00161\u0017\t\u0003#\u0002AQa\u001e\bA\u0002aDQA \bA\u0002}Dq!a\u0003\u000f\u0001\u0004\ti\u0001C\u0004\u0002\u001a9\u0001\r!a\u0007\t\u000f\u0005\u0005b\u00021\u0001\u0002$!9\u0011\u0011\u0006\bA\u0002\u0005-\u0002bBA\u001c\u001d\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u007fq\u0001\u0019AA!\u0011\u001d\t9E\u0004a\u0001\u0003\u0013Bq!a\u0014\u000f\u0001\u0004\t\t\u0006C\u0004\u0002X9\u0001\r!!\u0017\t\u000f\u0005}c\u00021\u0001\u0002b!B\u0011qVA:\u0003\u000f\u000bI\tC\u0004\u0002\u000e:\u0001\r!!\u0019)\u0011\u0005M\u00161OAD\u0003#C3ADA]!\u0011\t)(a/\n\t\u0005u\u0016q\u000f\u0002\n\u0003V$xn^5sK\u0012\f\u0001\u0003\u001f7SK2,\u0017m]3WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005\r\u0007\u0003BAc\u0003+l!!a2\u000b\u0007e\u000bIM\u0003\u0003\u0002L\u00065\u0017aA1qS*!\u0011qZAi\u0003\u0019\u0019XM\u001d<fe*\u0019\u00111\u001b\"\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a6\u0002H\n9a+\u001a:tS>tGCAAn!\u0011\ti.a9\u000e\u0005\u0005}'BAAq\u0003\u0015\u00198-\u00197b\u0013\u0011\t)/a8\u0003\tUs\u0017\u000e^\u0001\u0019e\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,WCAAv!\u0011\ti/!>\u000e\u0005\u0005=(bA-\u0002r*\u0019\u00111\u001f\"\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u0003\u0002x\u0006=(\u0001\u0007*fa>\u001c\u0018\u000e^8ssZ+'o]5p]N+'O^5dK\u0006IAm\\+qOJ\fG-Z\u0001\u0014G>,h\u000e\u001e*fG>\u0014Hm]%o)\u0006\u0014G.\u001a\u000b\u0005\u0003\u007f\u0014)\u0001\u0005\u0003\u0002^\n\u0005\u0011\u0002\u0002B\u0002\u0003?\u0014A\u0001T8oO\"9!qA\nA\u0002\t%\u0011!\u0003;bE2,g*Y7f!\u0011\u0011YA!\u0007\u000f\t\t5!Q\u0003\t\u0005\u0005\u001f\ty.\u0004\u0002\u0003\u0012)\u0019!1\u0003$\u0002\rq\u0012xn\u001c;?\u0013\u0011\u00119\"a8\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YB!\b\u0003\rM#(/\u001b8h\u0015\u0011\u00119\"a8\u0002-]L\u0007/Z(vi\u0006\u00138\r[5wK\u0012\u000bG/\u00192bg\u0016,\"!a7\u0002\u001f]L\u0007/Z(vi\u0012\u000bG/\u00192bg\u0016\f!#[:EE\u000ecW-\u00198va\u0016s\u0017M\u00197fIV\u0011!\u0011\u0006\t\u0005\u0003;\u0014Y#\u0003\u0003\u0003.\u0005}'a\u0002\"p_2,\u0017M\\\u0001\u001fSNLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bK]8gS2,\u0017i\u0019;jm\u0016\f!\u0002Z1uCN{WO]2f+\t\u0011)\u0004\u0005\u0003\u00038\t}RB\u0001B\u001d\u0015\u0011\t\u0019Ba\u000f\u000b\u0005\tu\u0012!\u00026bm\u0006D\u0018\u0002\u0002B!\u0005s\u0011!\u0002R1uCN{WO]2f\u0003\tqE*\u0006\u0002\u0003HA\u0019\u0011J!\u0013\n\u0007\tm!*A\u0002O\u0019\u0002\n1\u0002^1cY\u0016,\u00050[:ugR!!\u0011\u000bB+)\u0011\u0011ICa\u0015\t\u000f\u0005}3\u0004q\u0001\u0002b!9!qA\u000eA\u0002\t%\u0011A\u00053fY\u0016$X\rV1cY\u0016\u001cuN\u001c;f]R$BAa\u0017\u0003`Q!\u00111\u001cB/\u0011\u001d\ty\u0006\ba\u0002\u0003CBqAa\u0002\u001d\u0001\u0004\u0011I!A\reK2,G/\u001a)fe6L7o]5p]Ns\u0017\r]:i_R\u001c\u0018aB2mK\u0006tW\u000f]\u0001\u0007I\u0016dW\r^3\u0015\t\t%\"\u0011\u000e\u0005\b\u0005Wz\u0002\u0019\u0001B\u0005\u0003\tIG-\u0001\beK2,G/\u001a#fY&4XM]=\u0015\t\u0005m'\u0011\u000f\u0005\b\u0005W\u0002\u0003\u0019\u0001B\u0005\u0003=!W\r\\3uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BAn\u0005oBqAa\u001b\"\u0001\u0004\u0011I!\u0001\njg\u001ecwNY1m'\u0016$H/\u001b8hg&#G\u0003\u0002B\u0015\u0005{BqAa\u001b#\u0001\u0004\u0011I!A\u0007eK2,G/\u001a*fY\u0016\f7/\u001a\u000b\u0005\u00037\u0014\u0019\tC\u0004\u0003l\r\u0002\rA!\u0003\u0015\t\t%\"q\u0011\u0005\b\u0005\u0013#\u0003\u0019\u0001BF\u0003\u0011!X-Y7\u0011\t\t5%1S\u0007\u0003\u0005\u001fS1A!%A\u0003\u0019!w.\\1j]&!!Q\u0013BH\u0005\u0011!V-Y7\u0002#\u0011,G.\u001a;f\rJ|W.\u0011:dQ&4X\r\u0006\u0003\u0003\u001c\n\u0005\u0006\u0003BAo\u0005;KAAa(\u0002`\n\u0019\u0011J\u001c;\t\u000f\t\rV\u00051\u0001\u0003\n\u0005I!/\u001a7fCN,\u0017\nZ\u0001\u0016m\u0016\u0014\u0018NZ=SKB|7/\u001b;pef\u001cE.Z1o\u0003%\u0019w.\u001e8u\u0015>\u00147\u000f\u0006\u0002\u0003\u001c\u0006a1m\\;oi\u001a{G\u000eZ3sg\u0006\t2m\\;oi\u0006\u0003\b\u000f\\5dCRLwN\\:\u0002\u0013\r|WO\u001c;S_^\u001cHC\u0002BN\u0005g\u0013)\fC\u0004\u0003\b)\u0002\rA!\u0003\t\u000f\t]&\u00061\u0001\u0003\n\u0005Q1m\u001c7v[:t\u0015-\\3\u0002'\u001d,GOU3nC&t\u0017N\\4EKR\f\u0017\u000e\\:\u0015\u0011\tu&Q\u001bBl\u00057\u0004bAa0\u0003J\n=g\u0002\u0002Ba\u0005\u000btAAa\u0004\u0003D&\u0011\u0011\u0011]\u0005\u0005\u0005\u000f\fy.A\u0004qC\u000e\\\u0017mZ3\n\t\t-'Q\u001a\u0002\u0004'\u0016\f(\u0002\u0002Bd\u0003?\u0004\u0002\"!8\u0003R\n%!\u0011B\u0005\u0005\u0005'\fyN\u0001\u0004UkBdWM\r\u0005\b\u0005\u000fY\u0003\u0019\u0001B\u0005\u0011\u001d\u0011In\u000ba\u0001\u0005\u0013\tA\"\u001b3D_2,XN\u001c(b[\u0016DqA!8,\u0001\u0004\u0011I!A\buSRdWmQ8mk6tg*Y7f\u0003=1XM]5gs2+g\r^8wKJ\u001cH\u0003DAn\u0005G\u00149O!;\u0003n\n=\bb\u0002BsY\u0001\u0007!\u0011B\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\u00119\u0001\fa\u0001\u0005\u0013AqAa;-\u0001\u0004\u0011I!A\bd_VtGoQ8mk6tg*Y7f\u0011\u001d\u0011I\u000e\fa\u0001\u0005\u0013AqA!8-\u0001\u0004\u0011I!\u0001\u000euKN$H)\u001b3O_R\u001cE.Z1o\u0003\u001a$XM]%ug\u0016dg\r\u0006\u0005\u0003v\nm(q`B\u0002!\r\t&q_\u0005\u0004\u0005s\u0004%\u0001\u0006+fgR\u001cE.Z1okB,\u0005pY3qi&|g\u000eC\u0004\u0003~6\u0002\rA!\u0003\u0002\u0011Q,7\u000f\u001e(b[\u0016Dqa!\u0001.\u0001\u0004\u0011i,\u0001\u0004bGRLg/\u001a\u0005\b\u0007\u000bi\u0003\u0019\u0001B_\u0003!\t'o\u00195jm\u0016$\u0017!D2pk:$(+\u001a7fCN,7/A\u0007d_VtG\u000f\u0016:jO\u001e,'o]\u0001\u001cO\u0016$(+Z7bS:Lgn\u001a+sS\u001e<WM]:EKR\f\u0017\u000e\\:\u0015\u0005\r=\u0001C\u0002B`\u0005\u0013\u0014I!A\rhKR\u0014V-\\1j]&twMR8mI\u0016\u0014H)\u001a;bS2\u001cHC\u0001B_\u0003m9W\r\u001e*f[\u0006Lg.\u001b8h%\u0016dW-Y:fg\u0012+G/Y5mg\u0006\u0019s-\u001a;SK6\f\u0017N\\5oO\u0006\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001cH)\u001a;bS2\u001c\u0018!F2pk:$\u0018I]2iSZ,GMU3mK\u0006\u001cXm]\u0001\nG2,\u0017M\u001c-m\t\nD3!NB\u0010!\u0011\u0019\tc!\n\u000e\u0005\r\r\"\u0002BA=\u0005wIAaa\n\u0004$\tQ\u0001K]3EKN$(o\\=\u0002%\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^\u000b\u0003\u0007[\u00012A\\B\u0018\u0013\r\u0019\td\u001c\u0002\u0013\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH/\u0001\fbaBd\u0017nY1uS>t7i\u001c8uKb$x\fJ3r)\u0011\tYna\u000e\t\u0013\rer'!AA\u0002\r5\u0012a\u0001=%c\u0005\u0019\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=uA!\u001a\u0001ha\u0010\u0011\t\r\u00053QI\u0007\u0003\u0007\u0007RA!!!\u0002`&!1qIB\"\u00051\u0011U-\u00198Qe>\u0004XM\u001d;z\u0003U9W\r^!qa2L7-\u0019;j_:\u001cuN\u001c;fqR$\"a!\f)\u0007e\u001aye\u0003\u0001\u0002+M,G/\u00119qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yiR!\u00111\\B+\u0011%\u0019IDOA\u0001\u0002\u0004\u0019i\u0003K\u0002;\u0007\u001fBs\u0001AB.\u0003\u000f\u001b)\u0007\u0005\u0003\u0004^\r\u0005TBAB0\u0015\r\tIh\\\u0005\u0005\u0007G\u001ayFA\u0004Qe>4\u0017\u000e\\3-\u0005\r\u001d\u0014EAB5\u0003=Ig\u000e^3he\u0006$\u0018n\u001c8UKN$\bf\u0001\u0001\u0004nA!1qNB;\u001b\t\u0019\tHC\u0002\u0004tE\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00199h!\u001d\u0003\u0013\r{W\u000e]8oK:$\u0018\u0001E*rYN#xN]1hK\u001a\u000b7-\u00193f!\t\tFhE\u0002=\u0007\u007f\u0002B!!8\u0004\u0002&!11QAp\u0005\u0019\te.\u001f*fMR\u001111\u0010\u000b\u0005\u0007\u0013\u001bi\t\u0006\u0003\u0003\u001c\u000e-\u0005bBA0}\u0001\u0007\u0011\u0011\r\u0005\b\u0005Gs\u0004\u0019\u0001B\u0005\u0001")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final FacetRepository facetRepository;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    private final TaskPersistence taskPersistence;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    public <T> T asAdmin(Function0<T> block) {
        return (T)TestAuthentication.asAdmin$((TestAuthentication)this, block);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        if (this.isDbCleanupEnabled()) {
            DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
            LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
                private final DataSource reportingDataSource$1;

                public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                    return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
                }

                public DataSource dataSource() {
                    return this.reportingDataSource$1;
                }
                {
                    this.reportingDataSource$1 = reportingDataSource$1;
                    LiquibaseSupport.$init$((LiquibaseSupport)this);
                }
            };
            reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void wipeOutDatabase() {
        if (this.isDbCleanupEnabled() && this.isIntegrationTestProfileActive()) {
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean isDbCleanupEnabled() {
        String nodbcleanup = System.getProperty("nodbcleanup", "false");
        boolean isCleanupEnabled = !Boolean.parseBoolean(nodbcleanup);
        this.logger().info(new StringBuilder(17).append("Cleanup enabled: ").append(isCleanupEnabled).toString());
        return isCleanupEnabled;
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        if (!this.bitmap$0) {
            return this.dataSource$lzycompute();
        }
        return this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        if (this.tableExists(tableName, jdbcTemplate)) {
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
            return;
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_JOBS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id, (Integer)$this.taskPersistence.taskUidById(Ids.getParentId((String)id)).get());
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isFacetId((String)id)) {
                        $this.facetRepository.delete(id, $this.facetRepository.delete$default$2());
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else if (Ids.isDeliveryId((String)id)) {
                        this.deleteDelivery(id);
                    } else if (Ids.isDashboardId((String)id)) {
                        this.deleteDashboard(id);
                    } else if (!this.isGlobalSettingsId(id)) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public void deleteDelivery(String id) {
        this.jdbcTemplate.execute(new StringBuilder(40).append("DELETE FROM XLR_DELIVERIES WHERE ID = '").append(Ids.getName((String)id)).append("'").toString());
    }

    public void deleteDashboard(String id) {
        this.jdbcTemplate.execute(new StringBuilder(40).append("DELETE FROM XLR_DASHBOARDS WHERE ID = '").append(Ids.getName((String)id)).append("'").toString());
    }

    private boolean isGlobalSettingsId(String id) {
        String shortId = Ids.getName((String)id);
        return shortId.startsWith("EmailNotificationSettings");
    }

    public void deleteRelease(String id) {
        this.logger().info("Deleting release {}", (Object)id);
        boolean found = false;
        if (this.releaseRepository.exists(id)) {
            this.logger().info("Release {} found in repository", (Object)id);
            try {
                this.teamRepository.deleteTeamsFromPlatform(id);
            }
            catch (NotFoundException e) {
                this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
            }
            this.releaseRepository.delete(id, this.releaseRepository.delete$default$2());
            found = true;
        }
        if (this.archivingService.exists(id)) {
            this.logger().info("Release {} found in archive", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (this.archivingService.existsPreArchived(id)) {
            this.logger().info("Release {} found as pre-archived", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (!found) {
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
            return;
        }
    }

    @Override
    public boolean delete(Team team) {
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            return true;
        }
        return false;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        return (B1)new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    return tuple2 != null;
                }
            });
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
        int jobsCount = this.countJobs();
        if (jobsCount > 0) {
            Seq jobs = (Seq)this.getRemainingDetails(Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID()).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                    A1 A1 = x$1;
                    return (B1)x$1._2();
                }

                public final boolean isDefinedAt(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    return true;
                }
            });
            throw new TestCleanupException(new StringBuilder(25).append(testName).append("There are leftover jobs: ").append(jobs).toString());
        }
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover applications").toString(), "XLR_APPLICATIONS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover environments").toString(), "XLR_ENVIRONMENTS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(23).append(testName).append("There are leftover jobs").toString(), Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID());
    }

    private int countJobs() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT COUNT(1) FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countApplications() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(CI_UID) FROM XLR_APPLICATIONS", (rs, x$4) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countRows(String tableName, String columnName) {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(columnName).append(") FROM ").append(tableName).toString(), (rs, x$5) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingDetails(String tableName, String idColumnName, String titleColumnName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(idColumnName).append(", ").append(titleColumnName).append(" FROM ").append(tableName).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private void verifyLeftovers(String message, String tableName, String countColumnName, String idColumnName, String titleColumnName) {
        int count = this.countRows(tableName, countColumnName);
        if (count > 1) {
            Seq<Tuple2<String, String>> leftOvers = this.getRemainingDetails(tableName, idColumnName, titleColumnName);
            throw new TestCleanupException(new StringBuilder(2).append(message).append(": ").append(leftOvers).toString());
        }
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$7) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$9) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$10) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$11) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$12) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$13) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 != null) {
            String id = (String)tuple2._1();
            String title = (String)tuple2._2();
            return new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, FacetRepository facetRepository, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, TaskPersistence taskPersistence, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.facetRepository = facetRepository;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.taskPersistence = taskPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

