/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\r-d\u0001B\u001e=\u0001\rC\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Q\u00111\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005E\u0001A!A!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u00037A!\"!\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\ty\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0007\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005e\u0002BCA \u0001\t\u0005\t\u0015!\u0003\u0002B!Q\u0011q\t\u0001\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005=\u0003A!A!\u0002\u0013\t\t\u0006\u0003\u0006\u0002~\u0001\u0011\t\u0011)A\u0005\u0003#Bq!a!\u0001\t\u0003\t)\tC\u0004\u0002.\u0002!\t%a,\t\rU\u0003A\u0011IAd\u0011\u001d\t)\u000e\u0001C!\u0003/Dq!a:\u0001\t\u0003\n9\rC\u0004\u0002j\u0002!\t%a;\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!\u0011\u0003\u0001\u0005\n\t=\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005;\u0001A\u0011\u0002B\u000b\u0011)\u0011y\u0002\u0001EC\u0002\u0013\u0005!\u0011\u0005\u0005\n\u0005c\u0001!\u0019!C\u0005\u0005gA\u0001B!\u000f\u0001A\u0003%!Q\u0007\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000fBqAa\u0014\u0001\t\u0003\n9\rC\u0004\u0003R\u0001!\t%a2\t\u000f\tM\u0003\u0001\"\u0011\u0003V!9!1\f\u0001\u0005\u0012\tu\u0003b\u0002B*\u0001\u0011\u0005#\u0011\r\u0005\b\u0005g\u0002A\u0011\tB;\u0011\u001d\u0011\t\t\u0001C!\u0003\u000fDqAa!\u0001\t\u0013\u0011)\tC\u0004\u0003\b\u0002!IA!\"\t\u000f\t%\u0005\u0001\"\u0003\u0003\u0006\"9!1\u0012\u0001\u0005\n\t5\u0005b\u0002BK\u0001\u0011%!q\u0013\u0005\b\u0005w\u0003A\u0011\u0002B_\u0011\u001d\u0011i\r\u0001C\u0005\u0005\u001fDqAa9\u0001\t\u0013\u0011)\tC\u0004\u0003f\u0002!IA!\"\t\u000f\t\u001d\b\u0001\"\u0003\u0003j\"9!Q\u001e\u0001\u0005\n\t=\bb\u0002By\u0001\u0011%!q\u001e\u0005\b\u0005g\u0004A\u0011\u0002Bx\u0011\u001d\u0011)\u0010\u0001C\u0005\u0005\u000bCqAa>\u0001\t\u0003\t9\rC\u0006\u0004\u0006\u0001\u0001\r\u00111A\u0005\u0002\r\u001d\u0001bCB\b\u0001\u0001\u0007\t\u0019!C\u0001\u0007#A1ba\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0004\n!91Q\u0005\u0001\u0005\u0002\r\u001d\u0002bBB\u0017\u0001\u0011\u00051qF\u0004\b\u0007+b\u0004\u0012AB,\r\u0019YD\b#\u0001\u0004Z!9\u00111\u0011\u001d\u0005\u0002\r\u0005\u0004b\u0002B:q\u0011\u000511\r\u0002\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016T!!\u0010 \u0002\u0013ad'/\u001a7fCN,'BA A\u0003%AXMY5bY\u0006\u00147OC\u0001B\u0003\r\u0019w.\\\u0002\u0001'!\u0001A\t\u0014)Y7\u0006L\u0007CA#K\u001b\u00051%BA$I\u0003\u0011a\u0017M\\4\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u00055sU\"\u0001\u001f\n\u0005=c$!D*u_J\fw-\u001a$bG\u0006$W\r\u0005\u0002R-6\t!K\u0003\u0002T)\u0006IA.[9vS\n\f7/\u001a\u0006\u0003+r\nq!\u001e9he\u0006$W-\u0003\u0002X%\ni!)\u001a4pe\u0016,\u0006o\u001a:bI\u0016\u0004\"!T-\n\u0005ic$A\u0005+fgR\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u001f\u0002\u0005\u0011\u0014\u0017B\u00011^\u0005Aa\u0015.];jE\u0006\u001cXmU;qa>\u0014H\u000f\u0005\u0002cO6\t1M\u0003\u0002eK\u0006)Q\u000f^5mg*\u0011a\rP\u0001\u0007C\u000e$xN]:\n\u0005!\u001c'AE*dC2\f7\u000b\u001d:j]\u001e\u001cV\u000f\u001d9peR\u0004\"A[9\u000e\u0003-T!\u0001\\7\u0002\u000f\r|g\u000e^3yi*\u0011an\\\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001/A\u0002pe\u001eL!A]6\u0003/\u0005\u0003\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^!xCJ,\u0017!\u00044pY\u0012,'oU3sm&\u001cW\r\u0005\u0002vq6\taO\u0003\u0002xy\u000591/\u001a:wS\u000e,\u0017BA=w\u000551u\u000e\u001c3feN+'O^5dK\u0006ya-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fy\u0005Q!/\u001a9pg&$xN]=\n\u0007\u0005\u0005QPA\bGC\u000e,GOU3q_NLGo\u001c:z\u00039!X-Y7SKB|7/\u001b;pef\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017i\u0018aA:rY&!\u0011qBA\u0005\u0005E\u0019\u0016\u000f\u001c+fC6\u0014V\r]8tSR|'/_\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bc\u0001?\u0002\u0016%\u0019\u0011qC?\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\t\u0004k\u0006u\u0011bAA\u0010m\n!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\fQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\r\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\u0011\tI#!\u0003\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0005\u0003[\t9CA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bc\u0001?\u00024%\u0019\u0011QG?\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018aF2bY\u0016tG-\u0019:F]R\u0014\u0018PU3q_NLGo\u001c:z!\ra\u00181H\u0005\u0004\u0003{i(aF\"bY\u0016tG-\u0019:F]R\u0014\u0018PU3q_NLGo\u001c:z\u0003A\t'o\u00195jm&twmU3sm&\u001cW\rE\u0002v\u0003\u0007J1!!\u0012w\u0005A\t%o\u00195jm&twmU3sm&\u001cW-A\tue&<w-\u001a:SKB|7/\u001b;pef\u00042\u0001`A&\u0013\r\ti% \u0002\u0012)JLwmZ3s%\u0016\u0004xn]5u_JL\u0018\u0001\u00046eE\u000e$V-\u001c9mCR,\u0007\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0005G>\u0014XMC\u0002\u0002\\5\fAA\u001b3cG&!\u0011qLA+\u00051QEMY2UK6\u0004H.\u0019;fQ\u001dY\u00111MA<\u0003s\u0002B!!\u001a\u0002t5\u0011\u0011q\r\u0006\u0005\u0003S\nY'\u0001\u0006b]:|G/\u0019;j_:TA!!\u001c\u0002p\u00059a-Y2u_JL(bAA9[\u0006)!-Z1og&!\u0011QOA4\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-\t\u0002\u0002|\u0005I\u0002\u0010\u001c:SKB|7/\u001b;pefTEMY2UK6\u0004H.\u0019;f\u0003U\u0011X\r]8si&twM\u00133cGR+W\u000e\u001d7bi\u0016Ds\u0001DA2\u0003o\n\t)\t\u0002\u0002~\u00051A(\u001b8jiz\"\"$a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151TAO\u0003C\u0003\"!\u0014\u0001\t\u000bMl\u0001\u0019\u0001;\t\u000bil\u0001\u0019A>\t\u000f\u0005\rQ\u00021\u0001\u0002\u0006!9\u0011\u0011C\u0007A\u0002\u0005M\u0001bBA\r\u001b\u0001\u0007\u00111\u0004\u0005\b\u0003Ci\u0001\u0019AA\u0012\u0011\u001d\ty#\u0004a\u0001\u0003cAq!a\u000e\u000e\u0001\u0004\tI\u0004C\u0004\u0002@5\u0001\r!!\u0011\t\u000f\u0005\u001dS\u00021\u0001\u0002J!9\u0011qJ\u0007A\u0002\u0005E\u0003\u0006CAO\u0003G\n9(!\u001f\t\u000f\u0005uT\u00021\u0001\u0002R!B\u0011\u0011UA2\u0003o\n\t\tK\u0002\u000e\u0003O\u0003B!!\u001a\u0002*&!\u00111VA4\u0005%\tU\u000f^8xSJ,G-\u0001\tyYJ+G.Z1tKZ+'o]5p]R\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000b\u0019-\u0004\u0002\u00026*\u0019Q+a.\u000b\t\u0005e\u00161X\u0001\u0004CBL'\u0002BA_\u0003\u007f\u000baa]3sm\u0016\u0014(bAAa}\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002F\u0006U&a\u0002,feNLwN\u001c\u000b\u0003\u0003\u0013\u0004B!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0003\u0003\u001f\fQa]2bY\u0006LA!a5\u0002N\n!QK\\5u\u0003a\u0011X\r]8tSR|'/\u001f,feNLwN\\*feZL7-Z\u000b\u0003\u00033\u0004B!a7\u0002d6\u0011\u0011Q\u001c\u0006\u0004+\u0006}'bAAq}\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\t\u0005\u0015\u0018Q\u001c\u0002\u0019%\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,\u0017!\u00033p+B<'/\u00193f\u0003M\u0019w.\u001e8u%\u0016\u001cwN\u001d3t\u0013:$\u0016M\u00197f)\u0011\ti/a=\u0011\t\u0005-\u0017q^\u0005\u0005\u0003c\fiM\u0001\u0003M_:<\u0007bBA{%\u0001\u0007\u0011q_\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B!!?\u0003\b9!\u00111 B\u0002!\u0011\ti0!4\u000e\u0005\u0005}(b\u0001B\u0001\u0005\u00061AH]8pizJAA!\u0002\u0002N\u00061\u0001K]3eK\u001aLAA!\u0003\u0003\f\t11\u000b\u001e:j]\u001eTAA!\u0002\u0002N\u00061r/\u001b9f\u001fV$\u0018I]2iSZ,G)\u0019;bE\u0006\u001cX-\u0006\u0002\u0002J\u0006yq/\u001b9f\u001fV$H)\u0019;bE\u0006\u001cX-\u0001\njg\u0012\u00137\t\\3b]V\u0004XI\\1cY\u0016$WC\u0001B\f!\u0011\tYM!\u0007\n\t\tm\u0011Q\u001a\u0002\b\u0005>|G.Z1o\u0003yI7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e)s_\u001aLG.Z!di&4X-\u0001\u0006eCR\f7k\\;sG\u0016,\"Aa\t\u0011\t\t\u0015\"QF\u0007\u0003\u0005OQA!a\u0003\u0003*)\u0011!1F\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005_\u00119C\u0001\u0006ECR\f7k\\;sG\u0016\f!A\u0014'\u0016\u0005\tU\u0002cA#\u00038%\u0019!\u0011\u0002$\u0002\u00079c\u0005%A\u0006uC\ndW-\u0012=jgR\u001cH\u0003\u0002B \u0005\u0007\"BAa\u0006\u0003B!9\u0011q\n\u000eA\u0004\u0005E\u0003bBA{5\u0001\u0007\u0011q_\u0001\u0013I\u0016dW\r^3UC\ndWmQ8oi\u0016tG\u000f\u0006\u0003\u0003J\t5C\u0003BAe\u0005\u0017Bq!a\u0014\u001c\u0001\b\t\t\u0006C\u0004\u0002vn\u0001\r!a>\u00023\u0011,G.\u001a;f!\u0016\u0014X.[:tS>t7K\\1qg\"|Go]\u0001\bG2,\u0017M\\;q\u0003\u0019!W\r\\3uKR!!q\u0003B,\u0011\u001d\u0011IF\ba\u0001\u0003o\f!!\u001b3\u0002\u001b\u0011,G.\u001a;f%\u0016dW-Y:f)\u0011\tIMa\u0018\t\u000f\tes\u00041\u0001\u0002xR!!q\u0003B2\u0011\u001d\u0011)\u0007\ta\u0001\u0005O\nA\u0001^3b[B!!\u0011\u000eB8\u001b\t\u0011YGC\u0002\u0003nq\na\u0001Z8nC&t\u0017\u0002\u0002B9\u0005W\u0012A\u0001V3b[\u0006\tB-\u001a7fi\u00164%o\\7Be\u000eD\u0017N^3\u0015\t\t]$Q\u0010\t\u0005\u0003\u0017\u0014I(\u0003\u0003\u0003|\u00055'aA%oi\"9!qP\u0011A\u0002\u0005]\u0018!\u0003:fY\u0016\f7/Z%e\u0003U1XM]5gsJ+\u0007o\\:ji>\u0014\u0018p\u00117fC:\f\u0011bY8v]RTuNY:\u0015\u0005\t]\u0014\u0001D2pk:$hi\u001c7eKJ\u001c\u0018!E2pk:$\u0018\t\u001d9mS\u000e\fG/[8og\u0006I1m\\;oiJ{wo\u001d\u000b\u0007\u0005o\u0012yI!%\t\u000f\u0005Uh\u00051\u0001\u0002x\"9!1\u0013\u0014A\u0002\u0005]\u0018AC2pYVlgNT1nK\u0006\u0019r-\u001a;SK6\f\u0017N\\5oO\u0012+G/Y5mgRA!\u0011\u0014BY\u0005g\u00139\f\u0005\u0004\u0003\u001c\n\u0015&1\u0016\b\u0005\u0005;\u0013\tK\u0004\u0003\u0002~\n}\u0015BAAh\u0013\u0011\u0011\u0019+!4\u0002\u000fA\f7m[1hK&!!q\u0015BU\u0005\r\u0019V-\u001d\u0006\u0005\u0005G\u000bi\r\u0005\u0005\u0002L\n5\u0016q_A|\u0013\u0011\u0011y+!4\u0003\rQ+\b\u000f\\33\u0011\u001d\t)p\na\u0001\u0003oDqA!.(\u0001\u0004\t90\u0001\u0007jI\u000e{G.^7o\u001d\u0006lW\rC\u0004\u0003:\u001e\u0002\r!a>\u0002\u001fQLG\u000f\\3D_2,XN\u001c(b[\u0016\fqB^3sS\u001aLH*\u001a4u_Z,'o\u001d\u000b\r\u0003\u0013\u0014yLa1\u0003F\n%'1\u001a\u0005\b\u0005\u0003D\u0003\u0019AA|\u0003\u001diWm]:bO\u0016Dq!!>)\u0001\u0004\t9\u0010C\u0004\u0003H\"\u0002\r!a>\u0002\u001f\r|WO\u001c;D_2,XN\u001c(b[\u0016DqA!.)\u0001\u0004\t9\u0010C\u0004\u0003:\"\u0002\r!a>\u00025Q,7\u000f\u001e#jI:{Go\u00117fC:\fe\r^3s\u0013R\u001cX\r\u001c4\u0015\u0011\tE'q\u001bBn\u0005?\u00042!\u0014Bj\u0013\r\u0011)\u000e\u0010\u0002\u0015)\u0016\u001cHo\u00117fC:,\b/\u0012=dKB$\u0018n\u001c8\t\u000f\te\u0017\u00061\u0001\u0002x\u0006AA/Z:u\u001d\u0006lW\rC\u0004\u0003^&\u0002\rA!'\u0002\r\u0005\u001cG/\u001b<f\u0011\u001d\u0011\t/\u000ba\u0001\u00053\u000b\u0001\"\u0019:dQ&4X\rZ\u0001\u000eG>,h\u000e\u001e*fY\u0016\f7/Z:\u0002\u001b\r|WO\u001c;Ue&<w-\u001a:t\u0003m9W\r\u001e*f[\u0006Lg.\u001b8h)JLwmZ3sg\u0012+G/Y5mgR\u0011!1\u001e\t\u0007\u00057\u0013)+a>\u00023\u001d,GOU3nC&t\u0017N\\4G_2$WM\u001d#fi\u0006LGn\u001d\u000b\u0003\u00053\u000b1dZ3u%\u0016l\u0017-\u001b8j]\u001e\u0014V\r\\3bg\u0016\u001cH)\u001a;bS2\u001c\u0018aI4fiJ+W.Y5oS:<\u0017I]2iSZ,GMU3mK\u0006\u001cXm\u001d#fi\u0006LGn]\u0001\u0016G>,h\u000e^!sG\"Lg/\u001a3SK2,\u0017m]3t\u0003%\u0019G.Z1o12$%\rK\u00022\u0005w\u0004BA!@\u0004\u00025\u0011!q \u0006\u0005\u0003S\u0012I#\u0003\u0003\u0004\u0004\t}(A\u0003)sK\u0012+7\u000f\u001e:ps\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u+\t\u0019I\u0001E\u0002k\u0007\u0017I1a!\u0004l\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002-\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^0%KF$B!!3\u0004\u0014!I1QC\u001a\u0002\u0002\u0003\u00071\u0011B\u0001\u0004q\u0012\n\u0014aE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR\u0004\u0003f\u0001\u001b\u0004\u001cA!1QDB\u0011\u001b\t\u0019yB\u0003\u0003\u0002r\u00055\u0017\u0002BB\u0012\u0007?\u0011ABQ3b]B\u0013x\u000e]3sif\fQcZ3u\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\u0006\u0002\u0004\n!\u001aQga\u000b\f\u0001\u0005)2/\u001a;BaBd\u0017nY1uS>t7i\u001c8uKb$H\u0003BAe\u0007cA\u0011b!\u00067\u0003\u0003\u0005\ra!\u0003)\u0007Y\u001aY\u0003K\u0004\u0001\u0007o\t9h!\u0011\u0011\t\re2QH\u0007\u0003\u0007wQ1!!\u001bl\u0013\u0011\u0019yda\u000f\u0003\u000fA\u0013xNZ5mK2\u001211I\u0011\u0003\u0007\u000b\nq\"\u001b8uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0015\u0004\u0001\r%\u0003\u0003BB&\u0007#j!a!\u0014\u000b\u0007\r=S.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa\u0015\u0004N\tI1i\\7q_:,g\u000e^\u0001\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016\u0004\"!\u0014\u001d\u0014\u0007a\u001aY\u0006\u0005\u0003\u0002L\u000eu\u0013\u0002BB0\u0003\u001b\u0014a!\u00118z%\u00164GCAB,)\u0011\u0019)g!\u001b\u0015\t\t]4q\r\u0005\b\u0003\u001fR\u0004\u0019AA)\u0011\u001d\u0011yH\u000fa\u0001\u0003o\u0004")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final FacetRepository facetRepository;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_JOBS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isFacetId((String)id)) {
                        $this.facetRepository.delete(id, $this.facetRepository.delete$default$2());
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block5: {
            this.logger().info("Deleting release {}", (Object)id);
            boolean found = false;
            if (this.releaseRepository.exists(id)) {
                this.logger().info("Release {} found in repository", (Object)id);
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                found = true;
            }
            if (this.archivingService.exists(id)) {
                this.logger().info("Release {} found in archive", (Object)id);
                this.deleteFromArchive(id);
                found = true;
            }
            if (this.archivingService.existsPreArchived(id)) {
                this.logger().info("Release {} found as pre-archived", (Object)id);
                this.deleteFromArchive(id);
                found = true;
            }
            if (found) break block5;
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        object = new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            });
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
        int jobsCount = this.countJobs();
        if (jobsCount > 0) {
            Seq jobs = (Seq)this.getRemainingDetails(Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID()).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                    A1 A1 = x$1;
                    Object object = x$1._2();
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    boolean bl = true;
                    return bl;
                }
            });
            throw new TestCleanupException(new StringBuilder(25).append(testName).append("There are leftover jobs: ").append(jobs).toString());
        }
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover applications").toString(), "XLR_APPLICATIONS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover environments").toString(), "XLR_ENVIRONMENTS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(23).append(testName).append("There are leftover jobs").toString(), Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID());
    }

    private int countJobs() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT COUNT(1) FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countApplications() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(CI_UID) FROM XLR_APPLICATIONS", (rs, x$4) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countRows(String tableName, String columnName) {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(columnName).append(") FROM ").append(tableName).toString(), (rs, x$5) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingDetails(String tableName, String idColumnName, String titleColumnName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(idColumnName).append(", ").append(titleColumnName).append(" FROM ").append(tableName).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private void verifyLeftovers(String message, String tableName, String countColumnName, String idColumnName, String titleColumnName) {
        int count = this.countRows(tableName, countColumnName);
        if (count > 1) {
            Seq<Tuple2<String, String>> leftOvers = this.getRemainingDetails(tableName, idColumnName, titleColumnName);
            throw new TestCleanupException(new StringBuilder(2).append(message).append(": ").append(leftOvers).toString());
        }
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$7) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$9) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$10) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$11) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$12) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$13) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, FacetRepository facetRepository, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.facetRepository = facetRepository;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

