/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\r\u001dd\u0001\u0002\u001e<\u0001\tC\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\ts\u0002\u0011\t\u0011)A\u0005u\"Q\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005=\u0001A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0005\u00033A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011)\ti\u0003\u0001B\u0001B\u0003%\u0011q\u0006\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002BCA\u001f\u0001\t\u0005\t\u0015!\u0003\u0002@!Q\u0011Q\t\u0001\u0003\u0002\u0003\u0006I!a\u0012\t\u0015\u00055\u0003A!A!\u0002\u0013\ty\u0005\u0003\u0006\u0002|\u0001\u0011\t\u0011)A\u0005\u0003\u001fBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002,\u0002!\t%!,\t\rQ\u0003A\u0011IAc\u0011\u001d\t\u0019\u000e\u0001C!\u0003+Dq!!:\u0001\t\u0003\n)\rC\u0004\u0002h\u0002!\t%!;\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!q\u0002\u0001\u0005\n\t5\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u00057\u0001A\u0011\u0002B\n\u0011)\u0011i\u0002\u0001EC\u0002\u0013\u0005!q\u0004\u0005\n\u0005_\u0001!\u0019!C\u0005\u0005cA\u0001Ba\u000e\u0001A\u0003%!1\u0007\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqA!\u0014\u0001\t\u0003\n)\rC\u0004\u0003P\u0001!\t%!2\t\u000f\tE\u0003\u0001\"\u0011\u0003T!9!\u0011\f\u0001\u0005\u0012\tm\u0003b\u0002B)\u0001\u0011\u0005#q\f\u0005\b\u0005c\u0002A\u0011\tB:\u0011\u001d\u0011y\b\u0001C!\u0003\u000bDqA!!\u0001\t\u0013\u0011\u0019\tC\u0004\u0003\u0006\u0002!IAa!\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!\u0011\u0013\u0001\u0005\n\tM\u0005b\u0002B\\\u0001\u0011%!\u0011\u0018\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u0011\u001d\u0011y\u000e\u0001C\u0005\u0005\u0007CqA!9\u0001\t\u0013\u0011\u0019\tC\u0004\u0003d\u0002!IA!:\t\u000f\t%\b\u0001\"\u0003\u0003l\"9!Q\u001e\u0001\u0005\n\t-\bb\u0002Bx\u0001\u0011%!1\u001e\u0005\b\u0005c\u0004A\u0011\u0002BB\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0003\u000bD1b!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0004\u0004!Y11\u0002\u0001A\u0002\u0003\u0007I\u0011AB\u0007\u0011-\u0019\u0019\u0002\u0001a\u0001\u0002\u0003\u0006Ka!\u0002\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91\u0011\u0006\u0001\u0005\u0002\r-raBB)w!\u000511\u000b\u0004\u0007umB\ta!\u0016\t\u000f\u0005\u0005u\u0007\"\u0001\u0004^!9!\u0011O\u001c\u0005\u0002\r}#\u0001E*rYN#xN]1hK\u001a\u000b7-\u00193f\u0015\taT(A\u0005yYJ,G.Z1tK*\u0011ahP\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001Q\u0001\u0004G>l7\u0001A\n\t\u0001\r[uj\u0016.aQB\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0005Y\u0006twMC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%AB(cU\u0016\u001cG\u000f\u0005\u0002M\u001b6\t1(\u0003\u0002Ow\ti1\u000b^8sC\u001e,g)Y2bI\u0016\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\u00131L\u0017/^5cCN,'B\u0001+<\u0003\u001d)\bo\u001a:bI\u0016L!AV)\u0003\u001b\t+gm\u001c:f+B<'/\u00193f!\ta\u0005,\u0003\u0002Zw\t\u0011B+Z:u\u0003V$\b.\u001a8uS\u000e\fG/[8o!\tYf,D\u0001]\u0015\ti6(\u0001\u0002eE&\u0011q\f\u0018\u0002\u0011\u0019&\fX/\u001b2bg\u0016\u001cV\u000f\u001d9peR\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0015\\\u0014AB1di>\u00148/\u0003\u0002hE\n\u00112kY1mCN\u0003(/\u001b8h'V\u0004\bo\u001c:u!\tI\u0007/D\u0001k\u0015\tYG.A\u0004d_:$X\r\u001f;\u000b\u00055t\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003=\f1a\u001c:h\u0013\t\t(NA\fBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018i^1sK\u0006iam\u001c7eKJ\u001cVM\u001d<jG\u0016\u0004\"\u0001^<\u000e\u0003UT!A^\u001e\u0002\u000fM,'O^5dK&\u0011\u00010\u001e\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001f\u0019\f7-\u001a;SKB|7/\u001b;pef\u0004\"a\u001f@\u000e\u0003qT!!`\u001e\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002\u0000y\nya)Y2fiJ+\u0007o\\:ji>\u0014\u00180\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003}\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u001b\t9AA\tTc2$V-Y7SKB|7/\u001b;pef\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\rY\u00181C\u0005\u0004\u0003+a(!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u00042\u0001^A\u000e\u0013\r\ti\"\u001e\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKB!\u00111EA\u0015\u001b\t\t)C\u0003\u0003\u0002(\u0005\u001d\u0011a\u00039feNL7\u000f^3oG\u0016LA!a\u000b\u0002&\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\rY\u0018\u0011G\u0005\u0004\u0003ga(aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003]\u0019\u0017\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002|\u0003sI1!a\u000f}\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0019A/!\u0011\n\u0007\u0005\rSO\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0007m\fI%C\u0002\u0002Lq\u0014\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u00031QGMY2UK6\u0004H.\u0019;f!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\nAaY8sK*\u0019\u0011\u0011\f7\u0002\t)$'mY\u0005\u0005\u0003;\n\u0019F\u0001\u0007KI\n\u001cG+Z7qY\u0006$X\rK\u0004\f\u0003C\n)(a\u001e\u0011\t\u0005\r\u0014\u0011O\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005-\u0014QN\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\ty\u0007\\\u0001\u0006E\u0016\fgn]\u0005\u0005\u0003g\n)GA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u0011\u0011P\u0001\u001aq2\u0014(+\u001a9pg&$xN]=KI\n\u001cG+Z7qY\u0006$X-A\u000bsKB|'\u000f^5oO*#'m\u0019+f[Bd\u0017\r^3)\u000f1\t\t'!\u001e\u0002\u0000\u0005\u0012\u00111P\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005\u0015\u0015qQAE\u0003\u0017\u000bi)a$\u0002\u0012\u0006M\u0015QSAL\u00033\u000bY*a(\u0011\u00051\u0003\u0001\"\u0002:\u000e\u0001\u0004\u0019\b\"B=\u000e\u0001\u0004Q\bbBA\u0001\u001b\u0001\u0007\u00111\u0001\u0005\b\u0003\u001fi\u0001\u0019AA\t\u0011\u001d\t9\"\u0004a\u0001\u00033Aq!a\b\u000e\u0001\u0004\t\t\u0003C\u0004\u0002.5\u0001\r!a\f\t\u000f\u0005UR\u00021\u0001\u00028!9\u0011QH\u0007A\u0002\u0005}\u0002bBA#\u001b\u0001\u0007\u0011q\t\u0005\b\u0003\u001bj\u0001\u0019AA(Q!\tY*!\u0019\u0002v\u0005]\u0004bBA>\u001b\u0001\u0007\u0011q\n\u0015\t\u0003?\u000b\t'!\u001e\u0002\u0000!\u001aQ\"!*\u0011\t\u0005\r\u0014qU\u0005\u0005\u0003S\u000b)GA\u0005BkR|w/\u001b:fI\u0006\u0001\u0002\u0010\u001c*fY\u0016\f7/\u001a,feNLwN\u001c\u000b\u0003\u0003_\u0003B!!-\u0002B6\u0011\u00111\u0017\u0006\u0004)\u0006U&\u0002BA\\\u0003s\u000b1!\u00199j\u0015\u0011\tY,!0\u0002\rM,'O^3s\u0015\r\ty,P\u0001\tI\u0016\u0004Hn\\=ji&!\u00111YAZ\u0005\u001d1VM]:j_:$\"!a2\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017T!!!4\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00171\u001a\u0002\u0005+:LG/\u0001\rsKB|7/\u001b;pef4VM]:j_:\u001cVM\u001d<jG\u0016,\"!a6\u0011\t\u0005e\u0017\u0011]\u0007\u0003\u00037T1\u0001VAo\u0015\r\ty.P\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017\u0002BAr\u00037\u0014\u0001DU3q_NLGo\u001c:z-\u0016\u00148/[8o'\u0016\u0014h/[2f\u0003%!w.\u00169he\u0006$W-A\nd_VtGOU3d_J$7/\u00138UC\ndW\r\u0006\u0003\u0002l\u0006E\b\u0003BAe\u0003[LA!a<\u0002L\n!Aj\u001c8h\u0011\u001d\t\u0019P\u0005a\u0001\u0003k\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\t\u0005](Q\u0001\b\u0005\u0003s\u0014\t\u0001\u0005\u0003\u0002|\u0006-WBAA\u007f\u0015\r\ty0Q\u0001\u0007yI|w\u000e\u001e \n\t\t\r\u00111Z\u0001\u0007!J,G-\u001a4\n\t\t\u001d!\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\t\t\r\u00111Z\u0001\u0017o&\u0004XmT;u\u0003J\u001c\u0007.\u001b<f\t\u0006$\u0018MY1tKV\u0011\u0011qY\u0001\u0010o&\u0004XmT;u\t\u0006$\u0018MY1tK\u0006\u0011\u0012n\u001d#c\u00072,\u0017M\\;q\u000b:\f'\r\\3e+\t\u0011)\u0002\u0005\u0003\u0002J\n]\u0011\u0002\u0002B\r\u0003\u0017\u0014qAQ8pY\u0016\fg.\u0001\u0010jg&sG/Z4sCRLwN\u001c+fgR\u0004&o\u001c4jY\u0016\f5\r^5wK\u0006QA-\u0019;b'>,(oY3\u0016\u0005\t\u0005\u0002\u0003\u0002B\u0012\u0005Wi!A!\n\u000b\t\u0005%!q\u0005\u0006\u0003\u0005S\tQA[1wCbLAA!\f\u0003&\tQA)\u0019;b'>,(oY3\u0002\u00059cUC\u0001B\u001a!\r!%QG\u0005\u0004\u0005\u000f)\u0015a\u0001(MA\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0011\u0011iD!\u0011\u0015\t\tU!q\b\u0005\b\u0003\u001bR\u00029AA(\u0011\u001d\t\u0019P\u0007a\u0001\u0003k\f!\u0003Z3mKR,G+\u00192mK\u000e{g\u000e^3oiR!!q\tB&)\u0011\t9M!\u0013\t\u000f\u000553\u0004q\u0001\u0002P!9\u00111_\u000eA\u0002\u0005U\u0018!\u00073fY\u0016$X\rU3s[&\u001c8/[8o':\f\u0007o\u001d5piN\fqa\u00197fC:,\b/\u0001\u0004eK2,G/\u001a\u000b\u0005\u0005+\u0011)\u0006C\u0004\u0003Xy\u0001\r!!>\u0002\u0005%$\u0017!\u00043fY\u0016$XMU3mK\u0006\u001cX\r\u0006\u0003\u0002H\nu\u0003b\u0002B,?\u0001\u0007\u0011Q\u001f\u000b\u0005\u0005+\u0011\t\u0007C\u0004\u0003d\u0001\u0002\rA!\u001a\u0002\tQ,\u0017-\u001c\t\u0005\u0005O\u0012i'\u0004\u0002\u0003j)\u0019!1N\u001e\u0002\r\u0011|W.Y5o\u0013\u0011\u0011yG!\u001b\u0003\tQ+\u0017-\\\u0001\u0012I\u0016dW\r^3Ge>l\u0017I]2iSZ,G\u0003\u0002B;\u0005w\u0002B!!3\u0003x%!!\u0011PAf\u0005\rIe\u000e\u001e\u0005\b\u0005{\n\u0003\u0019AA{\u0003%\u0011X\r\\3bg\u0016LE-A\u000bwKJLg-\u001f*fa>\u001c\u0018\u000e^8ss\u000ecW-\u00198\u0002\u0019\r|WO\u001c;G_2$WM]:\u0015\u0005\tU\u0014!E2pk:$\u0018\t\u001d9mS\u000e\fG/[8og\u0006I1m\\;oiJ{wo\u001d\u000b\u0007\u0005k\u0012YI!$\t\u000f\u0005MX\u00051\u0001\u0002v\"9!qR\u0013A\u0002\u0005U\u0018AC2pYVlgNT1nK\u0006\u0019r-\u001a;SK6\f\u0017N\\5oO\u0012+G/Y5mgRA!Q\u0013BW\u0005_\u0013\u0019\f\u0005\u0004\u0003\u0018\n\u0005&q\u0015\b\u0005\u00053\u0013iJ\u0004\u0003\u0002|\nm\u0015BAAg\u0013\u0011\u0011y*a3\u0002\u000fA\f7m[1hK&!!1\u0015BS\u0005\r\u0019V-\u001d\u0006\u0005\u0005?\u000bY\r\u0005\u0005\u0002J\n%\u0016Q_A{\u0013\u0011\u0011Y+a3\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019P\na\u0001\u0003kDqA!-'\u0001\u0004\t)0\u0001\u0007jI\u000e{G.^7o\u001d\u0006lW\rC\u0004\u00036\u001a\u0002\r!!>\u0002\u001fQLG\u000f\\3D_2,XN\u001c(b[\u0016\fqB^3sS\u001aLH*\u001a4u_Z,'o\u001d\u000b\r\u0003\u000f\u0014YLa0\u0003B\n\u0015'q\u0019\u0005\b\u0005{;\u0003\u0019AA{\u0003\u001diWm]:bO\u0016Dq!a=(\u0001\u0004\t)\u0010C\u0004\u0003D\u001e\u0002\r!!>\u0002\u001f\r|WO\u001c;D_2,XN\u001c(b[\u0016DqA!-(\u0001\u0004\t)\u0010C\u0004\u00036\u001e\u0002\r!!>\u00025Q,7\u000f\u001e#jI:{Go\u00117fC:\fe\r^3s\u0013R\u001cX\r\u001c4\u0015\u0011\t5'1\u001bBl\u00057\u00042\u0001\u0014Bh\u0013\r\u0011\tn\u000f\u0002\u0015)\u0016\u001cHo\u00117fC:,\b/\u0012=dKB$\u0018n\u001c8\t\u000f\tU\u0007\u00061\u0001\u0002v\u0006AA/Z:u\u001d\u0006lW\rC\u0004\u0003Z\"\u0002\rA!&\u0002\r\u0005\u001cG/\u001b<f\u0011\u001d\u0011i\u000e\u000ba\u0001\u0005+\u000b\u0001\"\u0019:dQ&4X\rZ\u0001\u000eG>,h\u000e\u001e*fY\u0016\f7/Z:\u0002\u001b\r|WO\u001c;Ue&<w-\u001a:t\u0003m9W\r\u001e*f[\u0006Lg.\u001b8h)JLwmZ3sg\u0012+G/Y5mgR\u0011!q\u001d\t\u0007\u0005/\u0013\t+!>\u00023\u001d,GOU3nC&t\u0017N\\4G_2$WM\u001d#fi\u0006LGn\u001d\u000b\u0003\u0005+\u000b1dZ3u%\u0016l\u0017-\u001b8j]\u001e\u0014V\r\\3bg\u0016\u001cH)\u001a;bS2\u001c\u0018aI4fiJ+W.Y5oS:<\u0017I]2iSZ,GMU3mK\u0006\u001cXm\u001d#fi\u0006LGn]\u0001\u0016G>,h\u000e^!sG\"Lg/\u001a3SK2,\u0017m]3t\u0003%\u0019G.Z1o12$%\rK\u00021\u0005o\u0004BA!?\u0003~6\u0011!1 \u0006\u0005\u0003O\u00129#\u0003\u0003\u0003\u0000\nm(A\u0003)sK\u0012+7\u000f\u001e:ps\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u+\t\u0019)\u0001E\u0002j\u0007\u000fI1a!\u0003k\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002-\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^0%KF$B!a2\u0004\u0010!I1\u0011\u0003\u001a\u0002\u0002\u0003\u00071QA\u0001\u0004q\u0012\n\u0014aE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR\u0004\u0003fA\u001a\u0004\u0018A!1\u0011DB\u000f\u001b\t\u0019YB\u0003\u0003\u0002p\u0005-\u0017\u0002BB\u0010\u00077\u0011ABQ3b]B\u0013x\u000e]3sif\fQcZ3u\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\u0006\u0002\u0004\u0006!\u001aAga\n\f\u0001\u0005)2/\u001a;BaBd\u0017nY1uS>t7i\u001c8uKb$H\u0003BAd\u0007[A\u0011b!\u00056\u0003\u0003\u0005\ra!\u0002)\u0007U\u001a9\u0003K\u0004\u0001\u0007g\t)h!\u0010\u0011\t\rU2\u0011H\u0007\u0003\u0007oQ1!a\u001ak\u0013\u0011\u0019Yda\u000e\u0003\u000fA\u0013xNZ5mK2\u00121qH\u0011\u0003\u0007\u0003\nq\"\u001b8uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0015\u0004\u0001\r\u0015\u0003\u0003BB$\u0007\u001bj!a!\u0013\u000b\u0007\r-C.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa\u0014\u0004J\tI1i\\7q_:,g\u000e^\u0001\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016\u0004\"\u0001T\u001c\u0014\u0007]\u001a9\u0006\u0005\u0003\u0002J\u000ee\u0013\u0002BB.\u0003\u0017\u0014a!\u00118z%\u00164GCAB*)\u0011\u0019\tg!\u001a\u0015\t\tU41\r\u0005\b\u0003\u001bJ\u0004\u0019AA(\u0011\u001d\u0011i(\u000fa\u0001\u0003k\u0004")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final FacetRepository facetRepository;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isFacetId((String)id)) {
                        $this.facetRepository.delete(id, $this.facetRepository.delete$default$2());
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block5: {
            this.logger().info("Deleting release {}", (Object)id);
            boolean found = false;
            if (this.releaseRepository.exists(id)) {
                this.logger().info("Release {} found in repository", (Object)id);
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                found = true;
            }
            if (this.archivingService.exists(id)) {
                this.logger().info("Release {} found in archive", (Object)id);
                this.deleteFromArchive(id);
                found = true;
            }
            if (this.archivingService.existsPreArchived(id)) {
                this.logger().info("Release {} found as pre-archived", (Object)id);
                this.deleteFromArchive(id);
                found = true;
            }
            if (found) break block5;
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        object = new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            });
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover applications").toString(), "XLR_APPLICATIONS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover environments").toString(), "XLR_ENVIRONMENTS", "CI_UID", "ID", "TITLE");
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countApplications() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(CI_UID) FROM XLR_APPLICATIONS", (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countRows(String tableName, String columnName) {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(columnName).append(") FROM ").append(tableName).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingDetails(String tableName, String idColumnName, String titleColumnName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(idColumnName).append(", ").append(titleColumnName).append(" FROM ").append(tableName).toString(), (rs, x$4) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private void verifyLeftovers(String message, String tableName, String countColumnName, String idColumnName, String titleColumnName) {
        int count = this.countRows(tableName, countColumnName);
        if (count > 1) {
            Seq<Tuple2<String, String>> leftOvers = this.getRemainingDetails(tableName, idColumnName, titleColumnName);
            throw new TestCleanupException(new StringBuilder(2).append(message).append(": ").append(leftOvers).toString());
        }
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$5) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$6) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$7) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$8) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$9) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$10) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$11) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, FacetRepository facetRepository, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.facetRepository = facetRepository;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

