/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\r\u001db\u0001B\u001b7\u0001uB\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"AQ\u0010\u0001B\u0001B\u0003%a\u0010\u0003\u0006\u0002\u0006\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\b\u0011)\tY\u0002\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002.!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\u0005m\u0002A!A!\u0002\u0013\ti\u0004\u0003\u0006\u0002j\u0001\u0011\t\u0011)A\u0005\u0003{Aq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002\u0018\u0002!\t%!'\t\r=\u0003A\u0011IAY\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!!5\u0001\t\u0003\n\t\fC\u0004\u0002T\u0002!\t%!6\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9\u00111 \u0001\u0005\n\u0005e\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005\u000f\u0001A\u0011BA\u0000\u0011)\u0011I\u0001\u0001EC\u0002\u0013\u0005!1\u0002\u0005\n\u00057\u0001!\u0019!C\u0005\u0005;A\u0001Ba\t\u0001A\u0003%!q\u0004\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005cAqA!\u000f\u0001\t\u0003\n\t\fC\u0004\u0003<\u0001!\t%!-\t\u000f\tu\u0002\u0001\"\u0011\u0003@!9!Q\t\u0001\u0005\u0012\t\u001d\u0003b\u0002B\u001f\u0001\u0011\u0005#1\n\u0005\b\u0005;\u0002A\u0011\tB0\u0011\u001d\u0011Y\u0007\u0001C!\u0003cCqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003r\u0001!IAa\u001d\t\u000f\t}\u0005\u0001\"\u0003\u0003p!9!\u0011\u0015\u0001\u0005\n\t=\u0004b\u0002BR\u0001\u0011%!Q\u0015\u0005\b\u0005S\u0003A\u0011\u0002BV\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005WCqAa,\u0001\t\u0013\u0011Y\u000bC\u0004\u00032\u0002!IAa\u001c\t\u000f\tM\u0006\u0001\"\u0001\u00022\"Y!\u0011\u0019\u0001A\u0002\u0003\u0007I\u0011\u0001Bb\u0011-\u0011Y\r\u0001a\u0001\u0002\u0004%\tA!4\t\u0017\tM\u0007\u00011A\u0001B\u0003&!Q\u0019\u0005\b\u0005C\u0004A\u0011\u0001Br\u0011\u001d\u0011I\u000f\u0001C\u0001\u0005W<qa!\u00057\u0011\u0003\u0019\u0019B\u0002\u00046m!\u00051Q\u0003\u0005\b\u0003_\u0012D\u0011AB\u000f\u0011\u001d\u0011iF\rC\u0001\u0007?\u0011\u0001cU9m'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u000b\u0005]B\u0014!\u0003=me\u0016dW-Y:f\u0015\tI$(A\u0005yK\nL\u0017\r\\1cg*\t1(A\u0002d_6\u001c\u0001a\u0005\u0005\u0001}\u0019S%+V.d!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u00142kK\u000e$\bCA$I\u001b\u00051\u0014BA%7\u00055\u0019Fo\u001c:bO\u00164\u0015mY1eKB\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\nY&\fX/\u001b2bg\u0016T!a\u0014\u001c\u0002\u000fU\u0004xM]1eK&\u0011\u0011\u000b\u0014\u0002\u000e\u0005\u00164wN]3Va\u001e\u0014\u0018\rZ3\u0011\u0005\u001d\u001b\u0016B\u0001+7\u0005I!Vm\u001d;BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0011\u0005YKV\"A,\u000b\u0005a3\u0014A\u00013c\u0013\tQvK\u0001\tMSF,\u0018NY1tKN+\b\u000f]8siB\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0006kRLGn\u001d\u0006\u0003AZ\na!Y2u_J\u001c\u0018B\u00012^\u0005I\u00196-\u00197b'B\u0014\u0018N\\4TkB\u0004xN\u001d;\u0011\u0005\u0011\\W\"A3\u000b\u0005\u0019<\u0017aB2p]R,\u0007\u0010\u001e\u0006\u0003Q&\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002U\u0006\u0019qN]4\n\u00051,'aF!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\fu/\u0019:f\u000351w\u000e\u001c3feN+'O^5dKB\u0011qN]\u0007\u0002a*\u0011\u0011ON\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\bOA\u0007G_2$WM]*feZL7-Z\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z!\t180D\u0001x\u0015\tA\u00180A\u0002tc2T!A\u001f\u001c\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002}o\n\t2+\u001d7UK\u0006l'+\u001a9pg&$xN]=\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002\u0000\u0003\u0003i\u0011!_\u0005\u0004\u0003\u0007I(!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u00042a\\A\u0005\u0013\r\tY\u0001\u001d\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016]\f1\u0002]3sg&\u001cH/\u001a8dK&!\u0011\u0011DA\n\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0007}\fy\"C\u0002\u0002\"e\u0014qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002/\r\fG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\bcA@\u0002(%\u0019\u0011\u0011F=\u0003/\r\u000bG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\u0018\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\ry\u0017qF\u0005\u0004\u0003c\u0001(\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E!(/[4hKJ\u0014V\r]8tSR|'/\u001f\t\u0004\u007f\u0006]\u0012bAA\u001ds\n\tBK]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005!1m\u001c:f\u0015\r\t9eZ\u0001\u0005U\u0012\u00147-\u0003\u0003\u0002L\u0005\u0005#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007f\u0002\u0006\u0002P\u0005\r\u0014Q\r\t\u0005\u0003#\ny&\u0004\u0002\u0002T)!\u0011QKA,\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u00033\nY&A\u0004gC\u000e$xN]=\u000b\u0007\u0005us-A\u0003cK\u0006t7/\u0003\u0003\u0002b\u0005M#!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\t\t9'A\ryYJ\u0014V\r]8tSR|'/\u001f&eE\u000e$V-\u001c9mCR,\u0017!\u0006:fa>\u0014H/\u001b8h\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\b\u0017\u0005=\u00131MA7C\t\tI'\u0001\u0004=S:LGO\u0010\u000b\u0019\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006-\u0005CA$\u0001\u0011\u0015iG\u00021\u0001o\u0011\u0015!H\u00021\u0001v\u0011\u0015iH\u00021\u0001\u007f\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000fAq!!\u0004\r\u0001\u0004\ty\u0001C\u0004\u0002\u001c1\u0001\r!!\b\t\u000f\u0005\rB\u00021\u0001\u0002&!9\u00111\u0006\u0007A\u0002\u00055\u0002bBA\u001a\u0019\u0001\u0007\u0011Q\u0007\u0005\b\u0003wa\u0001\u0019AA\u001fQ!\t9)a\u0014\u0002d\u0005\u0015\u0004bBA5\u0019\u0001\u0007\u0011Q\b\u0015\t\u0003\u0017\u000by%a\u0019\u0002n!\u001aA\"!%\u0011\t\u0005E\u00131S\u0005\u0005\u0003+\u000b\u0019FA\u0005BkR|w/\u001b:fI\u0006\u0001\u0002\u0010\u001c*fY\u0016\f7/\u001a,feNLwN\u001c\u000b\u0003\u00037\u0003B!!(\u0002.6\u0011\u0011q\u0014\u0006\u0004\u001f\u0006\u0005&\u0002BAR\u0003K\u000b1!\u00199j\u0015\u0011\t9+!+\u0002\rM,'O^3s\u0015\r\tY\u000bO\u0001\tI\u0016\u0004Hn\\=ji&!\u0011qVAP\u0005\u001d1VM]:j_:$\"!a-\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS!!!/\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005u\u0016q\u0017\u0002\u0005+:LG/\u0001\rsKB|7/\u001b;pef4VM]:j_:\u001cVM\u001d<jG\u0016,\"!a1\u0011\t\u0005\u0015\u0017QZ\u0007\u0003\u0003\u000fT1aTAe\u0015\r\tY\rO\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017\u0002BAh\u0003\u000f\u0014\u0001DU3q_NLGo\u001c:z-\u0016\u00148/[8o'\u0016\u0014h/[2f\u0003%!w.\u00169he\u0006$W-A\nd_VtGOU3d_J$7/\u00138UC\ndW\r\u0006\u0003\u0002X\u0006u\u0007\u0003BA[\u00033LA!a7\u00028\n!Aj\u001c8h\u0011\u001d\ty.\u0005a\u0001\u0003C\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\t\u0005\r\u0018\u0011\u001f\b\u0005\u0003K\fi\u000f\u0005\u0003\u0002h\u0006]VBAAu\u0015\r\tY\u000fP\u0001\u0007yI|w\u000e\u001e \n\t\u0005=\u0018qW\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0018Q\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005=\u0018qW\u0001\u0017o&\u0004XmT;u\u0003J\u001c\u0007.\u001b<f\t\u0006$\u0018MY1tKV\u0011\u00111W\u0001\u0010o&\u0004XmT;u\t\u0006$\u0018MY1tK\u0006\u0011\u0012n\u001d#c\u00072,\u0017M\\;q\u000b:\f'\r\\3e+\t\u0011\t\u0001\u0005\u0003\u00026\n\r\u0011\u0002\u0002B\u0003\u0003o\u0013qAQ8pY\u0016\fg.\u0001\u0010jg&sG/Z4sCRLwN\u001c+fgR\u0004&o\u001c4jY\u0016\f5\r^5wK\u0006QA-\u0019;b'>,(oY3\u0016\u0005\t5\u0001\u0003\u0002B\b\u0005/i!A!\u0005\u000b\u0007a\u0014\u0019B\u0003\u0002\u0003\u0016\u0005)!.\u0019<bq&!!\u0011\u0004B\t\u0005)!\u0015\r^1T_V\u00148-Z\u0001\u0003\u001d2+\"Aa\b\u0011\u0007}\u0012\t#C\u0002\u0002t\u0002\u000b1A\u0014'!\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\t\t%\"Q\u0006\u000b\u0005\u0005\u0003\u0011Y\u0003C\u0004\u0002<e\u0001\u001d!!\u0010\t\u000f\u0005}\u0017\u00041\u0001\u0002b\u0006\u0011B-\u001a7fi\u0016$\u0016M\u00197f\u0007>tG/\u001a8u)\u0011\u0011\u0019Da\u000e\u0015\t\u0005M&Q\u0007\u0005\b\u0003wQ\u00029AA\u001f\u0011\u001d\tyN\u0007a\u0001\u0003C\f\u0011\u0004Z3mKR,\u0007+\u001a:nSN\u001c\u0018n\u001c8T]\u0006\u00048\u000f[8ug\u000691\r\\3b]V\u0004\u0018A\u00023fY\u0016$X\r\u0006\u0003\u0003\u0002\t\u0005\u0003b\u0002B\";\u0001\u0007\u0011\u0011]\u0001\u0003S\u0012\fQ\u0002Z3mKR,'+\u001a7fCN,G\u0003BAZ\u0005\u0013BqAa\u0011\u001f\u0001\u0004\t\t\u000f\u0006\u0003\u0003\u0002\t5\u0003b\u0002B(?\u0001\u0007!\u0011K\u0001\u0005i\u0016\fW\u000e\u0005\u0003\u0003T\teSB\u0001B+\u0015\r\u00119FN\u0001\u0007I>l\u0017-\u001b8\n\t\tm#Q\u000b\u0002\u0005)\u0016\fW.A\teK2,G/\u001a$s_6\f%o\u00195jm\u0016$BA!\u0019\u0003hA!\u0011Q\u0017B2\u0013\u0011\u0011)'a.\u0003\u0007%sG\u000fC\u0004\u0003j\u0001\u0002\r!!9\u0002\u0013I,G.Z1tK&#\u0017!\u0006<fe&4\u0017PU3q_NLGo\u001c:z\u00072,\u0017M\\\u0001\rG>,h\u000e\u001e$pY\u0012,'o\u001d\u000b\u0003\u0005C\n!\u0004^3ti\u0012KGMT8u\u00072,\u0017M\\!gi\u0016\u0014\u0018\n^:fY\u001a$\u0002B!\u001e\u0003|\t}$1\u0014\t\u0004\u000f\n]\u0014b\u0001B=m\t!B+Z:u\u00072,\u0017M\\;q\u000bb\u001cW\r\u001d;j_:DqA! $\u0001\u0004\t\t/\u0001\u0005uKN$h*Y7f\u0011\u001d\u0011\ti\ta\u0001\u0005\u0007\u000ba!Y2uSZ,\u0007C\u0002BC\u0005\u001f\u0013)J\u0004\u0003\u0003\b\n-e\u0002BAt\u0005\u0013K!!!/\n\t\t5\u0015qW\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tJa%\u0003\u0007M+\u0017O\u0003\u0003\u0003\u000e\u0006]\u0006\u0003CA[\u0005/\u000b\t/!9\n\t\te\u0015q\u0017\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\tu5\u00051\u0001\u0003\u0004\u0006A\u0011M]2iSZ,G-A\u0007d_VtGOU3mK\u0006\u001cXm]\u0001\u000eG>,h\u000e\u001e+sS\u001e<WM]:\u00027\u001d,GOU3nC&t\u0017N\\4Ue&<w-\u001a:t\t\u0016$\u0018-\u001b7t)\t\u00119\u000b\u0005\u0004\u0003\u0006\n=\u0015\u0011]\u0001\u001aO\u0016$(+Z7bS:Lgn\u001a$pY\u0012,'\u000fR3uC&d7\u000f\u0006\u0002\u0003\u0004\u0006Yr-\u001a;SK6\f\u0017N\\5oOJ+G.Z1tKN$U\r^1jYN\f1eZ3u%\u0016l\u0017-\u001b8j]\u001e\f%o\u00195jm\u0016$'+\u001a7fCN,7\u000fR3uC&d7/A\u000bd_VtG/\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002\u0013\rdW-\u00198YY\u0012\u0013\u0007fA\u0016\u00038B!!\u0011\u0018B_\u001b\t\u0011YL\u0003\u0003\u0002V\tM\u0011\u0002\u0002B`\u0005w\u0013!\u0002\u0015:f\t\u0016\u001cHO]8z\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0005\t\u0015\u0007c\u00013\u0003H&\u0019!\u0011Z3\u0003%\u0005\u0003\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^\u0001\u0017CB\u0004H.[2bi&|gnQ8oi\u0016DHo\u0018\u0013fcR!\u00111\u0017Bh\u0011%\u0011\t.LA\u0001\u0002\u0004\u0011)-A\u0002yIE\n1#\u00199qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yi\u0002B3A\fBl!\u0011\u0011IN!8\u000e\u0005\tm'\u0002BA/\u0003oKAAa8\u0003\\\na!)Z1o!J|\u0007/\u001a:us\u0006)r-\u001a;BaBd\u0017nY1uS>t7i\u001c8uKb$HC\u0001BcQ\ry#q]\u0006\u0001\u0003U\u0019X\r^!qa2L7-\u0019;j_:\u001cuN\u001c;fqR$B!a-\u0003n\"I!\u0011\u001b\u0019\u0002\u0002\u0003\u0007!Q\u0019\u0015\u0004a\t\u001d\bf\u0002\u0001\u0003t\u0006\r$Q \t\u0005\u0005k\u0014I0\u0004\u0002\u0003x*\u0019\u0011QK3\n\t\tm(q\u001f\u0002\b!J|g-\u001b7fY\t\u0011y0\t\u0002\u0004\u0002\u0005y\u0011N\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fK\u0002\u0001\u0007\u000b\u0001Baa\u0002\u0004\u000e5\u00111\u0011\u0002\u0006\u0004\u0007\u00179\u0017AC:uKJ,w\u000e^=qK&!1qBB\u0005\u0005%\u0019u.\u001c9p]\u0016tG/\u0001\tTc2\u001cFo\u001c:bO\u00164\u0015mY1eKB\u0011qIM\n\u0004e\r]\u0001\u0003BA[\u00073IAaa\u0007\u00028\n1\u0011I\\=SK\u001a$\"aa\u0005\u0015\t\r\u00052Q\u0005\u000b\u0005\u0005C\u001a\u0019\u0003C\u0004\u0002<Q\u0002\r!!\u0010\t\u000f\t%D\u00071\u0001\u0002b\u0002")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block5: {
            this.logger().info("Deleting release {}", (Object)id);
            boolean found = false;
            if (this.releaseRepository.exists(id)) {
                this.logger().info("Release {} found in repository", (Object)id);
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                found = true;
            }
            if (this.archivingService.exists(id)) {
                this.logger().info("Release {} found in archive", (Object)id);
                this.deleteFromArchive(id);
                found = true;
            }
            if (this.archivingService.existsPreArchived(id)) {
                this.logger().info("Release {} found as pre-archived", (Object)id);
                this.deleteFromArchive(id);
                found = true;
            }
            if (found) break block5;
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        object = new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            });
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$4) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$5) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$7) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

