/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.FolderVariablesDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.utils.Tree;
import com.xebialabs.xlrelease.domain.utils.Tree$;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B\u0014)\u0001MB\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!i\u0007A!b\u0001\n\u0003q\u0007\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011a\u0004!Q1A\u0005\u0004eD\u0011\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005=\u0001A!b\u0001\n\u0007\t\t\u0002\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003'Aq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\tY\u0010\u0001C!\u0003{DqA!\u0002\u0001\t\u0003\u00129\u0001C\u0005\u0003 \u0001\t\n\u0011\"\u0001\u0003\"!9!Q\u0007\u0001\u0005\u0002\t]\u0002b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u0017\u0002A\u0011\tB'\u0011\u001d\u0011)\u0006\u0001C!\u0005/BqAa\u001a\u0001\t\u0003\u0012I\u0007C\u0004\u0003t\u0001!\tE!\u001e\t\u000f\t}\u0004\u0001\"\u0011\u0003\u0002\"I!1\u0012\u0001\u0012\u0002\u0013\u0005!Q\u0012\u0005\b\u0005#\u0003A\u0011\tBJ\u0011!\u0011i\n\u0001C\u0001Q\t}\u0005\u0002\u0003BZ\u0001\u0011\u0005\u0001F!.\t\u0011\tm\u0007\u0001\"\u0001)\u0005;D!Ba9\u0001#\u0003%\t\u0001\u000bBG\u0011!\u0011)\u000f\u0001C\u0001Q\t\u001d\bB\u0003Bx\u0001E\u0005I\u0011\u0001\u0015\u0003\u000e\"9!\u0011\u001f\u0001\u0005\n\tM\b\"\u0003B\u0000\u0001E\u0005I\u0011\u0002BG\u0011!\u0019\t\u0001\u0001C\u0001Q\r\r\u0001BCB\u0005\u0001E\u0005I\u0011\u0001\u0015\u0003\u000e\n\u00192+\u001d7G_2$WM\u001d*fa>\u001c\u0018\u000e^8ss*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003[9\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005=\u0002\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005\t\u0014aA2p[\u000e\u00011C\u0002\u00015uyRU\n\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003wqj\u0011AK\u0005\u0003{)\u0012\u0001CR8mI\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0007}\u0002%)D\u0001)\u0013\t\t\u0005FA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015A\u00024pY\u0012,'O\u0003\u0002HY\u00051Am\\7bS:L!!\u0013#\u0003\r\u0019{G\u000eZ3s!\ty4*\u0003\u0002MQ\ti1+\u001d7SKB|7/\u001b;pef\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\u000bMdg\r\u000e6\u000b\u0003I\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003)>\u0013q\u0001T8hO&tw-A\tg_2$WM\u001d)feNL7\u000f^3oG\u0016\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u0015\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u00037b\u0013\u0011CR8mI\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005]s\u0016BA0Y\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB\u00111HY\u0005\u0003G*\u0012a\u0002V3b[J+\u0007o\\:ji>\u0014\u00180\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\bC\u00014l\u001b\u00059'B\u00015j\u0003!\u0019XmY;sSRL(B\u00016/\u0003!!W\r\u001d7ps&$\u0018B\u00017h\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\u0002!\u0011,7m\u001c:bi>\u00148+\u001a:wS\u000e,W#A8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Qd\u0013aA1qS&\u0011a/\u001d\u0002!\u0013:$XM\u001d8bY6+G/\u00193bi\u0006$UmY8sCR|'oU3sm&\u001cW-A\teK\u000e|'/\u0019;peN+'O^5dK\u0002\nAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012A\u001f\t\u0004w\u0006%Q\"\u0001?\u000b\u0005ut\u0018\u0001B2pe\u0016T1a`A\u0001\u0003\u0011QGMY2\u000b\t\u0005\r\u0011QA\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006y\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nq\u0001Z5bY\u0016\u001cG/\u0006\u0002\u0002\u0014A!\u0011QCA\u001e\u001d\u0011\t9\"!\u000e\u000f\t\u0005e\u0011\u0011\u0007\b\u0005\u00037\tiC\u0004\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003SqA!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K\u0011\u0014A\u0002\u001fs_>$h(C\u00012\u0013\ty\u0003'\u0003\u0002.]%\u0019\u0011q\u0006\u0017\u0002\u0005\u0011\u0014\u0017bA\u0015\u00024)\u0019\u0011q\u0006\u0017\n\t\u0005]\u0012\u0011H\u0001\u000b'Fd')^5mI\u0016\u0014(bA\u0015\u00024%!\u0011QHA \u0005\u001d!\u0015.\u00197fGRTA!a\u000e\u0002:\u0005AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*\u0003+\u0002\"a\u0010\u0001\t\u000bU[\u0001\u0019\u0001,\t\u000bq[\u0001\u0019A/\t\u000b\u0001\\\u0001\u0019A1\t\u000b\u0011\\\u0001\u0019A3\t\u000b5\\\u0001\u0019A8\t\u000ba\\\u00019\u0001>\t\u000f\u0005=1\u0002q\u0001\u0002\u0014\u00051Q\r_5tiN$B!a\u0017\u0002bA\u0019Q'!\u0018\n\u0007\u0005}cGA\u0004C_>dW-\u00198\t\u000f\u0005\rD\u00021\u0001\u0002f\u0005Aam\u001c7eKJLE\r\u0005\u0003\u0002h\u0005=d\u0002BA5\u0003W\u00022!!\t7\u0013\r\tiGN\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00141\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055d\u0007K\u0002\r\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0005\u0003{\nI$A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BAA\u0003w\u0012!\"S:SK\u0006$wJ\u001c7zQ\ra\u0011Q\u0011\t\u0005\u0003\u000f\u000b)*\u0004\u0002\u0002\n*!\u00111RAG\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u001f\u000b\t*A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005M\u0005'\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t9*!#\u0003\u000bQKW.\u001a3\u0002\u0011\u001d,G\u000fV5uY\u0016$B!!(\u0002$B)Q'a(\u0002f%\u0019\u0011\u0011\u0015\u001c\u0003\r=\u0003H/[8o\u0011\u001d\t\u0019'\u0004a\u0001\u0003KB3!DA<Q\ri\u0011QQ\u0001\bO\u0016$\b+\u0019;i)\u0011\ti+a0\u0011\r\u0005=\u0016\u0011XA3\u001d\u0011\t\t,!.\u000f\t\u0005\u0005\u00121W\u0005\u0002o%\u0019\u0011q\u0017\u001c\u0002\u000fA\f7m[1hK&!\u00111XA_\u0005\r\u0019V-\u001d\u0006\u0004\u0003o3\u0004bBA2\u001d\u0001\u0007\u0011Q\r\u0015\u0004\u001d\u0005]\u0004f\u0001\b\u0002\u0006\u00061q-\u001a;VS\u0012$B!!3\u0002bB!\u00111ZAn\u001d\u0011\ti-!7\u000f\t\u0005=\u0017q\u001b\b\u0005\u0003#\f)N\u0004\u0003\u0002\u001c\u0005M\u0017BA\u0016-\u0013\tI#&\u0003\u0002ZQ%\u0019\u0011q\u0017-\n\t\u0005u\u0017q\u001c\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0004\u0003oC\u0006bBA2\u001f\u0001\u0007\u0011Q\r\u0015\u0004\u001f\u0005]\u0004fA\b\u0002\u0006\u0006Aa-\u001b8e\u0005fLE\r\u0006\u0004\u0002l\u00065\u0018q\u001e\t\u0005k\u0005}%\tC\u0004\u0002dA\u0001\r!!\u001a\t\u0013\u0005E\b\u0003%AA\u0002\u0005M\u0018!\u00023faRD\u0007cA\u001b\u0002v&\u0019\u0011q\u001f\u001c\u0003\u0007%sG\u000fK\u0002\u0011\u0003\u000b\u000bqCZ5oIZKWm^1cY\u00164u\u000e\u001c3feN\u0014\u00150\u00133\u0015\r\u0005-\u0018q B\u0001\u0011\u001d\t\u0019'\u0005a\u0001\u0003KB\u0011\"!=\u0012!\u0003\u0005\r!a=)\u0007E\t))A\nmSN$h+[3xC\ndWMR8mI\u0016\u00148\u000f\u0006\u0005\u0003\n\t-!q\u0002B\r!\u0015\ty+!/C\u0011\u001d\u0011iA\u0005a\u0001\u0003K\n\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0005#\u0011\u0002\u0019\u0001B\n\u0003\u0011\u0001\u0018mZ3\u0011\u0007m\u0012)\"C\u0002\u0003\u0018)\u0012A\u0001U1hK\"I!1\u0004\n\u0011\u0002\u0003\u0007\u00111L\u0001\u0018I\u0016\u001cwN]1uK^KG\u000f\u001b)fe6L7o]5p]ND3AEAC\u0003ua\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:tI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0012U\u0011\tYF!\n,\u0005\t\u001d\u0002\u0003\u0002B\u0015\u0005ci!Aa\u000b\u000b\t\t5\"qF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a#7\u0013\u0011\u0011\u0019Da\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\rtKR\f5/\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z\u0013\u0012$BA!\u000f\u0003@A\u0019QGa\u000f\n\u0007\tubG\u0001\u0003V]&$\bbBA2)\u0001\u0007\u0011Q\r\u0015\u0004)\u0005\u0015\u0015AG5oQ\u0016\u0014\u0018\u000e^#gM\u0016\u001cG/\u001b<f'\u0016\u001cWO]5us&#G\u0003\u0002B\u001d\u0005\u000fBq!a\u0019\u0016\u0001\u0004\t)\u0007K\u0002\u0016\u0003\u000b\u000baa\u0019:fCR,G#\u0002\"\u0003P\tE\u0003b\u0002B\u0007-\u0001\u0007\u0011Q\r\u0005\u0006\u000bZ\u0001\rA\u0011\u0015\u0004-\u0005\u0015\u0015A\u00023fY\u0016$X\r\u0006\u0004\u0003:\te#1\f\u0005\b\u0003G:\u0002\u0019AA3\u0011%\u0011if\u0006I\u0001\u0002\u0004\u0011y&A\u0007eK2,G/\u001a*fY\u0016\f7/\u001a\t\nk\t\u0005\u00141_A3\u0005sI1Aa\u00197\u0005%1UO\\2uS>t'\u0007K\u0002\u0018\u0003\u000b\u000baA]3oC6,G#\u0002\"\u0003l\t5\u0004bBA21\u0001\u0007\u0011Q\r\u0005\b\u0005_B\u0002\u0019AA3\u0003\u001dqWm\u001e(b[\u0016D3\u0001GAC\u0003\u0011iwN^3\u0015\u000b\t\u00139H!\u001f\t\u000f\u0005\r\u0014\u00041\u0001\u0002f!9!1P\rA\u0002\u0005\u0015\u0014a\u00038foB\u000b'/\u001a8u\u0013\u0012D3!GAC\u0003)1\u0017N\u001c3CsB\u000bG\u000f\u001b\u000b\u0006\u0005\n\r%q\u0011\u0005\b\u0005\u000bS\u0002\u0019AA3\u0003%!\u0018\u000e\u001e7f!\u0006$\b\u000eC\u0005\u0002rj\u0001\n\u00111\u0001\u0002t\"\u001a!$!\"\u0002)\u0019Lg\u000e\u001a\"z!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yI\u000b\u0003\u0002t\n\u0015\u0012\u0001\u00064j]\u0012\u001cVO\u0019$pY\u0012,'OQ=USRdW\r\u0006\u0004\u0002l\nU%q\u0013\u0005\b\u0005\u001ba\u0002\u0019AA3\u0011\u001d\u0011I\n\ba\u0001\u0003K\nAA\\1nK\"\u001aA$!\"\u00021\u0019Lg\u000eZ*vE\u001a{G\u000eZ3s\t\u0006$\u0018MQ=USRdW\r\u0006\u0004\u0003\"\n=&\u0011\u0017\t\u0006k\u0005}%1\u0015\t\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*\u0019!\u0011\u0016-\u0002\t\u0011\fG/Y\u0005\u0005\u0005[\u00139KA\u0005G_2$WM\u001d*po\"9\u00111M\u000fA\u0002\u0005\u0015\u0004b\u0002BM;\u0001\u0007\u0011QM\u0001\u000bS:\u001cXM\u001d;O_\u0012,G\u0003\u0003B\\\u0005#\u0014\u0019Na6\u0011\r\te&1\u001aBR\u001d\u0011\u0011YL!2\u000f\t\tu&\u0011\u0019\b\u0005\u00037\u0011y,\u0003\u0002HY%\u0019!1\u0019$\u0002\u000bU$\u0018\u000e\\:\n\t\t\u001d'\u0011Z\u0001\u0005)J,WMC\u0002\u0003D\u001aKAA!4\u0003P\n!aj\u001c3f\u0015\u0011\u00119M!3\t\u000f\tee\u00041\u0001\u0002f!9!Q\u001b\u0010A\u0002\u0005\u0015\u0014aB4jm\u0016t\u0017\n\u001a\u0005\b\u00053t\u0002\u0019AAO\u0003-\u0001\u0018M]3oi&#w\n\u001d;\u0002\u0019\u0019Lg\u000e\u001a(pI\u0016\u0014\u00150\u00133\u0015\r\t]&q\u001cBq\u0011\u001d\t\u0019g\ba\u0001\u0003KB\u0011\"!= !\u0003\u0005\r!a=\u0002-\u0019Lg\u000e\u001a(pI\u0016\u0014\u00150\u00133%I\u00164\u0017-\u001e7uII\nQBZ5oI:{G-\u001a\"z+&$GC\u0002B\\\u0005S\u0014i\u000fC\u0004\u0003l\u0006\u0002\r!!3\u0002\u000b\rLW+\u001b3\t\u0013\u0005E\u0018\u0005%AA\u0002\u0005M\u0018a\u00064j]\u0012tu\u000eZ3CsVKG\r\n3fM\u0006,H\u000e\u001e\u00133\u0003Ea\u0017n\u001d;WS\u0016<\u0018M\u00197f\u001d>$Wm\u001d\u000b\u0007\u0005k\u0014YP!@\u0011\r\u0005=&q\u001fB\\\u0013\u0011\u0011I0!0\u0003\t1K7\u000f\u001e\u0005\b\u0003G\u001a\u0003\u0019AA3\u0011%\t\tp\tI\u0001\u0002\u0004\t\u00190A\u000emSN$h+[3xC\ndWMT8eKN$C-\u001a4bk2$HEM\u0001\u0016M&tGMV5fo\u0006\u0014G.\u001a(pI\u0016\u001c()_%e)\u0019\u00119l!\u0002\u0004\b!9\u00111M\u0013A\u0002\u0005\u0015\u0004\"CAyKA\u0005\t\u0019AAz\u0003}1\u0017N\u001c3WS\u0016<\u0018M\u00197f\u001d>$Wm\u001d\"z\u0013\u0012$C-\u001a4bk2$HE\r\u0015\u0004\u0001\r5\u0001\u0003BA=\u0007\u001fIAa!\u0005\u0002|\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlFolderRepository
implements FolderRepository,
InterceptedRepository<Folder>,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private Seq<PersistenceInterceptor<Folder>> persistenceInterceptors;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Folder> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public int findViewableFoldersById$default$2() {
        return FolderRepository.findViewableFoldersById$default$2$((FolderRepository)this);
    }

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public Seq<Folder> paginate(Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public Seq<Folder> decorateWithEffectiveSecurity(Seq<Folder> folders, DecoratorsCache cache) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders, (DecoratorsCache)cache);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Seq<PersistenceInterceptor<Folder>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Folder>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, depth))).map((Function1 & Serializable & scala.Serializable)tree -> {
            void var2_2;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES(), (List)Nil$.MODULE$))).asJava());
            return var2_2;
        });
    }

    @Timed
    public Option<Folder> findViewableFoldersById(String folderId, int depth) {
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findViewableNodesById(folderId, depth))).map((Function1 & Serializable & scala.Serializable)tree -> {
            void var3_3;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES(), (List)Nil$.MODULE$))).asJava(), cache);
            folder.setChildren((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.decorateWithEffectiveSecurity((Seq<Folder>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(folder.getChildren()).asScala()).toSeq(), cache).toSet()).asJava());
            return var3_3;
        });
    }

    @Timed
    public Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        Seq<Folder> results = (Seq<Folder>)this.listViewableNodes(parentId, page.depth()).map((Function1 & Serializable & scala.Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2)), List$.MODULE$.canBuildFrom());
        DecoratorsCache decoratorsCache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return this.paginate(decorateWithPermissions ? this.decorateWithEffectiveSecurity(results, decoratorsCache) : results, page);
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.interceptCreate((ConfigurationItem)folder);
            return this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId));
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new FoldersStoreException(new StringBuilder(28).append("Cannot create folder ").append(folder.getId()).append(" under ").append(parentId).toString(), e);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tree.Node created = (Tree.Node)success.value();
        Folder folder2 = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        return folder2;
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable & scala.Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException(new StringBuilder(34).append("Cannot find folder by empty path: ").append(titlePath).toString(), new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Finding folder by path ").append(pathFromRoot).toString());
        String[] pathElements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/"))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).isEmpty()) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption();
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringBuilder(34).append("Cannot find folder by empty path: ").append(titlePath).toString(), new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> option2 = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Option<FolderRow> topLevelData = option2;
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.uid()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(35).append("Could not find folder [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("] in path [").append(titlePath).append("]").toString(), new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail()).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail())).foldLeft((Object)topNode, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tree.Node node = (Tree.Node)tuple2._1();
            String pathElement = (String)tuple2._2();
            Tree.Node node2 = (Tree.Node)node.children().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringBuilder(35).append("Could not find folder [").append(pathElement).append("] in path [").append(titlePath).append("]").toString(), new Object[0]);
            });
            return node2;
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable & scala.Serializable)x$6 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$6)));
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        void var3_3;
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findByUid(ciUid, depth) : this.folderPersistence.findByUidHavingPermission(ciUid, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()), depth);
        return var3_3;
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth) {
        Tree.Node<FolderRow> viewableTree = this.findViewableNodesById(folderId, depth);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public Tree.Node<FolderRow> findViewableNodesById(String folderId, int depth) {
        void var3_3;
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()), depth);
        return var3_3;
    }

    public int findViewableNodesById$default$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(data.folderId().absolute());
        }
        $this.folderPersistence.deleteByUid(data.uid());
        $this.interceptDelete(data.folderId().absolute());
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$5) {
        String string = ((FolderRow)x$5.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

