/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.FolderVariablesDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.utils.Tree;
import com.xebialabs.xlrelease.domain.utils.Tree$;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\teh\u0001\u0002\u0013&\u0001AB\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!Q\u0007A!b\u0001\n\u0003Y\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011U\u0004!Q1A\u0005\u0004YD\u0011\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0015\u0005%\u0001A!b\u0001\n\u0007\tY\u0001\u0003\u0006\u0002<\u0001\u0011\t\u0011)A\u0005\u0003\u001bAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003C\u0004A\u0011IAr\u0011\u001d\t)\u0010\u0001C!\u0003oD\u0011Ba\u0004\u0001#\u0003%\tA!\u0005\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B\u001e\u0001\u0011\u0005#Q\b\u0005\b\u0005\u000b\u0002A\u0011\tB$\u0011\u001d\u00119\u0006\u0001C!\u00053BqAa\u0019\u0001\t\u0003\u0012)\u0007C\u0004\u0003p\u0001!\tE!\u001d\t\u0013\tm\u0004!%A\u0005\u0002\tu\u0004b\u0002BA\u0001\u0011\u0005#1\u0011\u0005\t\u0005\u001b\u0003A\u0011A\u0013\u0003\u0010\"A!1\u0015\u0001\u0005\u0002\u0015\u0012)\u000b\u0003\u0005\u0003L\u0002!\t!\nBg\u0011)\u0011\u0019\u000eAI\u0001\n\u0003)#Q\u0010\u0005\t\u0005+\u0004A\u0011A\u0013\u0003X\"Q!q\u001c\u0001\u0012\u0002\u0013\u0005QE! \t\u000f\t\u0005\b\u0001\"\u0003\u0003d\"I!q\u001e\u0001\u0012\u0002\u0013%!Q\u0010\u0002\u0014'Fdgi\u001c7eKJ\u0014V\r]8tSR|'/\u001f\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&\u0001\u0006sKB|7/\u001b;pefT!AK\u0016\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0017.\u0003%AXMY5bY\u0006\u00147OC\u0001/\u0003\r\u0019w.\\\u0002\u0001'\u0019\u0001\u0011gN\u001eH\u0015B\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001d\u000e\u0003\u001dJ!AO\u0014\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\bc\u0001\u001f>\u007f5\tQ%\u0003\u0002?K\t)\u0012J\u001c;fe\u000e,\u0007\u000f^3e%\u0016\u0004xn]5u_JL\bC\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u00191w\u000e\u001c3fe*\u0011A)K\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0019\u000b%A\u0002$pY\u0012,'\u000f\u0005\u0002=\u0011&\u0011\u0011*\n\u0002\u000e'Fd'+\u001a9pg&$xN]=\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015!B:mMRR'\"A(\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0015'\u0003\u000f1{wmZ5oO\u0006\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005Q;V\"A+\u000b\u0005Y+\u0013a\u00039feNL7\u000f^3oG\u0016L!\u0001W+\u0003#\u0019{G\u000eZ3s!\u0016\u00148/[:uK:\u001cW-\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001+\\\u0013\taVK\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0004;fC6\u0014V\r]8tSR|'/\u001f\t\u0003q}K!\u0001Y\u0014\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0005tK\u000e,(/\u001b;z\u0015\t97&\u0001\u0005eKBdw._5u\u0013\tIGM\u0001\nQKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\u0018\u0001\u00053fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f+\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003!Ig\u000e^3s]\u0006d'BA9*\u0003\r\t\u0007/[\u0005\u0003g:\u0014\u0001%\u00138uKJt\u0017\r\\'fi\u0006$\u0017\r^1EK\u000e|'/\u0019;peN+'O^5dK\u0006\tB-Z2pe\u0006$xN]*feZL7-\u001a\u0011\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003]\u00042\u0001_A\u0002\u001b\u0005I(B\u0001>|\u0003\u0011\u0019wN]3\u000b\u0005ql\u0018\u0001\u00026eE\u000eT!A`@\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0001\u0002\u0007=\u0014x-C\u0002\u0002\u0006e\u0014AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013a\u00023jC2,7\r^\u000b\u0003\u0003\u001b\u0001B!a\u0004\u000269!\u0011\u0011CA\u0018\u001d\u0011\t\u0019\"a\u000b\u000f\t\u0005U\u0011q\u0005\b\u0005\u0003/\t)C\u0004\u0003\u0002\u001a\u0005\rb\u0002BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}q&\u0001\u0004=e>|GOP\u0005\u0002]%\u0011A&L\u0005\u0003U-J1!!\u000b*\u0003\t!'-C\u0002'\u0003[Q1!!\u000b*\u0013\u0011\t\t$a\r\u0002\u0015M\u000bHNQ;jY\u0012,'OC\u0002'\u0003[IA!a\u000e\u0002:\t9A)[1mK\u000e$(\u0002BA\u0019\u0003g\t\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0003C\u0001\u001f\u0001\u0011\u0015\u00116\u00021\u0001T\u0011\u0015I6\u00021\u0001[\u0011\u0015i6\u00021\u0001_\u0011\u0015\t7\u00021\u0001c\u0011\u0015Q7\u00021\u0001m\u0011\u0015)8\u0002q\u0001x\u0011\u001d\tIa\u0003a\u0002\u0003\u001b\ta!\u001a=jgR\u001cH\u0003BA+\u00037\u00022AMA,\u0013\r\tIf\r\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0006\u0004a\u0001\u0003?\n\u0001BZ8mI\u0016\u0014\u0018\n\u001a\t\u0005\u0003C\nIG\u0004\u0003\u0002d\u0005\u0015\u0004cAA\u000eg%\u0019\u0011qM\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\tY'!\u001c\u0003\rM#(/\u001b8h\u0015\r\t9g\r\u0015\u0004\u0019\u0005E\u0004\u0003BA:\u0003sj!!!\u001e\u000b\t\u0005]\u00141G\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002|\u0005U$AC%t%\u0016\fGm\u00148ms\"\u001aA\"a \u0011\t\u0005\u0005\u0015qR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005%\u00151R\u0001\b[\u0016$(/[2t\u0015\r\ti)L\u0001\tG>$\u0017\r[1mK&!\u0011\u0011SAB\u0005\u0015!\u0016.\\3e\u0003!9W\r\u001e+ji2,G\u0003BAL\u0003;\u0003RAMAM\u0003?J1!a'4\u0005\u0019y\u0005\u000f^5p]\"9\u0011QL\u0007A\u0002\u0005}\u0003fA\u0007\u0002r!\u001aQ\"a \u0002\u000f\u001d,G\u000fU1uQR!\u0011qUA]!\u0019\tI+a-\u0002`9!\u00111VAX\u001d\u0011\tY\"!,\n\u0003QJ1!!-4\u0003\u001d\u0001\u0018mY6bO\u0016LA!!.\u00028\n\u00191+Z9\u000b\u0007\u0005E6\u0007C\u0004\u0002^9\u0001\r!a\u0018)\u00079\t\t\bK\u0002\u000f\u0003\u007f\naaZ3u+&$G\u0003BAb\u00037\u0004B!!2\u0002V:!\u0011qYAj\u001d\u0011\tI-!5\u000f\t\u0005-\u0017q\u001a\b\u0005\u0003+\ti-\u0003\u0002)S%\u0011aeJ\u0005\u0003-\u0016J1!!-V\u0013\u0011\t9.!7\u0003\u000b\rKW+\u001b3\u000b\u0007\u0005EV\u000bC\u0004\u0002^=\u0001\r!a\u0018)\u0007=\t\t\bK\u0002\u0010\u0003\u007f\n\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0007\u0003K\f9/!;\u0011\tI\nIj\u0010\u0005\b\u0003;\u0002\u0002\u0019AA0\u0011%\tY\u000f\u0005I\u0001\u0002\u0004\ti/A\u0003eKB$\b\u000eE\u00023\u0003_L1!!=4\u0005\rIe\u000e\u001e\u0015\u0004!\u0005}\u0014a\u00057jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0003CA}\u0003w\fyP!\u0003\u0011\u000b\u0005%\u00161W \t\u000f\u0005u\u0018\u00031\u0001\u0002`\u0005A\u0001/\u0019:f]RLE\rC\u0004\u0003\u0002E\u0001\rAa\u0001\u0002\tA\fw-\u001a\t\u0004q\t\u0015\u0011b\u0001B\u0004O\t!\u0001+Y4f\u0011%\u0011Y!\u0005I\u0001\u0002\u0004\t)&A\feK\u000e|'/\u0019;f/&$\b\u000eU3s[&\u001c8/[8og\"\u001a\u0011#a \u0002;1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:%I\u00164\u0017-\u001e7uIM*\"Aa\u0005+\t\u0005U#QC\u0016\u0003\u0005/\u0001BA!\u0007\u0003\"5\u0011!1\u0004\u0006\u0005\u0005;\u0011y\"A\u0005v]\u000eDWmY6fI*\u0019\u0011QQ\u001a\n\t\t\r\"1\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G:fi\u0006\u001bXI\u001a4fGRLg/Z*fGV\u0014\u0018\u000e^=JIR!!\u0011\u0006B\u0018!\r\u0011$1F\u0005\u0004\u0005[\u0019$\u0001B+oSRDq!!\u0018\u0014\u0001\u0004\ty\u0006K\u0002\u0014\u0003\u007f\n!$\u001b8iKJLG/\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z\u0013\u0012$BA!\u000b\u00038!9\u0011Q\f\u000bA\u0002\u0005}\u0003f\u0001\u000b\u0002\u0000\u000511M]3bi\u0016$Ra\u0010B \u0005\u0003Bq!!@\u0016\u0001\u0004\ty\u0006C\u0003C+\u0001\u0007q\bK\u0002\u0016\u0003\u007f\na\u0001Z3mKR,GC\u0002B\u0015\u0005\u0013\u0012Y\u0005C\u0004\u0002^Y\u0001\r!a\u0018\t\u0013\t5c\u0003%AA\u0002\t=\u0013!\u00043fY\u0016$XMU3mK\u0006\u001cX\rE\u00053\u0005#\ni/a\u0018\u0003*%\u0019!1K\u001a\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004f\u0001\f\u0002\u0000\u00051!/\u001a8b[\u0016$Ra\u0010B.\u0005;Bq!!\u0018\u0018\u0001\u0004\ty\u0006C\u0004\u0003`]\u0001\r!a\u0018\u0002\u000f9,wOT1nK\"\u001aq#a \u0002\t5|g/\u001a\u000b\u0006\u007f\t\u001d$\u0011\u000e\u0005\b\u0003;B\u0002\u0019AA0\u0011\u001d\u0011Y\u0007\u0007a\u0001\u0003?\n1B\\3x!\u0006\u0014XM\u001c;JI\"\u001a\u0001$a \u0002\u0015\u0019Lg\u000e\u001a\"z!\u0006$\b\u000eF\u0003@\u0005g\u00129\bC\u0004\u0003ve\u0001\r!a\u0018\u0002\u0013QLG\u000f\\3QCRD\u0007\"CAv3A\u0005\t\u0019AAwQ\rI\u0012qP\u0001\u0015M&tGMQ=QCRDG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}$\u0006BAw\u0005+\tACZ5oIN+(MR8mI\u0016\u0014()\u001f+ji2,GCBAs\u0005\u000b\u00139\tC\u0004\u0002~n\u0001\r!a\u0018\t\u000f\t%5\u00041\u0001\u0002`\u0005!a.Y7fQ\rY\u0012qP\u0001\u0019M&tGmU;c\r>dG-\u001a:ECR\f')\u001f+ji2,GC\u0002BI\u0005?\u0013\t\u000bE\u00033\u00033\u0013\u0019\n\u0005\u0003\u0003\u0016\nmUB\u0001BL\u0015\r\u0011I*V\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0003\u001e\n]%!\u0003$pY\u0012,'OU8x\u0011\u001d\ti\u0006\ba\u0001\u0003?BqA!#\u001d\u0001\u0004\ty&\u0001\u0006j]N,'\u000f\u001e(pI\u0016$\u0002Ba*\u0003B\n\r'q\u0019\t\u0007\u0005S\u0013YLa%\u000f\t\t-&Q\u0017\b\u0005\u0005[\u0013\tL\u0004\u0003\u0002\u0016\t=\u0016B\u0001#*\u0013\r\u0011\u0019lQ\u0001\u0006kRLGn]\u0005\u0005\u0005o\u0013I,\u0001\u0003Ue\u0016,'b\u0001BZ\u0007&!!Q\u0018B`\u0005\u0011qu\u000eZ3\u000b\t\t]&\u0011\u0018\u0005\b\u0005\u0013k\u0002\u0019AA0\u0011\u001d\u0011)-\ba\u0001\u0003?\nqaZ5wK:LE\rC\u0004\u0003Jv\u0001\r!a&\u0002\u0017A\f'/\u001a8u\u0013\u0012|\u0005\u000f^\u0001\rM&tGMT8eK\nK\u0018\n\u001a\u000b\u0007\u0005O\u0013yM!5\t\u000f\u0005uc\u00041\u0001\u0002`!I\u00111\u001e\u0010\u0011\u0002\u0003\u0007\u0011Q^\u0001\u0017M&tGMT8eK\nK\u0018\n\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005ia-\u001b8e\u001d>$WMQ=VS\u0012$bAa*\u0003Z\nu\u0007b\u0002BnA\u0001\u0007\u00111Y\u0001\u0006G&,\u0016\u000e\u001a\u0005\n\u0003W\u0004\u0003\u0013!a\u0001\u0003[\fqCZ5oI:{G-\u001a\"z+&$G\u0005Z3gCVdG\u000f\n\u001a\u0002#1L7\u000f\u001e,jK^\f'\r\\3O_\u0012,7\u000f\u0006\u0004\u0003f\n-(Q\u001e\t\u0007\u0003S\u00139Oa*\n\t\t%\u0018q\u0017\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002^\t\u0002\r!a\u0018\t\u0013\u0005-(\u0005%AA\u0002\u00055\u0018a\u00077jgR4\u0016.Z<bE2,gj\u001c3fg\u0012\"WMZ1vYR$#\u0007K\u0002\u0001\u0005g\u0004B!a\u001d\u0003v&!!q_A;\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlFolderRepository
implements FolderRepository,
InterceptedRepository<Folder>,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private Seq<PersistenceInterceptor<Folder>> persistenceInterceptors;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Folder> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public Seq<Folder> paginate(Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public Seq<Folder> decorateWithEffectiveSecurity(Seq<Folder> folders, DecoratorsCache cache) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders, (DecoratorsCache)cache);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Seq<PersistenceInterceptor<Folder>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Folder>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).map((Function1 & Serializable & scala.Serializable)tree -> {
            void var2_2;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES()}))).asJava(), DecoratorsCache$.MODULE$.NO_CACHE());
            return var2_2;
        });
    }

    @Timed
    public Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        Seq<Folder> results = (Seq<Folder>)this.listViewableNodes(parentId, this.listViewableNodes$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2)), List$.MODULE$.canBuildFrom());
        DecoratorsCache decoratorsCache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return this.paginate(decorateWithPermissions ? this.decorateWithEffectiveSecurity(results, decoratorsCache) : results, page);
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.interceptCreate((ConfigurationItem)folder);
            return this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId));
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new FoldersStoreException(new StringBuilder(28).append("Cannot create folder ").append(folder.getId()).append(" under ").append(parentId).toString(), e);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tree.Node created = (Tree.Node)success.value();
        Folder folder2 = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        return folder2;
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable & scala.Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException(new StringBuilder(34).append("Cannot find folder by empty path: ").append(titlePath).toString(), new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Finding folder by path ").append(pathFromRoot).toString());
        String[] pathElements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/"))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).isEmpty()) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption();
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringBuilder(34).append("Cannot find folder by empty path: ").append(titlePath).toString(), new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> option2 = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Option<FolderRow> topLevelData = option2;
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.uid()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(35).append("Could not find folder [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("] in path [").append(titlePath).append("]").toString(), new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail()).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail())).foldLeft((Object)topNode, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tree.Node node = (Tree.Node)tuple2._1();
            String pathElement = (String)tuple2._2();
            Tree.Node node2 = (Tree.Node)node.children().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringBuilder(35).append("Could not find folder [").append(pathElement).append("] in path [").append(titlePath).append("]").toString(), new Object[0]);
            });
            return node2;
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable & scala.Serializable)x$6 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$6)));
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        return this.folderPersistence.findByUid(ciUid, depth);
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth) {
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()), depth);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(data.folderId().absolute());
        }
        $this.folderPersistence.deleteByUid(data.uid());
        $this.interceptDelete(data.folderId().absolute());
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$5) {
        String string = ((FolderRow)x$5.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

